/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form.combo;

import ca.infodata.ofys.data.middle.dataobjects.XCountry;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.ProviderAR;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CountryCombo
extends MyCombo<XCountry> {
    private static final int STANDARD_TEXT_LIMIT = 100;

    public CountryCombo(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style, toolkit);
        this.setAutoComplete(true);
        this.setLabelProvider(new ProviderAR<XCountry, String>(){

            public String get(XCountry country) {
                return country == null || country.getName() == null ? "" : country.getName();
            }
        });
        this.setDisplayPredicate(new PredicateA<XCountry>(){

            public boolean evaluate(XCountry c) {
                return c != null && c.isActive();
            }
        });
        this.setTextLimit(100);
        this.fill();
    }

    protected void fill() {
        String text = this.getText();
        XCountry selection = (XCountry)this.getSelection();
        this.removeAllNoNotify();
        ArrayList<XCountry> fixedList = new ArrayList<XCountry>(2);
        fixedList.add(new XCountry("CANADA"));
        this.setItems(fixedList);
        if (selection != null) {
            this.selectNoNotify(selection);
        } else {
            this.setTextNoNotify(text);
        }
    }

    @Override
    public void select(XCountry item) {
        if (item == null) {
            if (this.getDefaultSelection() != null) {
                this.select((XCountry)this.getDefaultSelection());
            } else {
                this.selectNone();
            }
        } else if (this.contains(item)) {
            super.select(item);
        } else {
            this.add(item);
            super.select(item);
        }
    }

    public void selectCanada() {
        Collection items = this.getItems();
        for (XCountry c : items) {
            if (!"canada".equalsIgnoreCase(c.getName())) continue;
            this.setDefaultSelection(c);
            this.select(c);
            return;
        }
        for (XCountry c : items) {
            if (!"ca".equalsIgnoreCase(c.getName())) continue;
            this.setDefaultSelection(c);
            this.select(c);
            return;
        }
    }
}

