/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class ZipUnzip {
    private static final Logger logger = Logger.getLogger(ZipUnzip.class.getName());

    public static boolean zip(String zipfile, String[] filesToZip) {
        boolean zipOk;
        block3: {
            zipOk = false;
            int compressionLevel = 8;
            try {
                String zipName = zipfile;
                ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(zipName));
                zip.setMethod(8);
                zip.setLevel(compressionLevel);
                int argn = 0;
                while (argn < filesToZip.length) {
                    File file = new File(filesToZip[argn]);
                    FileInputStream in = new FileInputStream(file);
                    byte[] bytes = new byte[in.available()];
                    in.read(bytes);
                    in.close();
                    ZipEntry entry = new ZipEntry(file.getName());
                    entry.setTime(file.lastModified());
                    zip.putNextEntry(entry);
                    zip.write(bytes);
                    zip.closeEntry();
                    ++argn;
                }
                zip.close();
                zipOk = true;
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, "Failed to zip " + Arrays.toString(filesToZip) + " to " + zipfile, e);
            }
        }
        return zipOk;
    }

    public static boolean unZip(String zipFile) {
        boolean unZipOk = true;
        File theZipFile = new File(zipFile);
        if (!theZipFile.exists()) {
            unZipOk = false;
        }
        if (!theZipFile.canRead() && !theZipFile.canWrite()) {
            unZipOk = false;
        }
        if (unZipOk) {
            try {
                ZipFile archive = new ZipFile(zipFile);
                String extractionPath = zipFile.substring(0, zipFile.lastIndexOf("/") + 1);
                byte[] buffer = new byte[16384];
                Enumeration<? extends ZipEntry> e = archive.entries();
                while (e.hasMoreElements()) {
                    int count;
                    File parentFile;
                    ZipEntry entry = e.nextElement();
                    String filename = entry.getName();
                    filename = filename.replace('/', File.separatorChar);
                    File destFile = new File(String.valueOf(extractionPath) + filename);
                    if (destFile.exists()) {
                        logger.info("..deleting " + filename);
                        destFile.delete();
                    }
                    if (destFile.exists()) {
                        logger.info("..skipping " + filename + " (overwrite not implemented).");
                        continue;
                    }
                    logger.info("..writing " + filename);
                    String parent = destFile.getParent();
                    if (parent != null && !(parentFile = new File(parent)).exists()) {
                        parentFile.mkdirs();
                    }
                    InputStream in = archive.getInputStream(entry);
                    FileOutputStream out = new FileOutputStream(String.valueOf(extractionPath) + filename);
                    while ((count = in.read(buffer)) != -1) {
                        ((OutputStream)out).write(buffer, 0, count);
                    }
                    in.close();
                    out.flush();
                    ((OutputStream)out).close();
                    out = null;
                }
            }
            catch (Exception e) {
                unZipOk = false;
                logger.log(Level.WARNING, "Failed to unzip " + zipFile, e);
            }
        }
        return unZipOk;
    }

    public static boolean unZip(String zipFile, String destination) {
        String dir = destination;
        if (dir.charAt(dir.length() - 1) != '/') {
            dir = String.valueOf(dir) + "/";
        }
        return ZipUnzip.unZip(new File(zipFile), new File(dir));
    }

    public static boolean unZip(File zipFile, File to) {
        block24: {
            if (!zipFile.exists()) {
                logger.log(Level.INFO, "File does not exist " + zipFile);
                return false;
            }
            ZipFile zf = null;
            try {
                zf = new ZipFile(zipFile);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Cant open for reading " + zipFile, e);
                return false;
            }
            try {
                try {
                    int BUFFER = 8192;
                    BufferedOutputStream dest = null;
                    BufferedInputStream is = null;
                    Enumeration<? extends ZipEntry> zipEnum = zf.entries();
                    while (zipEnum.hasMoreElements()) {
                        File parentFile;
                        ZipEntry item = zipEnum.nextElement();
                        if (item.isDirectory()) {
                            File newdir = new File(to, item.getName());
                            logger.info("Creating directory " + newdir + "... ");
                            newdir.mkdirs();
                            logger.info("Done!");
                            continue;
                        }
                        String filename = item.getName();
                        File destFile = new File(to, filename = filename.replace('/', File.separatorChar));
                        if (destFile.exists()) {
                            logger.info("..overwriting " + destFile);
                            destFile.delete();
                        }
                        logger.info("..writing " + destFile);
                        String parent = destFile.getParent();
                        if (parent != null && !(parentFile = new File(parent)).exists()) {
                            parentFile.mkdirs();
                        }
                        logger.info("Writing " + destFile + "... ");
                        is = new BufferedInputStream(zf.getInputStream(item));
                        int remaining = (int)item.getSize();
                        if (remaining == 0) {
                            FileOutputStream fos = new FileOutputStream(destFile);
                            fos.flush();
                            fos.close();
                        } else {
                            int count;
                            byte[] data = new byte[BUFFER];
                            FileOutputStream fos = new FileOutputStream(destFile);
                            dest = new BufferedOutputStream(fos, Math.min(BUFFER, remaining));
                            while (remaining > 0 && (count = is.read(data, 0, Math.min(BUFFER, remaining))) != -1) {
                                dest.write(data, 0, count);
                                remaining -= count;
                            }
                            dest.flush();
                            dest.close();
                            fos.close();
                        }
                        is.close();
                        logger.info("Done!");
                    }
                    zf.close();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "ERREUR: " + zipFile + " -> " + to, e);
                    try {
                        if (zf != null) {
                            zf.close();
                        }
                        break block24;
                    }
                    catch (IOException iOException) {}
                    break block24;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (zf != null) {
                        zf.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (zf != null) {
                    zf.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static void main(String[] args) {
        File file = new File("F:/Users/sstlaurent/Desktop/ca.infodata.ramq.b2b.zip");
        File to = new File("F:/Users/sstlaurent/Desktop/test4");
        boolean r = ZipUnzip.unZip(file, to);
        System.out.println(r);
    }
}

