/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.library.log.Log;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class MoneyText
extends Canvas {
    private Text myText;
    protected boolean fromMe;
    protected int maxNumberBefore;
    protected int maxNumberAfter;

    public static MoneyText getInstance(Composite parent, Integer style) {
        return new MoneyText(parent, style);
    }

    public MoneyText(Composite parent, int style, int maxNumberBefore, int maxNumberAfter) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.myText = new Text((Composite)this, style);
        TextChangeListener list = new TextChangeListener();
        this.myText.addListener(25, (Listener)list);
        this.myText.addListener(24, (Listener)list);
        this.myText.addListener(16, (Listener)list);
        this.myText.addListener(15, (Listener)list);
        this.myText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int textLimit = ((Text)e.widget).getTextLimit();
                if (textLimit != -1 && ((Text)e.widget).getText().length() > textLimit) {
                    ((Text)e.widget).setText(((Text)e.widget).getText().substring(0, textLimit));
                }
            }
        });
        this.fromMe = false;
        this.maxNumberBefore = maxNumberBefore;
        this.maxNumberAfter = maxNumberAfter;
    }

    public MoneyText(Composite parent, int style) {
        this(parent, style, 8, 2);
    }

    public String getText() {
        return this.myText.getText();
    }

    public void setText(String text) {
        this.fromMe = true;
        try {
            this.myText.setText(text);
        }
        catch (Exception e) {
            Log.severe((String)"Erreur", (Exception)e);
            this.myText.setText("");
        }
        this.fromMe = false;
    }

    public void setEnabled(boolean value) {
        this.myText.setEnabled(value);
        super.setEnabled(value);
    }

    public void addKeyListener(KeyListener kl) {
        this.myText.addKeyListener(kl);
    }

    public void addModifyListener(ModifyListener ml) {
        this.myText.addModifyListener(ml);
    }

    public void addVerifyListener(VerifyListener ml) {
        this.myText.addVerifyListener(ml);
    }

    public void setVisible(boolean visible) {
        this.myText.setVisible(visible);
    }

    public boolean getVisible() {
        return this.myText.getVisible();
    }

    private class TextChangeListener
    implements Listener {
        private TextChangeListener() {
        }

        public void handleEvent(Event event) {
            if (!MoneyText.this.fromMe) {
                if (event.type == 25) {
                    if (event.character != '\b' && event.character != '\u007f') {
                        if (event.character >= '0' && event.character <= '9') {
                            int positionDot = MoneyText.this.myText.getText().indexOf(".");
                            if (positionDot != -1 && ((MoneyText)MoneyText.this).myText.getSelection().x > positionDot) {
                                if (MoneyText.this.myText.getText().length() - positionDot > MoneyText.this.maxNumberAfter && ((MoneyText)MoneyText.this).myText.getSelection().x == ((MoneyText)MoneyText.this).myText.getSelection().y) {
                                    event.doit = false;
                                }
                            } else if (((MoneyText)MoneyText.this).myText.getSelection().x == ((MoneyText)MoneyText.this).myText.getSelection().y) {
                                if (positionDot == -1) {
                                    positionDot = MoneyText.this.myText.getText().length();
                                }
                                if (positionDot + 1 > MoneyText.this.maxNumberBefore) {
                                    event.doit = false;
                                }
                            }
                        } else if (event.character == ',' || event.character == '.') {
                            if (MoneyText.this.myText.getText().indexOf(".") != -1) {
                                event.doit = false;
                            } else if (MoneyText.this.myText.getText().length() - ((MoneyText)MoneyText.this).myText.getSelection().y > 2) {
                                event.doit = false;
                            }
                        } else {
                            event.doit = false;
                        }
                    }
                } else if (event.type == 16) {
                    int positionDot = MoneyText.this.myText.getText().indexOf(".");
                    if (positionDot == 0 || MoneyText.this.myText.getText().length() == 0) {
                        MoneyText.this.fromMe = true;
                        MoneyText.this.myText.setText("0" + MoneyText.this.myText.getText());
                        MoneyText.this.fromMe = false;
                    }
                    if ((positionDot = MoneyText.this.myText.getText().indexOf(".")) != -1 && MoneyText.this.myText.getText().length() > positionDot) {
                        int i = MoneyText.this.myText.getText().length() - positionDot - 1;
                        while (i < 2) {
                            MoneyText.this.fromMe = true;
                            MoneyText.this.myText.setText(String.valueOf(MoneyText.this.myText.getText()) + "0");
                            MoneyText.this.fromMe = false;
                            ++i;
                        }
                    } else {
                        MoneyText.this.fromMe = true;
                        MoneyText.this.myText.setText(String.valueOf(MoneyText.this.myText.getText()) + ".00");
                        MoneyText.this.fromMe = false;
                    }
                    MoneyText.this.myText.setBackground(null);
                } else if (event.type == 24) {
                    int tempSelect = ((MoneyText)MoneyText.this).myText.getSelection().x;
                    MoneyText.this.fromMe = true;
                    MoneyText.this.myText.setText(MoneyText.this.myText.getText().replaceAll(",", "."));
                    MoneyText.this.fromMe = false;
                    MoneyText.this.myText.setSelection(tempSelect);
                } else if (event.type == 15) {
                    MoneyText.this.myText.selectAll();
                }
            }
        }
    }
}

