/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.MyMask;
import ca.infodata.util1.PredicateA;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class MaskedTextCellEditor
extends TextCellEditor {
    public static final int VALID_WITH_COLOR = 2;
    public static final int VALID_FIELD_MUST_NOT_BE_EMPTY = 4;
    public static final int VALID_FIELD_MUST_BE_COMPLETE = 8;
    public static final int VALID_NOT_SET_TEXT = 16;
    private boolean autoTraverseTabNextOnMaskLimit;
    private boolean externModifyTextDoit = true;
    private final List<ModifyListenerProxy> modifyListeners = new ArrayList<ModifyListenerProxy>();
    private final List<ListenerProxy> plainModifyListeners = new ArrayList<ListenerProxy>();
    private MyMask mask;
    private Color foreground;
    private Color background;
    private Color defaulInvalidTextColor;
    private Color invalidTextColor;
    private TextChangeListener listener;
    private int validStyle;
    private boolean validWithColor;
    private boolean validFieldMustBeComplete;
    private boolean validFieldMustNotBeEmpty;
    private boolean validNotSetText;
    private String newText;
    private Point newSelection = new Point(-1, -1);
    private boolean settext;
    private PredicateA<String> validPredicate;
    private final DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (MaskedTextCellEditor.this.defaulInvalidTextColor != null && !MaskedTextCellEditor.this.defaulInvalidTextColor.isDisposed()) {
                MaskedTextCellEditor.this.defaulInvalidTextColor.dispose();
            }
        }
    };
    protected static final String CASE_OBLIGATOIRE = Messages.getString((String)"CASE_OBLIGATOIRE", (String[])new String[0]);
    protected Image fieldDecorationErrorImage;
    protected Image fieldDecorationRequiredImage;
    protected ControlDecoration controlDecorationRequired = null;
    protected ControlDecoration controlDecorationError = null;

    protected MaskedTextCellEditor(Composite parent, int style) {
        super(parent, style);
        this.foreground = this.text.getForeground();
        this.background = this.text.getBackground();
        this.invalidTextColor = this.defaulInvalidTextColor = new Color((Device)this.text.getDisplay(), 255, 100, 100);
        this.listener = new TextChangeListener();
        this.addListeners();
    }

    private void addListeners() {
        this.text.addListener(24, (Listener)this.listener);
        this.text.addListener(25, (Listener)this.listener);
        this.text.addListener(16, (Listener)this.listener);
        this.text.addListener(15, (Listener)this.listener);
        this.text.addDisposeListener(this.disposeListener);
    }

    private void verifyEvent(Event event) {
        if (this.mask != null) {
            boolean valid;
            int count;
            String text;
            String oldText = this.text.getText();
            Point selection = this.text.getSelection();
            int selectionCount = this.text.getSelectionCount();
            if (event.character == '\b') {
                text = this.mask.starve(oldText, selection.y, Math.max(selectionCount, 1));
                count = oldText.length() - text.length();
                this.newSelection.y = this.newSelection.x = selection.x - count;
            } else if (event.character == '\u007f') {
                text = selection.x == selection.y ? this.mask.starve2(oldText, selection.x, selection.y + 1) : this.mask.starve2(oldText, selection.x, selection.y);
                this.newSelection.y = this.newSelection.x = selection.x;
            } else if (event.character != '\u0000' && selectionCount == 0) {
                text = this.mask.feed(oldText, selection.x, event.character);
                count = text.length() - oldText.length();
                this.newSelection.y = this.newSelection.x = selection.x + count;
            } else {
                if (this.settext) {
                    text = event.text;
                    this.newSelection.x = selection.x;
                    this.newSelection.y = selection.y;
                } else {
                    text = new StringBuilder(oldText).replace(selection.x, selection.y, event.text).toString();
                    count = event.text.length();
                    this.newSelection.y = this.newSelection.x = selection.x + count;
                }
                if (!(this.mask.valid(text) || this.settext && this.validNotSetText)) {
                    text = this.mask.apply(text);
                    this.newSelection.y = this.newSelection.x = text.length();
                }
            }
            boolean bl = valid = this.settext && this.validNotSetText || this.mask.valid(text);
            if (text != oldText && valid) {
                event.doit = true;
                this.newText = text;
            } else {
                event.doit = false;
            }
            this.setForegroundColor(valid, text);
            this.setBackgroundColor(valid, text);
        }
    }

    private void modifyEvent(Event event) {
        if (this.mask != null) {
            if (!this.text.getText().equals(this.newText)) {
                this.text.setText(this.newText);
                this.text.setSelection(this.newSelection);
            }
            if (this.autoTraverseTabNextOnMaskLimit && this.text.isFocusControl() && this.text.getText().length() == this.mask.getMask().length() && this.text.getCaretPosition() == this.mask.getMask().length()) {
                this.text.traverse(16);
            }
        }
    }

    private void focusOutEvent() {
        this.valid();
    }

    private void focusInEvent() {
        if (this.mask != null && this.validWithColor) {
            this.text.setForeground(this.foreground);
            this.text.setBackground(this.background);
        }
    }

    public boolean valid() {
        String text = this.text.getText();
        boolean valid = true;
        if (this.mask != null) {
            if (this.validFieldMustBeComplete) {
                boolean bl = valid = valid && (text.length() == 0 || text.length() == this.mask.getMask().length());
            }
            if (this.validFieldMustNotBeEmpty) {
                valid = valid && text.length() != 0;
            }
            valid = valid && this.mask.valid(text);
            valid = valid && (this.getValidPredicate() == null || this.getValidPredicate().evaluate((Object)text));
        }
        this.setForegroundColor(valid, text);
        this.setBackgroundColor(valid, text);
        return valid;
    }

    private void setForegroundColor(boolean valid, String text) {
        if (this.validWithColor && text != null && text.length() != 0) {
            if (valid) {
                this.text.setForeground(this.foreground);
            } else {
                if (this.getInvalidTextColor() == null) {
                    throw new IllegalStateException("invalidTextColor is null");
                }
                this.text.setForeground(this.getInvalidTextColor());
            }
        }
    }

    private void setBackgroundColor(boolean valid, String text) {
        if (this.validWithColor && (text == null || text.length() == 0)) {
            if (valid) {
                this.text.setBackground(this.background);
            } else {
                if (this.getInvalidTextColor() == null) {
                    throw new IllegalStateException("invalidTextColor is null");
                }
                this.text.setBackground(this.getInvalidTextColor());
            }
        }
    }

    public Color getInvalidTextColor() {
        return this.invalidTextColor;
    }

    public void setInvalidTextColor(Color color) {
        this.invalidTextColor = color;
    }

    public void addModifyListener(ModifyListener ml) {
        if (ml == null) {
            throw new NullPointerException();
        }
        ModifyListenerProxy proxy = new ModifyListenerProxy(ml);
        this.modifyListeners.add(proxy);
        this.text.addModifyListener((ModifyListener)proxy);
    }

    public void addListener(int eventType, Listener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (eventType == 24) {
            ListenerProxy proxy = new ListenerProxy(listener);
            this.plainModifyListeners.add(proxy);
            this.text.addListener(eventType, (Listener)proxy);
        } else {
            this.text.addListener(eventType, listener);
        }
    }

    public void removeListener(int eventType, Listener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (eventType == 24) {
            Iterator<ListenerProxy> iterator = this.plainModifyListeners.iterator();
            while (iterator.hasNext()) {
                ListenerProxy proxy = iterator.next();
                if (!proxy.listener.equals(listener)) continue;
                this.text.removeListener(eventType, (Listener)proxy);
                iterator.remove();
            }
        } else {
            this.text.removeListener(eventType, listener);
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Iterator<ModifyListenerProxy> iterator = this.modifyListeners.iterator();
        while (iterator.hasNext()) {
            ModifyListenerProxy proxy = iterator.next();
            if (!proxy.listener.equals(listener)) continue;
            this.text.removeModifyListener((ModifyListener)proxy);
            iterator.remove();
        }
    }

    public int getValidStyle() {
        return this.validStyle;
    }

    public void setValidStyle(int style) {
        this.validStyle = style;
        this.validWithColor = (style | 2) == style;
        this.validFieldMustBeComplete = (style | 8) == style;
        this.validFieldMustNotBeEmpty = (style | 4) == style;
        this.validNotSetText = (style | 0x10) == style;
        this.showRequiredFieldDecorator(this.validFieldMustNotBeEmpty);
        if (!this.validWithColor) {
            this.setForeground(this.foreground);
            this.setBackground(this.background);
        }
    }

    public void showRequiredFieldDecorator(boolean b) {
        if (b) {
            if (this.controlDecorationRequired == null) {
                this.fieldDecorationRequiredImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage();
                this.controlDecorationRequired = new ControlDecoration(this.getControl(), 0x1004000);
                this.controlDecorationRequired.setMarginWidth(0);
                this.controlDecorationRequired.setImage(this.fieldDecorationRequiredImage);
                this.controlDecorationRequired.setDescriptionText(CASE_OBLIGATOIRE);
            }
            this.controlDecorationRequired.show();
        } else if (this.controlDecorationRequired != null) {
            this.controlDecorationRequired.hide();
        }
    }

    public MyMask getMask() {
        return this.mask;
    }

    public void setMask(MyMask mask) {
        this.mask = mask;
    }

    public boolean isAutoTraverseTabNextOnMaskLimit() {
        return this.autoTraverseTabNextOnMaskLimit;
    }

    public void setAutoTraverseTabNextOnMaskLimit(boolean autoTraverseTabNextOnMaskLimit) {
        this.autoTraverseTabNextOnMaskLimit = autoTraverseTabNextOnMaskLimit;
    }

    public void copy() {
        this.text.copy();
    }

    public void cut() {
        this.text.cut();
    }

    public void paste() {
        this.text.paste();
    }

    public String getRawText() {
        return this.text.getText();
    }

    public String getText() {
        if (this.mask != null) {
            return this.mask.unapply(this.text.getText());
        }
        return this.text.getText();
    }

    public String getText(int start, int end) {
        return this.text.getText(start, end);
    }

    public int getTextLimit() {
        return this.text.getTextLimit();
    }

    public void selectAll() {
        this.text.selectAll();
    }

    public void setBackground(Color color) {
        this.text.setBackground(color);
        this.background = color;
    }

    public void setForeground(Color color) {
        this.text.setForeground(color);
        this.foreground = color;
    }

    public void clear() {
        this.setRawText(null);
    }

    public void setText(String string) {
        String string2 = string = string == null ? "" : string;
        if (this.mask != null && !this.validNotSetText) {
            string = this.mask.apply(string);
        }
        this.setRawText(string);
    }

    public void setTextKeepSelection(String string) {
        String string2 = string = string == null ? "" : string;
        if (this.mask != null && !this.validNotSetText) {
            string = this.mask.apply(string);
        }
        this.setRawTextKeepSelection(string);
    }

    public void setRawText(String string) {
        string = string == null ? "" : string;
        this.settext = true;
        this.text.setText(string);
        this.settext = false;
    }

    public void setRawTextKeepSelection(String string) {
        string = string == null ? "" : string;
        this.settext = true;
        Point selection = this.text.getSelection();
        this.text.setText(string);
        this.text.setSelection(selection);
        this.settext = false;
    }

    public PredicateA<String> getValidPredicate() {
        return this.validPredicate;
    }

    public void setValidPredicate(PredicateA<String> validPredicate) {
        this.validPredicate = validPredicate;
    }

    private class ListenerProxy
    implements Listener {
        private Listener listener;

        private ListenerProxy(Listener listener) {
            this.listener = listener;
        }

        public void handleEvent(Event e) {
            if (MaskedTextCellEditor.this.externModifyTextDoit) {
                this.listener.handleEvent(e);
            }
        }
    }

    private class ModifyListenerProxy
    implements ModifyListener {
        private ModifyListener listener;

        private ModifyListenerProxy(ModifyListener listener) {
            this.listener = listener;
        }

        public void modifyText(ModifyEvent e) {
            if (MaskedTextCellEditor.this.externModifyTextDoit) {
                this.listener.modifyText(e);
            }
        }
    }

    private class TextChangeListener
    implements Listener {
        private TextChangeListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 16) {
                MaskedTextCellEditor.this.focusOutEvent();
            } else if (event.type == 15) {
                MaskedTextCellEditor.this.focusInEvent();
            }
            if (!MaskedTextCellEditor.this.externModifyTextDoit) {
                return;
            }
            MaskedTextCellEditor.this.externModifyTextDoit = false;
            if (event.type == 25) {
                MaskedTextCellEditor.this.verifyEvent(event);
            } else if (event.type == 24) {
                MaskedTextCellEditor.this.modifyEvent(event);
            }
            MaskedTextCellEditor.this.externModifyTextDoit = true;
        }
    }
}

