/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.ui.controls.DateMask;
import ca.infodata.ofys.ui.controls.DateText;
import ca.infodata.ofys.ui.controls.MaskedTextCellEditor;
import ca.infodata.ofys.ui.controls.MyMask;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import ca.infodata.util1.date.PartialDate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class DateTextCellEditor
extends MaskedTextCellEditor {
    private static final Logger logger = Logger.getLogger(IDateListener.class.getName());
    public static IPartialDate dateIdem;
    private String rawTextCache;
    private IPartialDate dateCache;
    private boolean allowPartial;
    private ArrayList<IDateListener> dateListeners = new ArrayList();
    static boolean ignore;

    static {
        ignore = false;
    }

    public DateTextCellEditor(Composite parent) {
        super(parent, 0);
        this.init();
    }

    public DateTextCellEditor(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    private void init() {
        this.setMask(DateMask.getInstance());
        this.setValidStyle(8);
        Listener listener = new Listener(){
            private IPartialDate dateCache2;
            private LocalDate dateCache3;

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 1: {
                        DateTextCellEditor.this.processCustomKeys(e);
                        break;
                    }
                    case 15: {
                        DateTextCellEditor.this.selectAll();
                        break;
                    }
                    case 16: {
                        dateIdem = DateTextCellEditor.this.getDate();
                        if (DateTextCellEditor.this.allowPartial) break;
                        DateTextCellEditor.this.autoComplete();
                        break;
                    }
                    case 24: {
                        LocalDate date;
                        IPartialDate partial;
                        if (DateTextCellEditor.this.allowPartial && this.dateCache2 != (partial = DateTextCellEditor.this.getPartialDate())) {
                            DateTextCellEditor.this.firePartialDateChanged(partial);
                            this.dateCache2 = partial;
                        }
                        if (this.dateCache3 == (date = DateTextCellEditor.this.getDate())) break;
                        DateTextCellEditor.this.fireDateChanged(date);
                        this.dateCache3 = date;
                        break;
                    }
                }
            }
        };
        this.addListener(1, listener);
        this.addListener(15, listener);
        this.addListener(16, listener);
        this.addListener(24, listener);
        this.getControl().setToolTipText(Messages.getString((String)"DATE_TTT", (String[])new String[0]));
    }

    @Override
    public void setMask(MyMask mask) {
        if (!(mask instanceof DateMask)) {
            throw new IllegalArgumentException("mask must be instance of DateMask");
        }
        super.setMask(mask);
    }

    private void autoComplete() {
        String rawText = this.getRawText();
        int length = rawText.length();
        if (length >= 3 && length <= 4) {
            try {
                int month = Integer.parseInt(rawText.substring(0, 2));
                int day = Integer.parseInt(rawText.substring(2));
                this.setDate((IPartialDate)LocalDate.today().withMonth(month).withDay(day));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if (length >= 1 && length <= 2) {
            try {
                int day = Integer.parseInt(rawText);
                this.setDate((IPartialDate)LocalDate.today().withDay(day));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void processCustomKeys(Event e) {
        if (e.keyCode == 127) {
            this.setDate(null);
            return;
        }
        if (e.character == '\u0000' && e.keyCode == 0) {
            return;
        }
        IPartialDate date = this.getPartialDate();
        if (date == null) {
            date = LocalDate.today();
        }
        switch (e.character) {
            case 'T': 
            case 't': {
                this.setDate((IPartialDate)LocalDate.today());
                break;
            }
            case 'D': 
            case 'd': {
                break;
            }
            case 'X': 
            case 'x': {
                this.plusDay(date, 1);
                break;
            }
            case 'Z': 
            case 'z': {
                this.plusDay(date, -1);
                break;
            }
            case 'S': 
            case 's': {
                this.plusDay(date, 7);
                break;
            }
            case 'A': 
            case 'a': {
                this.plusDay(date, -7);
                break;
            }
            case 'W': 
            case 'w': {
                this.plusMonth(date, 1);
                break;
            }
            case 'Q': 
            case 'q': {
                this.plusMonth(date, -1);
                break;
            }
            case 'E': 
            case 'e': {
                this.plusYear(date, -1);
                break;
            }
            case 'R': 
            case 'r': {
                this.plusYear(date, 1);
                break;
            }
            case 'M': 
            case 'm': {
                this.withMonthFirst(date);
                break;
            }
            case 'H': 
            case 'h': {
                this.withMonthEnd(date);
                break;
            }
            case 'I': 
            case 'i': {
                if (dateIdem == null) break;
                this.setDate(dateIdem);
            }
        }
    }

    private void withMonthEnd(IPartialDate date) {
        assert (date != null);
        if (date instanceof LocalDate) {
            this.setDate((IPartialDate)((LocalDate)date).withDay(((LocalDate)date).getMonthEnd()));
        }
        if (date instanceof PartialDate) {
            LocalDate today = LocalDate.today();
            PartialDate partial = (PartialDate)date;
            int day2 = partial.getDay() == null ? today.day : partial.getDay();
            int month2 = partial.getMonth() == null ? today.month : partial.getMonth();
            int year2 = partial.getYear() == null ? today.year : partial.getYear();
            LocalDate date2 = LocalDate.from((int)day2, (int)month2, (int)year2);
            this.setDate((IPartialDate)date2.withDay(date2.getMonthEnd()));
        }
    }

    private void withMonthFirst(IPartialDate date) {
        assert (date != null);
        if (date instanceof LocalDate) {
            this.setDate((IPartialDate)((LocalDate)date).withDay(1));
        }
        if (date instanceof PartialDate) {
            LocalDate today = LocalDate.today();
            PartialDate partial = (PartialDate)date;
            int day2 = partial.getDay() == null ? today.day : partial.getDay();
            int month2 = partial.getMonth() == null ? today.month : partial.getMonth();
            int year2 = partial.getYear() == null ? today.year : partial.getYear();
            this.setDate((IPartialDate)LocalDate.from((int)day2, (int)month2, (int)year2).withDay(1));
        }
    }

    private void plusDay(IPartialDate partial, int day) {
        assert (partial != null);
        LocalDate today = LocalDate.today();
        int day2 = partial.getDay() == null ? today.day : partial.getDay();
        int month2 = partial.getMonth() == null ? today.month : partial.getMonth();
        int year2 = partial.getYear() == null ? today.year : partial.getYear();
        this.setDate((IPartialDate)LocalDate.from((int)day2, (int)month2, (int)year2).plusDay(day));
    }

    private void plusMonth(IPartialDate partial, int month) {
        assert (partial != null);
        LocalDate newDate = LocalDate.from((IPartialDate)partial).plusMonth(month);
        Integer day2 = partial.getDay();
        if (day2 != null) {
            if (day2 > newDate.getMonthEnd()) {
                day2 = newDate.getMonthEnd();
            } else if (day2 < 1) {
                day2 = 1;
            }
            newDate.withDay(day2.intValue());
        }
        PartialDate newPartial = PartialDate.from((LocalDate)newDate);
        this.setDate((IPartialDate)PartialDate.from((Integer)(day2 == null ? null : newPartial.getDay()), (Integer)newPartial.getMonth(), (Integer)newPartial.getYear()));
    }

    private void plusYear(IPartialDate partial, int year) {
        Integer day2;
        assert (partial != null);
        LocalDate today = LocalDate.today();
        int year2 = partial.getYear() == null ? today.year : partial.getYear();
        LocalDate newDate = today.withYear(year2 += year);
        Integer month2 = partial.getMonth();
        if (month2 != null) {
            if (month2 < 1) {
                month2 = 1;
            } else if (month2 > 12) {
                month2 = 12;
            }
            newDate = newDate.withMonth(month2.intValue());
        }
        if ((day2 = partial.getDay()) != null) {
            if (day2 > newDate.getMonthEnd()) {
                day2 = newDate.getMonthEnd();
            } else if (day2 < 1) {
                day2 = 1;
            }
        }
        this.setDate((IPartialDate)PartialDate.from((Integer)day2, (Integer)month2, (Integer)year2));
    }

    public void setDate(IPartialDate date) {
        if (date == null) {
            this.clear();
        } else if (date == this.dateCache) {
            this.setRawText(this.getRawText());
        } else {
            this.setRawText(date.formatHyphen());
        }
    }

    public LocalDate getDate() {
        IPartialDate date = this.getPartialDate();
        if (date == null) {
            return null;
        }
        if (date instanceof LocalDate) {
            return (LocalDate)date;
        }
        if (date.isComplete()) {
            return LocalDate.from((IPartialDate)date);
        }
        return null;
    }

    public IPartialDate getPartialDate() {
        IPartialDate date = this.dateCache;
        String rawText = this.getText();
        if (rawText.equals(this.rawTextCache)) {
            return this.dateCache;
        }
        int len = rawText.length();
        if (len <= 4) {
            try {
                int year = Integer.parseInt(rawText);
                date = PartialDate.from(null, null, (Integer)year);
            }
            catch (NumberFormatException numberFormatException) {
                date = null;
            }
        } else if (len <= 6) {
            try {
                int year = Integer.parseInt(rawText.substring(0, 4));
                int month = Integer.parseInt(rawText.substring(4, rawText.length()));
                date = PartialDate.from(null, (Integer)(month == 0 ? null : Integer.valueOf(month)), (Integer)year);
            }
            catch (NumberFormatException numberFormatException) {
                date = null;
            }
        } else if (len < 10) {
            try {
                int year = Integer.parseInt(rawText.substring(0, 4));
                int month = Integer.parseInt(rawText.substring(4, 6));
                int day = Integer.parseInt(rawText.substring(6, rawText.length()));
                date = PartialDate.from((Integer)(day == 0 ? null : Integer.valueOf(day)), (Integer)month, (Integer)year);
            }
            catch (NumberFormatException numberFormatException) {
                date = null;
            }
        } else if (rawText.length() == 10) {
            try {
                date = LocalDateFormat.parse((String)rawText, (String)FormatDateProvider.getFormatDate().toString());
            }
            catch (ParseException parseException) {
                date = null;
            }
        } else {
            date = null;
        }
        this.rawTextCache = rawText;
        this.dateCache = date;
        return date;
    }

    public void addDateListener(IDateListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.dateListeners.add(listener);
    }

    public void removeDateListener(IDateListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.dateListeners.remove(listener);
    }

    private void firePartialDateChanged(IPartialDate date) {
        try {
            for (IDateListener listener : this.dateListeners) {
                listener.partialChanged(date);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while notifying dateChanged event", e);
        }
    }

    private void fireDateChanged(LocalDate date) {
        try {
            for (IDateListener listener : this.dateListeners) {
                listener.dateChanged(date);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while notifying dateChanged event", e);
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        final DateText dateText = new DateText((Composite)shell, 2048);
        dateText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ignore) {
                    return;
                }
                System.out.println(dateText.getDate());
                ignore = true;
                dateText.setRawTextKeepSelection(dateText.getRawText());
                ignore = false;
            }
        });
        Button button = new Button((Composite)shell, 8);
        button.setText("test");
        button.setFocus();
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                dateText.clear();
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public boolean getAllowPartial() {
        return this.allowPartial;
    }

    public void setAllowPartial(boolean allowPartial) {
        this.allowPartial = allowPartial;
    }

    protected Object doGetValue() {
        return this.getDate();
    }

    protected void doSetValue(Object value) {
        if (value == null || value instanceof LocalDate) {
            this.setDate((IPartialDate)value);
        } else {
            super.doSetValue(value);
        }
    }

    public static class DateAdapter
    implements IDateListener {
        @Override
        public void dateChanged(LocalDate date) {
        }

        @Override
        public void partialChanged(IPartialDate date) {
        }
    }

    public static interface IDateListener {
        public void dateChanged(LocalDate var1);

        public void partialChanged(IPartialDate var1);
    }
}

