/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JustLogStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.BaseView;
import ca.infodata.ofys.ui.controls.IContributionManagerExtension;
import ca.infodata.ofys.ui.controls.template.NullTemplateAccessorClient;
import ca.infodata.ofys.ui.controls.template.TemplateAccessorClient;
import ca.infodata.ofys.ui.controls.util.IDialogSettings3;
import ca.infodata.ofys.ui.controls.util.PreferencesSettings;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.util.MiscUtil;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ControlsPlugin
extends AbstractUIPlugin {
    private static final Logger logger = Logger.getLogger(ControlsPlugin.class.getName());
    private static ControlsPlugin plugin;
    private static IStatusHandler statusHandler;
    private PreferencesSettings settings;
    private GlobalInstancesAdapter sessionListener;

    static {
        statusHandler = new JustLogStatusHandler();
    }

    public ControlsPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.configureTemplateService();
        this.settings = new PreferencesSettings(".settings", "root");
        PreferencesSettings.setInstance(this.settings);
        this.sessionListener = new GlobalInstancesAdapter(){

            public void sessionChanged() {
                ControlsPlugin.this.settings.setKeyPrefix(ControlsPlugin.this.settings.getClientCodeUserNamePrefixFromSession());
                ControlsPlugin.this.configureCityIndex();
            }
        };
        Application.get().getGlobalInstances().addGlobalInstancesListener((GlobalInstancesListener)this.sessionListener);
    }

    private void configureTemplateService() {
        try {
            if (Application.get().getGlobalInstances().getTemplateConnectionInfo() != null) {
                TemplateAccessorClient.setInstance(new TemplateAccessorClient());
            } else {
                TemplateAccessorClient.setInstance(new NullTemplateAccessorClient());
            }
        }
        catch (Exception e) {
            TemplateAccessorClient.setInstance(new NullTemplateAccessorClient());
            logger.log(Level.WARNING, "Failed to instanciate TemplateAccessorClient", e);
        }
    }

    protected void configureCityIndex() {
        if (Application.get().getGlobalInstances().isNBClient()) {
            LibPlugin.getDefault().getCityIndex().setNBOrdering();
        } else {
            LibPlugin.getDefault().getCityIndex().setQCOrdering();
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.settings.save();
        PreferencesSettings.setInstance(null);
        Application.get().getGlobalInstances().removeGlobalInstancesListener((GlobalInstancesListener)this.sessionListener);
        super.stop(context);
    }

    public static ControlsPlugin getDefault() {
        return plugin;
    }

    public static void setDefaultStatusHandler(IStatusHandler statusHandler) {
        if (statusHandler == null) {
            throw new NullPointerException("statusHandler");
        }
        ControlsPlugin.statusHandler = statusHandler;
    }

    public static IStatusHandler getDefaultStatusHandler() {
        return statusHandler;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchPage page = BaseView.getPage();
        if (page == null) {
            IWorkbenchWindow wwin;
            IWorkbench win = PlatformUI.getWorkbench();
            if (win != null && win.getActiveWorkbenchWindow() != null && win.getActiveWorkbenchWindow().getActivePage() != null) {
                page = win.getActiveWorkbenchWindow().getActivePage();
            }
            if (page == null && win != null && win.getWorkbenchWindowCount() > 0 && (page = (wwin = win.getWorkbenchWindows()[0]).getActivePage()) == null) {
                page = win.getWorkbenchWindows()[0].getPages()[0];
            }
        }
        return page;
    }

    public static Control newUnexpectedExceptionControl(Composite parent) {
        final Image image = ResourceGetter.getSystemImage((int)1);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ResourceGetter.dispose((Object)image);
            }
        });
        Composite container = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 10;
        layout.marginRight = 10;
        layout.marginLeft = 10;
        layout.marginTop = 10;
        layout.spacing = 10;
        container.setLayout((Layout)layout);
        Label imageLabel = new Label(container, 0);
        image.setBackground(imageLabel.getBackground());
        imageLabel.setImage(image);
        Label messageLabel = new Label(container, 64);
        messageLabel.setText(Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]));
        messageLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = image.getBounds().width;
        data.height = image.getBounds().height;
        imageLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)imageLabel);
        messageLabel.setLayoutData((Object)data);
        return container;
    }

    public static void fillWithContributionManagerExtensions(IContributionManager manager, String targetId) {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("ca.infodata.ofys.ui.controls.contribution");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    String targetId2 = e.getAttribute("targetId");
                    if (!MiscUtil.areObjectsEquals((Object)targetId, (Object)targetId2)) break block4;
                    Object c = e.createExecutableExtension("class");
                    if (c instanceof IContributionManagerExtension) {
                        ((IContributionManagerExtension)c).contribute(manager);
                        break block4;
                    }
                    throw new RuntimeException("ca.infodata.ofys.ui.controls.contribution menu class must be instanceof IContributionManagerExtension " + c);
                }
                catch (CoreException ex) {
                    logger.log(Level.WARNING, "Failed to load contribution " + e.getAttribute("id") + " extension for targetId " + targetId, ex);
                }
            }
            ++n2;
        }
    }

    public IDialogSettings3 getSettings() {
        return this.settings;
    }

    public static File askFolder(final Shell parent, final String defaultDirKey, final String[] filterExt) {
        final String defaultDir = ControlsPlugin.getDefault().getSettings().get(defaultDirKey);
        String filename = null;
        final String[] info = new String[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                FileDialog fd = new FileDialog(parent, 8192);
                fd.setText("Save");
                if (defaultDir != null) {
                    fd.setFilterPath(defaultDir);
                } else {
                    fd.setFilterPath(LibPlugin.OFYS_HOME);
                }
                if (filterExt != null) {
                    fd.setFilterExtensions(filterExt);
                }
                info[0] = fd.open();
                if (info[0] != null && !fd.getFilterPath().equals(defaultDir)) {
                    ControlsPlugin.getDefault().getSettings().put(defaultDirKey, fd.getFilterPath());
                }
            }
        });
        filename = info[0];
        if (filename == null) {
            return null;
        }
        return new File(filename);
    }

    public static class SETTING {
        public static final int NB_RESULT_BY_PAGE = 25;
    }
}

