/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser.util;

import ca.infodata.ofys.ui.browser.sonar.ComponentLoader;
import ca.infodata.ofys.ui.browser.sonar.IComponent;
import ca.infodata.ofys.ui.browser.sonar.IRenderEngine;
import ca.infodata.ofys.ui.browser.util.PlainResourceLoader;
import ca.infodata.ofys.ui.library.file.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.util.resource.Resource;

public class PlainRenderEngine
implements IRenderEngine {
    private static final Logger logger = Logger.getLogger(PlainRenderEngine.class.getName());
    private String location;
    private PlainResourceLoader resourceloader = new PlainResourceLoader();

    @Override
    public void start() {
    }

    @Override
    public String getPartialView(IComponent view) {
        return this.StringToFile(view.getId(), this.getViewPartialContent(view));
    }

    @Override
    public void setRoot(ComponentLoader cloader) {
        if (cloader.getComponentPath() == null) {
            return;
        }
        this.resourceloader.setCloader(cloader);
        this.location = cloader.getComponentPath();
    }

    @Override
    public String getView(IComponent view) {
        return this.StringToFile(String.valueOf(view.getId()) + view.getSkinPath().substring(view.getSkinPath().lastIndexOf(46)), this.getViewContent(view));
    }

    @Override
    public String getViewPartialContent(IComponent view) {
        try {
            if (view.getSkin() == null || view.getSkin().isEmpty()) {
                return this.renderViewToString(view.getSkinPath(), view.getData());
            }
            return view.getSkin();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to render rythm view", e);
            return "";
        }
    }

    @Override
    public String getViewContent(IComponent view) {
        String res = this.getViewPartialContent(view);
        return res;
    }

    @Override
    public String renderViewToString(String viewName, Object data) {
        if (viewName == null || viewName.isEmpty()) {
            throw new IllegalArgumentException("Invalide view path. Cannot evaluate empty path name.");
        }
        String viewContent = "";
        String templatepath = this.getFullName(viewName);
        if (templatepath != null && !templatepath.isEmpty()) {
            try {
                viewContent = this.fileToString(templatepath);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Sonar failed to render rhythm view : " + templatepath, e);
            }
        }
        return viewContent;
    }

    @Override
    public String parseString(String template, Object data) {
        return template;
    }

    @Override
    public void stop() {
    }

    @Override
    public void dispose() {
    }

    public void clearTemplates(File ... paths) {
        File[] fileArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.deleteFolderFiles(file);
            ++n2;
        }
    }

    public boolean deleteFile(File fileToDelete) {
        try {
            return fileToDelete.delete();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void deleteFolderFiles(File folder) {
        try {
            File[] fa;
            if (!folder.isDirectory()) {
                this.deleteFile(folder);
            } else if (!folder.getName().startsWith(".") && (fa = folder.listFiles()) != null) {
                File[] fileArray = folder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    this.deleteFolderFiles(file);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not clear rhythm template files", e);
        }
    }

    private String StringToFile(String fileName, String content) {
        File viewFile = FileUtil.saveToTemp((String)fileName, (String)content);
        return viewFile.getAbsolutePath();
    }

    private String fileToString(String path) {
        Resource res = null;
        try {
            res = this.resourceloader.getResource(path);
        }
        catch (MalformedURLException e) {
            logger.log(Level.SEVERE, "Error getting resource with path : " + path, e);
        }
        if (res != null) {
            try {
                return this.readFile(res.getInputStream());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error getting resource with path : " + path, e);
            }
        }
        return "";
    }

    private String readFile(InputStream f) {
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)f, (Writer)writer, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error reading inputstream", e);
        }
        return writer.toString();
    }

    private String getFullName(String viewName) {
        if (this.location == null || this.location.equals("")) {
            throw new IllegalArgumentException("Invalide file location. The home folder for the file " + viewName + " is not valide.");
        }
        if (viewName == null || viewName.equals("")) {
            throw new NullPointerException("Invalide template file reference.");
        }
        return String.valueOf(this.location) + viewName;
    }
}

