/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser.sonar;

import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.IWebSocketRequest;
import ca.infodata.ofys.client.web.core.WebApplication;
import ca.infodata.ofys.ui.browser.sonar.SonarWSRequest;
import ca.infodata.util1.StringUtils;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;

public class SonarRequest
implements IServerRequest {
    private static final Logger logger = Logger.getLogger(SonarRequest.class.getName());
    public static final String POSTBODY = "jsonData";
    public HttpServletRequest request;
    public HttpServletResponse response;
    public SonarWSRequest wsrequest;
    public RemoteEndpoint remote;
    public Boolean resolved = false;
    public String path;
    public Map<String, String> params;

    public String toString() {
        return "SonarRequest [request=" + this.request + ", wsrequest=" + this.wsrequest + ", path=" + this.path + ", params=" + this.params + "]";
    }

    public String getMethod() {
        if (this.request != null) {
            return this.request.getMethod();
        }
        if (this.wsrequest != null) {
            return "WS";
        }
        throw new IllegalStateException("cannot determine request method");
    }

    public String getPath() {
        return StringUtils.defaultString((String)this.path);
    }

    public String getQuery() {
        if (this.request != null) {
            return this.request.getQueryString();
        }
        return "";
    }

    public Map<String, String> getQueryParams() {
        return this.params;
    }

    public <T> T getQueryParam(String key, Class<T> c) {
        if (this.hasQueryParam(key)) {
            return this.getQueryParamAsC(key, c);
        }
        return null;
    }

    public <T> T getQueryParam(String key, T defaultValue, Class<T> c) {
        T value;
        if (this.hasQueryParam(key) && (value = this.getQueryParamAsC(key, c)) != null) {
            return value;
        }
        return defaultValue;
    }

    public <T> T getRequiredQueryParam(String key, Class<T> c) {
        if (this.hasQueryParam(key)) {
            T value = this.getQueryParamAsC(key, c);
            if (value == null) {
                throw new IllegalArgumentException("Parameter " + key + " is required to be non null");
            }
            return value;
        }
        throw new IllegalArgumentException("Parameter " + key + " is required");
    }

    public String getRequiredQueryParam(String key) {
        if (this.hasQueryParam(key)) {
            String value = this.getQueryParam(key);
            if (value == null) {
                throw new IllegalArgumentException("Parameter " + key + " is required to be non null");
            }
            return value;
        }
        throw new IllegalArgumentException("Parameter " + key + " is required");
    }

    private <T> T getQueryParamAsC(String key, Class<T> c) {
        String value = this.getQueryParam(key);
        try {
            return (T)WebApplication.get().getConvertProcessor().convert((Object)value, c);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to read parameter " + key + " with value " + value + " as " + c.getName());
        }
    }

    public boolean hasQueryParam(String key) {
        Map<String, String> queryParams = this.getQueryParams();
        return queryParams.containsKey(key);
    }

    public String getQueryParam(String key) {
        Map<String, String> queryParams = this.getQueryParams();
        return queryParams.get(key);
    }

    public boolean hasPostBody() {
        Object body = this.getPostBody();
        if (body instanceof String) {
            return StringUtils.isNotBlank((String)((String)body));
        }
        return body != null;
    }

    public Object getPostBody() {
        if (this.params != null) {
            if (this.params.containsKey(POSTBODY)) {
                String postBody = this.params.get(POSTBODY);
                return postBody;
            }
            if (this.request != null && "POST".equals(this.request.getMethod())) {
                return this.params;
            }
        }
        return null;
    }

    public <T> T getPostBody(Class<T> c) {
        Object postBody = this.getPostBody();
        if (postBody != null) {
            try {
                return (T)WebApplication.get().getConvertProcessor().convert(postBody, c);
            }
            catch (Exception e) {
                throw new RuntimeException("POSTBODY=" + String.valueOf(postBody), e);
            }
        }
        return null;
    }

    public IWebSocketRequest getWebSocketRequest() {
        return this.wsrequest;
    }

    public String getHostAddr() {
        if (this.request != null) {
            return String.valueOf(this.request.getRemoteAddr()) + ":" + this.request.getLocalPort();
        }
        return null;
    }

    public String printDebugInfo() {
        return StringUtils.safeToString((Logger)logger, (Object)this);
    }

    public String getHttpSessionId() {
        return null;
    }

    public IServerRequest.Browser getBrowser() {
        return null;
    }
}

