/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.b2b.simple;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.B2BAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.SaveCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.XVulnerability;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XDisabilityCode;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionCategory;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionEndReason;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionStatus;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientB2b;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientB2bModif;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientB2bModifAction;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientB2bModifActionType;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientB2bModifResponse;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientRepresentativeType;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XQuestion;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.b2b.simple.IPatientB2bReader;
import ca.infodata.ofys.ui.b2b.simple.IPatientB2bWriter;
import ca.infodata.ofys.ui.controls.IProgressMonitorWithLog;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;

public class PatientB2bDialogController
implements IPatientB2bReader,
IPatientB2bWriter {
    private static final String NA_PAS_ETE_EXECUTE = Messages.getString((String)"NON_EXECUTE", (String[])new String[0]);
    private static final String A_ETE_EXECUTE = Messages.getString((String)"EXECUTE", (String[])new String[0]);
    private static final String TERMINE = Messages.getString((String)"TERMINE", (String[])new String[0]);
    private static final String UNE_ERREUR_EST_SURVENUE = Messages.getString((String)"UNE_ERREUR_EST_SURVENUE", (String[])new String[0]);
    private XPatient patient;
    private XPatientB2b b2b;
    private XPatientB2bModif modif;
    private boolean dontSendToRamq;

    public PatientB2bDialogController(XPatient patient) {
        this.update(patient);
    }

    protected void update(XPatient obj) {
        this.patient = obj.clone();
        this.b2b = this.patient.getB2bInformation().clone();
        this.b2b.setIdPatient(this.patient.getId());
        this.modif = new XPatientB2bModif(this.patient);
        int i = this.b2b.getVulnerabilities().size() - 1;
        while (i < 3) {
            this.b2b.getVulnerabilities().add(new XVulnerability(XDisabilityCode.C00, null));
            ++i;
        }
        Short age = PatientB2bDialogController.getAgeAtASpecificDate(this.patient.getBirthDate(), LocalDate.today());
        if (age != null && age < 14 && this.b2b.getIdPatientRepresentative() == null && this.patient.getTutorId() != null) {
            this.b2b.setIdPatientRepresentative(this.patient.getTutorId());
            this.b2b.setPatientRepresentative(this.patient.getTutor());
            this.modif.setIdPatientRepresentative(this.patient.getTutorId());
            if (this.patient.getTutorId() == this.patient.getMotherId()) {
                this.b2b.setPatientRepresentativeType(XPatientRepresentativeType.TITULAIRE_DE_LAUTORITE_PARENTALE);
                this.modif.setPatientRepresentativeType(XPatientRepresentativeType.TITULAIRE_DE_LAUTORITE_PARENTALE);
            } else if (this.patient.getTutorId() == this.patient.getFatherId()) {
                this.b2b.setPatientRepresentativeType(XPatientRepresentativeType.TITULAIRE_DE_LAUTORITE_PARENTALE);
                this.modif.setPatientRepresentativeType(XPatientRepresentativeType.TITULAIRE_DE_LAUTORITE_PARENTALE);
            } else {
                this.b2b.setPatientRepresentativeType(XPatientRepresentativeType.TUTEUR);
                this.modif.setPatientRepresentativeType(XPatientRepresentativeType.TUTEUR);
            }
        }
        if (age != null && age < 14 && this.b2b.getIdPatientRepresentative() == null && this.patient.getMotherId() != null) {
            this.b2b.setIdPatientRepresentative(this.patient.getMotherId());
            this.b2b.setPatientRepresentative(this.patient.getMother());
            this.b2b.setPatientRepresentativeType(XPatientRepresentativeType.TITULAIRE_DE_LAUTORITE_PARENTALE);
            this.modif.setIdPatientRepresentative(this.patient.getMotherId());
            this.modif.setPatientRepresentativeType(XPatientRepresentativeType.TITULAIRE_DE_LAUTORITE_PARENTALE);
        }
        if (age != null && age < 14 && this.b2b.getIdPatientRepresentative() == null && this.patient.getFatherId() != null) {
            this.b2b.setIdPatientRepresentative(this.patient.getFatherId());
            this.b2b.setPatientRepresentative(this.patient.getFather());
            this.b2b.setPatientRepresentativeType(XPatientRepresentativeType.TITULAIRE_DE_LAUTORITE_PARENTALE);
            this.modif.setIdPatientRepresentative(this.patient.getFatherId());
            this.modif.setPatientRepresentativeType(XPatientRepresentativeType.TITULAIRE_DE_LAUTORITE_PARENTALE);
        }
        this.checkModified();
    }

    private static Short getAgeAtASpecificDate(LocalDate birthdate, LocalDate base) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        if (birthdate == null) {
            return null;
        }
        LocalDate today = base;
        short age = (short)(today.year - birthdate.year);
        if (today.before((IPartialDate)birthdate.withYear(today.year))) {
            age = (short)(age - 1);
        }
        return age;
    }

    public IPatient getPatient() {
        return this.patient;
    }

    @Override
    public IPatient getPatientRepresentative() {
        if (this.b2b.getPatientRepresentative() != null) {
            return this.b2b.getPatientRepresentative();
        }
        if (this.b2b.getIdPatientRepresentative() != null) {
            return PatientUtil.getIPatientOrBasePatient((Object)this.b2b.getIdPatientRepresentative());
        }
        return null;
    }

    @Override
    public XPatientRepresentativeType getPatientRepresentativeType() {
        return this.b2b.getPatientRepresentativeType();
    }

    @Override
    public XBaseProfessionnal getProfessionnalResident() {
        return PersonUiPlugin.getDefault().getBaseProfessionnal(this.b2b.getIdProfessionnalResident());
    }

    @Override
    public XSite getSiteFollow() {
        return SitePlugin.getDefault().getSite(this.b2b.getIdSiteFollow());
    }

    @Override
    public LocalDate getSiteFollowStartDate() {
        return this.b2b.getSiteFollowStartDate();
    }

    @Override
    public XInscriptionStatus getStatus() {
        return this.b2b.getStatus();
    }

    @Override
    public XInscriptionCategory getCategory() {
        return this.b2b.getCategory();
    }

    @Override
    public LocalDate getStartDate() {
        return this.b2b.getStartDate();
    }

    @Override
    public LocalDate getEndDate() {
        return this.b2b.getEndDate();
    }

    @Override
    public XInscriptionEndReason getEndReason() {
        return this.b2b.getEndReason();
    }

    @Override
    public LocalDate getVerificationDate() {
        return this.b2b.getVerificationDate();
    }

    @Override
    public XDisabilityCode getVulnerability1Code() {
        return ((XVulnerability)this.b2b.getVulnerabilities().get(0)).getDisCode();
    }

    @Override
    public XDisabilityCode getVulnerability2Code() {
        return ((XVulnerability)this.b2b.getVulnerabilities().get(1)).getDisCode();
    }

    @Override
    public XDisabilityCode getVulnerability3Code() {
        return ((XVulnerability)this.b2b.getVulnerabilities().get(2)).getDisCode();
    }

    @Override
    public LocalDate getVulnerability1Date() {
        return ((XVulnerability)this.b2b.getVulnerabilities().get(0)).getDate();
    }

    @Override
    public LocalDate getVulnerability2Date() {
        return ((XVulnerability)this.b2b.getVulnerabilities().get(1)).getDate();
    }

    @Override
    public LocalDate getVulnerability3Date() {
        return ((XVulnerability)this.b2b.getVulnerabilities().get(2)).getDate();
    }

    @Override
    public LocalDate getVulnerability1DateEnd() {
        return ((XVulnerability)this.b2b.getVulnerabilities().get(0)).getDateEnd();
    }

    @Override
    public LocalDate getVulnerability2DateEnd() {
        return ((XVulnerability)this.b2b.getVulnerabilities().get(1)).getDateEnd();
    }

    @Override
    public LocalDate getVulnerability3DateEnd() {
        return ((XVulnerability)this.b2b.getVulnerabilities().get(2)).getDateEnd();
    }

    @Override
    public void setSiteFollow(XSite site) {
        this.b2b.setIdSiteFollow(site == null ? null : site.getId());
        this.modif.setIdSiteFollow(site == null ? null : site.getId());
        this.checkModified();
    }

    @Override
    public void setPatientRepresentative(XPatient representative) {
        this.b2b.setPatientRepresentative(representative);
        this.b2b.setIdPatientRepresentative(representative == null ? null : representative.getId());
        this.modif.setIdPatientRepresentative(representative == null ? null : representative.getId());
        this.checkModified();
    }

    @Override
    public void setPatientRepresentativeType(XPatientRepresentativeType type) {
        this.b2b.setPatientRepresentativeType(type);
        this.modif.setPatientRepresentativeType(type);
        this.checkModified();
    }

    @Override
    public void setResident(XBaseProfessionnal prof) {
        this.b2b.setProfessionnalResident(prof);
        this.b2b.setIdProfessionnalResident(prof == null ? null : prof.getId());
        this.modif.setIdProfessionnalResident(prof == null ? null : prof.getId());
        this.checkModified();
    }

    @Override
    public void setStartDate(LocalDate date) {
        this.b2b.setStartDate(date);
        this.modif.setStartDate(date);
        this.checkModified();
    }

    @Override
    public void setEndDate(LocalDate date) {
        this.b2b.setEndDate(date);
        this.modif.setEndDate(date);
        this.checkModified();
    }

    @Override
    public void setEndReason(XInscriptionEndReason r) {
        this.b2b.setEndReason(r);
        this.modif.setEndReason(r);
        this.checkModified();
    }

    @Override
    public void setSiteFollowStartDate(LocalDate date) {
        this.b2b.setSiteFollowStartDate(date);
        this.modif.setSiteFollowStartDate(date);
        this.checkModified();
    }

    @Override
    public void setStatus(XInscriptionStatus status) {
        this.b2b.setStatus(status);
        this.modif.setStatus(status);
        this.checkModified();
    }

    @Override
    public void setCategory(XInscriptionCategory c) {
        this.b2b.setCategory(c);
        this.modif.setCategory(c);
        this.checkModified();
    }

    @Override
    public void setVulnerability1Code(XDisabilityCode selection) {
        ((XVulnerability)this.b2b.getVulnerabilities().get(0)).setDisCode(selection);
        this.modif.getVulnerabilities(0).setDisCode(selection);
        this.checkModified();
    }

    @Override
    public void setVulnerability2Code(XDisabilityCode selection) {
        ((XVulnerability)this.b2b.getVulnerabilities().get(1)).setDisCode(selection);
        this.modif.getVulnerabilities(1).setDisCode(selection);
        this.checkModified();
    }

    @Override
    public void setVulnerability3Code(XDisabilityCode selection) {
        ((XVulnerability)this.b2b.getVulnerabilities().get(2)).setDisCode(selection);
        this.modif.getVulnerabilities(2).setDisCode(selection);
        this.checkModified();
    }

    @Override
    public void setVulnerability1Date(LocalDate date) {
        ((XVulnerability)this.b2b.getVulnerabilities().get(0)).setDate(date);
        this.modif.getVulnerabilities(0).setDate(date);
        this.checkModified();
    }

    @Override
    public void setVulnerability2Date(LocalDate date) {
        ((XVulnerability)this.b2b.getVulnerabilities().get(1)).setDate(date);
        this.modif.getVulnerabilities(1).setDate(date);
        this.checkModified();
    }

    @Override
    public void setVulnerability3Date(LocalDate date) {
        ((XVulnerability)this.b2b.getVulnerabilities().get(2)).setDate(date);
        this.modif.getVulnerabilities(2).setDate(date);
        this.checkModified();
    }

    @Override
    public void setVulnerability1DateEnd(LocalDate date) {
        ((XVulnerability)this.b2b.getVulnerabilities().get(0)).setDateEnd(date);
        this.modif.getVulnerabilities(0).setDateEnd(date);
        this.checkModified();
    }

    @Override
    public void setVulnerability2DateEnd(LocalDate date) {
        ((XVulnerability)this.b2b.getVulnerabilities().get(1)).setDateEnd(date);
        this.modif.getVulnerabilities(1).setDateEnd(date);
        this.checkModified();
    }

    @Override
    public void setVulnerability3DateEnd(LocalDate date) {
        ((XVulnerability)this.b2b.getVulnerabilities().get(2)).setDateEnd(date);
        this.modif.getVulnerabilities(2).setDateEnd(date);
        this.checkModified();
    }

    private void checkModified() {
        ObjectListenerManager.fireObjectModified((Object)this);
    }

    public boolean isDirty() {
        return this.modif.hasDiffFromSource();
    }

    public void save(IProgressMonitor monitor) throws Exception {
        B2BAccessorClient accessor = B2BAccessorClient.getInstance();
        XSession session = Application.get().getGlobalInstances().getSession();
        ReturnObject ret = accessor.saveSync(this.hashCode(), session, new SaveCallback(session), (Serializable)this.b2b, true);
        if (ret == null || ret.getStatus() == null || !(ret.getObj() instanceof XPatient) || !ret.getStatus().isOK()) {
            throw new StatusException((IStatus)ret.getStatus());
        }
        this.update((XPatient)ret.getObj());
        this.setDontSendToRamq(false);
    }

    public void send(IProgressMonitorWithLog monitor) {
        try {
            if (this.modif.hasDiffFromSource()) {
                XPatientB2bModifResponse response = this.send(monitor, this.modif);
                monitor.log(Level.INFO, TERMINE);
                if (response != null) {
                    this.modif.setSource(response.patient);
                    if (!monitor.hasLog(new Level[]{Level.SEVERE})) {
                        this.update(response.patient);
                    }
                    this.checkModified();
                }
            }
        }
        catch (Exception e) {
            monitor.log(Level.SEVERE, UNE_ERREUR_EST_SURVENUE, (Throwable)e);
        }
    }

    private XPatientB2bModifResponse send(IProgressMonitorWithLog monitor, XPatientB2bModif modif) throws Exception {
        ReturnObject ret = B2BAccessorClient.getInstance().executeSync(modif, Application.get().getGlobalInstances().getSession());
        if (ret.getStatus().isOkToProceed()) {
            XPatientB2bModifResponse response = (XPatientB2bModifResponse)ret.getObj();
            Iterator actionsIterator = response.actions.iterator();
            while (actionsIterator.hasNext()) {
                XPatientB2bModifAction action = (XPatientB2bModifAction)actionsIterator.next();
                if (action.executed) {
                    monitor.log(Level.INFO, action.type + "...");
                    if (action.infos != null) {
                        for (String info : action.infos) {
                            monitor.log(Level.INFO, info);
                        }
                    }
                    if (action.success) {
                        monitor.log(Level.INFO, action.type + " " + A_ETE_EXECUTE);
                    } else if (action.questions != null && action.questions.size() > 0) {
                        boolean allTrue = true;
                        for (XQuestion question : action.questions) {
                            boolean rep = monitor.askQuestion("Question", question.message);
                            question.response = rep ? "O" : "N";
                            monitor.log(Level.INFO, question.message);
                            if (rep) {
                                monitor.log(Level.INFO, Messages.getString((String)"OUI", (String[])new String[0]));
                            } else {
                                monitor.log(Level.SEVERE, Messages.getString((String)"NON", (String[])new String[0]));
                            }
                            if (rep) continue;
                            allTrue = false;
                            break;
                        }
                        if (allTrue) {
                            XPatientB2bModif modif2 = modif.clone();
                            modif2.actions = response.actions;
                            return this.send(monitor, modif2);
                        }
                    } else if (StringUtils.isNotBlank((String)action.errorMessage)) {
                        String message = action.errorMessage.replace(" / ", "\n\t");
                        monitor.log(Level.SEVERE, message);
                        if (action.type != XPatientB2bModifActionType.VALIDATION) {
                            monitor.log(Level.WARNING, action.type + " " + NA_PAS_ETE_EXECUTE);
                        }
                    } else {
                        monitor.log(Level.WARNING, action.type + " " + NA_PAS_ETE_EXECUTE);
                    }
                } else {
                    monitor.log(Level.WARNING, action.type + " " + NA_PAS_ETE_EXECUTE);
                }
                actionsIterator.remove();
            }
            return response;
        }
        monitor.log(Level.SEVERE, UNE_ERREUR_EST_SURVENUE);
        monitor.log(Level.SEVERE, ret.getStatus().getMessage());
        return null;
    }

    public void setDontSendToRamq(boolean b) {
        this.dontSendToRamq = b;
        this.checkModified();
    }

    public boolean isDontSendToRamq() {
        return this.dontSendToRamq;
    }

    @Override
    public void quickActionPreInscrire() {
        try {
            ObjectListenerManager.disable((Object)this);
            this.setStatus(XInscriptionStatus.INSCRIT_NON_CONFIRME);
            this.setCategory(XInscriptionCategory.MF);
            this.setStartDate(LocalDate.today());
            this.setSiteFollow(SitePlugin.getDefault().getContextSite());
            this.setSiteFollowStartDate(LocalDate.today());
        }
        finally {
            ObjectListenerManager.enable((Object)this, (boolean)true);
        }
    }

    @Override
    public void quickActionInscrire() {
        try {
            ObjectListenerManager.disable((Object)this);
            this.setStatus(XInscriptionStatus.INSCRIT_CONFIRME);
            this.setCategory(XInscriptionCategory.MF);
            this.setStartDate(LocalDate.today());
            this.setSiteFollow(SitePlugin.getDefault().getContextSite());
            this.setSiteFollowStartDate(LocalDate.today());
        }
        finally {
            ObjectListenerManager.enable((Object)this, (boolean)true);
        }
    }

    @Override
    public void quickActionRenew() {
        LocalDate within3months = LocalDate.today().plusMonth(3);
        for (XVulnerability v : this.modif.getVulnerabilities()) {
            if (!XDisabilityCode.C10.equals((Object)v.disCode) || v.getDateEnd() != null && !v.getDateEnd().beforeOrEquals(within3months)) continue;
            v.dateEnd = LocalDate.from((int)1, (int)1, (int)1900);
        }
    }

    @Override
    public void quickActionCesser() {
        try {
            ObjectListenerManager.disable((Object)this);
            this.setStatus(XInscriptionStatus.NON_INSCRIT);
            this.setEndReason(XInscriptionEndReason.CR1);
            this.setEndDate(LocalDate.today());
        }
        finally {
            ObjectListenerManager.enable((Object)this, (boolean)true);
        }
    }

    @Override
    public void quickActionSupprimer() {
        try {
            ObjectListenerManager.disable((Object)this);
            this.setStatus(XInscriptionStatus.NON_INSCRIT);
            this.setCategory(null);
            this.setStartDate(null);
            this.setEndReason(XInscriptionEndReason.DELETE_INSCRIPTION);
            this.setEndDate(null);
            this.setSiteFollow(null);
            this.setSiteFollowStartDate(null);
            this.setVulnerability1Code(null);
            this.setVulnerability2Code(null);
            this.setVulnerability3Code(null);
            this.setVulnerability1Date(null);
            this.setVulnerability2Date(null);
            this.setVulnerability3Date(null);
            this.setPatientRepresentative(null);
            this.setPatientRepresentativeType(XPatientRepresentativeType.SO);
            this.setResident(null);
        }
        finally {
            ObjectListenerManager.enable((Object)this, (boolean)true);
        }
    }

    @Override
    public void quickActionEffacer() {
        try {
            ObjectListenerManager.disable((Object)this);
            this.setStatus(XInscriptionStatus.NON_INSCRIT);
            this.setCategory(null);
            this.setStartDate(null);
            XInscriptionEndReason modifEndReason = this.getEndReason();
            XInscriptionEndReason sourceEndReason = this.patient.getB2bInformation().getEndReason();
            if (modifEndReason != null && modifEndReason != XInscriptionEndReason.S_O && sourceEndReason != null && sourceEndReason != XInscriptionEndReason.S_O) {
                this.setEndReason(XInscriptionEndReason.S_O);
            }
            this.setEndDate(null);
            this.setSiteFollow(null);
            this.setSiteFollowStartDate(null);
            this.setVulnerability1Code(null);
            this.setVulnerability2Code(null);
            this.setVulnerability3Code(null);
            this.setVulnerability1Date(null);
            this.setVulnerability2Date(null);
            this.setVulnerability3Date(null);
            this.setPatientRepresentative(null);
            XPatientRepresentativeType modifPatientRepresentativeType = this.getPatientRepresentativeType();
            XPatientRepresentativeType sourcePatientRepresentativeType = this.patient.getB2bInformation().getPatientRepresentativeType();
            if (modifPatientRepresentativeType != null && modifPatientRepresentativeType != XPatientRepresentativeType.SO && sourcePatientRepresentativeType != null && sourcePatientRepresentativeType != XPatientRepresentativeType.SO) {
                this.setPatientRepresentativeType(XPatientRepresentativeType.SO);
            }
            this.setResident(null);
        }
        finally {
            ObjectListenerManager.enable((Object)this, (boolean)true);
        }
    }
}

