/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.search;

import ca.infodata.ofys.ui.appointment.search.AbstractCriteriaControl;
import ca.infodata.ofys.ui.controls.FontAwareShell;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.util1.JoinList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ListBasedCriteriaControl<E>
extends AbstractCriteriaControl {
    private static final int NB_CRIT_PER_COL = 14;

    public ListBasedCriteriaControl(Composite parent, int style, String buttonText, FormToolkit toolkit) {
        super(parent, style, buttonText, toolkit);
    }

    @Override
    protected Shell createPopupControlOverride(Shell parent, FormToolkit toolkit) {
        FontAwareShell shell = new FontAwareShell(this.getShell(), 2048);
        toolkit.adapt((Composite)shell);
        for (E e : this.getList()) {
            MyButton btn = new MyButton((Composite)shell, this.getTextForItem(e), 32, toolkit);
            btn.setData(e);
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button widget = (Button)e.widget;
                    if (ListBasedCriteriaControl.this.getController() != null) {
                        ListBasedCriteriaControl.this.dataSelectedInControl(widget.getData(), widget.getSelection());
                    }
                }
            });
        }
        int nbC = this.columnCount(this.getList().size());
        GridLayout layout = new GridLayout(nbC, true);
        shell.setLayout((Layout)layout);
        shell.pack();
        return shell;
    }

    private int columnCount(int listSize) {
        int nbc = listSize / 14;
        if (listSize % 14 > 0) {
            ++nbc;
        }
        return nbc;
    }

    @Override
    protected void refreshPopup() {
        if (this.getPopup() != null && !this.getPopup().isDisposed()) {
            Control[] children;
            Control[] controlArray = children = this.getPopup().getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                if (c instanceof Button) {
                    ((Button)c).setSelection(this.isDataSelectedInController(c.getData()));
                }
                ++n2;
            }
        }
    }

    @Override
    protected String computeLabel() {
        if (this.getController() == null) {
            return null;
        }
        List<E> model = this.getList();
        JoinList list = new JoinList(", ", model.size());
        for (E e : model) {
            if (!this.isDataSelectedInController(e)) continue;
            list.add((CharSequence)this.getTextForItem(e));
        }
        return list.toString();
    }

    protected abstract String getTextForItem(E var1);

    protected abstract List<E> getList();

    protected abstract void dataSelectedInControl(E var1, boolean var2);

    protected abstract boolean isDataSelectedInController(E var1);
}

