/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.recall;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformation;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecall;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecallSearchCriteria;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPreferredTime;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPriority;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelDef;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelResType;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.variablereplacer.PatientVariableReplacer;
import ca.infodata.ofys.ui.appointment.AppointmentPlugin;
import ca.infodata.ofys.ui.appointment.editor.recall.PatientRecallEditor2;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.FontAwareLabel;
import ca.infodata.ofys.ui.controls.FontAwareSection;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.XLabelDefTable;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchComposite;
import ca.infodata.ofys.ui.controls.plugins.searchview.DataObjectListAdapter;
import ca.infodata.ofys.ui.controls.plugins.searchview.EnumWithValueAdapter;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumn;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumnChoiceElement;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchControlAdapter;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchItem;
import ca.infodata.ofys.ui.controls.template.completion.TemplateAssistText;
import ca.infodata.ofys.ui.controls.textAssistant.AssistText;
import ca.infodata.ofys.ui.controls.windows.AbstractSingleInputWindows;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.professionnal.ProfessionalBySiteCombo;
import ca.infodata.ofys.ui.person.professionnal.ProfessionalBySiteComboASearchAdapter;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.IRelativeDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import ca.infodata.util1.date.RelativeDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PatientRecallSearchComposite
extends BaseSearchComposite {
    private static final Logger logger = Logger.getLogger(PatientRecallSearchComposite.class.getName());
    protected static final String CHANGER_LA_NOTE_DU_RAPPEL = Messages.getString((String)"CHANGER_LA_NOTE_DU_RAPPEL", (String[])new String[0]);
    private MyLabel lblDateRecall;
    private MyCalendarText txtDateRecallBegin;
    private MyCalendarText txtDateRecallEnd;
    private MyLabel lblDateCreated;
    private MyCalendarText txtDateCreatedBegin;
    private MyCalendarText txtDateCreatedEnd;
    private MyLabel lblReason;
    private PatientVariableReplacer txtReasonVariableReplacer;
    private TemplateAssistText txtReason;
    private MyLabel lblPriority;
    private MyCombo<XPriority> cmbPriority;
    private MyLabel lblStatus;
    private MyCombo<XStatus> cmbStatus;
    private MyLabel lblPreferredTime;
    private MyCombo<XPreferredTime> cmbPreferredTime;
    private MyLabel lblProfessionnal;
    private ProfessionalBySiteCombo cmbProfessionnal;
    private MyButton chkAllLabels;
    protected XLabelDefTable listLabel;

    public PatientRecallSearchComposite(Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style);
    }

    public PatientRecallSearchComposite(Composite parent, int style) {
        super(parent, style);
    }

    public void createMyPartControl(Composite theParent, FormToolkit toolkit, int style) {
        this.isWithTemplateTool = true;
        this.templateType = XCompletionProposalType.PATIENT_RECALL_SEARCH;
        super.createMyPartControl(theParent, toolkit, style);
    }

    protected void createMyControl(Composite parent, FormToolkit toolkit) {
        this.setViewSelectInactive();
        this.setIsWithButtonNew(false);
        FontAwareSection section = new FontAwareSection(parent, 2114, toolkit);
        toolkit.createCompositeSeparator((Composite)section);
        section.setText(Messages.getString((String)"CRITERES", (String[])new String[0]));
        Composite sectionComposite = toolkit.createComposite((Composite)section);
        section.setClient((Control)sectionComposite);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 5;
        layout.marginHeight = 5;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment(0);
        section.setLayoutData((Object)data);
        parent = sectionComposite;
        this.lblDateRecall = new MyLabel(parent, Messages.getString((String)"DATE__", (String[])new String[0]), 0, toolkit);
        this.txtDateRecallBegin = new MyCalendarText(parent, toolkit);
        this.txtDateRecallBegin.getTextControl().setMessage(Messages.getString((String)"HEURE_DEBUT", (String[])new String[0]));
        this.txtDateRecallBegin.getControl().addKeyListener(this.enterCtrlEnterListener);
        this.txtDateRecallBegin.getControl().setToolTipText(ENTER_CTRL_ENTER_TOOLTIP);
        this.txtDateRecallBegin.getTextControl().setAllowRelative(true);
        this.addSearchControl("txtDateRecallBegin", (IControl)this.txtDateRecallBegin);
        this.txtDateRecallEnd = new MyCalendarText(parent, toolkit);
        this.txtDateRecallEnd.getTextControl().setMessage(Messages.getString((String)"HEURE_FIN", (String[])new String[0]));
        this.txtDateRecallEnd.getControl().addKeyListener(this.enterCtrlEnterListener);
        this.txtDateRecallEnd.getControl().setToolTipText(ENTER_CTRL_ENTER_TOOLTIP);
        this.txtDateRecallEnd.getTextControl().setAllowRelative(true);
        this.addSearchControl("txtDateRecallEnd", (IControl)this.txtDateRecallEnd);
        this.lblDateCreated = new MyLabel(parent, Messages.getString((String)"DEMANDE__", (String[])new String[0]), 0, toolkit);
        this.txtDateCreatedBegin = new MyCalendarText(parent, toolkit);
        this.txtDateCreatedBegin.getTextControl().setMessage(Messages.getString((String)"HEURE_DEBUT", (String[])new String[0]));
        this.txtDateCreatedBegin.getControl().addKeyListener(this.enterCtrlEnterListener);
        this.txtDateCreatedBegin.getControl().setToolTipText(ENTER_CTRL_ENTER_TOOLTIP);
        this.txtDateCreatedBegin.getTextControl().setAllowRelative(true);
        this.addSearchControl("txtDateCreatedBegin", (IControl)this.txtDateCreatedBegin);
        this.txtDateCreatedEnd = new MyCalendarText(parent, toolkit);
        this.txtDateCreatedEnd.getTextControl().setMessage(Messages.getString((String)"HEURE_FIN", (String[])new String[0]));
        this.txtDateCreatedEnd.getControl().addKeyListener(this.enterCtrlEnterListener);
        this.txtDateCreatedEnd.getControl().setToolTipText(ENTER_CTRL_ENTER_TOOLTIP);
        this.txtDateCreatedEnd.getTextControl().setAllowRelative(true);
        this.addSearchControl("txtDateCreatedEnd", (IControl)this.txtDateCreatedEnd);
        this.lblReason = new MyLabel(parent, String.valueOf(Messages.getString((String)"NOTE", (String[])new String[0])) + " :", 0, toolkit);
        this.txtReasonVariableReplacer = new PatientVariableReplacer();
        this.txtReason = new TemplateAssistText(parent, 64, toolkit);
        this.txtReason.setVariablesReplacer((Object)this.txtReasonVariableReplacer);
        this.txtReason.setType(XCompletionProposalType.PATIENT_RECALL_REASON);
        ControlDecorator.decorateWithEditProposal((TemplateAssistText)this.txtReason, (int)16512);
        this.addSearchControl("txtReason", (IControl)this.txtReason);
        this.lblProfessionnal = new MyLabel(parent, Messages.getString((String)"PROFESSIONNEL", (String[])new String[0]), 0, toolkit);
        this.cmbProfessionnal = new ProfessionalBySiteCombo(parent, 8200, toolkit);
        this.cmbProfessionnal.fill();
        this.addSearchControl("cmbProfessionnal", (IControl)this.cmbProfessionnal, (SearchControlAdapter)new ProfessionalBySiteComboASearchAdapter(this.cmbProfessionnal));
        this.lblPriority = new MyLabel(parent, Messages.getString((String)"PRIORITE", (String[])new String[0]), 0, toolkit);
        this.cmbPriority = new MyCombo(parent, 8, toolkit);
        this.cmbPriority.setLabelProvider((ProviderAR)new ProviderAR<XPriority, String>(){

            public String get(XPriority p) {
                if (p == null) {
                    return Messages.getString((String)"SO", (String[])new String[0]);
                }
                return p.toString();
            }
        });
        this.cmbPriority.setItems((Object[])((XPriority[])ArrayUtils.add((Object[])XPriority.values(), (int)0, null)));
        this.cmbPriority.select(null);
        this.addSearchControl("cmbPriority", (IControl)this.cmbPriority, (SearchControlAdapter)new EnumWithValueAdapter(XPriority.class));
        this.lblStatus = new MyLabel(parent, Messages.getString((String)"STATUS", (String[])new String[0]), 0, toolkit);
        this.cmbStatus = new MyCombo(parent, 8, toolkit);
        this.cmbStatus.setLabelProvider((ProviderAR)new ProviderAR<XStatus, String>(){

            public String get(XStatus s) {
                if (s == null) {
                    return Messages.getString((String)"SO", (String[])new String[0]);
                }
                return s.toString();
            }
        });
        this.cmbStatus.setItems((Object[])((XStatus[])ArrayUtils.add((Object[])XStatus.values(), (int)0, null)));
        this.cmbStatus.select(null);
        this.addSearchControl("cmbStatus", (IControl)this.cmbStatus, (SearchControlAdapter)new EnumWithValueAdapter(XStatus.class));
        this.lblPreferredTime = new MyLabel(parent, Messages.getString((String)"PREFERENCE_DE_TEMPS", (String[])new String[0]), 0, toolkit);
        this.cmbPreferredTime = new MyCombo(parent, 8, toolkit);
        this.cmbPreferredTime.setLabelProvider((ProviderAR)new ProviderAR<XPreferredTime, String>(){

            public String get(XPreferredTime s) {
                if (s == null) {
                    return Messages.getString((String)"SO", (String[])new String[0]);
                }
                return s.toString();
            }
        });
        this.cmbPreferredTime.setItems((Object[])((XPreferredTime[])ArrayUtils.add((Object[])XPreferredTime.values(), (int)0, null)));
        this.cmbPreferredTime.select(null);
        this.addSearchControl("cmbPreferredTime", (IControl)this.cmbPreferredTime, (SearchControlAdapter)new EnumWithValueAdapter(XPreferredTime.class));
        this.tblSearch.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (PatientRecallSearchComposite.this.tblSearch.getSelectionCount() == 1 && UI.rightClick((MouseEvent)e)) {
                    Menu menu = new Menu((Control)PatientRecallSearchComposite.this.tblSearch);
                    menu.setVisible(true);
                    MenuItem item = new MenuItem(menu, 8);
                    item.setText(XStatus.NORMAL.toString());
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            SearchItem searchItem = (SearchItem)PatientRecallSearchComposite.this.tblSearch.getSelection()[0].getData();
                            XPatientRecall recall = (XPatientRecall)searchItem.getData();
                            PatientRecallSearchComposite.this.changePatientRecallStatus(recall, XStatus.NORMAL);
                        }
                    });
                    item = new MenuItem(menu, 8);
                    item.setText(XStatus.APPOINTMENT_GIVEN.toString());
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            SearchItem searchItem = (SearchItem)PatientRecallSearchComposite.this.tblSearch.getSelection()[0].getData();
                            XPatientRecall recall = (XPatientRecall)searchItem.getData();
                            PatientRecallSearchComposite.this.changePatientRecallStatus(recall, XStatus.APPOINTMENT_GIVEN);
                        }
                    });
                    item = new MenuItem(menu, 8);
                    item.setText(XStatus.CANCELED.toString());
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            SearchItem searchItem = (SearchItem)PatientRecallSearchComposite.this.tblSearch.getSelection()[0].getData();
                            XPatientRecall recall = (XPatientRecall)searchItem.getData();
                            PatientRecallSearchComposite.this.changePatientRecallStatus(recall, XStatus.CANCELED);
                        }
                    });
                    item = new MenuItem(menu, 8);
                    item.setText(XStatus.CLIENT_NOT_REACHED.toString());
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            SearchItem searchItem = (SearchItem)PatientRecallSearchComposite.this.tblSearch.getSelection()[0].getData();
                            XPatientRecall recall = (XPatientRecall)searchItem.getData();
                            PatientRecallSearchComposite.this.changePatientRecallStatus(recall, XStatus.CLIENT_NOT_REACHED);
                        }
                    });
                    item = new MenuItem(menu, 8);
                    item.setText(CHANGER_LA_NOTE_DU_RAPPEL);
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            SearchItem searchItem = (SearchItem)PatientRecallSearchComposite.this.tblSearch.getSelection()[0].getData();
                            final XPatientRecall recall = (XPatientRecall)searchItem.getData();
                            if (recall != null) {
                                AbstractSingleInputWindows windows = new AbstractSingleInputWindows(UI.getWorkbenchShell(), "Saisir la note", ""){

                                    protected boolean btnPressed(int btnId) {
                                        if (btnId == 0) {
                                            recall.setReason(((AssistText)this.control).getText());
                                            recall.setUpdated();
                                        }
                                        return true;
                                    }

                                    protected IControl createControlOverride(Composite parent, FormToolkit toolkit) {
                                        TemplateAssistText text = new TemplateAssistText(parent, 576, toolkit);
                                        text.setType(XCompletionProposalType.PATIENT_RECALL_REASON);
                                        FormData data = UI.newFillFormData();
                                        data.height = 100;
                                        text.getControl().setLayoutData((Object)data);
                                        return text;
                                    }
                                };
                                windows.open();
                                if (recall.isUpdated()) {
                                    PatientRecallSearchComposite.this.setPatientRecallNote(recall, recall.getReason());
                                }
                            }
                        }
                    });
                    item = new MenuItem(menu, 8);
                    item.setText(Messages.getString((String)"ASSIGNER_LE_RAPPEL_RDV", (String[])new String[0]));
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            SearchItem searchItem = (SearchItem)PatientRecallSearchComposite.this.tblSearch.getSelection()[0].getData();
                            XPatientRecall recall = (XPatientRecall)searchItem.getData();
                            AppointmentPlugin.getDefault().setPatientRecallTemp(recall);
                        }
                    });
                }
            }
        });
        this.chkAllLabels = new MyButton(parent, Messages.getString((String)"TOUS", (String[])new String[0]), 32, toolkit);
        this.addSearchControl("chkAllLabels", (IControl)this.chkAllLabels);
        MyLabel lblLabels = new MyLabel(parent, Messages.getString((String)"MOTS_CLES", (String[])new String[0]), 16384, toolkit);
        this.listLabel = new XLabelDefTable(parent);
        this.listLabel.fill(XLabelResType.WAIT_LIST);
        this.addSearchControl("listLabel", (IControl)this.listLabel, (SearchControlAdapter)new DataObjectListAdapter((Collection)this.listLabel.getItems()));
        FontAwareLabel lblSortDescription = new FontAwareLabel(parent, 64, Messages.getString((String)"PatientRecall.RECHERCHE_TRIE_DESCRIPTION", (String[])new String[0]), toolkit);
        Listener enterCtrlEnterListener2 = new Listener(){

            public void handleEvent(Event e) {
                KeyEvent keyEvent = new KeyEvent(e);
                if (e.type == 1) {
                    PatientRecallSearchComposite.this.enterCtrlEnterListener.keyPressed(keyEvent);
                } else if (e.type == 2) {
                    PatientRecallSearchComposite.this.enterCtrlEnterListener.keyReleased(keyEvent);
                }
            }
        };
        this.txtReason.getStyledText().addKeyListener(this.enterCtrlEnterListener);
        this.txtDateCreatedBegin.addKeyListener(this.enterCtrlEnterListener);
        this.txtDateCreatedEnd.addKeyListener(this.enterCtrlEnterListener);
        this.txtDateRecallBegin.addKeyListener(this.enterCtrlEnterListener);
        this.txtDateRecallEnd.addKeyListener(this.enterCtrlEnterListener);
        this.cmbPreferredTime.addListener(1, enterCtrlEnterListener2);
        this.cmbPriority.addListener(1, enterCtrlEnterListener2);
        this.cmbProfessionnal.addListener(1, enterCtrlEnterListener2);
        this.cmbStatus.addListener(1, enterCtrlEnterListener2);
        layout = new FormLayout();
        layout.marginBottom = 5;
        layout.marginHeight = 5;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(1);
        data.right = new FormAttachment(24);
        this.lblDateRecall.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(24, 2);
        data.right = new FormAttachment(62);
        this.txtDateRecallBegin.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(62, 2);
        data.right = new FormAttachment(100);
        this.txtDateRecallEnd.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtDateRecallEnd.getControl());
        data.left = new FormAttachment(1);
        data.right = new FormAttachment(24);
        this.lblDateCreated.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtDateRecallEnd.getControl());
        data.left = new FormAttachment(24, 2);
        data.right = new FormAttachment(62);
        this.txtDateCreatedBegin.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtDateRecallEnd.getControl());
        data.left = new FormAttachment(62, 2);
        data.right = new FormAttachment(100);
        this.txtDateCreatedEnd.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtDateCreatedBegin.getControl());
        data.left = new FormAttachment(1);
        this.lblReason.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtDateCreatedBegin.getControl());
        data.left = new FormAttachment(24, 2);
        data.right = new FormAttachment(100, -2);
        this.txtReason.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtReason.getControl());
        data.left = new FormAttachment(1);
        data.right = new FormAttachment(64);
        this.lblProfessionnal.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblProfessionnal.getControl());
        data.left = new FormAttachment(1);
        data.right = new FormAttachment(64);
        this.cmbProfessionnal.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.cmbProfessionnal.getControl());
        data.left = new FormAttachment(1);
        data.right = new FormAttachment(64);
        this.lblPriority.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblPriority.getControl());
        data.left = new FormAttachment(1);
        data.right = new FormAttachment(64);
        this.cmbPriority.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbPriority.getControl());
        data.left = new FormAttachment(1);
        data.right = new FormAttachment(64);
        this.lblStatus.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblStatus.getControl());
        data.left = new FormAttachment(1);
        data.right = new FormAttachment(64);
        this.cmbStatus.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbStatus.getControl());
        data.left = new FormAttachment(1);
        data.right = new FormAttachment(64);
        this.lblPreferredTime.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblPreferredTime.getControl());
        data.left = new FormAttachment(1);
        data.right = new FormAttachment(64);
        this.cmbPreferredTime.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtReason.getControl());
        data.left = new FormAttachment(64, 2);
        data.right = new FormAttachment(this.chkAllLabels.getControl(), 8);
        lblLabels.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblLabels.getControl(), 4, 128);
        data.right = new FormAttachment(100, -2);
        this.chkAllLabels.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblLabels.getControl());
        data.left = new FormAttachment(64, 2);
        data.right = new FormAttachment(100, -2);
        data.bottom = new FormAttachment(lblSortDescription.getControl());
        this.listLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbPreferredTime.getControl());
        data.left = new FormAttachment(1);
        data.right = new FormAttachment(100, -2);
        lblSortDescription.setLayoutData((Object)data);
        parent.setTabList(new Control[]{this.txtDateRecallBegin.getControl(), this.txtDateRecallEnd.getControl(), this.txtDateCreatedBegin.getControl(), this.txtDateCreatedEnd.getControl(), this.chkAllLabels.getControl(), this.txtReason.getControl(), this.cmbProfessionnal.getControl(), this.cmbPriority.getControl(), this.cmbStatus.getControl(), this.cmbPreferredTime.getControl()});
    }

    protected void changePatientRecallStatus(XPatientRecall recall, XStatus newStatus) {
        block4: {
            JobCallback callback = new JobCallback("changePatientRecallStatus"){

                public void responseReceived(final ReturnObject response) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!PatientRecallSearchComposite.this.isDisposed()) {
                                PatientRecallSearchComposite.this.refresh((XPatientRecall)response.getObj());
                            }
                        }
                    });
                }
            };
            try {
                AppointmentAccessorClient.getInstance().changePatientRecallStatus(recall.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, recall.getId().intValue(), newStatus);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, String.format("Error recall=%s, newStatus=%s", recall, newStatus), e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    protected void setPatientRecallNote(XPatientRecall recall, String note) {
        block4: {
            JobCallback callback = new JobCallback("setPatientRecallNote"){

                public void responseReceived(final ReturnObject response) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!PatientRecallSearchComposite.this.isDisposed()) {
                                PatientRecallSearchComposite.this.refresh((XPatientRecall)response.getObj());
                            }
                        }
                    });
                }
            };
            try {
                AppointmentAccessorClient.getInstance().setPatientRecallNote(recall.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, recall.getId().intValue(), note);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, String.format("Error recall=%s, note=%s", recall, note), e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    protected void refresh(XPatientRecall recall) {
        if (recall == null) {
            return;
        }
        TableItem[] items = this.tblSearch.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            SearchItem searchItem = (SearchItem)item.getData();
            XPatientRecall recall2 = (XPatientRecall)searchItem.getData();
            if (recall.equals((Object)recall2)) {
                SearchItem searchItem2 = this.newSearchItem(recall);
                item.setText(searchItem2.getText());
                item.setData((Object)searchItem2);
                break;
            }
            ++i;
        }
    }

    protected void search() {
        block4: {
            XPatientRecallSearchCriteria criteria = new XPatientRecallSearchCriteria();
            criteria.professionnalId = this.cmbProfessionnal.getSelection() == null ? null : this.cmbProfessionnal.getSelection().getId();
            criteria.note = this.txtReason.getText();
            criteria.dateCreatedStart = PatientRecallSearchComposite.toAbsoluteDateFix(this.txtDateCreatedBegin.getRelativeDate());
            criteria.dateCreatedEnd = PatientRecallSearchComposite.toAbsoluteDateFix(this.txtDateCreatedEnd.getRelativeDate());
            criteria.dateRecallStart = PatientRecallSearchComposite.toAbsoluteDateFix(this.txtDateRecallBegin.getRelativeDate());
            criteria.dateRecallEnd = PatientRecallSearchComposite.toAbsoluteDateFix(this.txtDateRecallEnd.getRelativeDate());
            criteria.priority = (XPriority)this.cmbPriority.getSelection();
            criteria.status = this.cmbStatus.getSelection() == null ? null : EnumSet.of((XStatus)this.cmbStatus.getSelection());
            criteria.preferredTime = (XPreferredTime)this.cmbPreferredTime.getSelection();
            criteria.mustHaveAllLabels = this.chkAllLabels.getSelection();
            criteria.labels = this.getCheckedLabels();
            JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(ReturnObject response) {
                    ArrayList obj = (ArrayList)response.getObj();
                    if (obj == null) {
                        obj = new ArrayList();
                    }
                    PatientRecallSearchComposite.this.searchResponse(obj);
                }
            };
            try {
                AppointmentAccessorClient.getInstance().findPatientRecall(Application.get().getGlobalInstances().getSession(), (ICallback)callback, criteria);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error", e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    private static final LocalDate toAbsoluteDateFix(IRelativeDate d) {
        if (d == null) {
            return null;
        }
        if (d instanceof LocalDate) {
            return (LocalDate)d;
        }
        if (d instanceof IPartialDate) {
            return d.toAbsoluteDate();
        }
        if (d instanceof RelativeDate) {
            RelativeDate r = (RelativeDate)d;
            LocalDate date = LocalDate.today();
            if (r.getYear() != null) {
                date = date.plusYear(r.getYear().intValue());
            }
            if (r.getMonth() != null) {
                date = date.plusMonth(r.getMonth().intValue());
            }
            if (r.getDay() != null) {
                date = date.plusDay(r.getDay().intValue());
            }
            return date;
        }
        return d.toAbsoluteDate();
    }

    private List<XLabelDef> getCheckedLabels() {
        return this.listLabel.getCheckedSelection();
    }

    private void searchResponse(final List<XPatientRecall> recalls) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!PatientRecallSearchComposite.this.parent.isDisposed()) {
                        PatientRecallSearchComposite.this.disposeTableColumns();
                        if (recalls.size() > 0) {
                            PatientRecallSearchComposite.this.createTableColumns();
                        }
                        SearchItem[] search = new SearchItem[recalls == null ? 0 : recalls.size()];
                        int i = 0;
                        while (i < search.length) {
                            search[i] = PatientRecallSearchComposite.this.newSearchItem(recalls.get(i));
                            ++i;
                        }
                        if (Application.get().getGlobalInstances().getSession().getClientPreferences().getReturnListLength() * 5 <= i) {
                            PatientRecallSearchComposite.this.setMessage(MSG_TROP_DONNEES);
                        } else if (i == 0) {
                            PatientRecallSearchComposite.this.setMessage(MSG_AUCUNES_DONNEES);
                        } else {
                            PatientRecallSearchComposite.this.setMessage(null);
                        }
                        PatientRecallSearchComposite.this.loadSearchListInTable(search);
                        PatientRecallSearchComposite.this.callbackContainerReferenceControlFromTableItems();
                    }
                }
                catch (RuntimeException e) {
                    logger.log(Level.SEVERE, "Error in search base patient recall response", e);
                }
            }
        });
    }

    protected void createTableColumns() {
        this.tblSearch.setLinesVisible(false);
        this.tblSearch.setHeaderVisible(true);
        this.tableColumns = new ArrayList();
        if (Application.get().getGlobalInstances().inDebugMode()) {
            this.tableColumns.add(new SearchColumn<XPatientRecall>((Table)this.tblSearch, "ID"){

                public String getText(XPatientRecall e) {
                    return String.valueOf(e.getId());
                }
            });
        }
        SearchColumn<XPatientRecall> sc = new SearchColumn<XPatientRecall>((Table)this.tblSearch, Messages.getString((String)"NOM", (String[])new String[0])){

            public String getText(XPatientRecall e) {
                return e.getPatient().getName().toUpperCase();
            }
        };
        sc.getColumn().setData("maxWidth", (Object)150);
        this.tableColumns.add(sc);
        this.tableColumns.add(new SearchColumn<XPatientRecall>((Table)this.tblSearch, Messages.getStringCap((String)"NO_TELEPHONE", (String[])new String[0])){

            public String getText(XPatientRecall e) {
                return PatientRecallSearchComposite.this.getFirstPhoneNumber(e);
            }
        });
        this.tableColumns.add(new SearchColumn<XPatientRecall>((Table)this.tblSearch, Messages.getStringCap((String)"AVEC", (String[])new String[0])){

            public String getText(XPatientRecall e) {
                return e.getProfessionnal() == null ? null : PersonUiPlugin.getDefault().getBaseProfessionnal(e.getProfessionnal()).getName();
            }
        });
        this.tableColumns.add(new SearchColumn<XPatientRecall>((Table)this.tblSearch, Messages.getStringCap((String)"DEMANDE_LE", (String[])new String[0])){

            public String getText(XPatientRecall e) {
                return LocalDateFormat.nullSafeFormat((LocalDate)e.getDateCreated(), (String)FormatDateProvider.getFormatDate().toString());
            }
        });
        this.tableColumns.add(new SearchColumn<XPatientRecall>((Table)this.tblSearch, String.valueOf(Messages.getStringCap((String)"POUR", (String[])new String[0])) + Messages.getString((String)"_LE_", (String[])new String[0])){

            public String getText(XPatientRecall e) {
                return LocalDateFormat.nullSafeFormat((LocalDate)e.getDateRecall(), (String)FormatDateProvider.getFormatDate().toString());
            }
        });
        this.tableColumns.add(new SearchColumn<XPatientRecall>((Table)this.tblSearch, Messages.getStringCap((String)"EN", (String[])new String[0])){

            public String getText(XPatientRecall e) {
                return e.getPreferredTime() == XPreferredTime.NONE || e.getPreferredTime() == null ? null : e.getPreferredTime().toString();
            }
        });
        this.tableColumns.add(new SearchColumn<XPatientRecall>((Table)this.tblSearch, Messages.getStringCap((String)"RAISON", (String[])new String[0])){

            public String getText(XPatientRecall e) {
                return StringUtils.trim((String)e.getReason());
            }
        });
        this.tableColumns.add(new SearchColumn<XPatientRecall>((Table)this.tblSearch, Messages.getStringCap((String)"PRIORITE", (String[])new String[0])){

            public String getText(XPatientRecall e) {
                return e.getPriority() == XPriority.NORMAL || e.getPriority() == null ? null : e.getPriority().toString();
            }
        });
        this.tableColumns.add(new SearchColumn<XPatientRecall>((Table)this.tblSearch, Messages.getStringCap((String)"STATUS", (String[])new String[0])){

            public String getText(XPatientRecall e) {
                return e.getStatus() == XStatus.NORMAL || e.getStatus() == null ? null : e.getStatus().toString();
            }
        });
    }

    private String getFirstPhoneNumber(XPatientRecall recall) {
        IPatient patient = recall.getPatient();
        String phoneNumber = null;
        XContactInformation contact = patient.getFirstContactInformation();
        if (contact != null && contact.getContact() != null && contact.getTypeContact() != null && XContactInformation.CONTACT_PHONE_TYPES.contains(contact.getTypeContact())) {
            phoneNumber = contact.getFormatedTelephone();
        } else {
            contact = patient.getSecondContactInformation();
            if (contact != null && contact.getContact() != null && contact.getTypeContact() != null && XContactInformation.CONTACT_PHONE_TYPES.contains(contact.getTypeContact())) {
                phoneNumber = contact.getFormatedTelephone();
            }
        }
        return phoneNumber;
    }

    public void setFocus() {
    }

    protected void createNew() {
    }

    protected void itemSelected(SearchItem item) {
        super.itemSelected(item);
    }

    protected void processSelection(SearchItem item) {
        if (item != null && item.getData() instanceof XPatientRecall) {
            BaseEditor.openEditorSafe((IEditorInput)new EditorInput((IDataObject)((XPatientRecall)item.getData())), (String)PatientRecallEditor2.class.getName());
        }
    }

    protected SearchColumnChoiceElement[] getSearchColumnChoiceElements() {
        return null;
    }

    protected String getPreferencesKeys() {
        return null;
    }
}

