/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.preferences;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ColorRow
extends Composite {
    private static final String CHOIX_DES_COULEURS = Messages.getString((String)"CHOIX_DES_COULEURS", (String[])new String[0]);
    protected Label cvsColor;
    protected Color color;
    protected Cursor cursor;
    protected PaintListener drawRect = new PaintListener(){

        public void paintControl(PaintEvent e) {
            e.gc.setLineWidth(2);
            e.gc.drawRectangle(0, 0, 15, 15);
            e.gc.setForeground(ResourceGetter.getColor((RGB)new RGB(0, 0, 0)));
        }
    };
    protected PaintListener drawSelectedRect = new PaintListener(){

        public void paintControl(PaintEvent e) {
            e.gc.setLineWidth(3);
            e.gc.drawFocus(0, 0, 15, 15);
            e.gc.setLineDash(new int[]{2, 2});
            e.gc.drawRectangle(0, 0, 14, 14);
            e.gc.setForeground(ResourceGetter.getColor((RGB)new RGB(0, 0, 0)));
        }
    };

    public ColorRow(Composite parent, int style) {
        super(parent, style);
        this.cursor = new Cursor((Device)UI.getWorkbenchShell().getDisplay(), 21);
        this.setVisible(false);
    }

    protected Label createLabel(Composite parent, int style, String t) {
        Label label = new Label(parent, 0x800 | style);
        label.setData("text", (Object)t);
        label.setSize(15, 15);
        label.addPaintListener(this.drawRect);
        label.addListener(32, e -> label.setCursor(this.cursor));
        return label;
    }

    protected RGB openColorDialog(Label ctrlSource) {
        String titre = (String)ctrlSource.getData("text");
        ColorDialog cd = new ColorDialog(UI.getWorkbenchShell());
        cd.setText(StringUtils.isEmpty((CharSequence)titre) ? CHOIX_DES_COULEURS : titre);
        if (ctrlSource.getData("rgb") != null) {
            cd.setRGB((RGB)ctrlSource.getData("rgb"));
        } else if (ctrlSource.getBackground() != null && !ctrlSource.getBackground().isDisposed()) {
            cd.setRGB(ctrlSource.getBackground().getRGB());
        }
        ctrlSource.removePaintListener(this.drawRect);
        ctrlSource.addPaintListener(this.drawSelectedRect);
        ctrlSource.setRedraw(true);
        return cd.open();
    }

    protected void changeColor() {
        RGB rgb = this.openColorDialog(this.cvsColor);
        if (rgb != null) {
            this.cvsColor.setData("rgb", (Object)rgb);
            if (this.color != null) {
                ResourceGetter.dispose((Object)this.color);
                this.color = ResourceGetter.getColor((RGB)rgb);
            }
            this.cvsColor.setBackground(this.color);
            this.cvsColor.redraw();
            this.cvsColor.setFocus();
        }
    }

    protected RGB getTypeColor(int[] tcolor) {
        boolean isTColorInvalid;
        boolean bl = isTColorInvalid = tcolor == null || tcolor.length != 3;
        if (isTColorInvalid) {
            return new RGB(255, 255, 255);
        }
        return new RGB(tcolor[0], tcolor[1], tcolor[2]);
    }
}

