/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.preferences;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionalFormatter;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentType;
import ca.infodata.ofys.ui.appointment.editor.preferences.ColorRow;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.util1.JoinList;
import java.util.Collection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public final class AppointmentTypeListRow
extends ColorRow {
    public static final String CODE = Messages.getString((String)"CODE", (String[])new String[0]);
    public static final String DUREE_RDVS = Messages.getString((String)"DUREE", (String[])new String[0]);
    public static final String ACTIF = Messages.getString((String)"ACTIF", (String[])new String[0]);
    public static final String COULEUR = Messages.getString((String)"COULEUR", (String[])new String[0]);
    public static final String DESCRIPTION = Messages.getString((String)"DESCRIPTION", (String[])new String[0]);
    public static final String PROFESSIONNEL = Messages.getString((String)"PROFESSIONNEL", (String[])new String[0]);
    public static final String STATUS = Messages.getString((String)"STATUS", (String[])new String[0]);
    public static final String QUESTION_ID = Messages.getString((String)"QUESTION_ID", (String[])new String[0]);
    public static final String ON_SITE = Messages.getString((String)"ON_SITE", (String[])new String[0]);
    public static final String TELMED = Messages.getString((String)"TELMED", (String[])new String[0]);
    public static final String BY_PHONE = Messages.getString((String)"BY_PHONE", (String[])new String[0]);
    public static final String NO_AUTO_COMM = Messages.getString((String)"NO_AUTO_COMM", (String[])new String[0]);
    public static final String NO_COMM = Messages.getString((String)"NO_COMM", (String[])new String[0]);
    public static final String IS_TODO = Messages.getString((String)"IS_TODO", (String[])new String[0]);
    public static final String VALEUR_DEFAUT = Messages.getString((String)"VALEUR_DEFAUT", (String[])new String[0]);
    private final MyLabel lblCode;
    private final MyLabel lblDuree;
    private final MyLabel lblDescription;
    private final MyLabel lblProfessional;
    private final MyLabel lblSurveyId;
    private final MyLabel lblStatus;
    private final MyLabel lblActif;
    private final MyButton btnDelete;
    private final MyButton btnEdit;
    private XAppointmentType type;

    public AppointmentTypeListRow(IBaseEditor editor, Composite parent, int style, FormToolkit toolkit) {
        super(parent, style);
        if (editor == null) {
            throw new NullPointerException("editor");
        }
        if (toolkit == null) {
            throw new NullPointerException("toolkit");
        }
        this.cvsColor = this.createLabel(parent, 2048, "");
        this.lblCode = new MyLabel(parent, null, 0, toolkit);
        this.lblDuree = new MyLabel(parent, null, 0, toolkit);
        this.lblDescription = new MyLabel(parent, null, 0, toolkit);
        this.lblProfessional = new MyLabel(parent, null, 0, toolkit);
        this.lblSurveyId = new MyLabel(parent, null, 0, toolkit);
        this.lblStatus = new MyLabel(parent, null, 0, toolkit);
        this.lblActif = new MyLabel(parent, null, 0, toolkit);
        this.btnDelete = new MyButton(parent, null, 8, toolkit);
        this.btnDelete.setImage(ResourceGetter.getImage((String)"images/delete_edit.gif"));
        this.btnDelete.setToolTipText(Messages.getString((String)"SUPPRIMER", (String[])new String[0]));
        this.btnDelete.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)editor, 13){

            public void edited(Event e) {
                if (AppointmentTypeListRow.this.type != null) {
                    AppointmentTypeListRow.this.type.setIsDeleted(Boolean.valueOf(true));
                    AppointmentTypeListRow.this.showDataObject();
                }
            }
        });
        this.btnEdit = new MyButton(parent, null, 8, toolkit);
        this.btnEdit.setImage(ResourceGetter.getImage((String)"images/edit.gif"));
        this.btnEdit.setToolTipText(Messages.getString((String)"MODIFIER", (String[])new String[0]));
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ResourceGetter.dispose((Object)AppointmentTypeListRow.this.color);
            }
        });
    }

    public XAppointmentType getType() {
        return this.type;
    }

    public void setType(XAppointmentType type) {
        this.type = type;
        this.showDataObject();
    }

    public void showDataObject() {
        RGB typeColor = this.getTypeColor();
        if (this.color == null) {
            this.color = ResourceGetter.getColor((RGB)typeColor);
        } else if (!typeColor.equals((Object)this.color.getRGB())) {
            ResourceGetter.dispose((Object)this.color);
            this.color = ResourceGetter.getColor((RGB)typeColor);
        }
        this.cvsColor.setBackground(this.color);
        if (this.type != null) {
            boolean isDefault = Boolean.TRUE.equals(this.type.getIsDefault());
            this.lblCode.setText(this.type.getCode());
            this.lblDuree.setText(this.type.getDuree() == null ? null : this.type.getDuree().toString());
            this.lblDescription.setText(this.type.getDescription());
            if (this.type.getProfessionnal() == null) {
                this.lblProfessional.setText(null);
            } else {
                XBaseProfessionnal baseProfessionnal = PersonUiPlugin.getDefault().getBaseProfessionnal(this.type.getProfessionnal());
                if (baseProfessionnal == null) {
                    this.lblProfessional.setText(null);
                } else {
                    this.lblProfessional.setText(XProfessionalFormatter.format((XBaseProfessionnal)baseProfessionnal, (boolean)false));
                }
            }
            this.lblSurveyId.setText(this.type.getSurvey1Q() == null ? "" : this.type.getSurvey1Q().toString());
            if (this.type.getStatus().size() > 0) {
                this.lblStatus.setText(String.valueOf(this.type.getStatus().size()));
                this.lblStatus.setToolTipText(new JoinList("\n", (Collection)this.type.getStatus()).toString());
            } else {
                this.lblStatus.setText(null);
            }
            if (this.type.getIsDeleted() == null || this.type.getIsDeleted().booleanValue()) {
                this.lblActif.setText(null);
            } else {
                this.lblActif.setText("*");
            }
            this.btnDelete.setVisible(this.type.isNewOrNewUpdated());
            this.btnEdit.setEnabled(!this.type.isStatusDeleted() && !this.type.isNonExisting());
            if (isDefault) {
                this.lblCode.setFont(0, 1);
                this.lblCode.setToolTipText(VALEUR_DEFAUT);
                this.lblDuree.setFont(0, 1);
                this.lblDuree.setToolTipText(VALEUR_DEFAUT);
                this.lblDescription.setFont(0, 1);
                this.lblDescription.setToolTipText(VALEUR_DEFAUT);
                this.lblProfessional.setFont(0, 1);
                this.lblProfessional.setToolTipText(VALEUR_DEFAUT);
                this.lblSurveyId.setFont(0, 1);
                this.lblSurveyId.setToolTipText(VALEUR_DEFAUT);
                this.lblStatus.setFont(0, 1);
            } else {
                this.lblCode.setFont(0, 0);
                this.lblCode.setToolTipText("");
                this.lblDuree.setFont(0, 0);
                this.lblDuree.setToolTipText("");
                this.lblDescription.setFont(0, 0);
                this.lblDescription.setToolTipText("");
                this.lblProfessional.setFont(0, 0);
                this.lblProfessional.setToolTipText("");
                this.lblSurveyId.setFont(0, 0);
                this.lblSurveyId.setToolTipText("");
                this.lblStatus.setFont(0, 0);
            }
        } else {
            this.lblCode.setText(null);
            this.lblDuree.setText(null);
            this.lblDescription.setText(null);
            this.lblProfessional.setText(null);
            this.lblSurveyId.setText(null);
            this.lblStatus.setText(null);
            this.lblActif.setText(null);
            this.btnDelete.setVisible(false);
            this.btnEdit.setEnabled(false);
        }
    }

    private RGB getTypeColor() {
        return this.getTypeColor(this.type == null ? null : this.type.getColor());
    }

    public Label getCvsColor() {
        return this.cvsColor;
    }

    public MyLabel getLblCode() {
        return this.lblCode;
    }

    public MyLabel getLblDuree() {
        return this.lblDuree;
    }

    public MyLabel getLblDescription() {
        return this.lblDescription;
    }

    public MyLabel getLblProfessional() {
        return this.lblProfessional;
    }

    public MyLabel getLblSurveyId() {
        return this.lblSurveyId;
    }

    public MyLabel getLblStatus() {
        return this.lblStatus;
    }

    public MyLabel getLblActif() {
        return this.lblActif;
    }

    public void dispose() {
        this.lblActif.dispose();
        this.cvsColor.dispose();
        this.lblCode.dispose();
        this.lblDuree.dispose();
        this.lblDescription.dispose();
        this.lblProfessional.dispose();
        this.lblSurveyId.dispose();
        this.lblStatus.dispose();
        this.btnDelete.dispose();
        this.btnEdit.dispose();
    }

    public MyButton getBtnDelete() {
        return this.btnDelete;
    }

    public MyButton getBtnEdit() {
        return this.btnEdit;
    }
}

