/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.multiprof;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IVisualAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriod;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.appointment.control.AppointmentDateControl;
import ca.infodata.ofys.ui.appointment.control.AppointmentPrintDialog;
import ca.infodata.ofys.ui.appointment.control.AppointmentVisualStructure;
import ca.infodata.ofys.ui.appointment.control.IAppointmentDateControlContentProvider;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentMainController;
import ca.infodata.ofys.ui.controls.IUserInteractionHelper;
import ca.infodata.ofys.ui.controls.UserInteractionHelper;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.ofys.util.json.IJsonReader;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

abstract class AppointmentDateControl2
extends AppointmentDateControl {
    private static final Logger logger = Logger.getLogger(AppointmentDateControl2.class.getName());
    private static final String ctrlCmdSign = LibPlugin.ON_MAC ? "  CMD+" : "  CTRL+";
    private TransactionType transactionType;
    private IAppointment transaction;
    private IAppointment oldAppointment;
    private AppointmentMainController controller;

    public AppointmentDateControl2(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style, new MyAppointmentDateControlContentProvider());
    }

    @Override
    protected void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (UI.rightClick((MouseEvent)e)) {
            Point point = this.getDisplay().map((Control)this.getCanvas(), null, e.x, e.y);
            this.showPopupMenu(point.x, point.y);
        }
    }

    public void showPopupMenu(int x, int y) {
        Menu menu = new Menu((Control)this.getCanvas());
        menu.setLocation(x, y);
        menu.setVisible(true);
        MenuItem item2 = new MenuItem(menu, 64);
        item2.setText(Messages.getString((String)"ACTUALISER", (String[])new String[0]));
        item2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppointmentVisualStructure vs = AppointmentDateControl2.this.getAppointmentVisualStructure();
                if (vs != null) {
                    vs.forceReset();
                }
            }
        });
        if (this.getVisualStructure() != null && this.getVisualStructure().isUsable()) {
            boolean canSeeAndModifyAppointment;
            IAppointment currentAppointment;
            IVisualAppointment currentVisualAppointment = this.getVisualStructure().getSelectedAppointment();
            if (currentVisualAppointment instanceof IAppointment) {
                MenuItem cut;
                currentAppointment = (IAppointment)currentVisualAppointment;
                canSeeAndModifyAppointment = this.getVisualStructure().canSeeAndModifyAppointment((IVisualAppointment)currentAppointment);
                if (currentAppointment != null && Boolean.TRUE.equals(currentAppointment.getIsDeleted()) && canSeeAndModifyAppointment) {
                    cut = new MenuItem(menu, 8);
                    cut.setText(Messages.getString((String)"ANNULER_SUPPRESSION", (String[])new String[0]));
                    cut.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            AppointmentDateControl2.this.getController().undeleteAppointment(currentAppointment);
                        }
                    });
                }
                if (currentAppointment != null && !Boolean.TRUE.equals(currentAppointment.getIsDeleted()) && canSeeAndModifyAppointment) {
                    cut = new MenuItem(menu, 8);
                    cut.setText(String.valueOf(Messages.getString((String)"COUPER", (String[])new String[0])) + ctrlCmdSign + "X");
                    cut.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            AppointmentDateControl2.this.getController().cut(currentAppointment);
                        }
                    });
                    MenuItem copy = new MenuItem(menu, 8);
                    copy.setText(String.valueOf(Messages.getString((String)"COPIER", (String[])new String[0])) + ctrlCmdSign + "C");
                    copy.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            AppointmentDateControl2.this.getController().copy(currentAppointment);
                        }
                    });
                }
            }
            if (this.getController().canPaste()) {
                MenuItem paste = new MenuItem(menu, 8);
                paste.setText(String.valueOf(Messages.getString((String)"COLLER", (String[])new String[0])) + ctrlCmdSign + "V");
                paste.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AppointmentDateControl2.this.getController().paste((IUserInteractionHelper)new UserInteractionHelper(AppointmentDateControl2.this.getShell()));
                    }
                });
            }
            if (currentVisualAppointment instanceof IAppointment) {
                currentAppointment = (IAppointment)currentVisualAppointment;
                canSeeAndModifyAppointment = this.getVisualStructure().canSeeAndModifyAppointment((IVisualAppointment)currentAppointment);
                if (currentAppointment != null && !Boolean.TRUE.equals(currentAppointment.getIsDeleted()) && canSeeAndModifyAppointment) {
                    new MenuItem(menu, 2);
                    if (currentAppointment.getPatientOrAdhoc((IJsonReader)Application.get().getGsonProcessor()) != null) {
                        MenuItem print = new MenuItem(menu, 8);
                        print.setText(String.valueOf(Messages.getString((String)"IMPRIMER", (String[])new String[0])) + ctrlCmdSign + "P");
                        print.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                new AppointmentPrintDialog(AppointmentDateControl2.this.getShell(), currentAppointment).open();
                            }
                        });
                        new MenuItem(menu, 2);
                    }
                    MenuItem item = new MenuItem(menu, 8);
                    item.setText(String.valueOf(Messages.getString((String)"EFFACER", (String[])new String[0])) + " DEL");
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (MessageUtil.askQuestion((Shell)AppointmentDateControl2.this.getShell(), (String)Messages.getString((String)"ETES_VOUS_CERTAINS", (String[])new String[0]), (boolean)false)) {
                                AppointmentDateControl2.this.getController().deleteAppointment(currentAppointment);
                            }
                        }
                    });
                    item = new MenuItem(menu, 64);
                    item.setText(Messages.getString((String)"ETAT_DU_PATIENT", (String[])new String[0]));
                    Menu patientStateSubMenu = new Menu(menu);
                    item.setMenu(patientStateSubMenu);
                    item = new MenuItem(patientStateSubMenu, 32);
                    item.setText(Messages.getString((String)"AUCUN", (String[])new String[0]));
                    item.setSelection(currentAppointment.getPatientStatus().value == XPatientStatus.NONE.value);
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            AppointmentDateControl2.this.getController().setPatientStatus(currentAppointment, XPatientStatus.NONE);
                        }
                    });
                    item = new MenuItem(patientStateSubMenu, 32);
                    item.setText(String.valueOf(Messages.getString((String)"ANNULE", (String[])new String[0])) + ctrlCmdSign + "L");
                    item.setSelection(currentAppointment.getPatientStatus().value == XPatientStatus.CANCEL.value);
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            AppointmentDateControl2.this.getController().setPatientStatus(currentAppointment, XPatientStatus.CANCEL);
                        }
                    });
                    item = new MenuItem(patientStateSubMenu, 32);
                    item.setText(Messages.getString((String)"CANCEL_LESS_24H", (String[])new String[0]));
                    item.setSelection(currentAppointment.getPatientStatus().value == XPatientStatus.CANCEL_LESS_24H.value);
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            AppointmentDateControl2.this.getController().setPatientStatus(currentAppointment, XPatientStatus.CANCEL_LESS_24H);
                        }
                    });
                    item = new MenuItem(patientStateSubMenu, 32);
                    item.setText(String.valueOf(Messages.getString((String)"VU", (String[])new String[0])) + ctrlCmdSign + "U");
                    item.setSelection(currentAppointment.getPatientStatus().value == XPatientStatus.SEEN.value);
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            AppointmentDateControl2.this.getController().setPatientStatus(currentAppointment, XPatientStatus.SEEN);
                        }
                    });
                    item = new MenuItem(patientStateSubMenu, 32);
                    item.setText(String.valueOf(Messages.getString((String)"ARRIVE", (String[])new String[0])) + ctrlCmdSign + "R");
                    item.setSelection(currentAppointment.getPatientStatus().value == XPatientStatus.ARRIVED.value);
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            AppointmentDateControl2.this.getController().setPatientStatus(currentAppointment, XPatientStatus.ARRIVED);
                        }
                    });
                    item = new MenuItem(patientStateSubMenu, 32);
                    item.setText(String.valueOf(Messages.getString((String)"NE_SEST_PAS_PRESENTE", (String[])new String[0])) + ctrlCmdSign + "T");
                    item.setSelection(currentAppointment.getPatientStatus().value == XPatientStatus.NOT_CAME.value);
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            AppointmentDateControl2.this.getController().setPatientStatus(currentAppointment, XPatientStatus.NOT_CAME);
                        }
                    });
                    item = new MenuItem(patientStateSubMenu, 32);
                    item.setText(String.valueOf(Messages.getString((String)"PLACED", (String[])new String[0])) + ctrlCmdSign + "K");
                    item.setSelection(currentAppointment.getPatientStatus().value == XPatientStatus.PLACED.value);
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            AppointmentDateControl2.this.getController().setPatientStatus(currentAppointment, XPatientStatus.PLACED);
                        }
                    });
                    item = new MenuItem(menu, 64);
                    item.setText(Messages.getString((String)"ETAT_DU_RENDEZ_VOUS", (String[])new String[0]));
                    Menu appointmentStateSubMenu = new Menu(menu);
                    item.setMenu(appointmentStateSubMenu);
                    XAppointmentStatus[] xAppointmentStatusArray = XAppointmentStatus.values();
                    int n = xAppointmentStatusArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final XAppointmentStatus state = xAppointmentStatusArray[n2];
                        item = new MenuItem(appointmentStateSubMenu, 32);
                        String text = state.toString();
                        switch (state) {
                            case MESSAGE_LEAVED: {
                                text = String.valueOf(text) + ctrlCmdSign + "G";
                                break;
                            }
                            case NO_ANSWER: {
                                text = String.valueOf(text) + ctrlCmdSign + "D";
                                break;
                            }
                            case CONFIRMED: {
                                text = String.valueOf(text) + ctrlCmdSign + "I";
                                break;
                            }
                        }
                        item.setText(text);
                        item.setSelection(currentAppointment.getStatus() == state);
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                AppointmentDateControl2.this.getController().setAppointmentStatus(currentAppointment, state);
                            }
                        });
                        ++n2;
                    }
                }
            }
        }
    }

    @Override
    protected void keyboardAction(KeyEvent e) {
        super.keyboardAction(e);
        if (this.getVisualStructure() == null) {
            return;
        }
        if (e.keyCode == 0x1000007) {
            this.scrollHome();
        } else if (e.keyCode == 0x1000008) {
            this.scrollEnd();
        } else if (e.keyCode == 0x1000005) {
            this.scrollPageUp();
        } else if (e.keyCode == 0x1000006) {
            this.scrollPageDown();
        } else if (e.keyCode == 0x1000001 && e.stateMask == 0) {
            if (this.transaction != null && this.transactionType == TransactionType.ByKey) {
                this.getVisualStructure().up(this.transaction);
                this.scrollUp(true);
            } else {
                this.getVisualStructure().up();
                this.scrollUp(true);
            }
        } else if (e.keyCode == 0x1000002 && e.stateMask == 0) {
            if (this.transaction != null && this.transactionType == TransactionType.ByKey) {
                this.scrollDown(true);
                this.getVisualStructure().down((IVisualAppointment)this.transaction);
            } else {
                this.scrollDown(true);
                this.getVisualStructure().down();
            }
        } else if (e.keyCode == 0x1000002 && e.stateMask == 65536) {
            if (this.transaction != null && this.transactionType == TransactionType.ByKey) {
                this.getVisualStructure().resize((IVisualAppointment)this.transaction, false);
            }
        } else if (e.keyCode == 0x1000001 && e.stateMask == 65536) {
            if (this.transaction != null && this.transactionType == TransactionType.ByKey) {
                this.getVisualStructure().resize((IVisualAppointment)this.transaction, true);
            }
        } else if (e.keyCode == 0x1000003) {
            if (this.transaction == null) {
                this.getVisualStructure().left();
            }
        } else if (e.keyCode == 0x1000004) {
            if (this.transaction == null) {
                this.getVisualStructure().right();
            }
        } else if ((e.keyCode == 122 || e.keyCode == 90) && UI.CTRL((KeyEvent)e)) {
            if (this.transactionType == TransactionType.ByKey) {
                this.cancelTransaction();
            }
        } else if (UI.CR((KeyEvent)e) && e.stateMask == 0) {
            if (this.transaction == null) {
                this.getOrCreateAndOpenSelectedAppointment();
            }
        } else if (UI.CR((KeyEvent)e) && UI.CTRL((KeyEvent)e)) {
            if (this.transaction != null && this.transactionType == TransactionType.ByKey) {
                this.commitTransaction();
            }
        } else if (UI.ESC((KeyEvent)e)) {
            this.getController().cancelCopyOrCut();
            if (this.transactionType == TransactionType.ByKey) {
                this.cancelTransaction();
            }
        } else {
            Point point;
            IAppointment currentAppointment = this.getController().getCurrentAppointment();
            boolean canSeeAndModifyAppointment = this.getController().canSeeAndModifyAppointment(currentAppointment);
            if (UI.CTRL((KeyEvent)e) && (e.keyCode == 120 || e.keyCode == 88)) {
                if (this.transaction == null && currentAppointment != null && !Boolean.TRUE.equals(currentAppointment.getIsDeleted()) && canSeeAndModifyAppointment) {
                    this.getController().cut(currentAppointment);
                }
            } else if (UI.CTRL((KeyEvent)e) && (e.keyCode == 99 || e.keyCode == 67)) {
                if (this.transaction == null && currentAppointment != null && !Boolean.TRUE.equals(currentAppointment.getIsDeleted()) && canSeeAndModifyAppointment) {
                    this.getController().copy(currentAppointment);
                }
            } else if (UI.CTRL((KeyEvent)e) && (e.keyCode == 118 || e.keyCode == 86)) {
                if (this.transaction == null) {
                    this.getController().paste((IUserInteractionHelper)new UserInteractionHelper(this.getShell()));
                }
            } else if (UI.CTRL((KeyEvent)e) && (e.keyCode == 112 || e.keyCode == 80)) {
                if (this.transaction == null && currentAppointment != null && !Boolean.TRUE.equals(currentAppointment.getIsDeleted()) && canSeeAndModifyAppointment) {
                    new AppointmentPrintDialog(this.getShell(), currentAppointment).open();
                }
            } else if (e.keyCode == 127 || e.keyCode == 8) {
                if (this.transaction == null && currentAppointment != null && !Boolean.TRUE.equals(currentAppointment.getIsDeleted()) && canSeeAndModifyAppointment && MessageUtil.askQuestion((Shell)this.getShell(), (String)Messages.getString((String)"ETES_VOUS_CERTAINS", (String[])new String[0]))) {
                    this.getController().deleteAppointment(currentAppointment);
                }
            } else if (UI.CTRL((KeyEvent)e) && (e.keyCode == 108 || e.keyCode == 76)) {
                if (this.transaction == null && currentAppointment != null && !Boolean.TRUE.equals(currentAppointment.getIsDeleted()) && canSeeAndModifyAppointment) {
                    this.getController().setPatientStatus(currentAppointment, XPatientStatus.CANCEL);
                }
            } else if (UI.CTRL((KeyEvent)e) && (e.keyCode == 117 || e.keyCode == 85)) {
                if (this.transaction == null && currentAppointment != null && !Boolean.TRUE.equals(currentAppointment.getIsDeleted()) && canSeeAndModifyAppointment) {
                    this.getController().setPatientStatus(currentAppointment, XPatientStatus.SEEN);
                }
            } else if (UI.CTRL((KeyEvent)e) && (e.keyCode == 114 || e.keyCode == 82)) {
                if (this.transaction == null && currentAppointment != null && !Boolean.TRUE.equals(currentAppointment.getIsDeleted()) && canSeeAndModifyAppointment) {
                    this.getController().setPatientStatus(currentAppointment, XPatientStatus.ARRIVED);
                }
            } else if (UI.CTRL((KeyEvent)e) && (e.keyCode == 116 || e.keyCode == 84)) {
                if (this.transaction == null && currentAppointment != null && !Boolean.TRUE.equals(currentAppointment.getIsDeleted()) && canSeeAndModifyAppointment) {
                    this.getController().setPatientStatus(currentAppointment, XPatientStatus.NOT_CAME);
                }
            } else if (UI.CTRL((KeyEvent)e) && (e.keyCode == 103 || e.keyCode == 71)) {
                if (this.transaction == null && currentAppointment != null && !Boolean.TRUE.equals(currentAppointment.getIsDeleted()) && canSeeAndModifyAppointment) {
                    this.getController().setAppointmentStatus(currentAppointment, XAppointmentStatus.MESSAGE_LEAVED);
                }
            } else if (UI.CTRL((KeyEvent)e) && (e.keyCode == 100 || e.keyCode == 68)) {
                if (this.transaction == null && currentAppointment != null && !Boolean.TRUE.equals(currentAppointment.getIsDeleted()) && canSeeAndModifyAppointment) {
                    this.getController().setAppointmentStatus(currentAppointment, XAppointmentStatus.NO_ANSWER);
                }
            } else if (UI.CTRL((KeyEvent)e) && (e.keyCode == 105 || e.keyCode == 73)) {
                if (this.transaction == null && currentAppointment != null && !Boolean.TRUE.equals(currentAppointment.getIsDeleted()) && canSeeAndModifyAppointment) {
                    this.getController().setAppointmentStatus(currentAppointment, XAppointmentStatus.CONFIRMED);
                }
            } else if (UI.CTRL((KeyEvent)e) && e.keyCode == 47 && (point = this.getDrawer().getGcSelectionFromVsSelection()) != null) {
                point = this.getDisplay().map((Control)this.getCanvas(), null, point);
                this.showPopupMenu(point.x, point.y);
            }
        }
    }

    private void cancelTransaction() {
        if (this.transaction != null) {
            this.getController().cancelAll();
            this.getDrawer().setSelectionCursorBlack();
        }
        this.transaction = null;
    }

    private void commitTransaction() {
        if (this.transaction != null) {
            block7: {
                try {
                    try {
                        IStatus status = this.getController().saveAll();
                        if (!status.isOkToProceed()) {
                            this.getController().cancelAll();
                        }
                    }
                    catch (Exception exception) {
                        this.getController().cancelAll();
                        this.transaction = null;
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.transaction = null;
                    throw throwable;
                }
                this.transaction = null;
            }
            this.getDrawer().setSelectionCursorBlack();
        }
    }

    @Override
    protected void mouseDoubleClickedOverride(MouseEvent e) {
        AppointmentVisualStructure.VsPoint selection;
        super.mouseDoubleClickedOverride(e);
        if (this.getController() != null && (selection = this.getVisualStructure().getSelection()) != null) {
            this.getOrCreateAndOpenSelectedAppointment();
        }
    }

    private void getOrCreateAndOpenSelectedAppointment() {
        AppointmentMainController controller = this.getController();
        if (controller != null) {
            IAppointment appointment = controller.getCurrentAppointment();
            if (appointment == null) {
                AppointmentVisualStructure visualStructure = this.getVisualStructure();
                int length = visualStructure.getScale();
                if (visualStructure.getSelectedPeriod() != null) {
                    length = visualStructure.getSelectedPeriod().getDefaultLength();
                }
                appointment = controller.createNewAppointment(length);
            }
            if (appointment != null) {
                this.openAppointmentWindow();
            }
        }
    }

    @Override
    public void selectionChanged(IVisualAppointment selectedAppointment, XAppointmentPeriod selectedPeriod, XAppointmentDateTemplate selectedDateTemplate, XAppointmentDate selectedDate, Integer startTime, Integer endTime) {
        Log.log((Logger)logger, (String)"MyAppointmentDateControlListener.selectionChanged", (String[])new String[]{"selectedAppointment", "selectedPeriod", "selectedDateTemplate", "selectedDate", "startTime", "endTime"}, (Object[])new Object[]{selectedAppointment, selectedPeriod, selectedDateTemplate, selectedDate, startTime, endTime});
        this.getController().setCurrentPeriod(selectedPeriod);
        this.getController().setCurrentAppointment(selectedAppointment instanceof IAppointment ? (IAppointment)selectedAppointment : null);
        this.getController().setCurrentStartTime(startTime);
        this.getController().setCurrentEndTime(endTime);
        if (!MiscUtil.objectsAreEquals((Object)this.oldAppointment, (Object)selectedAppointment)) {
            this.commitTransaction();
            this.oldAppointment = selectedAppointment instanceof IAppointment ? (IAppointment)selectedAppointment : null;
        }
    }

    protected abstract void openAppointmentWindow();

    public AppointmentMainController getController() {
        return this.controller;
    }

    public void setController(AppointmentMainController controller) {
        this.controller = controller;
    }

    static class MyAppointmentDateControlContentProvider
    implements IAppointmentDateControlContentProvider {
        MyAppointmentDateControlContentProvider() {
        }

        @Override
        public XAppointmentPeriod createNewPeriod(XAppointmentDateTemplate dateTemplate, int startTime, int endTime) {
            return null;
        }

        @Override
        public boolean canResize() {
            return false;
        }

        @Override
        public boolean canMove() {
            return false;
        }
    }

    private static enum TransactionType {
        ByKey,
        ByMouse;

    }
}

