/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.model2;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XReservedAppointment;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.util1.ConcurrentHashSet;
import ca.infodata.util1.Pair;
import ca.infodata.util1.date.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections4.map.MultiValueMap;

public class XReservedAppointmentTable {
    private static final Logger logger = Logger.getLogger(XReservedAppointmentTable.class.getName());
    private MultiValueMap reserverdAppointmentByProfDate;
    private HashMap<Integer, XReservedAppointment> reservedAppointmentById;
    private ConcurrentHashSet<XReservedAppointment> reservedAppointmentSet;
    private TimerTask delayedTask = new TimerScheduleDelay();

    public XReservedAppointmentTable() {
        this.reserverdAppointmentByProfDate = new MultiValueMap();
        this.reservedAppointmentSet = new ConcurrentHashSet(1000, 8);
        this.reservedAppointmentById = new HashMap(1000);
        Timer timer = new Timer();
        timer.schedule(this.delayedTask, 1000L, 1000L);
    }

    public synchronized IEditableDataObjectList<XReservedAppointment> get(Integer idProf, LocalDate date) {
        Pair key = Pair.newPair((Object)idProf, (Object)date);
        Collection c = this.reserverdAppointmentByProfDate.getCollection((Object)key);
        if (c == null) {
            return EditableDataObjectList.emptyList();
        }
        return new EditableDataObjectList(c);
    }

    public synchronized boolean add(XReservedAppointment reservedAppointment) {
        if (reservedAppointment == null) {
            return false;
        }
        boolean b = this.reservedAppointmentSet.add((Object)reservedAppointment);
        if (b) {
            Integer mainIdProf = reservedAppointment.getIdProfessional();
            Pair key = Pair.newPair((Object)mainIdProf, (Object)reservedAppointment.getDate());
            this.reserverdAppointmentByProfDate.put((Object)key, (Object)reservedAppointment);
            this.reservedAppointmentById.put(reservedAppointment.getId(), reservedAppointment);
        }
        return b;
    }

    public synchronized void addAll(Collection<XReservedAppointment> c) {
        if (c != null) {
            long t = System.currentTimeMillis() - 50L;
            for (XReservedAppointment a : c) {
                a.setTimeOfExpiration(Long.valueOf(t + (long)(a.getNumberOfSecToExpire() * 1000)));
                this.add(a);
            }
        }
    }

    public synchronized boolean replace(XReservedAppointment reservedAppointment) {
        if (reservedAppointment == null) {
            return false;
        }
        this.remove(reservedAppointment);
        if (reservedAppointment.isInvalidateMe()) {
            return true;
        }
        return this.add(reservedAppointment);
    }

    private synchronized void remove(XReservedAppointment reservedAppointment) {
        if (reservedAppointment == null) {
            return;
        }
        this.reservedAppointmentSet.remove((Object)reservedAppointment);
        this.reservedAppointmentById.remove(reservedAppointment.getId());
        for (Map.Entry e : this.reserverdAppointmentByProfDate.entrySet()) {
            ((Collection)e.getValue()).remove(reservedAppointment);
        }
    }

    public synchronized void remove(Integer idProf, LocalDate date) {
        Pair key = Pair.newPair((Object)idProf, (Object)date);
        Collection c = this.reserverdAppointmentByProfDate.getCollection((Object)key);
        this.reserverdAppointmentByProfDate.remove((Object)key);
        if (c != null) {
            for (XReservedAppointment a : c) {
                this.reservedAppointmentSet.remove((Object)a);
                this.reservedAppointmentById.remove(a.getId());
            }
        }
    }

    public synchronized Collection<XReservedAppointment> getAll() {
        return this.reservedAppointmentSet;
    }

    public synchronized XReservedAppointment get(Integer id) {
        return this.reservedAppointmentById.get(id);
    }

    public void dispose() {
        this.delayedTask.cancel();
    }

    class TimerScheduleDelay
    extends TimerTask {
        TimerScheduleDelay() {
        }

        @Override
        public void run() {
            long t = System.currentTimeMillis();
            if (!XReservedAppointmentTable.this.reservedAppointmentSet.isEmpty()) {
                for (XReservedAppointment x : XReservedAppointmentTable.this.reservedAppointmentSet) {
                    if (!x.isInvalidateMe() && t <= x.getTimeOfExpiration()) continue;
                    x.setInvalidateMe(true);
                    try {
                        Application.get().getGlobalInstances().getNotificationSystem().sendDataObjectUpdatedNotification((IDataObject)x);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to sendDataObjectUpdatedNotification for invalided or expired XReservedAppointment", e);
                    }
                    XReservedAppointmentTable.this.remove(x);
                }
            }
        }
    }
}

