/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.model2;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.ui.appointment.editor.model2.Model;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.util1.date.LocalDate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class CacheCleaner {
    private static final Logger logger = Logger.getLogger(CacheCleaner.class.getName());
    private Timer timer;
    private TimerTask task;
    private static int threshold = 20000;
    private Model model;
    private ConcurrentHashMap<XBaseProfessionnal, Set<LocalDate>> vetos;

    public CacheCleaner(Model model) {
        this.model = model;
        this.timer = new Timer("modelCacheCleaner", true);
        this.task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ((CacheCleaner)CacheCleaner.this).model.lock;
                synchronized (object) {
                    try {
                        if (!Application.get().getGlobalInstances().isLoggingOut()) {
                            CacheCleaner.this.doit();
                        }
                    }
                    catch (RuntimeException e) {
                        logger.log(Level.SEVERE, "Error", e);
                        this.cancel();
                    }
                }
            }
        };
        this.vetos = new ConcurrentHashMap();
        this.timer.schedule(this.task, TimeUnit.MINUTES.toMillis(30L), TimeUnit.MINUTES.toMillis(5L));
    }

    private void doit() {
        int count = this.computeCacheCount();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("count vs threshold. (" + count + " vs " + threshold + ")");
        }
        if (count > threshold) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("count > threshold. (" + count + ">" + threshold + ")");
            }
            Map<XBaseProfessionnal, Set<LocalDate>> vetos = this.computeVetos();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("vetos objects (%s) %s", this.sizeOf(vetos), vetos));
            }
            Map<Integer, Collection<LocalDate>> objectToRemove = this.computeObjectToRemove();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("objects to removes (%s) %s", this.sizeOf(objectToRemove), objectToRemove));
            }
            for (Map.Entry<XBaseProfessionnal, Set<LocalDate>> entry : vetos.entrySet()) {
                if (!objectToRemove.containsKey(entry.getKey().getId())) continue;
                objectToRemove.get(entry.getKey().getId()).removeAll((Collection)entry.getValue());
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("objects to removes-vetos (%s) %s", this.sizeOf(objectToRemove), objectToRemove));
            }
            for (Map.Entry<Object, Collection<LocalDate>> entry : objectToRemove.entrySet()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("removing for prof " + PersonUiPlugin.getDefault().getBaseProfessionnal((Integer)entry.getKey()).getName());
                }
                Integer prof = (Integer)entry.getKey();
                this.model.cache.remove(prof, entry.getValue());
                this.model.data.remove(prof, entry.getValue());
            }
        }
    }

    private int sizeOf(Map<?, ?> map) {
        int size = 0;
        for (Map.Entry<?, ?> e : map.entrySet()) {
            size += ((Collection)e.getValue()).size();
        }
        return size;
    }

    private int computeCacheCount() {
        return this.model.data.getAppointments().getAll().size();
    }

    private Map<XBaseProfessionnal, Set<LocalDate>> computeVetos() {
        return this.vetos;
    }

    private Map<Integer, Collection<LocalDate>> computeObjectToRemove() {
        return this.model.cache.getAllNonUsedSince(System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(30L));
    }

    public void veto(XBaseProfessionnal prof, Collection<LocalDate> dates) {
        this.vetos.putIfAbsent(prof, new HashSet());
        this.vetos.get(prof).addAll(dates);
    }

    public void unveto(XBaseProfessionnal prof, Collection<LocalDate> dates) {
        this.vetos.putIfAbsent(prof, new HashSet());
        this.vetos.get(prof).removeAll(dates);
    }

    ConcurrentHashMap<XBaseProfessionnal, Set<LocalDate>> getVetos() {
        return this.vetos;
    }

    public void dispose() {
        this.timer.cancel();
        this.timer = null;
        this.task = null;
        this.model = null;
        this.vetos.clear();
    }
}

