/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.CommonAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XModificationEntry;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentCancelledBy;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecall;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecallSearchCriteria;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.appointment.XAppointmentFormatter;
import ca.infodata.ofys.ui.appointment.editor.appointment.AppointmentController;
import ca.infodata.ofys.ui.appointment.editor.appointment.AppointmentEditionControl;
import ca.infodata.ofys.ui.appointment.editor.recall.XPatientRecallFormatter;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.FontAwareSection;
import ca.infodata.ofys.ui.controls.FontAwareShell;
import ca.infodata.ofys.ui.controls.FontAwareTable;
import ca.infodata.ofys.ui.controls.MyMessageDialogBuilder;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyList;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonMultiEditorFactory;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import ca.infodata.ofys.ui.person.search.PatientSearchComposite;
import ca.infodata.ofys.ui.person.search.ProfessionnalSearchComposite;
import ca.infodata.ofys.ui.site.ContextSiteProvider;
import ca.infodata.ofys.util.EnumWithValueFactory;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.ProviderR;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AppointmentWindow
implements IRefreshFont {
    private static final Logger logger = Logger.getLogger(AppointmentWindow.class.getName());
    protected static final String VRAI = Messages.getString((String)"YES", (String[])new String[0]);
    protected static final String FAUX = Messages.getString((String)"NO", (String[])new String[0]);
    protected static final String AJOUT = Messages.getString((String)"AJOUT", (String[])new String[0]);
    private final AppointmentEditionControl appointmentEditionControl;
    private final FontAwareShell window;
    private PatientSearchComposite patientSearchComposite;
    private ProfessionnalSearchComposite professionnalSearchComposite;
    private boolean needToSearchForPatientFirst = true;
    private boolean isDisposed = false;
    private TabFolder searchFolder;
    private MyButton btnSaveAnCompletePatient;
    private MyButton btnSave;
    private MyButton btnCancel;
    private AppointmentController controller;
    private IAppointmentControllerListenerImplementation controllerListener;
    private SwtRefreshRunnable swtRefreshRunnable;
    private Control[] controls = new Control[1];
    private Listener keyDownListener;
    private TabItem tabSearchProfessionnal;
    private TabItem tabSearchPatient;
    private Composite modificationSection;
    private Composite rightSection;
    private FontAwareTable tblPatientRecalls;
    private FontAwareTable tblFutureAppointments;
    private List<XPatientRecall> recalls;
    private ProviderAR<XPatientRecall, String> recallLabelProvider;
    private boolean patientRecallsNeverFilled;
    private boolean futureAppointmentsNeverFilled;
    private boolean modificationEntriesNeverFilled;
    private Control oldFocusedControl;
    private MyList<XModificationEntry> listModification;
    private FontAwareComposite buttonComp;

    public AppointmentWindow(Shell parent, FormToolkit toolkit) {
        this.controllerListener = new IAppointmentControllerListenerImplementation();
        this.swtRefreshRunnable = new SwtRefreshRunnable();
        this.window = new FontAwareShell(parent, 67632);
        this.window.setVisible(false);
        this.appointmentEditionControl = new AppointmentEditionControl();
        this.appointmentEditionControl.createPartControl((Composite)this.window);
        this.buttonComp = new FontAwareComposite((Composite)this.window, 0);
        toolkit.adapt((Composite)this.buttonComp);
        this.btnSave = new MyButton((Composite)this.buttonComp, Messages.getString((String)"SAUVEGARDER", (String[])new String[0]), 8, toolkit);
        this.btnSaveAnCompletePatient = new MyButton((Composite)this.buttonComp, Messages.getString((String)"SAUVEGARDER_COMPLETER_LE_PATIENT", (String[])new String[0]), 8, toolkit);
        this.btnSaveAnCompletePatient.setToolTipText(Messages.getString((String)"SAUVEGARDER_COMPLETER_LE_PATIENT_TTT", (String[])new String[0]));
        this.btnCancel = new MyButton((Composite)this.buttonComp, Messages.getString((String)"ANNULER", (String[])new String[0]), 8, toolkit);
        this.recallLabelProvider = new ProviderAR<XPatientRecall, String>(){

            public String get(XPatientRecall recall) {
                JoinList b = new JoinList(", ", 7);
                b.setTrim(true);
                if (recall.getDateRecall() != null) {
                    b.add((CharSequence)LocalDateFormat.format((LocalDate)recall.getDateRecall(), (String)FormatDateProvider.getFormatDate().toString()));
                }
                b.add((CharSequence)XPatientRecallFormatter.formatWithoutPatientName(recall));
                return b.toString();
            }
        };
        FillLayout layout = new FillLayout();
        layout.spacing = 5;
        this.buttonComp.setLayout((Layout)layout);
        this.createSearchFolder(toolkit);
        this.createRightSection(toolkit);
        this.createModificationFolder(toolkit);
        this.createEvents();
        toolkit.adapt((Composite)this.window);
        toolkit.adapt((Composite)this.searchFolder);
        this.mainLayout();
        ResourceGetter.addListener((IRefreshFont)this.window);
    }

    public void mainLayout() {
        FormLayout layout = new FormLayout();
        layout.marginBottom = 10;
        layout.marginLeft = 10;
        layout.marginTop = 10;
        layout.marginRight = 10;
        layout.spacing = 5;
        this.window.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.appointmentEditionControl.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.appointmentEditionControl.getControl());
        data.left = new FormAttachment(this.appointmentEditionControl.getControl(), 0, 16384);
        data.right = new FormAttachment(this.appointmentEditionControl.getControl(), 0, 131072);
        this.buttonComp.setLayoutData((Object)data);
        if (this.needToSearchForPatientFirst) {
            this.showSearhFolder();
        } else {
            this.hideSearchFolder(false);
        }
        this.window.pack();
        this.setWindowTitle();
        this.setSaveButtonStatus();
    }

    public Point getAppointmentWindowLocation() {
        Composite parent = this.window.getParent();
        Point location = parent.getLocation();
        Point size = parent.getSize();
        Point mySize = this.window.getSize();
        int x = location.x + size.x / 2 - mySize.x / 2;
        int y = location.y + size.y / 2 - mySize.y / 2;
        return new Point(x, y);
    }

    private void createEvents() {
        SelectionAdapter selShowRight = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (((Button)event.widget).getSelection()) {
                    AppointmentWindow.this.showHideRightSection(((Button)event.widget).getData("do"));
                }
            }
        };
        this.appointmentEditionControl.btnShowRightAppt.addSelectionListener((SelectionListener)selShowRight);
        this.appointmentEditionControl.btnShowRightSearch.addSelectionListener((SelectionListener)selShowRight);
        this.appointmentEditionControl.btnShowRightMods.addSelectionListener((SelectionListener)selShowRight);
        this.appointmentEditionControl.btnShowRightNil.addSelectionListener((SelectionListener)selShowRight);
        this.btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AppointmentWindow.this.close(CloseType.OK);
            }
        });
        this.btnSaveAnCompletePatient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AppointmentWindow.this.close(CloseType.OK, true);
            }
        });
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AppointmentWindow.this.close(CloseType.CANCEL);
            }
        });
        this.window.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 2) {
                    e.doit = false;
                }
            }
        });
        this.keyDownListener = new Listener(){

            public void handleEvent(Event e) {
                if (!AppointmentWindow.this.window.isDisposed() && AppointmentWindow.this.window.getDisplay().getActiveShell() == AppointmentWindow.this.window) {
                    if (UI.CTRL((Event)e) && UI.CR((Event)e)) {
                        AppointmentWindow.this.close(CloseType.OK);
                    }
                    if (UI.ESC((Event)e)) {
                        if (AppointmentWindow.this.searchFolder.isVisible()) {
                            AppointmentWindow.this.hideSearchFolder(true);
                            e.doit = false;
                        } else if (AppointmentWindow.this.rightSection.isVisible()) {
                            AppointmentWindow.this.hideRightSection(true);
                            e.doit = false;
                        } else {
                            Shell[] shells;
                            Shell[] shellArray = shells = e.display.getShells();
                            int n = shells.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Shell shell = shellArray[n2];
                                if (shell.getParent() == AppointmentWindow.this.window && !shell.isDisposed() && shell.getVisible()) {
                                    return;
                                }
                                ++n2;
                            }
                            AppointmentWindow.this.close(CloseType.CANCEL);
                        }
                    }
                }
            }
        };
        this.window.getDisplay().addFilter(1, this.keyDownListener);
    }

    private void showHideRightSection(Object fct) {
        if (fct.equals("search")) {
            this.showSearhFolder();
        } else if (fct.equals("appt")) {
            this.showRightSection();
        } else if (fct.equals("nil")) {
            this.hideModificationSection(false);
            this.hideRightSection(true);
        } else if (fct.equals("mods")) {
            this.showModificationsFolder();
        }
    }

    private void showRightSection() {
        this.hideSearchFolder(false);
        this.hideModificationSection(false);
        Control c = UI.getFocusedControl((Composite)this.window);
        if (!(c instanceof Button)) {
            this.oldFocusedControl = c;
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.appointmentEditionControl.getControl(), 2);
        data.bottom = new FormAttachment(this.appointmentEditionControl.getControl(), 0, 1024);
        data.width = 300;
        this.rightSection.setLayoutData((Object)data);
        this.rightSection.setVisible(true);
        this.window.layout(new Control[]{this.rightSection});
        this.window.pack();
        this.reCenterWindowAuBesoin();
        if (this.patientRecallsNeverFilled) {
            this.fillPatientRecalls();
        }
        if (this.futureAppointmentsNeverFilled) {
            this.fillFuturAppointments();
        }
    }

    private void hideModificationSection(boolean doPack) {
        this.hideSearchFolder(false);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = 0;
        data.height = 0;
        this.modificationSection.setLayoutData((Object)data);
        this.modificationSection.setVisible(false);
        this.window.layout(new Control[]{this.modificationSection});
        if (doPack) {
            this.window.pack();
        }
        if (this.oldFocusedControl != null) {
            this.oldFocusedControl.setFocus();
        }
    }

    private void hideRightSection(boolean doPack) {
        this.hideSearchFolder(false);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = 0;
        data.height = 0;
        this.rightSection.setLayoutData((Object)data);
        this.rightSection.setVisible(false);
        this.window.layout(new Control[]{this.rightSection});
        if (doPack) {
            this.window.pack();
        }
        if (this.oldFocusedControl != null) {
            this.oldFocusedControl.setFocus();
        }
    }

    private void createRightSection(FormToolkit toolkit) {
        Color white = ResourceGetter.getColor((int)255, (int)255, (int)255);
        this.rightSection = new FontAwareComposite((Composite)this.window, 2048);
        this.rightSection.setBackground(white);
        this.rightSection.setVisible(false);
        FontAwareSection sectionPatientRecalls = new FontAwareSection(this.rightSection, 64, toolkit);
        sectionPatientRecalls.setText(Messages.getString((String)"RAPPELS", (String[])new String[0]));
        FontAwareComposite compPatientRecalls = new FontAwareComposite((Composite)sectionPatientRecalls, 0);
        compPatientRecalls.setLayout((Layout)new FillLayout());
        sectionPatientRecalls.setClient((Control)compPatientRecalls);
        this.tblPatientRecalls = new FontAwareTable((Composite)compPatientRecalls, 2048, toolkit);
        toolkit.createCompositeSeparator((Composite)sectionPatientRecalls);
        FontAwareSection sectionFutureAppointments = new FontAwareSection(this.rightSection, 64, toolkit);
        sectionFutureAppointments.setText(Messages.getString((String)"RENDEZVOUS_FUTURS", (String[])new String[0]));
        FontAwareComposite compFutureAppointments = new FontAwareComposite((Composite)sectionFutureAppointments, 0);
        compFutureAppointments.setLayout((Layout)new FillLayout());
        sectionFutureAppointments.setClient((Control)compFutureAppointments);
        this.tblFutureAppointments = new FontAwareTable((Composite)compFutureAppointments, 2048, toolkit);
        toolkit.createCompositeSeparator((Composite)sectionFutureAppointments);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.rightSection.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(40);
        sectionPatientRecalls.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)sectionPatientRecalls);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        sectionFutureAppointments.setLayoutData((Object)data);
        this.tblPatientRecalls.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (AppointmentWindow.this.tblPatientRecalls.getSelectionCount() == 1 && UI.rightClick((MouseEvent)e)) {
                    Menu menu = new Menu((Control)AppointmentWindow.this.tblPatientRecalls);
                    menu.setVisible(true);
                    MenuItem item = new MenuItem(menu, 8);
                    item.setText(XStatus.APPOINTMENT_GIVEN.toString());
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (MessageDialog.openConfirm((Shell)AppointmentWindow.this.getWindow(), (String)Messages.getString((String)"APPOINTEMNT_WINDOW.PATIENT_RECALL_CHANGE_STATUS_WARNING_TITLE", (String[])new String[0]), (String)Messages.getString((String)"APPOINTEMNT_WINDOW.PATIENT_RECALL_CHANGE_STATUS_WARNING", (String[])new String[0]))) {
                                XPatientRecall recall = (XPatientRecall)AppointmentWindow.this.tblPatientRecalls.getSelection()[0].getData();
                                AppointmentWindow.this.changePatientRecallStatus(recall, XStatus.APPOINTMENT_GIVEN);
                            }
                        }
                    });
                }
            }
        });
    }

    protected void changePatientRecallStatus(XPatientRecall recall, XStatus newStatus) {
        block4: {
            JobCallback callback = new JobCallback("changePatientRecallStatus", (IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(ReturnObject response) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!AppointmentWindow.this.isDisposed()) {
                                AppointmentWindow.this.fillPatientRecalls();
                            }
                        }
                    });
                }
            };
            try {
                AppointmentAccessorClient.getInstance().changePatientRecallStatus(recall.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, recall.getId().intValue(), newStatus);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, String.format("Error recall=%s, newStatus=%s", recall, newStatus), e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    private void createModificationFolder(FormToolkit toolkit) {
        Color white = ResourceGetter.getColor((int)255, (int)255, (int)255);
        this.modificationSection = new FontAwareComposite((Composite)this.window, 2048);
        this.modificationSection.setBackground(white);
        this.modificationSection.setVisible(false);
        FontAwareSection section = new FontAwareSection(this.modificationSection, 64, toolkit);
        section.setText(Messages.getString((String)"HISTORIQUE_DES_MODIFICATIONS", (String[])new String[0]));
        FontAwareComposite comp = new FontAwareComposite((Composite)section, 0);
        comp.setLayout((Layout)new FillLayout());
        section.setClient((Control)comp);
        this.listModification = new MyList((Composite)comp, 0x800000);
        this.listModification.setLabelProvider((ProviderAR)new ProviderAR<XModificationEntry, String>(){

            public String get(XModificationEntry e) {
                String s = String.valueOf(DateUtil.nonThreadSafeFormat((Long)e.getDatetime(), (String)(String.valueOf(FormatDateProvider.getFormatDate().toString()) + " HH:mm"))) + " " + PersonUiPlugin.getDefault().getUserCompleteName(e.getIdUser());
                return s;
            }
        });
        this.listModification.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                int itemTop = 0;
                int i = 0;
                while (i < AppointmentWindow.this.listModification.getItemCount()) {
                    if (event.y >= itemTop && event.y <= itemTop + AppointmentWindow.this.listModification.getItemHeight()) {
                        System.out.println("Click on item " + AppointmentWindow.this.listModification.getItem(AppointmentWindow.this.listModification.getTopIndex() + i));
                        XModificationEntry x = (XModificationEntry)((List)AppointmentWindow.this.listModification.getModel()).get(AppointmentWindow.this.listModification.getTopIndex() + i);
                        StringBuilder sb = new StringBuilder();
                        if (x.getUpdatedData() == null) {
                            sb.append("==> ").append(AJOUT);
                        } else {
                            try {
                                JsonObject obj = new JsonParser().parse(x.getUpdatedData()).getAsJsonObject();
                                Set entrySet = obj.entrySet();
                                for (Map.Entry o : entrySet) {
                                    String key = (String)o.getKey();
                                    String value = ((JsonElement)o.getValue()).getAsString().split("~>")[1];
                                    String titre = AppointmentEditionControl.mapMsg.containsKey(key) ? AppointmentEditionControl.mapMsg.get(key) : key;
                                    String val = AppointmentEditionControl.setIsABool.contains(key) ? (value.equals("0") ? FAUX : VRAI) : (AppointmentEditionControl.setIsATime.contains(key) ? DateUtil.convertTimeToString((Integer)Integer.valueOf(value), (Character)Character.valueOf(':')) : (AppointmentEditionControl.setIsALongDateTime.contains(key) ? DateUtil.longToDataString((long)Long.valueOf(value)) : (AppointmentEditionControl.setIsAStatus.contains(key) ? XAppointmentStatus.from((Integer)Integer.valueOf(value)).toString() : (AppointmentEditionControl.setIsAPatientStatus.contains(key) ? XPatientStatus.from((Integer)Integer.valueOf(value)).toString() : (AppointmentEditionControl.setIsACancelledBy.contains(key) ? ((XAppointmentCancelledBy)EnumWithValueFactory.fromInt(XAppointmentCancelledBy.class, (Integer)Integer.valueOf(value))).name() : value)))));
                                    sb.append("_____ " + titre + " _____\n").append("==> " + val + "\n");
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        AppointmentWindow.this.listModification.setToolTipText(sb.toString());
                    }
                    itemTop += AppointmentWindow.this.listModification.getItemHeight();
                    ++i;
                }
            }
        });
        toolkit.createCompositeSeparator((Composite)section);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.modificationSection.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        section.setLayoutData((Object)data);
    }

    private void fillModifications() {
        block7: {
            if (this.controller != null) {
                Integer id = this.controller.getId();
                if (id != null) {
                    JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

                        public void responseReceived(final ReturnObject response) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!AppointmentWindow.this.isDisposed()) {
                                        if (response == null || response.getObj() == null) {
                                            AppointmentWindow.this.fillModifications(Collections.EMPTY_LIST);
                                        } else {
                                            AppointmentWindow.this.fillModifications((List)response.getObj());
                                        }
                                    }
                                }
                            });
                        }
                    };
                    try {
                        CommonAccessorClient.getInstance().findModificationEntries(this.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, "appointment", id);
                    }
                    catch (CannotConnectToServerException cannotConnectToServerException) {
                        if (callback != null && !callback.killed()) {
                            callback.kill();
                        }
                        break block7;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to fillModifications, idAppointment " + id, e);
                        if (callback != null && !callback.killed()) {
                            callback.kill();
                        }
                        break block7;
                    }
                }
                this.fillModifications(Collections.EMPTY_LIST);
            }
        }
    }

    private void fillModifications(List<XModificationEntry> list) {
        this.listModification.setItems(list);
        this.modificationEntriesNeverFilled = false;
    }

    private void fillPatientRecalls() {
        block7: {
            if (this.controller != null) {
                IPatient patient = this.controller.getCurrentPatient();
                if (patient != null && patient.getId() != null) {
                    JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

                        public void responseReceived(final ReturnObject response) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!AppointmentWindow.this.isDisposed()) {
                                        if (response == null || response.getObj() == null) {
                                            AppointmentWindow.this.fillPatientRecalls(Collections.EMPTY_LIST);
                                        } else {
                                            AppointmentWindow.this.fillPatientRecalls((List)response.getObj());
                                        }
                                    }
                                }
                            });
                        }
                    };
                    try {
                        XPatientRecallSearchCriteria criteria = new XPatientRecallSearchCriteria();
                        criteria.patientId = patient.getId();
                        AppointmentAccessorClient.getInstance().findPatientRecall(Application.get().getGlobalInstances().getSession(), (ICallback)callback, criteria);
                    }
                    catch (CannotConnectToServerException cannotConnectToServerException) {
                        if (callback != null && !callback.killed()) {
                            callback.kill();
                        }
                        break block7;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to fillPatientRecalls, patient " + patient, e);
                        if (callback != null && !callback.killed()) {
                            callback.kill();
                        }
                        break block7;
                    }
                }
                this.fillPatientRecalls(Collections.EMPTY_LIST);
            }
        }
    }

    private void fillPatientRecalls(List<XPatientRecall> list) {
        this.recalls = new ArrayList<XPatientRecall>(list.size());
        for (XPatientRecall recall : list) {
            if (recall.getStatus() != XStatus.NORMAL && recall.getStatus() != XStatus.CLIENT_NOT_REACHED) continue;
            this.recalls.add(recall);
        }
        Collections.sort(this.recalls);
        this.tblPatientRecalls.clearAll();
        this.tblPatientRecalls.setItemCount(0);
        for (XPatientRecall recall : this.recalls) {
            TableItem item = new TableItem((Table)this.tblPatientRecalls, 0);
            item.setData((Object)recall);
            item.setText((String)this.recallLabelProvider.get((Object)recall));
        }
        String text = (String)this.appointmentEditionControl.btnShowRightAppt.getData("text");
        text = String.valueOf(text) + "(" + this.tblPatientRecalls.getItemCount() + ")";
        this.appointmentEditionControl.btnShowRightAppt.setText(text);
        this.patientRecallsNeverFilled = false;
    }

    private void fillFuturAppointments() {
        block7: {
            if (this.controller != null) {
                IPatient patient = this.controller.getCurrentPatient();
                if (patient != null && patient.getId() != null) {
                    JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

                        public void responseReceived(final ReturnObject response) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!AppointmentWindow.this.isDisposed()) {
                                        if (response == null || response.getObj() == null) {
                                            AppointmentWindow.this.fillFuturAppointments(Collections.EMPTY_LIST);
                                        } else {
                                            AppointmentWindow.this.fillFuturAppointments((List)response.getObj());
                                        }
                                    }
                                }
                            });
                        }
                    };
                    try {
                        AppointmentAccessorClient.getInstance().findFutureAppointmentsByPatient(this.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, patient.getId().intValue());
                    }
                    catch (CannotConnectToServerException cannotConnectToServerException) {
                        if (callback != null && !callback.killed()) {
                            callback.kill();
                        }
                        break block7;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to fillFuturAppointments, patient " + patient, e);
                        if (callback != null && !callback.killed()) {
                            callback.kill();
                        }
                        break block7;
                    }
                }
                this.fillFuturAppointments(Collections.EMPTY_LIST);
            }
        }
    }

    private void fillFuturAppointments(List<IAppointment> appointments) {
        this.tblFutureAppointments.clearAll();
        this.tblFutureAppointments.setItemCount(0);
        ArrayList<IAppointment> list = new ArrayList<IAppointment>(appointments);
        for (IAppointment appointment : list) {
            if (Boolean.TRUE.equals(appointment.getIsDeleted())) continue;
            TableItem item = new TableItem((Table)this.tblFutureAppointments, 0);
            item.setData((Object)appointment);
            item.setText(XAppointmentFormatter.format(appointment, true, true, false, true, true));
        }
        this.futureAppointmentsNeverFilled = false;
    }

    private void createSearchFolder(FormToolkit toolkit) {
        Color white = ResourceGetter.getColor((int)255, (int)255, (int)255);
        this.searchFolder = new TabFolder((Composite)this.window, 2048);
        this.searchFolder.setBackground(white);
        this.searchFolder.setLayout((Layout)new FormLayout());
        this.searchFolder.setVisible(false);
        this.tabSearchPatient = new TabItem(this.searchFolder, 0);
        this.tabSearchPatient.setText(String.valueOf(Messages.getString((String)"RECHERCHE", (String[])new String[0])) + "-Client");
        Composite parent1 = new Composite((Composite)this.searchFolder, 0);
        parent1.setBackground(white);
        parent1.setLayout((Layout)new FillLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        parent1.setLayoutData((Object)data);
        this.patientSearchComposite = new PatientSearchComposite(parent1, toolkit, 0);
        this.patientSearchComposite.setIsWithButtonNew(false);
        this.patientSearchComposite.hideKeepFocus();
        this.patientSearchComposite.setContextSiteProvider((ContextSiteProvider)this.appointmentEditionControl);
        this.tabSearchPatient.setControl((Control)parent1);
        this.tabSearchProfessionnal = new TabItem(this.searchFolder, 0);
        this.tabSearchProfessionnal.setText(String.valueOf(Messages.getString((String)"RECHERCHE", (String[])new String[0])) + "-" + Messages.getString((String)"PROFESSIONNEL", (String[])new String[0]));
        Composite parent2 = new Composite((Composite)this.searchFolder, 0);
        parent2.setBackground(white);
        parent2.setLayout((Layout)new FillLayout());
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        parent2.setLayoutData((Object)data);
        this.professionnalSearchComposite = new ProfessionnalSearchComposite(parent2, toolkit, 0);
        this.tabSearchProfessionnal.setControl((Control)parent2);
        this.appointmentEditionControl.setPatientSearchProvider(new ProviderR<PatientSearchComposite>(){

            public PatientSearchComposite get() {
                AppointmentWindow.this.showSearhFolder();
                AppointmentWindow.this.searchFolder.setSelection(AppointmentWindow.this.tabSearchPatient);
                if (AppointmentWindow.this.patientSearchComposite != null) {
                    AppointmentWindow.this.patientSearchComposite.setFocus();
                }
                return AppointmentWindow.this.patientSearchComposite;
            }
        });
        this.appointmentEditionControl.setProfessionalSearchProvider(new ProviderR<ProfessionnalSearchComposite>(){

            public ProfessionnalSearchComposite get() {
                AppointmentWindow.this.showSearhFolder();
                AppointmentWindow.this.searchFolder.setSelection(AppointmentWindow.this.tabSearchProfessionnal);
                if (AppointmentWindow.this.professionnalSearchComposite != null) {
                    AppointmentWindow.this.professionnalSearchComposite.getControl().setFocus();
                }
                return AppointmentWindow.this.professionnalSearchComposite;
            }
        });
        this.controls[0] = this.searchFolder;
    }

    private void setWindowTitle() {
        if (!this.window.isDisposed()) {
            if (this.controller == null) {
                this.window.setText("");
            } else if (Application.get().getGlobalInstances().inDebugMode() && this.controller.getAppointment() != null) {
                XAppointment appointment = this.controller.getAppointment();
                JoinList patientIds = new JoinList(",");
                for (IPatient patient : appointment.getPatients()) {
                    patientIds.add((CharSequence)(patient.getId() == null ? "null" : patient.getId().toString()));
                }
                this.window.setText("appid=" + this.controller.getId() + ", ptid=" + patientIds + "  " + this.controller.format(true, true));
            } else {
                this.window.setText(this.controller.format(true, true));
            }
        }
    }

    private void setSaveButtonStatus() {
        this.btnSave.setEnabled(this.controller != null && this.controller.hasAppointment() && this.controller.getIsDeleted() != null && this.controller.getIsDeleted() == false);
        this.btnSaveAnCompletePatient.setEnabled(this.btnSave.getEnabled() && this.controller.getAppointment().getPatients().size() == 1 && this.controller.canSeeAndModifyAppointment());
    }

    public void setFocus() {
        if (this.needToSearchForPatientFirst) {
            this.appointmentEditionControl.getPatientSearch().setFocus();
        } else {
            this.appointmentEditionControl.setFocus();
        }
    }

    public Point getLocation() {
        return this.window.getLocation();
    }

    public void setLocation(Point location) {
        this.window.setLocation(location);
    }

    private void showModificationsFolder() {
        this.hideRightSection(false);
        this.hideSearchFolder(false);
        Control c = UI.getFocusedControl((Composite)this.window);
        if (!(c instanceof Button)) {
            this.oldFocusedControl = c;
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.appointmentEditionControl.getControl(), 2);
        data.bottom = new FormAttachment(this.appointmentEditionControl.getControl(), 0, 1024);
        data.width = 300;
        this.modificationSection.setLayoutData((Object)data);
        this.modificationSection.setVisible(true);
        this.window.layout(new Control[]{this.modificationSection});
        this.window.pack();
        this.reCenterWindowAuBesoin();
        if (this.modificationEntriesNeverFilled) {
            this.fillModifications();
        }
    }

    private void showSearhFolder() {
        this.hideRightSection(false);
        this.hideModificationSection(false);
        Control c = UI.getFocusedControl((Composite)this.window);
        if (!(c instanceof Button)) {
            this.oldFocusedControl = c;
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.appointmentEditionControl.getControl(), 2);
        data.bottom = new FormAttachment(this.appointmentEditionControl.getControl(), 0, 1024);
        data.width = 300;
        this.searchFolder.setLayoutData((Object)data);
        this.searchFolder.setVisible(true);
        this.window.layout(new Control[]{this.searchFolder});
        if (this.searchFolder.getSelectionIndex() == 0) {
            this.patientSearchComposite.setFocus();
        } else {
            this.professionnalSearchComposite.setFocus();
        }
        this.window.pack();
        this.reCenterWindowAuBesoin();
    }

    protected void reCenterWindowAuBesoin() {
        Point location = this.window.getLocation();
        Point size = this.window.getSize();
        Rectangle bounds = this.window.getDisplay().getClientArea();
        Rectangle rect = this.window.getBounds();
        int x = 0;
        int y = 0;
        if (location.x + size.x > bounds.width) {
            x = bounds.x + (bounds.width - rect.width) / 2;
        }
        if (location.y + size.y > bounds.height) {
            y = bounds.y + (bounds.height - rect.height) / 2;
        }
        if (x != 0 || y != 0) {
            x = x == 0 ? rect.x : x;
            y = y == 0 ? rect.y : y;
            this.window.setLocation(x, y);
        }
    }

    private void hideSearchFolder(boolean doPack) {
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = 0;
        data.height = 0;
        this.searchFolder.setLayoutData((Object)data);
        this.searchFolder.setVisible(false);
        this.window.layout(this.controls);
        if (doPack) {
            this.window.pack();
        }
        if (this.oldFocusedControl != null) {
            this.oldFocusedControl.setFocus();
        }
    }

    public void open() {
        this.professionnalSearchComposite.reset();
        this.professionnalSearchComposite.setType(null);
        this.patientSearchComposite.reset();
        this.patientSearchComposite.setReferenceControl((Object)this.appointmentEditionControl.getTxtPatient());
        this.professionnalSearchComposite.setReferenceControl((Object)this.appointmentEditionControl.getTxtTreatingProfessionnal());
        this.appointmentEditionControl.btnShowRightMods.setSelection(false);
        this.appointmentEditionControl.btnShowRightSearch.setSelection(false);
        this.appointmentEditionControl.btnShowRightNil.setSelection(false);
        this.appointmentEditionControl.btnShowRightAppt.setSelection(false);
        if (this.needToSearchForPatientFirst) {
            this.appointmentEditionControl.btnShowRightSearch.setSelection(true);
            this.appointmentEditionControl.btnShowRightSearch.notifyListeners(13, new Event());
        } else {
            this.appointmentEditionControl.btnShowRightNil.setSelection(true);
            this.appointmentEditionControl.btnShowRightNil.notifyListeners(13, new Event());
        }
        this.window.setVisible(true);
        this.setFocus();
    }

    private void close(CloseType closeType) {
        this.close(closeType, false);
    }

    private void close(CloseType closeType, boolean openPatientEditorOnSucess) {
        this.appointmentEditionControl.getTxtPatient().setFocus();
        switch (closeType) {
            case OK: {
                IPatient patient;
                XAppointment appointment;
                boolean isNewAppointment = this.controller.getAppointment() != null && this.controller.getAppointment().getId() == null;
                boolean hasOnlyOnePatient = this.controller.getAppointment() != null && this.controller.getAppointment().getPatient() != null;
                IStatus status = this.save();
                if (!status.isOkToProceed()) break;
                if (isNewAppointment && hasOnlyOnePatient) {
                    Integer idPatient = null;
                    try {
                        idPatient = this.controller.getAppointment().getPatient().getId();
                        if (idPatient != null) {
                            this.askUserToUpdatePatientRecall(idPatient);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to askUserToUpdatePatientRecall idPatient=" + idPatient + ", appointment=" + this.controller.getAppointment(), e);
                    }
                }
                this.window.setVisible(false);
                if (!openPatientEditorOnSucess || (appointment = this.controller.getAppointment()) == null || (patient = appointment.getPatient()) == null) break;
                patient = patient.clone();
                if (Application.get().getGlobalInstances().getSession() != null && Application.get().getGlobalInstances().getSession().getClientPreferences() != null && Application.get().getGlobalInstances().getSession().getClientPreferences().isMultiplePatientWindows()) {
                    PersonMultiEditorFactory.openPatient((IPatient)patient);
                    break;
                }
                PatientMultiEditor editor = (PatientMultiEditor)BaseEditor.openEditorSafe((IEditorInput)new EditorInput((IDataObject)patient), (String)PatientMultiEditor.class.getName());
                if (editor == null) break;
                editor.setActivePage(editor.getiGeneralPage());
                break;
            }
            case CANCEL: {
                if (!this.cancel()) break;
                this.window.setVisible(false);
            }
        }
    }

    private void askUserToUpdatePatientRecall(int idPatient) throws Exception {
        XPatientRecallSearchCriteria criteria = new XPatientRecallSearchCriteria();
        criteria.patientId = idPatient;
        final List list2 = AppointmentAccessorClient.getInstance().findPatientRecallSync(Application.get().getGlobalInstances().getSession(), criteria);
        Collections.sort(list2);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            XPatientRecall r = (XPatientRecall)iterator.next();
            if (r.getStatus() != XStatus.APPOINTMENT_GIVEN && r.getStatus() != XStatus.CANCELED) continue;
            iterator.remove();
        }
        if (list2.size() > 0) {
            XPatientRecall recall;
            MyMessageDialogBuilder builder = new MyMessageDialogBuilder(){
                MyList<XPatientRecall> list;

                protected Control createCustomArea(Composite parent) {
                    this.list = new MyList(parent, 2564);
                    this.list.setLabelProvider(AppointmentWindow.this.recallLabelProvider);
                    this.list.setItems((Collection)list2);
                    this.list.select((Object)((XPatientRecall)list2.get(0)));
                    parent.setLayout((Layout)new FormLayout());
                    FormData data = new FormData();
                    data.top = new FormAttachment(0);
                    data.left = new FormAttachment(0);
                    data.right = new FormAttachment(100);
                    data.height = 100;
                    this.list.setLayoutData((Object)data);
                    return this.list.getControl();
                }

                protected boolean customShouldTakeFocus() {
                    return true;
                }

                protected boolean buttonPressed(int buttonId) {
                    this.input = this.list.getSelection3();
                    return true;
                }
            };
            builder.setButtonLabels(new String[]{"Celui-ci", "Aucun"});
            builder.setDefaultButton(0);
            builder.useQuestionBundle();
            builder.setParent((Shell)this.window);
            builder.setTitle("Rappels");
            builder.setMessage("Quel rappel correspond au rendez-vous que vous venez de cr\u00e9er ?");
            int r = builder.buildAndOpen();
            if (r == 0 && (recall = (XPatientRecall)builder.getInput()) != null) {
                IStatus status = this.changePatientRecallStatusSync((Shell)this.window, recall, XStatus.APPOINTMENT_GIVEN);
                MessageUtil.show((Shell)this.window, (IStatus)status);
                if (!status.isOkToProceed()) {
                    this.askUserToUpdatePatientRecall(idPatient);
                }
            }
        }
    }

    protected IStatus changePatientRecallStatusSync(Shell shell, XPatientRecall recall, XStatus newStatus) {
        try {
            MultiStatus status = AppointmentAccessorClient.getInstance().changePatientRecallStatusSync(recall.hashCode(), Application.get().getGlobalInstances().getSession(), recall.getId().intValue(), newStatus);
            return status;
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, String.format("Error recall=%s, newStatus=%s", recall, newStatus), e);
        }
        return new Status(IStatus.Severity.BUG);
    }

    private boolean cancel() {
        IStatus status = this.appointmentEditionControl.doCancel(null);
        return status.isOK();
    }

    private IStatus save() {
        return this.appointmentEditionControl.doSave(null);
    }

    public Shell getWindow() {
        return this.window;
    }

    public void setAppointmentEditorInput(AppointmentController newController) {
        if (this.controller != null) {
            this.controller.removeListener(this.controllerListener);
        }
        this.futureAppointmentsNeverFilled = true;
        this.patientRecallsNeverFilled = true;
        this.modificationEntriesNeverFilled = true;
        this.controller = newController;
        this.appointmentEditionControl.setController(this.controller);
        if (this.controller != null) {
            this.controller.addListener(this.controllerListener);
            this.needToSearchForPatientFirst = false;
        }
        if (this.controller == null) {
            this.needToSearchForPatientFirst = false;
            this.futureAppointmentsNeverFilled = false;
            this.patientRecallsNeverFilled = false;
            this.modificationEntriesNeverFilled = false;
        }
        this.fillPatientRecalls();
        this.setWindowTitle();
        this.setSaveButtonStatus();
        this.appointmentEditionControl.setGuiToInitialState();
        boolean canSeeAndModifyAppointment = this.controller.canSeeAndModifyAppointment();
        this.appointmentEditionControl.grpShowRight.setVisible(canSeeAndModifyAppointment);
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.appointmentEditionControl.setPatientSearchProvider(null);
            this.appointmentEditionControl.setProfessionalSearchProvider(null);
            this.appointmentEditionControl.dispose();
            if (this.controller != null) {
                this.controller.removeListener(this.controllerListener);
            }
            this.controllerListener = null;
            this.swtRefreshRunnable = null;
            this.patientSearchComposite.getControl().dispose();
            this.professionnalSearchComposite.getControl().dispose();
            this.searchFolder.dispose();
            this.btnSave.dispose();
            this.btnSaveAnCompletePatient.dispose();
            this.btnCancel.dispose();
            this.window.getDisplay().removeFilter(1, this.keyDownListener);
            this.window.dispose();
            this.isDisposed = true;
            ResourceGetter.removeListener((IRefreshFont)this.window);
        }
    }

    public void refreshFont() {
        if (!this.isDisposed) {
            this.window.refreshFont();
            this.mainLayout();
            this.window.layout(true, true);
        }
    }

    private static enum CloseType {
        OK,
        CANCEL;

    }

    private final class IAppointmentControllerListenerImplementation
    implements AppointmentController.IAppointmentControllerListener {
        private IAppointmentControllerListenerImplementation() {
        }

        @Override
        public void appointmentChanged() {
            Display.getDefault().asyncExec((Runnable)AppointmentWindow.this.swtRefreshRunnable);
        }

        @Override
        public void appointmentModified() {
            Display.getDefault().asyncExec((Runnable)AppointmentWindow.this.swtRefreshRunnable);
        }

        @Override
        public void patientModified() {
        }
    }

    private final class SwtRefreshRunnable
    implements Runnable {
        private SwtRefreshRunnable() {
        }

        @Override
        public void run() {
            AppointmentWindow.this.setWindowTitle();
            AppointmentWindow.this.setSaveButtonStatus();
        }
    }
}

