/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.appointment.AbstractAppointmentPluginController;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.dataaccess.util.IGlobalInstances;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumerListener;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XConsultationReason;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XClientPreferences;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.util1.JoinList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.Display;

public class AppointmentPluginController
extends AbstractAppointmentPluginController {
    private static final Logger logger = Logger.getLogger(AppointmentPluginController.class.getName());
    private List<XAppointmentPeriodType> periodTypes;
    private Map<Integer, XAppointmentPeriodType> idMapPeriodTypes;
    private List<XAppointmentType> appointmentTypes;
    private Map<Integer, XAppointmentType> idMapAppointmentTypes;
    private Map<String, XConsultationReason> idMapConsultationReasons;
    private Integer defaultTemplateStartHour;
    private Integer defaultTemplateEndHour;
    private Integer defaultTemplateScale;
    private XAppointmentType defaultAppointmentType;
    private XAppointmentPeriodType defaultPeriodType;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final GlobalInstancesAdapter sessionListener = new GlobalInstancesAdapter(){

        public void sessionChanged() {
            AppointmentPluginController.this.load();
        }
    };
    private final IConsumerListener notificationHandlerImplementation = new IConsumerListener(){

        public void handle(DataObjectUpdatedNotification notification) {
            try {
                final IDataObject object = notification.getObject();
                if (object instanceof XAppointmentType) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            XAppointmentType t = (XAppointmentType)object;
                            AppointmentPluginController.this.idMapAppointmentTypes.put(t.getId(), t);
                            AppointmentPluginController.this.appointmentTypes.clear();
                            AppointmentPluginController.this.appointmentTypes.addAll(AppointmentPluginController.this.idMapAppointmentTypes.values());
                        }
                    });
                } else if (object instanceof XAppointmentPeriodType) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            XAppointmentPeriodType t = (XAppointmentPeriodType)object;
                            AppointmentPluginController.this.idMapPeriodTypes.put(t.getId(), t);
                            AppointmentPluginController.this.periodTypes.clear();
                            AppointmentPluginController.this.periodTypes.addAll(AppointmentPluginController.this.idMapPeriodTypes.values());
                        }
                    });
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in IConsumerListener.handle", e);
            }
        }

        public void handleOther(Notification notification) {
        }

        public void forceRefresh() {
            try {
                AppointmentPluginController.this.load();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in AppointmentPlugin.forceRefresh", e);
            }
        }
    };

    public AppointmentPluginController() {
        this.periodTypes = new CopyOnWriteArrayList<XAppointmentPeriodType>();
        this.idMapPeriodTypes = new HashMap<Integer, XAppointmentPeriodType>();
        this.appointmentTypes = new CopyOnWriteArrayList<XAppointmentType>();
        this.idMapAppointmentTypes = new HashMap<Integer, XAppointmentType>();
        this.idMapConsultationReasons = new HashMap<String, XConsultationReason>();
        Application.get().getGlobalInstances().addGlobalInstancesListener((GlobalInstancesListener)this.sessionListener);
        this.sessionListener.sessionChanged();
        Application.get().getGlobalInstances().getNotificationSystem().addListener(this.notificationHandlerImplementation);
    }

    public XAppointmentPeriodType getPeriodType(Integer idType) {
        if (idType == null) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            XAppointmentPeriodType type = this.idMapPeriodTypes.get(idType);
            if (type == null) {
                logger.log(Level.SEVERE, "Failed to get XAppointmentPeriodType for id " + idType + ". \n" + Log.getPrintedStackTrace());
            }
            XAppointmentPeriodType xAppointmentPeriodType = type;
            return xAppointmentPeriodType;
        }
        finally {
            readLock.unlock();
        }
    }

    public List<XAppointmentPeriodType> getPeriodTypes() {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            List<XAppointmentPeriodType> list = this.periodTypes;
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    public XAppointmentType getAppointmentType(Integer id) {
        if (id == null) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            XAppointmentType type = this.idMapAppointmentTypes.get(id);
            if (type == null) {
                logger.log(Level.SEVERE, "Failed to get XAppointmentType for id " + id + ". \n" + Log.getPrintedStackTrace());
            }
            XAppointmentType xAppointmentType = type;
            return xAppointmentType;
        }
        finally {
            readLock.unlock();
        }
    }

    public List<XAppointmentType> getAppointmentTypes() {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            List<XAppointmentType> list = this.appointmentTypes;
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    public XConsultationReason getConsultationReason(String id) {
        if (id == null) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            XConsultationReason type = this.idMapConsultationReasons.get(id);
            if (type == null) {
                logger.log(Level.SEVERE, "Failed to get XAppointmentType for id " + id + ". \n" + Log.getPrintedStackTrace());
            }
            XConsultationReason xConsultationReason = type;
            return xConsultationReason;
        }
        finally {
            readLock.unlock();
        }
    }

    protected XClientPreferences getContextClientPreferences() {
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null) {
            return session.getClientPreferences();
        }
        return null;
    }

    private synchronized void load() {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            XSession session = Application.get().getGlobalInstances().getSession();
            if (session == null) {
                System.out.println("AppointmentPlugin.clear()");
                this.periodTypes = Collections.emptyList();
                this.idMapPeriodTypes.clear();
                this.appointmentTypes.clear();
                this.idMapAppointmentTypes.clear();
                this.idMapConsultationReasons.clear();
                this.defaultTemplateStartHour = null;
                this.defaultTemplateEndHour = null;
                this.defaultTemplateScale = null;
                this.defaultAppointmentType = null;
                this.defaultPeriodType = null;
            } else {
                System.out.println("AppointmentPlugin.load()");
                XClientPreferences pref = session.getClientPreferences();
                this.defaultTemplateStartHour = pref.getAppointmentStartHour();
                this.defaultTemplateEndHour = pref.getAppointmentEndHour();
                this.defaultTemplateScale = pref.getAppointmentBaseTime();
                this.appointmentTypes = new CopyOnWriteArrayList<XAppointmentType>((Collection<XAppointmentType>)pref.getAppointmentTypes());
                this.periodTypes = new CopyOnWriteArrayList<XAppointmentPeriodType>((Collection<XAppointmentPeriodType>)pref.getAppointmentPeriodTypes());
                this.idMapAppointmentTypes.clear();
                for (XAppointmentType xAppointmentType : this.appointmentTypes) {
                    this.idMapAppointmentTypes.put(xAppointmentType.getId(), xAppointmentType);
                    if (!Boolean.TRUE.equals(xAppointmentType.getIsDefault())) continue;
                    this.defaultAppointmentType = xAppointmentType;
                }
                this.idMapPeriodTypes.clear();
                for (XAppointmentPeriodType xAppointmentPeriodType : this.periodTypes) {
                    this.idMapPeriodTypes.put(xAppointmentPeriodType.getId(), xAppointmentPeriodType);
                    if (!Boolean.TRUE.equals(xAppointmentPeriodType.getIsDefault())) continue;
                    this.defaultPeriodType = xAppointmentPeriodType;
                }
                this.idMapConsultationReasons.clear();
                XConsultationReason xConsultationReason = new XConsultationReason();
                xConsultationReason.uid = "null";
                xConsultationReason.title_fr = "S/O";
                xConsultationReason.title_en = "N/A";
                xConsultationReason.desc_fr = " ...";
                xConsultationReason.desc_en = " ...";
                this.idMapConsultationReasons.put("-null", xConsultationReason);
                if (pref.lstConsultationReason != null) {
                    for (XConsultationReason type : pref.lstConsultationReason) {
                        this.idMapConsultationReasons.put(type.uid, type);
                    }
                }
                if (this.defaultAppointmentType == null && this.appointmentTypes.size() > 0) {
                    this.defaultAppointmentType = this.appointmentTypes.get(0);
                }
                if (this.defaultPeriodType == null && this.periodTypes.size() > 0) {
                    this.defaultPeriodType = this.periodTypes.get(0);
                }
            }
            PersonUiPlugin.getDefault().setAppointmentTypes(this.appointmentTypes);
            PersonUiPlugin.getDefault().setIdMapAppointmentTypes(this.idMapAppointmentTypes);
            PersonUiPlugin.getDefault().setMapConsultationReasons(this.idMapConsultationReasons);
        }
        finally {
            writeLock.unlock();
        }
    }

    public int getDefaultTemplateStartHour() {
        return this.defaultTemplateStartHour;
    }

    public int getDefaultTemplateEndHour() {
        return this.defaultTemplateEndHour;
    }

    public int getDefaultTemplateScale() {
        return this.defaultTemplateScale;
    }

    public XAppointmentType getDefaultAppointmentType() {
        return this.defaultAppointmentType;
    }

    public XAppointmentPeriodType getDefaultAppointmentPeriodType() {
        return this.defaultPeriodType;
    }

    public List<XBaseProfessionnal> findNonDeletedProfessionnalsThatUseAppointments() {
        List<XBaseProfessionnal> list = PersonUiPlugin.getDefault().getBaseProfessionnals().filter(p -> p.useAppointment && !Boolean.TRUE.equals(p.getIsDeleted())).collect(Collectors.toList());
        JoinList l = new JoinList("\n");
        for (XBaseProfessionnal a : PersonUiPlugin.getDefault().getBaseProfessionnals().collect(Collectors.toList())) {
            JoinList j = new JoinList(", ");
            j.add((CharSequence)a.firstName).add((CharSequence)a.lastName);
            j.add("IsProdTx=", String.valueOf(a.isProfTx));
            j.add("IsDeleted=", String.valueOf(a.isDeleted));
            j.add("UseAppointment=", String.valueOf(a.useAppointment));
            l.add((CharSequence)j.toString());
        }
        logger.info(l.toString());
        return list;
    }

    public Map<String, XConsultationReason> getMapConsultationReasons() {
        return this.idMapConsultationReasons;
    }

    public void dispose() {
        IGlobalInstances globalInstances = Application.get().getGlobalInstances();
        globalInstances.removeGlobalInstancesListener((GlobalInstancesListener)this.sessionListener);
        globalInstances.getNotificationSystem().removeListener(this.notificationHandlerImplementation);
    }
}

