var Assistant = {};
(function(assist) {

	
	var assistCount = 0;
	var isCtrl = false;
	var ctrlTime = 0;
	
	function hitCtrl() {
		var val = ++ctrlTime;
		isCtrl = true;
		
		setTimeout(function() {
			chkCtrl(val);
		}, 1500)
	}
	
	function chkCtrl(val) {
		if (isCtrl && ctrlTime == val) {
			isCtrl = false;
		}
	}
	
	
	assist.NEW = function(editor) {
	
		var divEditor = $(editor.contentAreaContainer);
	
		assistCount++;
		//Si pas d'élément ou que celui ci pas valid, on va pas plus loin
		
		var relDiv = $("<div>");
		relDiv.attr("id","assistposi-"+assistCount);
		divEditor.attr("assistId","assistposi-"+assistCount);
		divEditor.before(relDiv);
		
//		var isCtrl = false;
		$(editor.contentDocument).keyup(function (e) { 
			if(e.which == 17) {
				isCtrl=false; 
			}
		}).keydown(function (e) { 
			if(e.which == 17) {
				hitCtrl(); 
			}
			if (e.which == 27) {
				closeAllAssist(e);
			}
		});
		
		var assist = new AssistDynaText(editor, relDiv);
		
		assist.ajaxCall = function(value) {
			var newTemplate = { desc: getNewTemplateValue(this.editor), special: true };
			var idType = $(this.baseElement).attr("idType");
			var w = getWord(this.editor);
			var spanW = this.assistElement.find(".search-word");
			this.searchedWord = w;
			if (w.w) {
				w = w.w;
			}

			if (w != null && w.length > 0 ) {
				spanW.text(" ("+w+")");
			} else {
				spanW.text("");
				w = null;
			}
			var sObj = getAssistText(idType, w);
			var obj = $.parseJSON(sObj);
			
			var list = new Array();
			
			for (var i = 0 ;i  < obj.length; i++) {
				list.push(obj[i]);
			}
			if (newTemplate.desc != null) {
				list.push(newTemplate);
			}
			
			this.search.elems = list;
		}
		
		assist.getSpecialKey = function(elem) {
			var span = $("<span>");
			span.text("Ajouter assistant");
			span.addClass("special-assist");
			return span;
		}
		
		assist.getSpecialDescription = function(elem) {
			var div = $("<div>");
			var pA = $("<div>");
			var pB = $("<div>");
			var pC = $("<div>");
			
			div.append(pA).append(pB).append(pC);
			
			pA.addClass("desc-special-header");
			pB.addClass("desc-special-text");
			pC.addClass("desc-special-footer");
			
			pA.text("Voici le texte qui sera ajout\u00E9 comme assistant:");
			pB.html(elem.desc.replace(/\n/g,"<br/>").replace(/  /g,"&nbsp;"));
			pC.text(
				"Le texte d'ajout d'un assistant est le texte s\u00E9lectionn\u00E9.  Si aucun text est "
				+"s\u00E9lectionn\u00E9, c'est le texte complet."
			);
			
			return div;
		}
		assist.getKeyClass = function(elem) {
			if (elem.special) {
				return "flag-0";
			}
			return "flag-"+elem.flag
		}
		assist.getKey = function(elem) {
			if (elem.special) {
				return this.getSpecialKey(elem);
			}
		
			var key = elem.name;
			var div = $("<div>");
			div.text(key);
			return div;
		}
		
		assist.getDescription = function(elem) {
			if (elem.special) {
				return this.getSpecialDescription(elem);
			}
			var desc = elem.text;
			var div = $("<div>");
			div.html(desc.replace(/\$\{[^\}]*\}/g,"").replace(/\n/g,"<br/>").replace(/  /g,"&nbsp;"));
			
			return div;
		}
		
		assist.selection = function(elem) {
			if (elem.special) {
				this.getSpecialSelection(elem);
				return;
			}
			
			/* IE and Safari cant do a real select*/
			if (this.searchedWord != null && this.searchedWord.w) {
				var word = this.editor.selection.getContent({format: 'text'});
				if (typeof word == 'undefined' || word == null || word == "" || word != this.searchedWord.w) {
					var range = this.editor.selection.getRng();
					var node = this.editor.selection.getNode();
					var se = this.editor.selection.getSel();
					var sel = {	s:se.anchorOffset, 
								e:se.anchorOffset, 
								t:se.anchorNode.nodeValue, 
								node: se.anchorNode, 
								rng: range, 
								selNode: node
					};
					console.log("ORIG:"+this.searchedWord.s+"/"+this.searchedWord.e+"/"+this.searchedWord.node.nodeName+", SEL:"+sel.s+"/"+sel.e+"/"+sel.node.nodeName);
					var siA = $(sel.node).parent().children().index(sel.node);
					var siB = $(this.searchedWord.selNode).parent().children().index(this.searchedWord.selNode);
					var siC = -1;
					if (sel.node.previousSibling) siC = $(sel.node.previousSibling).parent().children().index(sel.node.previousSibling);
//					if ( sel.node !== this.searchedWord.node && sel.node.previousElementSibling && sel.node.previousElementSibling === this.searchedWord.node) {
					if ( siA != -1 && siB != -1 && siC != -1 && siA != siB && siB == siC ) {
						if (sel.node.innerText && (sel.node.innerText == "" || sel.node.innerText == "\n" || sel.node.innerText == "\r") ){
							if ( sel.node.childNodes.length == 1 && node.childNodes[0].getAttribute('data-mce-bogus') ) {
								//Ca veut dire qu'on va devoir l'enlever et travailler sur le noeud précédent
								//Il y a eu un "enter" et on veut écraler le tout.
								this.editor.dom.remove(sel.node);
								
								var n = this.searchedWord.selNode;
								var txt = n.innerText;
								var i = txt.lastIndexOf(this.searchedWord.w);
								if ( i != -1) {
									//Si on a trouver le text (devrait tjrs  être le cas)
									var t = [txt.substring(0, i), txt.substring(i+this.searchedWord.w.length)];
									var s = "";
									if (t[0] != null) s += t[0];
									s += elem.text;
									if (t[1] != null) s += t[1];
									
									n.innerText = s;
									
									this.editor.selection.select(n);
									return;
								} else{
									//Si on a pas trouver le text
								}
							}
						}
					}
				}
			}

			
			this.editor.selection.setContent(elem.text);

		}
		
		assist.getSpecialSelection = function(elem) {
			popupAddWindow(elem.desc,$(this.baseElement).attr("idType"));
		}
		assist.getEditorText = function() {
			return $(this.editor.contentDocument.body).text();
		}
		assist.calculatePosition = function(){

			var sel = $(this.editor.selection.getNode());
			
			return sel.offset().top + sel.height() - $(this.editor.contentDocument).scrollTop() + 3;
		};
	};
	
	function popupAddWindow(desc, idType) {
		
		var mainTable = $("<table>");

		for (var j = 0; j < 3; j++) {
			var tr = $("<tr>");
			for (var i = 0; i < 3; i++) {
				var td = $("<td>");
				td.addClass("col-"+(i+1));
				tr.append(td);
			}
			tr.addClass("row-"+(j+1));
			mainTable.append(tr);
		}
		
		mainTable.addClass("popup-table");
		
		var popupDiv = $("<div>");
		var hDiv = $("<div>");
		var cDiv = $("<div>");
		var tDiv = $("<div>");
		var input = $("<input>");
		var buOkiDiv = $("<div>");
		var buCancelDiv = $("<div>");
		var cBuDiv = $("<div>");
		var errDiv = $("<div>");
		
		input.attr("type", "text");
		input.addClass("popup-input");
		
		popupDiv.addClass("popup-div");
		hDiv.addClass("header");
		cDiv.addClass("content");
		tDiv.addClass("text");
		buOkiDiv.addClass("popup-bu").addClass("popup-bu-oki");
		buCancelDiv.addClass("popup-bu").addClass("popup-bu-can");
		cBuDiv.addClass("clear");
		errDiv.addClass("error");
		input.addClass("input").addClass("starter");
		
		hDiv.text("Ajouter un assistant");
		cDiv.text("Vous devez donner un nom pour identifier ce nouvel assistant ayant le contenu suivant:");
		tDiv.text(desc);
		buOkiDiv.text("Sauvegarder");
		buCancelDiv.text("Annuler");
		var startName = "Nom de l'assistant";
		input.val(startName);
		
		popupDiv.append(hDiv)
			.append(cDiv)
			.append(tDiv)
			.append(input)
			.append(errDiv)
			.append(buOkiDiv)
			.append(buCancelDiv)
			.append(cBuDiv);
			
		buCancelDiv.click(function() {
			mainTable.remove();
		});
		
		buOkiDiv.click(function() {
			var val = input.val();
			if (val.length && (val.length == 0 || val == startName)) {
				
				var p = $("<div>");
				var childs = errDiv.children();
				p.hide();
				p.text("Vous devez entrer un nom pour votre assistant!");
				if (childs.size() > 0 ) {
					childs.slideUp(200, function() {
						childs.remove();
						errDiv.append(p);
						p.slideDown();
					});
				} else {
					errDiv.append(p);
					p.slideDown();
				}
			} else {
				createNewAssistant(idType,desc, val);
				mainTable.remove();
			}
		});
		
		input.keydown(function() {
			if (input.val() == startName) {
				input.val("");
				input.removeClass("starter");
			}
		});
		
		mainTable.find(".row-2 .col-2").append(popupDiv);
		$(document.body).append(mainTable);
		input.focus();
	}
	
	function getNewTemplateValue(editor) {
		var word = editor.selection.getContent({format: 'html'});
		if (typeof word == 'undefined' || word == null || word == "") {
			
			word = editor.getContent({format: 'html'});//$(editor.contentDocument.body).text();
			if (typeof word == 'undefined' || word == null || word == "") {
				return null;
			}
		}
		return word;
	}
	
	function getWord(editor) {
	
		var word = editor.selection.getContent({format: 'text'});
		if (typeof word == 'undefined' || word == null || word == "") {
			var range = editor.selection.getRng();
//			var orStart = orginRange.startOffset;
			var node = editor.selection.getNode();
			var se = editor.selection.getSel();
			var sel = {s:se.anchorOffset, e:se.anchorOffset, t:se.anchorNode.nodeValue, node: se.anchorNode, rng: range, selNode: node};

			while (sel.s > 0) {
				sel.s--;
				if ( !(/^\w/.test(sel.t.substring(sel.s, sel.e)) ) ) {
					sel.s++;
					break;
				}
			}
			
			if (typeof(sel.t) != 'undefined' && sel.t != null) {
				word = sel.t.substring(sel.s, sel.e);
			}
			
			sel.w = word;
			if (range.startOffset) {
				range.setStart(range.endContainer, range.startOffset - (sel.e - sel.s));
			}

			return sel;
		}
		return word;

	}
	
	function createNewAssistant(desc, val) {
//				console.log("CREATE: "+val+" - "+desc);
	}
	function getAssistText() {
		var str = "[{\"id\":390,\"name\":\"Principale\",\"text\":\"Principale\",\"type\":2,\"flag\":1,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"},"+
				"{\"id\":3,\"name\":\"Travail\",\"text\":\"Travail\",\"type\":2,\"flag\":1,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"},"+
				"{\"id\":4,\"name\":\"Travail1\",\"text\":\"Travail1\",\"type\":2,\"flag\":1,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"},"+
				"{\"id\":5,\"name\":\"Travail2\",\"text\":\"Travail2\",\"type\":2,\"flag\":2,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"},"+
				"{\"id\":6,\"name\":\"Travail3\",\"text\":\"Travail3\",\"type\":2,\"flag\":2,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"},"+
				"{\"id\":7,\"name\":\"Travail4\",\"text\":\"Travail4\",\"type\":2,\"flag\":3,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"},"+
				"{\"id\":8,\"name\":\"Travail5\",\"text\":\"Travail5\",\"type\":2,\"flag\":3,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"},"+
				"{\"id\":9,\"name\":\"Travail6\",\"text\":\"Travail6\",\"type\":2,\"flag\":4,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"},"+
				"{\"id\":10,\"name\":\"Travail7\",\"text\":\"Travail7\",\"type\":2,\"flag\":4,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"},"+
				"{\"id\":11,\"name\":\"Travail8\",\"text\":\"Travail8\",\"type\":2,\"flag\":4,\"user\":{\"id\":4,\"idUser\":37,\"application\":\"ofys\",\"idClient\":3},\"isHtml\":false,\"isClientPrivate\":true,\"type2\":\"ADDRESS_NOTE\"}"+
				"]";
//				console.log(str);
		return str;
	}
			
		
		
		
		
		






/****************************
 *	BASE ASSISTANT BUILDER	*
 ****************************/

var listAssist = new Array();

var currentAssist = null;


function AssistDynaText(editor, helper) {
	this.editor = editor;
	this.baseElement = editor.contentDocument.body;
	this.assistElement = helper;
	this.search = null;
	this.assistCss = {
		listWidth: 300,
		descWidth: 500,
		borderColor: "rgb(201,156,71)",
		//backgroundColor: "rgb(245,228,154)",
		backgroundColor: "rgb(242,232,187)",
		helpText: "'ESC' pour fermer, \u2191 et \u2193 pour d\u00E9placer, 'ENTRER' pour s\u00E9lectionner."
	};
	this.isOver = false;
	this.isOpen = false;
	/*
		Must be defined on the fly :
		var elem : element that we want the description
		return : $ element that can be append to an other element
	*/
	this.getText = function(elem){};
	this.getKey = function(elem){};
	this.getKeyClass = function(elem){ return null;};
	this.getDescription = function(elem){};
	this.selection = function(elem){};
	this.calculatePosition = function(){ return null; };
	this.getEditorText = function(){ return null; }
	
	/*
		Must be synchronus call
	*/
	this.ajaxCall = function(value){};
	
	this.open = function() {
		if (this.assistElement == null) return;
		this.isOpen = true;
		if (this.buildInner()) {
			this.assistElement.children(".assist-main-div").fadeIn(300);
		}
		var pos = this.calculatePosition();
		if (pos != null) {
			this.assistElement.children(".assist-main-div").css("top",pos+"px");
		}
		var vertical = {
			wh : $(window).height(),
			ws : $(window).scrollTop(),
			ah : this.assistElement.children(".assist-main-div").height(),
			as : this.assistElement.children(".assist-main-div").offset().top
		};
		var scrollTo = Math.max(0,vertical.as + vertical.ah - vertical.wh);
		if (scrollTo > vertical.ws) {
			$(window).scrollTop(scrollTo);
		}
		var ul = this.assistElement.children(".assist-main-div").children(".assist-list-div").children(".assist-list-ul");
		if (ul.height() > 300) {
			ul.css("overflow","scroll");
			ul.css("height",300+"px");
		} else {
			ul.css("overflow","");
			ul.css("height","");
		}
	};
	

	
	this.close = function(dontReset) {
		//Make reset as default
		var reset = !(dontReset || false);
		if (this.assistElement == null) return;
		this.assistElement.children(".assist-main-div").fadeOut(100);
		if (reset) {
			this.resetSearch();
		}
		this.isOpen = false;
	};
	
	this.buildBase = function() {
		//Check if usable


		
		if (this.assistElement.size() != 1) {
			this.assistElement = null;
			return;
		}
		
		//On va construire les prémisse asteur
		var assistMainDiv = $("<div></div>");
		var helpDiv = $("<div></div>");
		var spanW = $("<span></span>");
		var assistListDiv = $("<div></div>");
		var assistListUL = $("<ul></ul>");
		var assistDescDiv = $("<div></div>");
//		var clearDiv = $("<div></div>");
		
		//On va rendre l'assistElement comme positionneur
		this.assistElement.children().remove();
		this.assistElement.css("position","relative");
		this.assistElement.css("top","0px");
		this.assistElement.css("left","0px");
		this.assistElement.css("z-index","40");
		
		//On va ajuster les div
		helpDiv.addClass("assist-help-div");
		helpDiv.css("width",(this.assistCss.listWidth+this.assistCss.descWidth+4)+"px");
		helpDiv.css("border-color",this.assistCss.borderColor);
		helpDiv.css("background-color",this.assistCss.backgroundColor);
		helpDiv.text(this.assistCss.helpText);
		helpDiv.css(CSS.find("assist-list-div, .assist-desc-div, .assist-help-div "));
		
		spanW.addClass("search-word");
		
		assistMainDiv.addClass("assist-main-div");
		assistMainDiv.css("width",(this.assistCss.listWidth+this.assistCss.descWidth+8+6)+"px");
		assistMainDiv.css(CSS.find("assist-main-div"));

		assistListDiv.addClass("assist-list-div");
		assistListDiv.css("width",(this.assistCss.listWidth-2)+"px");
		assistListDiv.css("border-color",this.assistCss.borderColor);
		assistListDiv.css("background-color",this.assistCss.backgroundColor);
		assistListDiv.css(CSS.find("assist-list-div, .assist-desc-div, .assist-help-div "));

		assistDescDiv.addClass("assist-desc-div");
		assistDescDiv.css("width",(this.assistCss.descWidth-2)+"px");
		assistDescDiv.css("border-color",this.assistCss.borderColor);
		assistDescDiv.css("background-color",this.assistCss.backgroundColor);
		assistDescDiv.css(CSS.find("assist-list-div, .assist-desc-div, .assist-help-div "));
		
		assistListUL.addClass("assist-list-ul");

		//Bind event
		var that = this;
		$(this.baseElement).keydown(function(e) {
			if (that.isOpen) {
				if (	e.which == 40 
					||	e.which == 39 
					||	e.which == 38 
					||	e.which == 37 
					||	e.which == 13
				){
					e.preventDefault();
				}
			}
			if (isCtrl) {
				if (e.which == 32) {
					e.preventDefault();
				}
			}
		});
		$(document).keypress(function(e) {
			if (that.isOpen) {
				if (	e.which == 40 
					||	e.which == 39 
					||	e.which == 38 
					||	e.which == 37 
					||	e.which == 27
					||	e.which == 13
				){
					e.preventDefault();
				}
			}
			if (isCtrl) {
				if (e.which == 32) {
					e.preventDefault();
				}
			}
		});
		$(this.baseElement).keyup(function(e) {
			if (e.which == 32 && isCtrl && !that.isOpen) {
				e.preventDefault();
				e.stopPropagation();
				closeAllAssist();
				that.open();
			} else if (e.which == 40 && that.isOpen) {
				e.preventDefault();
				e.stopPropagation();
				that.selectNext();
			} else if (e.which == 38 && that.isOpen) {
				e.preventDefault();
				e.stopPropagation();
				that.selectPrev();
			} else if (e.which == 13 && that.isOpen) {
				e.preventDefault();
				e.stopPropagation();
				that.select();
			} else if (e.which == 27 && that.isOpen) {
				e.preventDefault();
				e.stopPropagation();
				closeAllAssist();
			} else if ( typeof that.baseElement.value !== 'undefined' && that.baseElement.value.length >= 3 && !that.isOpen && !isHelperKey(e.which)) {
/*				if (that.search.originalText == null) {
					closeAllAssist();
				}
				console.log("OPEN B");
				that.open();*/
			} else if ( typeof that.baseElement.value !== 'undefined' && that.baseElement.value.length >= 3 && that.isOpen && !isHelperKey(e.which)) {
				e.preventDefault();
				e.stopPropagation();
	//			that.buildInner();
			} else if ( typeof that.baseElement.value !== 'undefined' && that.baseElement.value.length < 3 && that.isOpen) {
				e.preventDefault();
				e.stopPropagation();
				that.open();
			}
			
		});
		$(this.baseElement).blur(function() {
			if (!that.isOver) {
				that.close();
			}
		});
		
		$(this.assistElement).mouseover(function() {
			that.isOver = true;
		}).mouseout(function() {
			that.isOver = false;
		});
		
		//finir d'initaliser
		this.resetSearch();
		
		//On va les assembler
		helpDiv.append(spanW);
		assistListDiv.append(assistListUL);
		assistMainDiv.append(helpDiv).append(assistListDiv).append(assistDescDiv);
		this.assistElement.append(assistMainDiv);
		
		//S'enregistrer
		listAssist.push(this);
		
	};
	
	this.buildInner = function() {
		//On va aller chercher la valeur a rechercher
		var val = this.getEditorText();
		//this.baseElement.value;
		//On va aller voir si on doit faire un ajaxCall
		//console.log(this.search.originalText+"/"+val.indexOf(this.search.originalText)
//		console.log("val="+val+", orig="+this.search.originalText);
		if (this.search.originalText == null) {//  && val.length >= 3) {
			this.resetSearch();
			this.search.originalText = val;
			this.ajaxCall(val);
		} else if (this.search.originalText != null && this.search.originalText != val) {// && val.length >= 3) {
			this.resetSearch();
			this.search.originalText = val;
			this.ajaxCall(val);
		} else {
/*			this.close();
			return false;*/
		}
		
		if (this.search.elems == null || this.search.elems.length < 1) {
			this.close();
			return false;
		}
		
		//Gonna creates elements : first : remove all old
		var ul = this.assistElement.children(".assist-main-div").children(".assist-list-div").children(".assist-list-ul");
		ul.children().remove();
		var count = 0;
		
		//NORMAL LIST
		for (var i = 0; i < this.search.elems.length; i++) {
			var key = this.getKey(this.search.elems[i]);
			//On construit!
			var li = $("<li></li>");
			if (typeof key == "string") {
				li.text(key);
			} else {
				li.append(key);
			}
			li.attr("ref",i);
			li.addClass("assist-item-"+i);
			li.addClass("assist-item");
			var c = this.getKeyClass(this.search.elems[i]);
			if (c != null) {
				li.addClass(c);
			}
			//bind event
			var that = this;
			li.mouseover(function() {
				var ind = $(this).attr("ref");
				if (typeof ind != 'undefined' && ind != null) {
					that.assistElement.find(".item-selected").removeClass("item-selected");
					that.selectThisOne(ind);
				}
			});
			li.click(function() {
				that.select();
			});
				
			ul.append(li);
			count++;
		}
		
		if (count == 0) {
			this.close(true);
			return false;
		} else if (ul.height() > 300) {
			ul.css("overflow","scroll");
			ul.css("height",300+"px");
		} else {
			ul.css("overflow","");
			ul.css("height","");
		} 
	
		this.selectNext();
		return true;
	}
	
	this.select = function(arg) {
		var i = this.assistElement.find(".item-selected").attr("ref");
		var elem = null;
		if (typeof i != 'undefined' && i != null) {
			var e = this.search.elems[i];
			if (typeof e != 'undefined' && e != null) {
				elem = e;
			}
		}
		
		this.close();
		if (elem != null) {
			this.selection(elem, arg);
		}
	}
	
	this.selectThisOne = function(index) {
		var s = this.assistElement.find(".assist-item-"+index);
		s.addClass("item-selected");
		var e = this.search.elems[index];
		var desc = null;
		if (typeof e != 'undefined' && e != null) {
			desc = this.getDescription(e);
		}
		this.assistElement.find(".assist-desc-div").children().remove();
		if (typeof desc != 'undefined' && desc != null) {
			this.assistElement.find(".assist-desc-div").append(desc).show();
		} else {
			this.assistElement.find(".assist-desc-div").text("").hide();
		}
	};
	
	this.selectNext = function() {
		var s = this.assistElement.find(".item-selected").removeClass("item-selected");
		var i = 0;
		if (s.size() > 0) {
			var next = s.next("li");
			if (next.size() > 0) {
				var index = next.attr("ref");
				if (typeof index != 'undefined' && index != null) {
					i = index;
				}
			} else {
				var index = this.assistElement.find(".assist-item").first().attr("ref");
				if (typeof index != 'undefined' && index != null) {
					i = index;
				}
			}
		} else {
			var index = this.assistElement.find(".assist-item").first().attr("ref");
			if (typeof index != 'undefined' && index != null) {
				i = index;
			}
		}

		this.selectThisOne(i);
	};
	this.selectPrev = function() {
		var s = this.assistElement.find(".item-selected").removeClass("item-selected");
		var i = 0;
		if (s.size() > 0) {
			var prev = s.prev("li");
			if (prev.size() > 0) {
				var index = prev.attr("ref");
				if (typeof index != 'undefined' && index != null) {
					i = index;
				}
			} else {
				var index = this.assistElement.find(".assist-item").last().attr("ref");
				if (typeof index != 'undefined' && index != null) {
					i = index;
				}
			}
		}

		this.selectThisOne(i);
	};
	
	this.resetSearch = function() {
		this.search = {originalText: null, elems: new Array()};
	}
	
	this.buildBase();
	
}

function closeAllAssist(e) {
	var oneOpen = false;
	for(var i = 0; i < listAssist.length; i++) {
		oneOpen = oneOpen || listAssist[i].isOpen;
		listAssist[i].close();
	}
	
	if (typeof(e) != 'undefined' && e != null && oneOpen) {
		e.preventDefault();
		e.stopPropagation();
	}
}


function isHelperKey(value) {
	if
		(value == 17
		|| value == 27
		|| value == 16
		|| value == 20
		|| value == 18
		|| value == 9
		|| value == 144
		|| value == 45
		|| value == 145
		|| value == 44
		|| value == 46
		|| value == 35
		|| value == 36
		|| value == 33
		|| value == 34
		|| (value >= 112 && value <= 123)) {
		return true;
	}
	return false;
}

function getJavaAssist(val) {
	return [
		{key:val+"a"+Math.floor((Math.random()*10)+1), desc: "a-desc"},
		{key:val+"b"+Math.floor((Math.random()*10)+1), desc: "b-desc"},
		{key:val+"c"+Math.floor((Math.random()*10)+1), desc: "c-desc"},
		{key:val+"aa"+Math.floor((Math.random()*10)+1), desc: "aa-desc"},
		{key:val+"bb"+Math.floor((Math.random()*10)+1), desc: "bb-desc"},
		{key:val+"cc"+Math.floor((Math.random()*10)+1), desc: "cc-desc"}
	];
}

/*********
 *	CSS	 *
 *********/

 
 
 var CSS = [
	{	id: "assist-main-div",
		data: {
		"display": "none",
		"position": "absolute",
		"top": "0px",
		"left": "0px",
		"font-size": "14pt",
	}},
	{	id: "assist-list-ul  .flag-1 ",
		data: {
		"background-color": "rgb(255,218,144)",
	}},
	{	id: "assist-list-ul  .flag-0 ",
		data: {
		"text-align": "center",
		"font-style": "italic",
		"font-size": "0.9em",
	}},
	{	id: "assist-list-ul  .flag-2 ",
		data: {
		"background-color": "rgb(240,248,150)",
	}},
	{	id: "assist-list-ul  .flag-3 ",
		data: {
		"background-color": "rgb(245,228,204)",
	}},
	{	id: "assist-list-ul  .flag-4 ",
		data: {
		"background-color": "rgb(245,248,194)",
	}},
	{	id: "assist-list-div, .assist-desc-div, .assist-help-div ",
		data: {
		"float": "left",
		"border-width": "1px",
		"border-style": "solid",
		"margin": "2px",
	}},
	{	id: "assist-help-div ",
		data: {
		"font-size": "10pt",
		"padding-left": "4px",
		"color": "rgb(184,78,33)",
	}},
	{	id: "assist-item.item-selected ",
		data: {
		"background-color": "#DDDDDD",
	}},
	{ 	id: "li.assist-item",
		data: {
		"cursor": "pointer",
		"padding": "1px 3px",
		"font-size": "14pt",
	}},
	{	id: "assist-desc-div ",
		data: {
		"padding": "5px 3px",
		"font-size": "14pt",
	}},
	{	id: "assist-list-ul  ",
		data: {
		"list-style-type": "none",
		"padding": "0px",
		"margin": "0px",
	}},
	{	id: "msg-formulaire ",
		data: {
		"color": "rgb(224,120,45)", 
		"font-size": "8pt",
	}},
	{	id: "pres-name ",
		data: {
		"font-weight": "bold",
	}},

	/*Specific to eform assistant*/

	{	id: "desc-special-header ",
		data: {
		"margin": "3px",
		
	}},
	{	id: "desc-special-text ",
		data: {
		"color": "rgb(122,122,122)",
		"margin": "3px 3px 7px 7px",
		"font-family": "Courier New",
		"font-size": "0.8em",
	}},
	{	id: "desc-special-footer ",
		data: {
		"margin": "3px",
		"font-size": "0.7em",
		"color": "rgb(184,78,33)",
	}},

	{	id: "popup-table ",
		data: {
		"position": "fixed",
		"top": "0px",
		"left": "0px",
		"height": "100%",
		"width": "100%",
		"background-color": "grey",
	}},

	{	id: "popup-table .row-1, .popup-table .row-3",
		data: {
		"height": "50%",
	}},
	{	id: "popup-table .col-1, .popup-table .col-3",
		data: {
		"width": "50%",
	}},
	{	id: "popup-table .row-2 .col-2 ",
		data: {
	}},

	{	id: "popup-table .popup-div",
		data: {
		"border-radius": "15px",
		"border": "3px ridge red",
		"background-color": "rgb(242,236, 208)",
		/*rgb(255,245,245);*/
		"width": "400px",
		"padding": "5px 10px",
	}},
	{	id: "popup-table .popup-div .header",
		data: {
		"width": "392px",
		"border": "1px solid grey",
		"border-radius": "5px",
		"padding": "3px",
		"background-color": "rgb(179,192,228)",
		"text-align": "center",
	}},
	{	id: "popup-table .popup-div .content",
		data: {
		"width": "100%",
	}},
	{	id: "popup-table .popup-div .input",
		data: {
		"width": "396px",
		"margin-bottom": "5px",
	}},
	{	id: "popup-table .popup-div .input.starter",
		data: {
		"color": "grey",
	}},
	{	id: "popup-table .popup-div .error",
		data: {
		"width": "100%",
		"text-align": "center",
		"font-size": "0.9em",
		"font-weight": "bold",
		"color": "rgb(50,0,0)",
		"margin-top": "4px",
		"margin-bottom": "5px",
		"height": "20px",
		"overflow": "hidden",
	}},
	{	id: "popup-table .popup-div .error > div",
		data: {
	}},
	{	id: "popup-table .popup-div .popup-bu",
		data: {
		"border": "1px solid grey",
		"border-radius": "5px",
		"padding": "3px",
		"cursor": "pointer",
	}},
	{	id: "popup-table .text ",
		data: {
		"color": "rgb(122,122,122)",
		"margin": "3px 3px 7px 7px",
		"font-family": "Courier New",
		"font-size": "0.8em",
	}},
	{	id: "popup-table .popup-div .popup-bu-oki",
		data: {
		"background-color": "rgb(37,168,250)",
		"float": "right",
	}},
	{	id: "popup-table .popup-div .popup-bu-oki:hover",
		data: {
		"background-color": "rgb(15,95, 186)",
	}},
	{	id: "popup-table .popup-div .popup-bu-can",
		data: {
		"background-color": "rgb(190,30,30)",
		"float": "left",
	}},
	{	id: "popup-table .popup-div .popup-bu-can:hover",
		data: {
		"background-color": "rgb(110,0,0)",
	}},

	{	id: "popup-table .popup-div .clear",
		data: {
		"clear": "both",
	}}

 ];
 CSS.find = function(name) {
	for(var i = 0; i < CSS.length; i++) {
		if (CSS[i].id == name) {
			return CSS[i].data;
		}
	}
	return {};
 }
})(Assistant)


