/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.util.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;

public final class SortedListGroupingIterator<R, E>
implements Iterator<Group<R, E>> {
    private final Function<E, R> groupKeyFunction;
    private ListIterator<E> listIterator;
    private final Group<R, E> group;
    private boolean groupKeyIsUndefined;

    public SortedListGroupingIterator(List<E> list, Function<E, R> groupKeyFunction) {
        this(list.listIterator(), groupKeyFunction);
    }

    public SortedListGroupingIterator(ListIterator<E> listIterator, Function<E, R> groupKeyFunction) {
        if (groupKeyFunction == null) {
            throw new NullPointerException("groupKeyFunction");
        }
        this.groupKeyFunction = groupKeyFunction;
        this.group = new Group();
        this.group.items = new ArrayList();
        this.set(listIterator);
    }

    public SortedListGroupingIterator(Function<E, R> groupKeyFunction) {
        if (groupKeyFunction == null) {
            throw new NullPointerException("groupKeyFunction");
        }
        this.groupKeyFunction = groupKeyFunction;
        this.group = new Group();
        this.group.items = new ArrayList();
    }

    public void set(ListIterator<E> listIterator) {
        if (listIterator == null) {
            throw new NullPointerException("listIterator");
        }
        this.listIterator = listIterator;
        this.groupKeyIsUndefined = true;
        this.group.key = null;
        this.group.items.clear();
    }

    public void set(List<E> list) {
        this.set(list.listIterator());
    }

    @Override
    public boolean hasNext() {
        if (this.listIterator == null) {
            throw new IllegalStateException("no listIterator has been set");
        }
        return this.listIterator.hasNext();
    }

    @Override
    public Group<R, E> next() {
        if (this.listIterator == null) {
            throw new IllegalStateException("no listIterator has been set");
        }
        this.group.items.clear();
        while (this.listIterator.hasNext()) {
            E e = this.listIterator.next();
            R key = this.groupKeyFunction.apply(e);
            if (this.groupKeyIsUndefined) {
                this.group.key = key;
                this.group.items.add(e);
                this.groupKeyIsUndefined = false;
                continue;
            }
            if (this.areObjectsEquals(this.group.key, key)) {
                this.group.items.add(e);
                continue;
            }
            this.listIterator.previous();
            this.groupKeyIsUndefined = true;
            break;
        }
        return this.group;
    }

    private boolean areObjectsEquals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static class Group<B, A> {
        protected List<A> items;
        protected B key;

        public List<A> getItems() {
            return this.items;
        }

        public B getKey() {
            return this.key;
        }
    }
}

