/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.signatures;

import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformData;
import ca.infodata.ofys.data.middle.dataobjects.signatures.CUserSignature;
import ca.infodata.ofys.data.middle.dataobjects.signatures.CUserSignatureType;
import ca.infodata.ofys.data.middle.dataobjects.signatures.CUserSignatures;
import ca.infodata.util1.StringUtils;
import java.util.Properties;

public class CUserSignaturesForEformData {
    public static final String SIGNATURE_ENABLED = "signature_enabled";
    public static final String SIGNATURE1_ID = "signature1_id";
    public static final String SIGNATURE1_LABEL = "signature1_label";
    public static final String SIGNATURE1_IMAGE = "signature1_image";
    public static final String SIGNATUREMD_ID = "signatureMd_id";
    public static final String SIGNATUREMD_LABEL = "signatureMd_label";
    public static final String SIGNATUREMD_IMAGE = "signatureMd_image";

    private CUserSignaturesForEformData() {
    }

    public static void signEformData(XBaseProfessionnal sessionProfessionnal, CUserSignatures signatures, XEformData data, Properties properties) {
        if (CUserSignaturesForEformData.signatureEnabled(properties)) {
            if (sessionProfessionnal == null) {
                CUserSignaturesForEformData.removeAllSignatures(properties);
            } else {
                if (data.getIdAnchor() == null) {
                    CUserSignaturesForEformData.removeAllSignatures(properties);
                }
                CUserSignatureType type = CUserSignaturesForEformData.getProfessionnalType(sessionProfessionnal);
                switch (type) {
                    case MD: {
                        CUserSignaturesForEformData.applyMDSignature(signatures, properties);
                        break;
                    }
                    default: {
                        CUserSignaturesForEformData.applySignature(signatures, properties);
                    }
                }
            }
        }
    }

    public static boolean signatureEnabled(Properties properties) {
        return properties.containsKey(SIGNATURE_ENABLED);
    }

    private static void applySignature(CUserSignatures signatures, Properties properties) {
        CUserSignaturesForEformData.removeSignatureMD(properties);
        CUserSignaturesForEformData.removeSignature1(properties);
        if (signatures != null) {
            if (signatures.full != null) {
                CUserSignaturesForEformData.applySignature1(signatures.full, properties);
            } else if (signatures.initial != null) {
                CUserSignaturesForEformData.applySignature1(signatures.initial, properties);
            }
        }
    }

    private static void applySignature1(CUserSignature signature, Properties properties) {
        properties.setProperty(SIGNATURE1_ID, String.valueOf(signature.id));
        properties.setProperty(SIGNATURE1_LABEL, signature.label);
    }

    public static void removeSignature1(Properties properties) {
        properties.remove(SIGNATURE1_ID);
        properties.remove(SIGNATURE1_LABEL);
        properties.remove(SIGNATURE1_IMAGE);
    }

    private static void applyMDSignature(CUserSignatures signatures, Properties properties) {
        CUserSignaturesForEformData.removeSignatureMD(properties);
        if (signatures != null && (signatures.full != null || signatures.initial != null)) {
            if (CUserSignaturesForEformData.hasSignature1(properties) && signatures.initial != null) {
                CUserSignaturesForEformData.applySignatureMD(signatures.initial, properties);
            } else if (signatures.full != null) {
                CUserSignaturesForEformData.applySignatureMD(signatures.full, properties);
            } else if (signatures.initial != null) {
                CUserSignaturesForEformData.applySignatureMD(signatures.initial, properties);
            }
        }
    }

    private static void applySignatureMD(CUserSignature signature, Properties properties) {
        properties.setProperty(SIGNATUREMD_ID, String.valueOf(signature.id));
        properties.setProperty(SIGNATUREMD_LABEL, signature.label);
    }

    private static boolean hasSignature1(Properties properties) {
        return StringUtils.isNotBlank((String)properties.getProperty(SIGNATURE1_ID));
    }

    public static Integer getIdSignature1(Properties properties) {
        String value = properties.getProperty(SIGNATURE1_ID);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public static Integer getIdSignatureMD(Properties properties) {
        String value = properties.getProperty(SIGNATUREMD_ID);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public static void removeSignatureMD(Properties properties) {
        properties.remove(SIGNATUREMD_ID);
        properties.remove(SIGNATUREMD_LABEL);
        properties.remove(SIGNATUREMD_IMAGE);
    }

    private static CUserSignatureType getProfessionnalType(XBaseProfessionnal prof) {
        if (prof.getProfessionalType() != null) {
            switch (prof.getProfessionalType()) {
                case INFIRMIERE: 
                case INFIRMIERE_PRATICIENNE: {
                    return CUserSignatureType.INF;
                }
                case RESIDENT: 
                case STAGIAIRE_CMQ: {
                    return CUserSignatureType.RES;
                }
                case EXTERNE: {
                    return CUserSignatureType.EXT;
                }
            }
            if (prof.isStagiaire()) {
                return CUserSignatureType.RES;
            }
            return CUserSignatureType.MD;
        }
        if (prof.isStagiaire()) {
            return CUserSignatureType.RES;
        }
        return CUserSignatureType.MD;
    }

    private static void removeAllSignatures(Properties properties) {
        CUserSignaturesForEformData.removeSignature1(properties);
        CUserSignaturesForEformData.removeSignatureMD(properties);
    }
}

