/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.scan;

import ca.infodata.dsq.domain.imaging.ImagingResultExam;
import ca.infodata.dsq.domain.labo.getreport.pdf.LaboReportHeaderFlat;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.eform.XAttenteResultats;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterLabel;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelDef;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.scan.XBasePatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageResultType;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class XPatientImage
extends EditableDataObject {
    private static final long serialVersionUID = 1L;
    public Integer id;
    public IPatient patient;
    public Integer idPatient;
    public String name;
    public byte[] picture;
    public byte[] pictureToPrint;
    public List<XLabelDef> labels;
    public XPatientImageResultType result;
    public Long datetimeScanned;
    public LocalDate documentDate;
    public String notesHistory;
    public Integer idUserAnchor;
    public String userName;
    public LaboReportHeaderFlat valDsq;
    public ImagingResultExam dsqImagingResultExam;
    public Boolean scannedAsResultToOrderId;
    public Integer orderId;
    public Boolean orderWasRejected;
    public Boolean scannedAsSendOrder;
    public Integer sentOrderTargetProfessionnalId;
    public Integer speciality;
    public Boolean scannedAsReceivedOrder;
    public Integer receivedOrderFromProfessionnalId;
    public boolean doCreateTaskOnSave;
    private IEditableDataObjectList<XPatientImageProfessionnal> professionnals = new EditableDataObjectList<XPatientImageProfessionnal>();
    private XBaseProfessionnal encounterProfessionnal = null;
    public List<XAppointment> futurApts = new ArrayList<XAppointment>();
    public List<XAttenteResultats> attentes = new ArrayList<XAttenteResultats>();
    public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);

    public EnumSet<XEncounterLabel> getEncLabel() {
        return this.encLabel;
    }

    public void setEncLabel(EnumSet<XEncounterLabel> status) {
        this.encLabel = status;
        this.setUpdated();
    }

    public void removeXEncounterLabel(XEncounterLabel x) {
        this.encLabel.remove(x);
        this.setUpdated();
    }

    public void addXEncounterLabel(XEncounterLabel x) {
        this.encLabel.add(x);
        this.setUpdated();
    }

    public XPatientImage() {
    }

    public XPatientImage(Integer id, String picture_name, Integer result, Integer id_patient_anchor, Long date_scanned, Long document_date, Integer idUserAnchor, String userName, String vDsq, String dsqImagingResultExam) {
        Gson gson;
        this.id = id;
        this.name = picture_name;
        this.result = XPatientImageResultType.from(result);
        this.idPatient = id_patient_anchor;
        this.datetimeScanned = date_scanned;
        this.documentDate = LocalDate.fromTimeInMillisUTC((Long)document_date);
        this.idUserAnchor = idUserAnchor;
        this.userName = userName;
        if (StringUtils.isNotEmpty((CharSequence)vDsq)) {
            gson = new Gson();
            this.valDsq = (LaboReportHeaderFlat)gson.fromJson(vDsq, LaboReportHeaderFlat.class);
        }
        if (StringUtils.isNotEmpty((CharSequence)dsqImagingResultExam)) {
            gson = new Gson();
            this.dsqImagingResultExam = (ImagingResultExam)gson.fromJson(vDsq, ImagingResultExam.class);
        }
    }

    @Override
    public void initialize() {
        this.setNew();
        this.picture = new byte[0];
        this.labels = new ArrayList<XLabelDef>();
        this.result = XPatientImageResultType.SO;
        this.name = new String();
        this.datetimeScanned = DateUtil.newCalendar().getTimeInMillis();
        this.documentDate = LocalDate.today();
        this.professionnals = new EditableDataObjectList<XPatientImageProfessionnal>();
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.professionnals != null && this.professionnals.isDirty();
    }

    public void setDatetimeScanned(Long date) {
        this.datetimeScanned = date;
        this.setUpdated();
    }

    public void setDocumentDate(LocalDate date) {
        this.documentDate = date;
        this.setUpdated();
    }

    public void setImageAsSeen() {
        this.setUpdated();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.setUpdated();
    }

    public byte[] getPicture() {
        return this.picture;
    }

    public void setPicture(byte[] picture) {
        this.picture = picture;
        this.setUpdated();
    }

    public XPatientImageResultType getResult() {
        return this.result;
    }

    public void setResult(XPatientImageResultType result) {
        this.result = result;
        this.setUpdated();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.setUpdated();
    }

    public LaboReportHeaderFlat getValDsq() {
        return this.valDsq;
    }

    public void setValDsq(LaboReportHeaderFlat valDsq) {
        this.valDsq = valDsq;
        this.setUpdated();
    }

    public Long getDateScanned() {
        return this.datetimeScanned;
    }

    public LocalDate getDocumentDate() {
        return this.documentDate;
    }

    public IPatient getPatient() {
        return this.patient;
    }

    public void setPatient(IPatient patient) {
        this.patient = patient;
        this.idPatient = patient == null ? null : patient.getId();
        this.setUpdated();
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XPatientImage) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XPatientImage" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    @Override
    public String toString() {
        return this.isNewOrNewUpdated() ? Messages.getString("NOUVELLE_IMAGE", new String[0]) : LocalDateFormat.nullSafeFormat((LocalDate)this.getDocumentDate(), (String)FormatDateProvider.getFormatDate().toString()) + " " + (this.getPatient() == null ? "" : this.getPatient().toString()) + " " + (this.getName() == null ? "" : this.getName());
    }

    @Override
    public XPatientImage clone() {
        XPatientImage c = (XPatientImage)super.clone();
        c.id = this.id;
        if (this.picture == null) {
            c.picture = null;
        } else {
            c.picture = new byte[this.picture.length];
            System.arraycopy(this.picture, 0, c.picture, 0, this.picture.length);
        }
        if (this.pictureToPrint == null) {
            c.pictureToPrint = null;
        } else {
            c.pictureToPrint = new byte[this.pictureToPrint.length];
            System.arraycopy(this.pictureToPrint, 0, c.pictureToPrint, 0, this.pictureToPrint.length);
        }
        c.labels = MiscUtil.deepClone(this.labels);
        c.result = this.result;
        c.name = this.name;
        c.datetimeScanned = this.datetimeScanned;
        c.documentDate = this.documentDate;
        c.professionnals = this.professionnals.deepClone();
        c.valDsq = this.valDsq;
        c.dsqImagingResultExam = this.dsqImagingResultExam;
        if (this.patient != null) {
            c.patient = this.patient.clone();
        }
        c.encLabel = this.encLabel.clone();
        return c;
    }

    public IEditableDataObjectList<XPatientImageProfessionnal> getProfessionnals() {
        return this.professionnals;
    }

    public void setProfessionnals(IEditableDataObjectList<XPatientImageProfessionnal> professionnals) {
        this.professionnals = professionnals;
    }

    public String getNotesHistory() {
        return this.notesHistory;
    }

    public void setNotesHistory(String notesHistory) {
        this.notesHistory = notesHistory;
    }

    public List<XLabelDef> getLabels() {
        return this.labels;
    }

    public void setLabels(List<XLabelDef> labels) {
        this.labels = labels;
    }

    public XBaseProfessionnal getEncounterProfessionnal() {
        return this.encounterProfessionnal;
    }

    public void setEncounterProfessionnal(XBaseProfessionnal encounterProfessionnal) {
        this.encounterProfessionnal = encounterProfessionnal;
    }

    public byte[] getPictureToPrint() {
        return this.pictureToPrint;
    }

    public void setPictureToPrint(byte[] pictureToPrint) {
        this.pictureToPrint = pictureToPrint;
    }

    public ImagingResultExam getDsqImagingResultExam() {
        return this.dsqImagingResultExam;
    }

    public void setDsqImagingResultExam(ImagingResultExam dsqImagingResultExam) {
        this.dsqImagingResultExam = dsqImagingResultExam;
        this.setUpdated();
    }

    public XBasePatientImage toXBase(boolean withPatient) {
        XBasePatientImage x = new XBasePatientImage();
        x.id = this.id;
        x.idPatient = this.idPatient;
        x.labels = MiscUtil.deepClone(this.labels);
        x.result = this.result;
        x.strWithoutPatient = this.name;
        x.documentDate = this.documentDate;
        x.dateScanned = this.getDateScanned();
        x.professionnals = this.professionnals.deepClone();
        x.valDsq = this.valDsq;
        x.dsqImagingResultExam = this.dsqImagingResultExam;
        x.encLabel = this.encLabel.clone();
        String date = x.documentDate.formatHyphen();
        x.strWithoutPatient = date + " : " + this.getName();
        if (withPatient && this.patient != null) {
            x.patient = (XPatient)this.patient.clone();
            String ptnom = " (" + x.patient.getName() + ")";
            x.str = date + " : " + ptnom + " " + this.getName();
        } else {
            x.str = x.strWithoutPatient;
        }
        if (this.attentes != null && this.attentes.size() > 0) {
            x.attentes = new ArrayList<XAttenteResultats>(this.attentes.size());
            x.attentes.addAll(this.attentes);
        }
        return x;
    }
}

