/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.interfaces;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.AbstractGenericCollectionDecorator;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.Interceptor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public final class SetWithInterceptor<E>
extends AbstractGenericCollectionDecorator<E>
implements Set<E> {
    private final Interceptor interceptor;

    public static <T> Set<T> decorate(Set<T> list, Interceptor interceptor) {
        return new SetWithInterceptor<T>(list, interceptor);
    }

    public SetWithInterceptor(Set<E> list, Interceptor interceptor) {
        super(list);
        if (interceptor == null) {
            throw new NullPointerException("interceptor");
        }
        this.interceptor = interceptor;
    }

    @Override
    public boolean add(E e) {
        boolean add = super.add(e);
        if (add) {
            this.modified();
        }
        return add;
    }

    private void modified() {
        this.interceptor.modified();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean addAll = super.addAll(c);
        if (addAll) {
            this.modified();
        }
        return addAll;
    }

    @Override
    public void clear() {
        super.clear();
        this.modified();
    }

    @Override
    public boolean remove(Object o) {
        boolean remove = super.remove(o);
        if (remove) {
            this.modified();
        }
        return remove;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removeAll = super.removeAll(c);
        if (removeAll) {
            this.modified();
        }
        return removeAll;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean retainAll = super.retainAll(c);
        if (retainAll) {
            this.modified();
        }
        return retainAll;
    }

    @Override
    public Iterator<E> iterator() {
        return new InterceptorIterator(super.iterator());
    }

    private class InterceptorIterator<T>
    implements Iterator<T> {
        private final Iterator<T> original;

        private InterceptorIterator(Iterator<T> iterator) {
            this.original = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.original.hasNext();
        }

        @Override
        public T next() {
            return this.original.next();
        }

        @Override
        public void remove() {
            try {
                this.original.remove();
                SetWithInterceptor.this.modified();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

