/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.interfaces;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.AbstractSerializableGenericListDecorator;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.Interceptor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class ListWithInterceptor<E>
extends AbstractSerializableGenericListDecorator<E> {
    private static final long serialVersionUID = 8037113904755669339L;
    private final Interceptor interceptor;

    public static <T> List<T> decorate(List<T> list, Interceptor interceptor) {
        return new ListWithInterceptor<T>(list, interceptor);
    }

    public ListWithInterceptor(List<E> list, Interceptor interceptor) {
        super(list);
        if (interceptor == null) {
            throw new NullPointerException("interceptor");
        }
        this.interceptor = interceptor;
    }

    @Override
    public boolean add(E e) {
        boolean add = super.add(e);
        if (add) {
            this.modified();
        }
        return add;
    }

    private void modified() {
        this.interceptor.modified();
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        this.modified();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean addAll = super.addAll(c);
        if (addAll) {
            this.modified();
        }
        return addAll;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean addAll = super.addAll(index, c);
        if (addAll) {
            this.modified();
        }
        return addAll;
    }

    @Override
    public void clear() {
        super.clear();
        this.modified();
    }

    @Override
    public E remove(int index) {
        Object remove = super.remove(index);
        this.modified();
        return remove;
    }

    @Override
    public boolean remove(Object o) {
        boolean remove = super.remove(o);
        if (remove) {
            this.modified();
        }
        return remove;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removeAll = super.removeAll(c);
        if (removeAll) {
            this.modified();
        }
        return removeAll;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean retainAll = super.retainAll(c);
        if (retainAll) {
            this.modified();
        }
        return retainAll;
    }

    @Override
    public E set(int index, E element) {
        E set = super.set(index, element);
        this.modified();
        return set;
    }

    @Override
    public Iterator<E> iterator() {
        return new InterceptorIterator(super.iterator());
    }

    private class InterceptorIterator<T>
    implements Iterator<T> {
        private final Iterator<T> original;

        private InterceptorIterator(Iterator<T> iterator) {
            this.original = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.original.hasNext();
        }

        @Override
        public T next() {
            return this.original.next();
        }

        @Override
        public void remove() {
            try {
                this.original.remove();
                ListWithInterceptor.this.modified();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

