/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.interfaces;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.util1.StringUtils;
import java.io.Serializable;

public abstract class CEditableDataObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Integer tag;
    public Integer version;
    public String guid;
    public Boolean editMode;
    public String modificationStatus;

    public abstract <T> void convertc(T var1);

    public abstract <T> T convertx();

    public CEditableDataObject() {
        this.modificationStatus = ModificationStatus.STATUS_NEUTRAL.name();
    }

    public CEditableDataObject(EditableDataObject editable) {
        this.init(editable);
    }

    protected void init(IEditableDataObject editable) {
        if (editable != null) {
            this.tag = editable.getTag();
            this.version = editable.getVersion();
            this.modificationStatus = editable.getModificationStatus().toString();
        }
    }

    public void setTag() {
        this.tag = System.identityHashCode(this);
    }

    public void setVersion(Integer v) {
        this.version = v;
    }

    public EditableDataObject x(EditableDataObject x) {
        if (StringUtils.isEmpty((String)this.modificationStatus)) {
            x.modificationStatus.plain_set(ModificationStatus.STATUS_NEUTRAL);
        } else {
            x.modificationStatus.plain_set(ModificationStatus.from(this.modificationStatus));
        }
        x.setVersion(this.version);
        x.setTag(this.tag);
        return x;
    }

    public final boolean isStatusDeleted() {
        return ModificationStatus.STATUS_DELETED.name().equals(this.modificationStatus);
    }

    public boolean isDirty() {
        return !ModificationStatus.STATUS_NEUTRAL.name().equals(this.modificationStatus);
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }
}

