/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart;

import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.Language;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.Sex;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class GrowChartPdfUtil {
    private static final Logger logger = Logger.getLogger(GrowChartPdfUtil.class.getName());

    GrowChartPdfUtil() {
    }

    static byte[] readFile(String fileBaseName, Sex sex, Language language, boolean blackAndWhite) throws Exception {
        int nRead;
        String name = "pdf/" + fileBaseName + "_" + sex.name() + "_" + language.name() + (blackAndWhite ? "_bw" : "") + ".pdf";
        ClassLoader loader = GrowChartPdfUtil.class.getClassLoader();
        InputStream is = null;
        if (loader != null) {
            is = loader.getResourceAsStream(name);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    static void showWithExternalViewer(byte[] pdf) throws IOException {
        File file = GrowChartPdfUtil.writeOnDisk(pdf);
        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + file.getAbsolutePath(), null, null);
    }

    private static File writeOnDisk(byte[] document) {
        String fileName = "report" + System.currentTimeMillis() + ".pdf";
        File file = GrowChartPdfUtil.saveToFileRelativeFromHome(fileName, document);
        return file;
    }

    private static File saveToFileRelativeFromHome(String relativeFilePath, byte[] fileContents) {
        File file;
        if (relativeFilePath == null) {
            throw new NullPointerException("relativeFilePath");
        }
        if (fileContents == null) {
            fileContents = new byte[]{};
        }
        try {
            file = new File("target", relativeFilePath);
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file);
            out.write(fileContents);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "GrowChartPdfUtil.saveToFileRelativeFromHome, relativeFilePath=" + relativeFilePath, e);
            return null;
        }
        return file;
    }
}

