/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.encounter;

import ca.infodata.ofys.data.middle.dataobjects.GenericDataMapping;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CPrescriptionFormatter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XAllergy;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XAllergyType;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDiagnostic;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterLabel;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterModificationRequest;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XImmunization;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XIntervention;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XLifeHabit;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPlan;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPrevent;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XRappel;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.CEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescriptionDrugNameFormat;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocaleProvider;
import ca.infodata.util1.date.TimeZoneProvider;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;

public final class CSummary
extends CEditableDataObject
implements Serializable {
    private static final long serialVersionUID = 189796544L;
    public String className = CSummary.class.getSimpleName();
    @FieldSerializer.NotNull
    private Integer idPatientAnchor;
    private Integer idProfAnchor;
    private Integer idSite;
    private Integer encounterLanguage;
    private String[] familyHistoryObjArr;
    public CEncounter.EncounterNote familyHistoryObj;
    private String[] medicalHistoryObjArr;
    public CEncounter.EncounterNote medicalHistoryObj;
    private String[] socialHistoryObjArr;
    public CEncounter.EncounterNote socialHistoryObj;
    private String[] ongoingConcernsObjArr;
    public CEncounter.EncounterNote ongoingConcernsObj;
    private String[] otherMedicationsObjArr;
    public CEncounter.EncounterNote otherMedicationsObj;
    private String[] allergies;
    private String[] intolerances;
    private String[] interventions;
    private String[] lifeHabits;
    private String[] prevents;
    private String[] rappels;
    private String[] immunizations;
    private String[] bps;
    private String[] bts;
    private String[] fqs;
    private String[] mss;
    private String[] pes;
    private String[] prescriptions;
    private String[] devices;
    private String[] custMeasures;
    private String[] dxs;
    private String[] probs;
    private String[] plans;
    private List<CEncounter.Allergies> lstAllergy;
    private List<CEncounter.Intolerances> lstIntolerance;
    private List<CEncounter.Interventions> lstIntervention;
    private List<CEncounter.LifeHabits> lstLifeHabit;
    private List<CEncounter.Prevents> lstPrevent;
    private List<CEncounter.Rappels> lstRappel;
    private List<CEncounter.Immunizations> lstImmunization;
    private List<CEncounter.Immunizations> lstAllImmunization;
    private List<CEncounter.BloodPres> lstBloodPres;
    private List<CEncounter.BodyTemp> lstBodyTemp;
    private List<CEncounter.Freq> lstFreq;
    private List<CEncounter.Measurement> lstMeasurement;
    private List<CEncounter.PhysicalExam> lstPhysicalExam;
    private List<CEncounter.Prescription> lstPrescription;
    private List<CEncounter.Prescription> lstAllPrescription;
    private List<CEncounter.Device> lstDevice;
    private List<CEncounter.CustMeasure> lstCustMeasure;
    private List<CEncounter.Dx> lstDx;
    private List<CEncounter.Prob> lstProb;
    private List<Plan> lstPlan;
    private List<CAbnLab4Rxv> lstAbnLab4Rxv;
    protected XPrescriptionDrugNameFormat prescriptionDrugNameFormat;

    public CSummary(XEncounterModificationRequest req) {
        super(req.getEncounter());
        this.init(req.getEncounter());
        if (req.getAllergies() != null) {
            for (XAllergy xAllergy : req.getAllergies()) {
                if (XAllergyType.ALLERGY.equals((Object)xAllergy.getDataType())) {
                    this.addToLst(new CEncounter.Allergies(xAllergy));
                    continue;
                }
                this.addToLst(new CEncounter.Intolerances(xAllergy));
            }
        }
        if (req.getRappels() != null) {
            for (XRappel xRappel : req.getRappels()) {
                this.addToLst(new CEncounter.Rappels(xRappel));
            }
        }
        if (req.getImmunizations() != null) {
            for (XImmunization xImmunization : req.getImmunizations()) {
                CEncounter.Immunizations imm = new CEncounter.Immunizations(xImmunization);
                this.addToLstAll(imm);
            }
        }
        if (req.getInterventions() != null) {
            for (XIntervention xIntervention : req.getInterventions()) {
                this.addToLst(new CEncounter.Interventions(xIntervention));
            }
        }
        if (req.getLifeHabits() != null) {
            for (XLifeHabit xLifeHabit : req.getLifeHabits()) {
                this.addToLst(new CEncounter.LifeHabits(xLifeHabit));
            }
        }
        if (req.getPrescriptions() != null) {
            for (XPrescription xPrescription : req.getPrescriptions()) {
                if (xPrescription.getDevice() != null) {
                    this.addToLst(new CEncounter.Device(xPrescription));
                    continue;
                }
                if (xPrescription.getStrength() == null) continue;
                this.addToLstAll(new CEncounter.Prescription(xPrescription));
            }
        }
        if (req.getPrevents() != null) {
            for (XPrevent xPrevent : req.getPrevents()) {
                this.addToLst(new CEncounter.Prevents(xPrevent));
            }
        }
        if (req.getDiagnostics() != null) {
            for (XDiagnostic xDiagnostic : req.getDiagnostics()) {
                if (Boolean.TRUE.equals(xDiagnostic.getIsProblem())) {
                    this.addToLst(new CEncounter.Prob(xDiagnostic));
                    continue;
                }
                this.addToLst(new CEncounter.Dx(xDiagnostic));
            }
        }
        if (req.familyHistoryObj != null) {
            this.familyHistoryObj = new CEncounter.EncounterNote(req.familyHistoryObj);
        }
        if (req.medicalHistoryObj != null) {
            this.medicalHistoryObj = new CEncounter.EncounterNote(req.medicalHistoryObj);
        }
        if (req.ongoingConcernsObj != null) {
            this.ongoingConcernsObj = new CEncounter.EncounterNote(req.ongoingConcernsObj);
        }
        if (req.otherMedicationsObj != null) {
            this.otherMedicationsObj = new CEncounter.EncounterNote(req.otherMedicationsObj);
        }
        if (req.socialHistoryObj != null) {
            this.socialHistoryObj = new CEncounter.EncounterNote(req.socialHistoryObj);
        }
    }

    public CSummary(XEncounter encounter) {
        super(encounter);
        this.init(encounter);
    }

    public CSummary() {
    }

    public void setIdPatientAnchor(Integer integer) {
        this.idPatientAnchor = integer;
    }

    public Integer getIdPatientAnchor() {
        return this.idPatientAnchor;
    }

    public Integer getIdProfAnchor() {
        return this.idProfAnchor;
    }

    public void setIdProfAnchor(Integer idProfAnchor) {
        this.idProfAnchor = idProfAnchor;
    }

    public Integer getIdSite() {
        return this.idSite;
    }

    public void setIdSite(Integer idSite) {
        this.idSite = idSite;
    }

    public Integer getEncounterLanguage() {
        return this.encounterLanguage;
    }

    public void setEncounterLanguage(Integer encounterLanguage) {
        this.encounterLanguage = encounterLanguage;
    }

    public String[] getSocialHistoryObjArr() {
        return this.socialHistoryObjArr;
    }

    public void setSocialHistoryObjArr(String[] socialHistoryObjArr) {
        this.socialHistoryObjArr = socialHistoryObjArr;
    }

    public String[] getFamilyHistoryObjArr() {
        return this.familyHistoryObjArr;
    }

    public void setFamilyHistoryObjArr(String[] familyHistoryObjArr) {
        this.familyHistoryObjArr = familyHistoryObjArr;
    }

    public String[] getMedicalHistoryObjArr() {
        return this.medicalHistoryObjArr;
    }

    public void setMedicalHistoryObjArr(String[] medicalHistoryObjArr) {
        this.medicalHistoryObjArr = medicalHistoryObjArr;
    }

    public String[] getOngoingConcernsObjArr() {
        return this.ongoingConcernsObjArr;
    }

    public void setOngoingConcernsObjArr(String[] ongoingConcernsObjArr) {
        this.ongoingConcernsObjArr = ongoingConcernsObjArr;
    }

    public String[] getOtherMedicationsObjArr() {
        return this.otherMedicationsObjArr;
    }

    public void setOtherMedicationsObjArr(String[] otherMedicationsObjArr) {
        this.otherMedicationsObjArr = otherMedicationsObjArr;
    }

    public String toString() {
        return super.toString();
    }

    public String[] getAllergies() {
        return this.allergies;
    }

    public void setAllergies(String[] allergies) {
        this.allergies = allergies;
    }

    public String[] getIntolerances() {
        return this.intolerances;
    }

    public void setIntolerances(String[] intolerances) {
        this.intolerances = intolerances;
    }

    public String[] getInterventions() {
        return this.interventions;
    }

    public void setInterventions(String[] interventions) {
        this.interventions = interventions;
    }

    public String[] getLifeHabits() {
        return this.lifeHabits;
    }

    public void setLifeHabits(String[] lifeHabits) {
        this.lifeHabits = lifeHabits;
    }

    public String[] getPrevents() {
        return this.prevents;
    }

    public void setPrevents(String[] prevents) {
        this.prevents = prevents;
    }

    public String[] getRappels() {
        return this.rappels;
    }

    public void setRappels(String[] rappels) {
        this.rappels = rappels;
    }

    public String[] getImmunizations() {
        return this.immunizations;
    }

    public void setImmunizations(String[] immunizations) {
        this.immunizations = immunizations;
    }

    public String[] getBps() {
        return this.bps;
    }

    public void setBps(String[] bps) {
        this.bps = bps;
    }

    public String[] getBts() {
        return this.bts;
    }

    public void setBts(String[] bts) {
        this.bts = bts;
    }

    public String[] getFqs() {
        return this.fqs;
    }

    public void setFqs(String[] fqs) {
        this.fqs = fqs;
    }

    public String[] getMss() {
        return this.mss;
    }

    public void setMss(String[] mss) {
        this.mss = mss;
    }

    public String[] getPes() {
        return this.pes;
    }

    public void setPes(String[] pes) {
        this.pes = pes;
    }

    public String[] getPrescriptions() {
        return this.prescriptions;
    }

    public void setPrescriptions(String[] prescriptions) {
        this.prescriptions = prescriptions;
    }

    public String[] getDevices() {
        return this.devices;
    }

    public void setDevices(String[] array) {
        this.devices = array;
    }

    public String[] getCustMeasures() {
        return this.custMeasures;
    }

    public void setCustMeasures(String[] custMeasures) {
        this.custMeasures = custMeasures;
    }

    public String[] getDxs() {
        return this.dxs;
    }

    public void setDxs(String[] dxs) {
        this.dxs = dxs;
    }

    public String[] getProbs() {
        return this.probs;
    }

    public void setProbs(String[] probs) {
        this.probs = probs;
    }

    public List<CEncounter.Allergies> getLstAllergy() {
        return this.lstAllergy;
    }

    public void setLstAllergy(List<CEncounter.Allergies> lstAllergy) {
        this.lstAllergy = lstAllergy;
    }

    public void addToLst(CEncounter.Allergies a) {
        if (this.lstAllergy == null) {
            this.lstAllergy = new ArrayList<CEncounter.Allergies>();
        }
        this.lstAllergy.add(a);
    }

    public List<CEncounter.Intolerances> getLstIntolerance() {
        return this.lstIntolerance;
    }

    public void setLstIntolerance(List<CEncounter.Intolerances> lstIntolerance) {
        this.lstIntolerance = lstIntolerance;
    }

    public void addToLst(CEncounter.Intolerances a) {
        if (this.lstIntolerance == null) {
            this.lstIntolerance = new ArrayList<CEncounter.Intolerances>();
        }
        this.lstIntolerance.add(a);
    }

    public List<CEncounter.Interventions> getLstIntervention() {
        return this.lstIntervention;
    }

    public void setLstIntervention(List<CEncounter.Interventions> lstIntervention) {
        this.lstIntervention = lstIntervention;
    }

    public void addToLst(CEncounter.Interventions a) {
        if (this.lstIntervention == null) {
            this.lstIntervention = new ArrayList<CEncounter.Interventions>();
        }
        this.lstIntervention.add(a);
    }

    public List<CEncounter.LifeHabits> getLstLifeHabit() {
        return this.lstLifeHabit;
    }

    public void setLstLifeHabit(List<CEncounter.LifeHabits> lstLifeHabit) {
        this.lstLifeHabit = lstLifeHabit;
    }

    public void addToLst(CEncounter.LifeHabits a) {
        if (this.lstLifeHabit == null) {
            this.lstLifeHabit = new ArrayList<CEncounter.LifeHabits>();
        }
        this.lstLifeHabit.add(a);
    }

    public List<CEncounter.Prevents> getLstPrevent() {
        return this.lstPrevent;
    }

    public void setLstPrevent(List<CEncounter.Prevents> lstPrevent) {
        this.lstPrevent = lstPrevent;
    }

    public void addToLst(CEncounter.Prevents a) {
        if (this.lstPrevent == null) {
            this.lstPrevent = new ArrayList<CEncounter.Prevents>();
        }
        this.lstPrevent.add(a);
    }

    public List<CEncounter.Rappels> getLstRappel() {
        return this.lstRappel;
    }

    public void setLstRappel(List<CEncounter.Rappels> lstRappel) {
        this.lstRappel = lstRappel;
    }

    public void addToLst(CEncounter.Rappels a) {
        if (this.lstRappel == null) {
            this.lstRappel = new ArrayList<CEncounter.Rappels>();
        }
        this.lstRappel.add(a);
    }

    public List<CEncounter.Immunizations> getLstAllImmunization() {
        return this.lstAllImmunization;
    }

    public void setLstAllImmunization(List<CEncounter.Immunizations> lstImmunization) {
        this.lstAllImmunization = lstImmunization;
    }

    public void addToLstAll(CEncounter.Immunizations a) {
        if (this.lstAllImmunization == null) {
            this.lstAllImmunization = new ArrayList<CEncounter.Immunizations>();
        }
        this.lstAllImmunization.add(a);
    }

    public List<CEncounter.Immunizations> getLstImmunization() {
        return this.lstImmunization;
    }

    public void setLstImmunization(List<CEncounter.Immunizations> lstImmunization) {
        this.lstImmunization = lstImmunization;
    }

    public void addToLst(CEncounter.Immunizations a) {
        if (this.lstImmunization == null) {
            this.lstImmunization = new ArrayList<CEncounter.Immunizations>();
        }
        this.lstImmunization.add(a);
    }

    public List<CEncounter.BloodPres> getLstBloodPres() {
        return this.lstBloodPres;
    }

    public void setLstBloodPres(List<CEncounter.BloodPres> lstBloodPres) {
        this.lstBloodPres = lstBloodPres;
    }

    public List<CEncounter.BodyTemp> getLstBodyTemp() {
        return this.lstBodyTemp;
    }

    public void setLstBodyTemp(List<CEncounter.BodyTemp> lstBodyTemp) {
        this.lstBodyTemp = lstBodyTemp;
    }

    public List<CEncounter.Freq> getLstFreq() {
        return this.lstFreq;
    }

    public void setLstFreq(List<CEncounter.Freq> lstFreq) {
        this.lstFreq = lstFreq;
    }

    public List<CEncounter.Measurement> getLstMeasurement() {
        return this.lstMeasurement;
    }

    public void setLstMeasurement(List<CEncounter.Measurement> lstMeasurement) {
        this.lstMeasurement = lstMeasurement;
    }

    public List<CEncounter.PhysicalExam> getLstPhysicalExam() {
        return this.lstPhysicalExam;
    }

    public void setLstPhysicalExam(List<CEncounter.PhysicalExam> lstPhysicalExam) {
        this.lstPhysicalExam = lstPhysicalExam;
    }

    public List<CEncounter.Prescription> getLstAllPrescription() {
        return this.lstAllPrescription;
    }

    public void setLstAllPrescription(List<CEncounter.Prescription> lstPrescription) {
        this.lstAllPrescription = lstPrescription;
    }

    public void addToLstAll(CEncounter.Prescription a) {
        if (this.lstAllPrescription == null) {
            this.lstAllPrescription = new ArrayList<CEncounter.Prescription>();
        }
        this.lstAllPrescription.add(a);
    }

    public List<CEncounter.Prescription> getLstPrescription() {
        return this.lstPrescription;
    }

    public void setLstPrescription(List<CEncounter.Prescription> lstPrescription) {
        this.lstPrescription = lstPrescription;
    }

    public void addToLst(CEncounter.Prescription a) {
        if (this.lstPrescription == null) {
            this.lstPrescription = new ArrayList<CEncounter.Prescription>();
        }
        this.lstPrescription.add(a);
    }

    public List<CEncounter.Device> getLstDevice() {
        return this.lstDevice;
    }

    public void setLstDevice(List<CEncounter.Device> lstDevice) {
        this.lstDevice = lstDevice;
    }

    public void addToLst(CEncounter.Device a) {
        if (this.lstDevice == null) {
            this.lstDevice = new ArrayList<CEncounter.Device>();
        }
        this.lstDevice.add(a);
    }

    public List<CEncounter.CustMeasure> getLstCustMeasure() {
        return this.lstCustMeasure;
    }

    public void setLstCustMeasure(List<CEncounter.CustMeasure> lstCustMeasure) {
        this.lstCustMeasure = lstCustMeasure;
    }

    public List<CEncounter.Dx> getLstDx() {
        return this.lstDx;
    }

    public void setLstDx(List<CEncounter.Dx> lstDx) {
        this.lstDx = lstDx;
    }

    public void addToLst(CEncounter.Dx a) {
        if (this.lstDx == null) {
            this.lstDx = new ArrayList<CEncounter.Dx>();
        }
        this.lstDx.add(a);
    }

    public List<CEncounter.Prob> getLstProb() {
        return this.lstProb;
    }

    public void setLstProb(List<CEncounter.Prob> lstProb) {
        this.lstProb = lstProb;
    }

    public void addToLst(CEncounter.Prob a) {
        if (this.lstProb == null) {
            this.lstProb = new ArrayList<CEncounter.Prob>();
        }
        this.lstProb.add(a);
    }

    public String[] getPlans() {
        return this.plans;
    }

    public void setPlans(String[] plans) {
        this.plans = plans;
    }

    public List<Plan> getLstPlan() {
        return this.lstPlan;
    }

    public void setLstPlan(List<Plan> lstPlan) {
        this.lstPlan = lstPlan;
    }

    public void addToLst(Plan a) {
        if (this.lstPlan == null) {
            this.lstPlan = new ArrayList<Plan>();
        }
        this.lstPlan.add(a);
    }

    public void map(CSummaryMapArg arg) {
        GenericDataMapping gdm = new GenericDataMapping();
        this.prescriptionDrugNameFormat = arg.drugNameFormat;
        this.setLstAllergy(new ArrayList<CEncounter.Allergies>());
        if (this.allergies != null && this.allergies.length > 0) {
            gdm.setList(this.getLstAllergy(), CEncounter.Allergies.class, null, this.allergies);
            Collections.sort(this.getLstAllergy(), CEncounter.Allergies.compare);
            this.setAllergies(null);
        }
        this.setLstIntolerance(new ArrayList<CEncounter.Intolerances>());
        if (this.intolerances != null && this.intolerances.length > 0) {
            gdm.setList(this.getLstIntolerance(), CEncounter.Intolerances.class, null, this.intolerances);
            Collections.sort(this.getLstIntolerance(), CEncounter.Allergies.compare);
            this.setIntolerances(null);
        }
        this.setLstIntervention(new ArrayList<CEncounter.Interventions>());
        if (this.interventions != null && this.interventions.length > 0) {
            gdm.setList(this.getLstIntervention(), CEncounter.Interventions.class, null, this.interventions);
            Collections.sort(this.getLstIntervention(), CEncounter.Interventions.compare);
            this.setInterventions(null);
        }
        this.setLstLifeHabit(new ArrayList<CEncounter.LifeHabits>());
        if (this.lifeHabits != null && this.lifeHabits.length > 0) {
            gdm.setList(this.getLstLifeHabit(), CEncounter.LifeHabits.class, null, this.lifeHabits);
            Collections.sort(this.getLstLifeHabit(), CEncounter.LifeHabits.compare);
            this.setLifeHabits(null);
        }
        this.setLstPrevent(new ArrayList<CEncounter.Prevents>());
        if (this.prevents != null && this.prevents.length > 0) {
            gdm.setList(this.getLstPrevent(), CEncounter.Prevents.class, null, this.prevents);
            Collections.sort(this.getLstPrevent(), CEncounter.Prevents.compare);
            this.setPrevents(null);
        }
        this.setLstRappel(new ArrayList<CEncounter.Rappels>());
        if (this.rappels != null && this.rappels.length > 0) {
            ArrayList lstRap = new ArrayList();
            gdm.setList(lstRap, CEncounter.Rappels.class, null, this.rappels);
            Iterator iterator = lstRap.iterator();
            while (iterator.hasNext()) {
                CEncounter.Rappels rpl = (CEncounter.Rappels)iterator.next();
                this.getLstRappel().add(rpl);
            }
            Collections.sort(this.getLstRappel(), CEncounter.Rappels.compare);
            this.setRappels(null);
        }
        this.setLstAllImmunization(new ArrayList<CEncounter.Immunizations>());
        this.setLstImmunization(new ArrayList<CEncounter.Immunizations>());
        if (this.immunizations != null && this.immunizations.length > 0) {
            gdm.setList(this.getLstAllImmunization(), CEncounter.Immunizations.class, null, this.immunizations);
            for (CEncounter.Immunizations immunizations : this.getLstAllImmunization()) {
                if (!Boolean.TRUE.equals(immunizations.getShowInPatientSummary())) continue;
                this.addToLst(immunizations);
            }
            Collections.sort(this.getLstAllImmunization(), CEncounter.Immunizations.compare);
            if (this.getLstImmunization() != null) {
                Collections.sort(this.getLstImmunization(), CEncounter.Immunizations.compare);
            }
            this.setImmunizations(null);
        }
        this.setLstBloodPres(new ArrayList<CEncounter.BloodPres>());
        if (this.bps != null && this.bps.length > 0) {
            gdm.setList(this.getLstBloodPres(), CEncounter.BloodPres.class, null, this.bps);
            this.setBps(null);
        }
        this.setLstBodyTemp(new ArrayList<CEncounter.BodyTemp>());
        if (this.bts != null && this.bts.length > 0) {
            gdm.setList(this.getLstBodyTemp(), CEncounter.BodyTemp.class, null, this.bts);
            this.setBts(null);
        }
        this.setLstFreq(new ArrayList<CEncounter.Freq>());
        if (this.fqs != null && this.fqs.length > 0) {
            gdm.setList(this.getLstFreq(), CEncounter.Freq.class, null, this.fqs);
            this.setFqs(null);
        }
        this.setLstMeasurement(new ArrayList<CEncounter.Measurement>());
        if (this.mss != null && this.mss.length > 0) {
            gdm.setList(this.getLstMeasurement(), CEncounter.Measurement.class, null, this.mss);
            this.setMss(null);
        }
        this.setLstPhysicalExam(new ArrayList<CEncounter.PhysicalExam>());
        if (this.pes != null && this.pes.length > 0) {
            gdm.setList(this.getLstPhysicalExam(), CEncounter.PhysicalExam.class, null, this.pes);
            this.setPes(null);
        }
        this.setLstAllPrescription(new ArrayList<CEncounter.Prescription>());
        this.setLstPrescription(new ArrayList<CEncounter.Prescription>());
        if (this.prescriptions != null && this.prescriptions.length > 0) {
            CPrescriptionFormatter.setDrugNameFormat(arg.drugNameFormat);
            gdm.setList(this.getLstAllPrescription(), CEncounter.Prescription.class, null, this.prescriptions);
            List<CEncounter.DevicePrescription> activePrescriptions = this.getActivePrescriptions(Calendar.getInstance().getTime().getTime(), this.getLstAllPrescription());
            for (CEncounter.DevicePrescription prescr : activePrescriptions) {
                if (prescr.idProfessionnalAnchor != null) {
                    prescr.setProfNom((String)arg.profNameResolver.get((Object)prescr.idProfessionnalAnchor));
                }
                this.addToLst((CEncounter.Prescription)prescr);
            }
            Collections.sort(this.getLstAllPrescription(), CEncounter.DevicePrescription.compare);
            Collections.sort(this.getLstPrescription(), CEncounter.DevicePrescription.compare);
            this.setPrescriptions(null);
        }
        this.setLstDevice(new ArrayList<CEncounter.Device>());
        if (this.devices != null && this.devices.length > 0) {
            gdm.setList(this.getLstDevice(), CEncounter.Device.class, null, this.devices);
            List<CEncounter.DevicePrescription> activeDevices = this.getActivePrescriptions(Calendar.getInstance().getTime().getTime(), this.getLstDevice());
            for (CEncounter.DevicePrescription prescr : activeDevices) {
                if (prescr.idProfessionnalAnchor == null) continue;
                prescr.setProfNom((String)arg.profNameResolver.get((Object)prescr.idProfessionnalAnchor));
            }
            Collections.sort(this.getLstDevice(), CEncounter.DevicePrescription.compare);
            this.setDevices(null);
        }
        this.setLstCustMeasure(new ArrayList<CEncounter.CustMeasure>());
        if (this.custMeasures != null && this.custMeasures.length > 0) {
            gdm.setList(this.getLstCustMeasure(), CEncounter.CustMeasure.class, null, this.custMeasures);
            this.setCustMeasures(null);
        }
        this.setLstDx(new ArrayList<CEncounter.Dx>());
        if (this.dxs != null && this.dxs.length > 0) {
            gdm.setList(this.getLstDx(), CEncounter.Dx.class, null, this.dxs);
            Collections.sort(this.getLstDx(), CEncounter.Dx.compare);
            this.setDxs(null);
        }
        this.setLstProb(new ArrayList<CEncounter.Prob>());
        if (this.getProbs() != null && this.getProbs().length > 0) {
            gdm.setList(this.getLstProb(), CEncounter.Prob.class, null, this.getProbs());
            Collections.sort(this.getLstProb(), CEncounter.Dx.compare);
            this.setProbs(null);
        }
        this.setLstPlan(new ArrayList<Plan>());
        if (this.getPlans() != null && this.getPlans().length > 0) {
            gdm.setList(this.getLstPlan(), Plan.class, null, this.getPlans());
            Collections.sort(this.getLstPlan(), new Comparator<Plan>(){

                @Override
                public int compare(Plan o1, Plan o2) {
                    return o1.getEntryDate().compareTo(o2.getEntryDate());
                }
            });
            this.setPlans(null);
        }
        ArrayList<CEncounter.EncounterNote> lstNoteMedHx = new ArrayList<CEncounter.EncounterNote>();
        if (this.getMedicalHistoryObjArr() != null && this.getMedicalHistoryObjArr().length > 0) {
            gdm.setList(lstNoteMedHx, CEncounter.EncounterNote.class, null, this.getMedicalHistoryObjArr());
            if (lstNoteMedHx.size() > 0) {
                this.compLastEntryDate(lstNoteMedHx);
                this.medicalHistoryObj = (CEncounter.EncounterNote)lstNoteMedHx.get(0);
                if (this.medicalHistoryObj.idProfessionnalAnchor != null) {
                    this.medicalHistoryObj.setProfNom((String)arg.profNameResolver.get((Object)this.medicalHistoryObj.idProfessionnalAnchor));
                }
            }
            this.setMedicalHistoryObjArr(null);
        }
        ArrayList<CEncounter.EncounterNote> arrayList = new ArrayList<CEncounter.EncounterNote>();
        if (this.getSocialHistoryObjArr() != null && this.getSocialHistoryObjArr().length > 0) {
            gdm.setList(arrayList, CEncounter.EncounterNote.class, null, this.getSocialHistoryObjArr());
            if (arrayList.size() > 0) {
                this.compLastEntryDate(arrayList);
                this.socialHistoryObj = (CEncounter.EncounterNote)arrayList.get(0);
                if (this.socialHistoryObj.idProfessionnalAnchor != null) {
                    this.socialHistoryObj.setProfNom((String)arg.profNameResolver.get((Object)this.socialHistoryObj.idProfessionnalAnchor));
                }
            }
            this.setSocialHistoryObjArr(null);
        }
        ArrayList<CEncounter.EncounterNote> lstNoteFamHx = new ArrayList<CEncounter.EncounterNote>();
        if (this.getFamilyHistoryObjArr() != null && this.getFamilyHistoryObjArr().length > 0) {
            gdm.setList(lstNoteFamHx, CEncounter.EncounterNote.class, null, this.getFamilyHistoryObjArr());
            if (lstNoteFamHx.size() > 0) {
                this.compLastEntryDate(lstNoteFamHx);
                this.familyHistoryObj = (CEncounter.EncounterNote)lstNoteFamHx.get(0);
                if (this.familyHistoryObj.idProfessionnalAnchor != null) {
                    this.familyHistoryObj.setProfNom((String)arg.profNameResolver.get((Object)this.familyHistoryObj.idProfessionnalAnchor));
                }
            }
            this.setFamilyHistoryObjArr(null);
        }
        ArrayList<CEncounter.EncounterNote> lstNoteOthRx = new ArrayList<CEncounter.EncounterNote>();
        if (this.getOtherMedicationsObjArr() != null && this.getOtherMedicationsObjArr().length > 0) {
            gdm.setList(lstNoteOthRx, CEncounter.EncounterNote.class, null, this.getOtherMedicationsObjArr());
            if (lstNoteOthRx.size() > 0) {
                this.compLastEntryDate(lstNoteOthRx);
                this.otherMedicationsObj = (CEncounter.EncounterNote)lstNoteOthRx.get(0);
                if (this.otherMedicationsObj.idProfessionnalAnchor != null) {
                    this.otherMedicationsObj.setProfNom((String)arg.profNameResolver.get((Object)this.otherMedicationsObj.idProfessionnalAnchor));
                }
            }
            this.setOtherMedicationsObjArr(null);
        }
        ArrayList<CEncounter.EncounterNote> lstNoteOngC = new ArrayList<CEncounter.EncounterNote>();
        if (this.getOngoingConcernsObjArr() != null && this.getOngoingConcernsObjArr().length > 0) {
            gdm.setList(lstNoteOngC, CEncounter.EncounterNote.class, null, this.getOngoingConcernsObjArr());
            if (lstNoteOngC.size() > 0) {
                this.compLastEntryDate(lstNoteOngC);
                this.ongoingConcernsObj = (CEncounter.EncounterNote)lstNoteOngC.get(0);
                if (this.ongoingConcernsObj.idProfessionnalAnchor != null) {
                    this.ongoingConcernsObj.setProfNom((String)arg.profNameResolver.get((Object)this.ongoingConcernsObj.idProfessionnalAnchor));
                }
            }
            this.setOngoingConcernsObjArr(null);
        }
    }

    private void compLastEntryDate(List<CEncounter.EncounterNote> lstNoteSum) {
        if (lstNoteSum.size() > 1) {
            Collections.sort(lstNoteSum, new Comparator<CEncounter.EncounterNote>(){

                @Override
                public int compare(CEncounter.EncounterNote o1, CEncounter.EncounterNote o2) {
                    return o2.entryDate.compareTo(o1.entryDate);
                }
            });
            CEncounter.EncounterNote note = lstNoteSum.get(0);
            lstNoteSum.clear();
            lstNoteSum.add(note);
        }
    }

    private List<CEncounter.DevicePrescription> getActivePrescriptions(long referenceTime, List lst) {
        ArrayList<CEncounter.DevicePrescription> list = new ArrayList<CEncounter.DevicePrescription>();
        if (lst != null && !lst.isEmpty()) {
            ArrayList filteredPrescriptions = new ArrayList(lst);
            LocalDate today = LocalDate.today();
            for (CEncounter.DevicePrescription p : filteredPrescriptions) {
                LocalDate referenceDate = LocalDate.fromTimeInMillisLOCAL((Long)referenceTime);
                if (p.getStopDate() != null && LocalDate.fromTimeInMillisLOCAL((Long)p.getStopDate()).beforeOrEquals(referenceDate) || p.getEndDate() != null && LocalDate.fromTimeInMillisLOCAL((Long)p.getEndDate()).before((IPartialDate)referenceDate)) continue;
                LocalDate presumedDateToRenvew = null;
                if ((p.getToReprescribe() == null || p.getToReprescribe() == 0) && (presumedDateToRenvew = p.getPresumedDateToRenew()) != null && LocalDate.fromTimeInMillisLOCAL((Long)referenceTime).after((IPartialDate)presumedDateToRenvew)) continue;
                if (presumedDateToRenvew == null) {
                    presumedDateToRenvew = p.getPresumedDateToRenew();
                }
                LocalDate endDate = null;
                if (p.getEndDate() != null) {
                    endDate = LocalDate.fromTimeInMillisLOCAL((Long)p.getEndDate());
                    if (presumedDateToRenvew == null || endDate.before((IPartialDate)presumedDateToRenvew)) {
                        presumedDateToRenvew = endDate;
                    }
                }
                if (presumedDateToRenvew != null) {
                    p.expiredDateSD = (presumedDateToRenvew.equals((Object)endDate) ? "" : "~") + presumedDateToRenvew.formatHyphen();
                    if (p.getStopDate() == null && today.plusDay(1).after((IPartialDate)presumedDateToRenvew)) {
                        p.expiredStatus = 1;
                        if (today.plusMonth(-6).after((IPartialDate)presumedDateToRenvew)) {
                            p.expiredStatus = 2;
                        }
                    }
                }
                if (p.getId() != null) {
                    boolean isReferenced = false;
                    for (Object p2 : lst) {
                        if (((CEncounter.DevicePrescription)p2).getIdPrevPrescription() == null || !((CEncounter.DevicePrescription)p2).getIdPrevPrescription().equals(p.getId())) continue;
                        isReferenced = true;
                        break;
                    }
                    if (isReferenced) continue;
                    list.add(p);
                    continue;
                }
                list.add(p);
            }
        }
        return list;
    }

    public void init(XEncounter enc) {
        super.init(enc);
        if (enc != null) {
            this.setIdSite(enc.getSite());
            this.setIdProfAnchor(enc.getProfessionnal());
            this.setIdPatientAnchor(enc.idPatient);
        }
    }

    public XEncounter x() {
        XEncounter res = new XEncounter();
        super.x(res);
        res.setSite(this.idSite);
        res.setProfessionnal(this.idProfAnchor);
        res.idPatient = this.idPatientAnchor;
        res.modificationStatus.plain_set(this.modificationStatus == null ? ModificationStatus.STATUS_NEUTRAL : ModificationStatus.valueOf(this.modificationStatus));
        return res;
    }

    @Override
    public <T> void convertc(T type) {
        XEncounter x = (XEncounter)XEncounter.class.cast(type);
        this.init(x);
    }

    public XEncounter convertx() {
        return this.x();
    }

    public void replaceSavedObjectsInSource(CSummary saved) {
        int i;
        ArrayList<Integer> itemsToRemove;
        HashMap<Integer, CEditableDataObject> mapItemsToReplace;
        if (this.getLstAllergy() != null && saved.getLstAllergy() != null) {
            mapItemsToReplace = new HashMap<Integer, CEditableDataObject>(0);
            itemsToRemove = new ArrayList<Integer>(0);
            for (CEncounter.Allergies allergies : saved.getLstAllergy()) {
                if (allergies.tag != null) continue;
                this.getLstAllergy().add(allergies);
            }
            for (int i2 = 0; i2 < this.getLstAllergy().size(); ++i2) {
                CEncounter.Allergies allergies = this.getLstAllergy().get(i2);
                if (!allergies.isDirty()) continue;
                if (saved == null || saved.getLstAllergy() == null) {
                    itemsToRemove.add(i2);
                    continue;
                }
                for (CEncounter.Allergies allergies2 : saved.getLstAllergy()) {
                    if (!allergies.tag.equals(allergies2.tag)) continue;
                    if (allergies.isStatusDeleted()) {
                        itemsToRemove.add(i2);
                        continue;
                    }
                    mapItemsToReplace.put(i2, allergies2);
                }
            }
            for (Map.Entry entry : mapItemsToReplace.entrySet()) {
                this.getLstAllergy().set((Integer)entry.getKey(), (CEncounter.Allergies)entry.getValue());
            }
            for (i = itemsToRemove.size() - 1; i >= 0; --i) {
                this.getLstAllergy().remove((Integer)itemsToRemove.get(i));
            }
        }
        if (this.getLstIntolerance() != null && saved.getLstIntolerance() != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (CEncounter.Intolerances intolerances : saved.getLstIntolerance()) {
                if (intolerances.tag != null) continue;
                this.getLstIntolerance().add(intolerances);
            }
            for (int i3 = 0; i3 < this.getLstIntolerance().size(); ++i3) {
                CEncounter.Intolerances intolerances = this.getLstIntolerance().get(i3);
                if (!intolerances.isDirty()) continue;
                if (saved == null || saved.getLstIntolerance() == null) {
                    itemsToRemove.add(i3);
                    continue;
                }
                for (CEncounter.Intolerances intolerances2 : saved.getLstIntolerance()) {
                    if (!intolerances.tag.equals(intolerances2.tag)) continue;
                    if (intolerances.isStatusDeleted()) {
                        itemsToRemove.add(i3);
                        continue;
                    }
                    mapItemsToReplace.put(i3, intolerances2);
                }
            }
            for (Map.Entry entry : mapItemsToReplace.entrySet()) {
                this.getLstIntolerance().set((Integer)entry.getKey(), (CEncounter.Intolerances)entry.getValue());
            }
            for (i = itemsToRemove.size() - 1; i >= 0; --i) {
                this.getLstIntolerance().remove((Integer)itemsToRemove.get(i));
            }
        }
        if (this.getLstRappel() != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (i = 0; i < this.getLstRappel().size(); ++i) {
                CEncounter.Rappels rappels = this.getLstRappel().get(i);
                if (!rappels.isDirty()) continue;
                if (saved == null || saved.getLstRappel() == null) {
                    itemsToRemove.add(i);
                    continue;
                }
                for (CEncounter.Rappels rappels2 : saved.getLstRappel()) {
                    if (!rappels.tag.equals(rappels2.tag)) continue;
                    if (rappels.isStatusDeleted()) {
                        itemsToRemove.add(i);
                        continue;
                    }
                    mapItemsToReplace.put(i, rappels2);
                }
            }
            for (Map.Entry entry : mapItemsToReplace.entrySet()) {
                this.getLstRappel().set((Integer)entry.getKey(), (CEncounter.Rappels)entry.getValue());
            }
        }
        if (this.getLstAllImmunization() != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (int i4 = 0; i4 < this.getLstAllImmunization().size(); ++i4) {
                CEncounter.Immunizations immunizations = this.getLstAllImmunization().get(i4);
                if (!immunizations.isDirty()) continue;
                if (saved == null || saved.getLstAllImmunization() == null) {
                    itemsToRemove.add(i4);
                    continue;
                }
                for (CEncounter.Immunizations immunizations2 : saved.getLstAllImmunization()) {
                    if (!immunizations.tag.equals(immunizations2.tag)) continue;
                    if (immunizations.isStatusDeleted()) {
                        itemsToRemove.add(i4);
                        continue;
                    }
                    mapItemsToReplace.put(i4, immunizations2);
                }
            }
            for (Map.Entry entry : mapItemsToReplace.entrySet()) {
                this.getLstAllImmunization().set((Integer)entry.getKey(), (CEncounter.Immunizations)entry.getValue());
            }
            for (int i5 = itemsToRemove.size() - 1; i5 >= 0; --i5) {
                this.getLstAllImmunization().remove((Integer)itemsToRemove.get(i5));
            }
            this.setLstImmunization(new ArrayList<CEncounter.Immunizations>());
            for (CEncounter.Immunizations immunizations : this.getLstAllImmunization()) {
                if (!Boolean.TRUE.equals(immunizations.getShowInPatientSummary())) continue;
                this.addToLst(immunizations);
            }
        }
        if (this.getLstAllPrescription() != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (int i6 = 0; i6 < this.getLstAllPrescription().size(); ++i6) {
                CEncounter.Prescription prescription = this.getLstAllPrescription().get(i6);
                if (!prescription.isDirty()) continue;
                if (saved == null || saved.getLstAllPrescription() == null) {
                    itemsToRemove.add(i6);
                    continue;
                }
                for (CEncounter.Prescription prescription2 : saved.getLstAllPrescription()) {
                    if (!prescription.tag.equals(prescription2.tag)) continue;
                    if (prescription.isStatusDeleted()) {
                        itemsToRemove.add(i6);
                        continue;
                    }
                    mapItemsToReplace.put(i6, prescription2);
                }
            }
            for (Map.Entry entry : mapItemsToReplace.entrySet()) {
                this.getLstAllPrescription().set((Integer)entry.getKey(), (CEncounter.Prescription)entry.getValue());
            }
            for (int i7 = itemsToRemove.size() - 1; i7 >= 0; --i7) {
                this.getLstAllPrescription().remove((Integer)itemsToRemove.get(i7));
            }
            this.setLstPrescription(new ArrayList<CEncounter.Prescription>());
            List<CEncounter.DevicePrescription> actRx = this.getActivePrescriptions(Calendar.getInstance().getTime().getTime(), this.getLstAllPrescription());
            for (CEncounter.DevicePrescription prescr : actRx) {
                this.getLstPrescription().add((CEncounter.Prescription)prescr);
            }
        }
        if (this.getLstDevice() != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (int i8 = 0; i8 < this.getLstDevice().size(); ++i8) {
                CEncounter.Device device = this.getLstDevice().get(i8);
                if (!device.isDirty()) continue;
                if (saved == null || saved.getLstDevice() == null) {
                    itemsToRemove.add(i8);
                    continue;
                }
                for (CEncounter.Device device2 : saved.getLstDevice()) {
                    if (!device.tag.equals(device2.tag)) continue;
                    if (device.isStatusDeleted()) {
                        itemsToRemove.add(i8);
                        continue;
                    }
                    mapItemsToReplace.put(i8, device2);
                }
            }
            for (Map.Entry entry : mapItemsToReplace.entrySet()) {
                this.getLstDevice().set((Integer)entry.getKey(), (CEncounter.Device)entry.getValue());
            }
            for (int i9 = itemsToRemove.size() - 1; i9 >= 0; --i9) {
                this.getLstDevice().remove((Integer)itemsToRemove.get(i9));
            }
        }
        if (this.getLstIntervention() != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (int i10 = 0; i10 < this.getLstIntervention().size(); ++i10) {
                CEncounter.Interventions interventions = this.getLstIntervention().get(i10);
                if (!interventions.isDirty()) continue;
                if (saved == null || saved.getLstIntervention() == null) {
                    itemsToRemove.add(i10);
                    continue;
                }
                for (CEncounter.Interventions interventions2 : saved.getLstIntervention()) {
                    if (!interventions.tag.equals(interventions2.tag)) continue;
                    if (interventions.isStatusDeleted()) {
                        itemsToRemove.add(i10);
                        continue;
                    }
                    mapItemsToReplace.put(i10, interventions2);
                }
            }
            for (Map.Entry entry : mapItemsToReplace.entrySet()) {
                this.getLstIntervention().set((Integer)entry.getKey(), (CEncounter.Interventions)entry.getValue());
            }
            for (int i11 = itemsToRemove.size() - 1; i11 >= 0; --i11) {
                this.getLstIntervention().remove((Integer)itemsToRemove.get(i11));
            }
        }
        if (this.getLstLifeHabit() != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (int i12 = 0; i12 < this.getLstLifeHabit().size(); ++i12) {
                CEncounter.LifeHabits lifeHabits = this.getLstLifeHabit().get(i12);
                if (!lifeHabits.isDirty()) continue;
                if (saved == null || saved.getLstLifeHabit() == null) {
                    itemsToRemove.add(i12);
                    continue;
                }
                for (CEncounter.LifeHabits lifeHabits2 : saved.getLstLifeHabit()) {
                    if (!lifeHabits.tag.equals(lifeHabits2.tag)) continue;
                    if (lifeHabits.isStatusDeleted()) {
                        itemsToRemove.add(i12);
                        continue;
                    }
                    mapItemsToReplace.put(i12, lifeHabits2);
                }
            }
            for (Map.Entry entry : mapItemsToReplace.entrySet()) {
                this.getLstLifeHabit().set((Integer)entry.getKey(), (CEncounter.LifeHabits)entry.getValue());
            }
            for (int i13 = itemsToRemove.size() - 1; i13 >= 0; --i13) {
                this.getLstLifeHabit().remove((Integer)itemsToRemove.get(i13));
            }
        }
        if (this.getLstPrevent() != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (int i14 = 0; i14 < this.getLstPrevent().size(); ++i14) {
                CEncounter.Prevents prevents = this.getLstPrevent().get(i14);
                if (!prevents.isDirty()) continue;
                if (saved == null || saved.getLstPrevent() == null) {
                    itemsToRemove.add(i14);
                    continue;
                }
                for (CEncounter.Prevents prevents2 : saved.getLstPrevent()) {
                    if (!prevents.tag.equals(prevents2.tag)) continue;
                    if (prevents.isStatusDeleted()) {
                        itemsToRemove.add(i14);
                        continue;
                    }
                    mapItemsToReplace.put(i14, prevents2);
                }
            }
            for (Map.Entry entry : mapItemsToReplace.entrySet()) {
                this.getLstPrevent().set((Integer)entry.getKey(), (CEncounter.Prevents)entry.getValue());
            }
            for (int i15 = itemsToRemove.size() - 1; i15 >= 0; --i15) {
                this.getLstPrevent().remove((Integer)itemsToRemove.get(i15));
            }
        }
        if (this.getLstDx() != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (int i16 = 0; i16 < this.getLstDx().size(); ++i16) {
                CEncounter.Dx dx = this.getLstDx().get(i16);
                if (!dx.isDirty()) continue;
                if (saved == null || saved.getLstDx() == null) {
                    itemsToRemove.add(i16);
                    continue;
                }
                for (CEncounter.Dx dx2 : saved.getLstDx()) {
                    if (!dx.tag.equals(dx2.tag)) continue;
                    if (dx.isStatusDeleted()) {
                        itemsToRemove.add(i16);
                        continue;
                    }
                    mapItemsToReplace.put(i16, dx2);
                }
            }
            for (Map.Entry entry : mapItemsToReplace.entrySet()) {
                this.getLstDx().set((Integer)entry.getKey(), (CEncounter.Dx)entry.getValue());
            }
            for (int i17 = itemsToRemove.size() - 1; i17 >= 0; --i17) {
                this.getLstDx().remove((Integer)itemsToRemove.get(i17));
            }
        }
        if (this.getLstProb() != null) {
            mapItemsToReplace = new HashMap(0);
            itemsToRemove = new ArrayList(0);
            for (int i18 = 0; i18 < this.getLstProb().size(); ++i18) {
                CEncounter.Prob prob = this.getLstProb().get(i18);
                if (!prob.isDirty()) continue;
                if (saved == null || saved.getLstProb() == null) {
                    itemsToRemove.add(i18);
                    continue;
                }
                for (CEncounter.Prob prob2 : saved.getLstProb()) {
                    if (!prob.tag.equals(prob2.tag)) continue;
                    if (prob.isStatusDeleted()) {
                        itemsToRemove.add(i18);
                        continue;
                    }
                    mapItemsToReplace.put(i18, prob2);
                }
            }
            for (Map.Entry entry : mapItemsToReplace.entrySet()) {
                this.getLstProb().set((Integer)entry.getKey(), (CEncounter.Prob)entry.getValue());
            }
            for (int i19 = itemsToRemove.size() - 1; i19 >= 0; --i19) {
                this.getLstProb().remove((Integer)itemsToRemove.get(i19));
            }
        }
        if (this.familyHistoryObj != null && this.familyHistoryObj.isDirty()) {
            CEncounter.EncounterNote encounterNote = this.familyHistoryObj = ModificationStatus.STATUS_DELETED.name().equals(this.familyHistoryObj.modificationStatus) ? null : saved.familyHistoryObj;
        }
        if (this.medicalHistoryObj != null && this.medicalHistoryObj.isDirty()) {
            CEncounter.EncounterNote encounterNote = this.medicalHistoryObj = ModificationStatus.STATUS_DELETED.name().equals(this.medicalHistoryObj.modificationStatus) ? null : saved.medicalHistoryObj;
        }
        if (this.ongoingConcernsObj != null && this.ongoingConcernsObj.isDirty()) {
            CEncounter.EncounterNote encounterNote = this.ongoingConcernsObj = ModificationStatus.STATUS_DELETED.name().equals(this.ongoingConcernsObj.modificationStatus) ? null : saved.ongoingConcernsObj;
        }
        if (this.otherMedicationsObj != null && this.otherMedicationsObj.isDirty()) {
            CEncounter.EncounterNote encounterNote = this.otherMedicationsObj = ModificationStatus.STATUS_DELETED.name().equals(this.otherMedicationsObj.modificationStatus) ? null : saved.otherMedicationsObj;
        }
        if (this.socialHistoryObj != null && this.socialHistoryObj.isDirty()) {
            this.socialHistoryObj = ModificationStatus.STATUS_DELETED.name().equals(this.socialHistoryObj.modificationStatus) ? null : saved.socialHistoryObj;
        }
    }

    public XPrescriptionDrugNameFormat getPrescriptionDrugNameFormat() {
        return this.prescriptionDrugNameFormat;
    }

    public static final class CSummaryMapArg {
        public XPrescriptionDrugNameFormat drugNameFormat;
        public ProviderAR<Integer, String> profNameResolver;
    }

    public static final class CAbnLab4Rxv {
        public final String date;
        public final String code;
        public final String anomaly;

        public CAbnLab4Rxv(String date, String code, String anomaly) {
            this.date = date;
            this.code = code;
            this.anomaly = anomaly;
        }
    }

    public static final class Plan
    extends CEditableDataObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"id", "idAnchor", "idPatientAnchor", "idUserAnchor", "version", "idNextModificationEntry", "entryDate", "note", "createDate", "isDone", "isDeleted", "encLabel"};
        public Integer id;
        public Integer idAnchor;
        public Integer idPatientAnchor;
        public Integer idUserAnchor;
        public Boolean isPrivate;
        public Integer idNextModificationEntry;
        public Long entryDate;
        public String entryDateS;
        public String note;
        public Long createDate;
        public String createDateS;
        public Integer isDone;
        public Boolean isDoneB;
        public Integer isDeleted;
        public Boolean isDeletedB;
        public IPatient patientTemp;
        public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);
        public String title = "Plan de traitement";
        public String[] descr;
        public String[] descrTitle = new String[]{"Note", "Statut", "Date"};

        protected static String getStringDateTimeFromLong(Long l) {
            if (l == null) {
                return null;
            }
            return FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm", (TimeZone)TimeZoneProvider.getTimeZone(), (Locale)LocaleProvider.getLocale()).format(new Date(l));
        }

        public EnumSet<XEncounterLabel> getEncLabel() {
            return this.encLabel;
        }

        public void setEncLabel(EnumSet<XEncounterLabel> status) {
            this.encLabel = status;
        }

        public void removeXEncounterLabel(XEncounterLabel x) {
            this.encLabel.remove(x);
        }

        public void addXEncounterLabel(XEncounterLabel x) {
            this.encLabel.add(x);
        }

        public void setDescriptionOfObject() {
            this.descr = new String[3];
            this.descr[0] = this.note;
            this.descr[1] = Boolean.TRUE.equals(this.isDoneB) ? "Fait" : "";
            this.descr[2] = this.createDateS;
        }

        public Plan() {
        }

        public Plan(XPlan p) {
            this.id = p.getId();
            this.entryDate = p.getEntryDate();
            this.entryDateS = Plan.getStringDateTimeFromLong(p.getEntryDate());
            this.createDate = p.getCreateDate();
            this.createDateS = Plan.getStringDateTimeFromLong(p.getCreateDate());
            this.idAnchor = p.getIdAnchor();
            this.isDeletedB = p.getIsDeleted();
            this.isDoneB = p.getIsDone();
            this.note = p.getNote();
            this.idPatientAnchor = p.getPatient() == null ? null : p.getPatient().getId();
            this.idUserAnchor = p.getIdUserAnchor();
            this.isPrivate = this.idUserAnchor != null ? Boolean.TRUE : Boolean.FALSE;
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getIdNextModificationEntry() {
            return this.idNextModificationEntry;
        }

        public final void setIdNextModificationEntry(Integer idNextModificationEntry) {
            this.idNextModificationEntry = idNextModificationEntry;
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateS() {
            return this.entryDateS;
        }

        public final void setEntryDateS(String entryDateS) {
            this.entryDateS = entryDateS;
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public Integer getIdAnchor() {
            return this.idAnchor;
        }

        public void setIdAnchor(Integer idAnchor) {
            this.idAnchor = idAnchor;
        }

        public Integer getIdPatientAnchor() {
            return this.idPatientAnchor;
        }

        public void setIdPatientAnchor(Integer idPatientAnchor) {
            this.idPatientAnchor = idPatientAnchor;
        }

        public Integer getIdUserAnchor() {
            return this.idUserAnchor;
        }

        public void setIdUserAnchor(Integer idUserAnchor) {
            this.idUserAnchor = idUserAnchor;
            this.isPrivate = this.idUserAnchor != null ? Boolean.TRUE : Boolean.FALSE;
        }

        public Long getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(Long createDate) {
            this.createDate = createDate;
        }

        public String getCreateDateS() {
            return this.createDateS;
        }

        public void setCreateDateS(String createDateS) {
            this.createDateS = createDateS;
        }

        public Integer getIsDone() {
            return this.isDone;
        }

        public void setIsDone(Integer isDone) {
            this.isDone = isDone;
        }

        public Boolean getIsDoneB() {
            return this.isDoneB;
        }

        public void setIsDoneB(Boolean isDoneB) {
            this.isDoneB = isDoneB;
        }

        public Integer getIsDeleted() {
            return this.isDeleted;
        }

        public void setIsDeleted(Integer isDeleted) {
            this.isDeleted = isDeleted;
        }

        public Boolean getIsDeletedB() {
            return this.isDeletedB;
        }

        public void setIsDeletedB(Boolean isDeletedB) {
            this.isDeletedB = isDeletedB;
        }

        @Override
        public <T> void convertc(T type) {
        }

        @Override
        public <T> T convertx() {
            return null;
        }
    }

    public static final class Profs
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static String[] fields = new String[]{"idProfessionnalAnchor", "entryDate"};
        public Integer idProfessionnalAnchor;
        public String profNom;
        public Long entryDate;
        public String entryDateS;
        public String title = "Professionnels impliqu\u00e9s";
        public String[] descr;
        public String[] descrTitle = new String[]{"Professionnal", "Date"};

        public void setDescriptionOfObject() {
            this.descr = new String[2];
            this.descr[0] = this.profNom;
            this.descr[1] = this.entryDateS;
        }

        public final Integer getIdProfessionnalAnchor() {
            return this.idProfessionnalAnchor;
        }

        public final void setIdProfessionnalAnchor(Integer id) {
            this.idProfessionnalAnchor = id;
        }

        public String getProfNom() {
            return this.profNom;
        }

        public void setProfNom(String profNom) {
            this.profNom = profNom;
            this.setDescriptionOfObject();
        }

        public final Long getEntryDate() {
            return this.entryDate;
        }

        public final void setEntryDate(Long entryDate) {
            this.entryDate = entryDate;
        }

        public final String getEntryDateS() {
            return this.entryDateS;
        }

        public final void setEntryDateS(String entryDateS) {
            this.entryDateS = entryDateS;
        }
    }
}

