/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumer;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.IConsumeTask;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XReservedAppointment;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterModificationRequest;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalConsumeTask
implements IConsumeTask {
    private static final Logger logger = Logger.getLogger(LocalConsumeTask.class.getName());
    private IConsumer consumer;
    private DataObjectUpdatedNotification notification;

    public LocalConsumeTask(IConsumer consumer, DataObjectUpdatedNotification notification) {
        if (consumer == null) {
            throw new NullPointerException("consumer");
        }
        this.consumer = consumer;
        if (notification == null) {
            throw new NullPointerException("notification");
        }
        this.notification = notification;
    }

    @Override
    public void run() {
        try {
            logger.info("-->localDelivery " + this.notification);
            XSession session = Application.get().getGlobalInstances().getSession();
            if (session != null && this.shouldProcess(session, this.notification)) {
                this.onMessage(this.notification);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "consumer handleDelivery", e);
        }
    }

    private boolean shouldProcess(XSession session, DataObjectUpdatedNotification cn) {
        DataObjectUpdatedNotification don = cn;
        boolean doitAnyway = true;
        if (don.getObject() instanceof DataObject) {
            DataObject dto = (DataObject)don.getObject();
            doitAnyway = !XEncounterModificationRequest.class.getName().equals(dto.getClazz());
        } else if (don.getObject() instanceof XReservedAppointment) {
            doitAnyway = false;
        }
        return doitAnyway;
    }

    private void onMessage(DataObjectUpdatedNotification object) {
        try {
            this.consumer.process((Notification)object);
        }
        catch (Exception e) {
            String smessage;
            try {
                smessage = String.valueOf(object);
            }
            catch (Exception e2) {
                smessage = e2.getMessage();
            }
            logger.log(Level.SEVERE, "Unexpected exception for message " + smessage, e);
        }
    }
}

