/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumer;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.IConsumeTask;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XReservedAppointment;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterModificationRequest;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import ca.infodata.ofys.util.LZMAClientSerialiser;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasicConsumeTask
implements IConsumeTask {
    private static final Logger logger = Logger.getLogger(BasicConsumeTask.class.getName());
    private IConsumer consumer;
    private Envelope envelope;
    private AMQP.BasicProperties properties;
    private byte[] body;

    public BasicConsumeTask(IConsumer consumer, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        this.consumer = consumer;
        this.envelope = envelope;
        this.properties = properties;
        this.body = body;
    }

    @Override
    public void run() {
        try {
            Object object;
            logger.info("-->handleDelivery - tag = " + this.envelope.getDeliveryTag());
            XSession session = Application.get().getGlobalInstances().getSession();
            if (session != null && this.shouldProcess(session, object = LZMAClientSerialiser.deserialize((byte[])this.body))) {
                this.onMessage(object);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "consumer handleDelivery", e);
        }
    }

    private boolean shouldProcess(XSession session, Object object) {
        boolean doitAnyway = true;
        Integer sessionId = this.parseMessageSessionId();
        if (sessionId != null && sessionId.equals(session.getId()) && object instanceof DataObjectUpdatedNotification) {
            DataObjectUpdatedNotification don = (DataObjectUpdatedNotification)object;
            if (don.getObject() instanceof DataObject) {
                DataObject dto = (DataObject)((DataObjectUpdatedNotification)object).getObject();
                doitAnyway = !XEncounterModificationRequest.class.getName().equals(dto.getClazz());
            } else if (don.getObject() instanceof XReservedAppointment) {
                doitAnyway = false;
            }
        }
        return doitAnyway;
    }

    private Integer parseMessageSessionId() {
        Integer sessionId = null;
        if (this.properties.getHeaders() != null && this.properties.getHeaders().containsKey("sessionId")) {
            try {
                sessionId = (Integer)this.properties.getHeaders().get("sessionId");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "properties.getHeaders().get('sessionId') dans messageSelector: ", e);
            }
        }
        return sessionId;
    }

    private void onMessage(Object object) {
        try {
            if (object instanceof Notification) {
                Notification notification = (Notification)object;
                this.consumer.process(notification);
            } else if (object instanceof Notification[]) {
                Notification[] notifications = (Notification[])object;
                this.consumer.process(notifications);
            } else {
                logger.log(Level.SEVERE, "Unsupported message object received " + object);
            }
        }
        catch (Exception e) {
            String smessage;
            try {
                smessage = String.valueOf(object);
            }
            catch (Exception e2) {
                smessage = e2.getMessage();
            }
            logger.log(Level.SEVERE, "Unexpected exception for message " + smessage, e);
        }
    }
}

