/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.callback;

import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeleteCallback
extends JobCallback {
    private static final Logger logger = Logger.getLogger(DeleteCallback.class.getName());
    private IDataObject dataObject;
    private BaseAccessorClient accessorClient;
    private final XSession session;
    private IStatusHandler.State handlerStatusState;

    public DeleteCallback(XSession session) {
        this(session, BaseAccessorClient.defaultStatusHandler);
    }

    public DeleteCallback(XSession session, IStatusHandler statusHandler) {
        super(Messages.getString((String)"SUPPRIMER", (String[])new String[0]), statusHandler);
        this.session = session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean handleStatus(ReturnObject response) {
        try {
            IStatusHandler handler = this.getStatusHandler();
            if (response != null && handler != null) {
                this.handlerStatusState = handler.handle((IStatus)response.getStatus());
                if (this.handlerStatusState != IStatusHandler.State.HANDLED_POSITIVE) {
                    this.innerResponseReceived(response);
                    return true;
                }
                if (this.accessorClient == null) {
                    logger.log(Level.SEVERE, "accessor client is null in DeleteCallback " + this.toString());
                }
                this.accessorClient.delete(BaseAccessorClient.getNextUniqueKey2(), this.session, this, this.dataObject, false);
                return false;
            }
            this.innerResponseReceived(response);
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in Callback status handling. " + this.toString(), e);
        }
        return true;
    }

    public final void innerResponseReceived(ReturnObject response) {
        try {
            this.responseReceivedOverride(response);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in Callback response. " + this.toString(), e);
        }
    }

    public void responseReceivedOverride(ReturnObject response) {
    }

    public void setDataObject(IDataObject dataObject) {
        this.dataObject = dataObject;
    }

    @Override
    public String toString() {
        return String.format("DeleteCallback {functionName=%s, killed=%s, wasUsedOnServer=%s, dataObject}", this.getFunctionName(), this.killed(), this.wasUsedOnServer, this.dataObject);
    }

    public void setAccessorClient(BaseAccessorClient accessorClient) {
        this.accessorClient = accessorClient;
    }

    public IStatusHandler.State getHandlerStatusState() {
        return this.handlerStatusState;
    }
}

