/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IObjectUsageAccessor;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.ui.library.log.Log;

public class ObjectUsageAccessorClient
extends BaseAccessorClient {
    private static ObjectUsageAccessorClient instance;
    private final IObjectUsageAccessor accessor;

    public static ObjectUsageAccessorClient getInstance() throws CannotConnectToServerException {
        return ObjectUsageAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static ObjectUsageAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new ObjectUsageAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", e2);
            throw e2;
        }
        return instance;
    }

    private ObjectUsageAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getObjectUsageAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    public void setObjectUsed(int uniqueKey, XSession session, final ICallback callback, final IDataObject obj) {
        final String function = "ObjectUsageAccessorClient.setObjectUsed" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.setObjectUsed(obj));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            ObjectUsageAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        ObjectUsageAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void removeObjectFromUsed(int uniqueKey, XSession session, final ICallback callback, final IDataObject obj) {
        final String function = "ObjectUsageAccessorClient.removeObjectFromUsed" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.removeObjectFromUsed(obj));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            ObjectUsageAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        ObjectUsageAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    protected IObjectUsageAccessor getAccessor() {
        return this.accessor;
    }
}

