/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.ICommonAccessor;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.callback.DefaultCallback;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.export.XExportOrder;
import ca.infodata.ofys.data.middle.dataobjects.export.XExportableField;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelDef;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelResType;
import ca.infodata.ofys.data.middle.dataobjects.search.XSearchOrder;
import ca.infodata.ofys.data.middle.dataobjects.search.XSearchResult;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.library.log.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommonAccessorClient
extends BaseAccessorClient {
    private static final Logger logger = Logger.getLogger(CommonAccessorClient.class.getName());
    private static CommonAccessorClient instance;
    private final ICommonAccessor accessor;

    public static CommonAccessorClient getInstance() throws CannotConnectToServerException {
        return CommonAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static CommonAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new CommonAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", e2);
            throw e2;
        }
        return instance;
    }

    private CommonAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getCommonAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    public void findModificationEntries(int uniqueKey, final XSession session, final ICallback callback, final String type, final Integer idAnchor) {
        final String function = "AppointmentAccessorClient.findAppointmentModifications" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.findModificationEntries(type, idAnchor);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, type=%s, id=%s}", function, session, callback, type, idAnchor), e);
                            CommonAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        CommonAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public List<XLabelDef> findLabelDef(XLabelResType type, boolean all, XSession session) {
        DefaultCallback callback;
        List<Object> list = new ArrayList<XLabelDef>();
        String function = "CommonAccessorClient.findLabelDef" + type;
        if (this.isOkToCallFunction(function, callback = new DefaultCallback())) {
            try {
                try {
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("type", type);
                    parameters.put("all", all);
                    ReturnObject ret = CommonAccessorClient.instance.accessor.findLabelDef(parameters);
                    callback.response(ret);
                    if (ret != null && ret.getObj() != null) {
                        list = (List)ret.getObj();
                    }
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded(function, callback);
                }
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
        return list;
    }

    public void findLabelDef(final XLabelResType type, final ICallback callback, XSession session) {
        final String function = "CommonAccessorClient.findLabelDef" + type;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            HashMap<String, Object> parameters = new HashMap<String, Object>();
                            parameters.put("type", type);
                            parameters.put("all", true);
                            ReturnObject ret = instance.accessor.findLabelDef(parameters);
                            callback.response(ret);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            CommonAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        CommonAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findSearchResult(XSession session, final ICallback callback) {
        if (this.isOkToCallFunction("CommonAccessorClient.listSearchResultHeader", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = CommonAccessorClient.this.accessor.findSearchResult();
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            CommonAccessorClient.this.functionCallEnded("CommonAccessorClient.listSearchResultHeader", callback);
                        }
                    }
                    finally {
                        CommonAccessorClient.this.functionCallEnded("CommonAccessorClient.listSearchResultHeader", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public List<XSearchResult> findSearchResultSync(XSession session) {
        if (this.isOkToCallFunction("CommonAccessorClient.findSearchResultSync", null)) {
            try {
                ReturnObject returnObject;
                ReturnObject ret = returnObject = this.accessor.findSearchResult();
                List list = (List)ret.getObj();
                return list;
            }
            catch (Exception e) {
                Log.severe((String)"Erreur", (Exception)e);
            }
            finally {
                this.functionCallEnded("CommonAccessorClient.findSearchResultSync", null);
            }
        }
        return Collections.emptyList();
    }

    public void getSearchResultIds(final XSearchResult result, XSession session, final ICallback callback) {
        if (this.isOkToCallFunction("CommonAccessorClient.getSearchResultIds", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = CommonAccessorClient.this.accessor.getSearchResultIds(result.getId().intValue());
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            CommonAccessorClient.this.functionCallEnded("CommonAccessorClient.getSearchResultIds", callback);
                        }
                    }
                    finally {
                        CommonAccessorClient.this.functionCallEnded("CommonAccessorClient.getSearchResultIds", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findSearchOrder(XSession session, final ICallback callback) {
        if (this.isOkToCallFunction("CommonAccessorClient.listSearchOrder", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = CommonAccessorClient.this.accessor.findSearchOrder();
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            CommonAccessorClient.this.functionCallEnded("CommonAccessorClient.listSearchOrder", callback);
                        }
                    }
                    finally {
                        CommonAccessorClient.this.functionCallEnded("CommonAccessorClient.listSearchOrder", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public List<XSearchOrder> findSearchOrderSync(XSession session) {
        String function = "CommonAccessorClient.listSearchOrder";
        if (this.isOkToCallFunction(function)) {
            try {
                ReturnObject returnObject;
                ReturnObject ret = returnObject = this.accessor.findSearchOrder();
                List list = (List)ret.getObj();
                return list;
            }
            catch (Exception e) {
                Log.severe((String)"Erreur", (Exception)e);
            }
            finally {
                this.functionCallEnded(function);
            }
        }
        return Collections.emptyList();
    }

    public List<HashMap<XExportableField, Serializable>> exportSearchResult(XExportOrder order, XSession session) {
        ReturnObject returnObject = this.accessor.exportSearchResult(order);
        if (returnObject == null) {
            throw new RuntimeException("returnObject is null");
        }
        if (returnObject.getObj() == null) {
            throw new RuntimeException("returnObject payload is null");
        }
        if (!returnObject.getStatus().isOK()) {
            throw new StatusException((IStatus)returnObject.getStatus());
        }
        return (List)returnObject.getObj();
    }

    protected ICommonAccessor getAccessor() {
        return this.accessor;
    }
}

