/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.client.dataaccess;

import ca.infodata.ofys.ui.library.log.LogContextProvider;
import ca.infodata.util1.Pair;
import java.util.ArrayDeque;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class LastShowMessageLogList
implements LogContextProvider {
    private final ArrayDeque<Pair<Long, String>> list;
    private final FastDateFormat sdf = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");

    protected LastShowMessageLogList() {
        this.list = new ArrayDeque(100);
    }

    public void add(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return;
        }
        if (this.list.size() >= 100) {
            this.list.pollLast();
        }
        this.list.offerFirst((Pair<Long, String>)Pair.newPair((Object)System.currentTimeMillis(), (Object)message));
    }

    public String getContextElement() {
        StringBuilder b = new StringBuilder();
        b.ensureCapacity(this.list.size() * 50);
        b.append("Last100ErrorMessages");
        for (Pair<Long, String> e : this.list) {
            b.append("\n");
            b.append(this.sdf.format(new Date((Long)e.first))).append(" : ").append((String)e.second);
        }
        return b.toString();
    }
}

