/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.tools;

import ca.infodata.dsq.domain.Address;
import ca.infodata.dsq.domain.Annotation;
import ca.infodata.dsq.domain.BasicProvider;
import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.College;
import ca.infodata.dsq.domain.DetectedIssueEvent;
import ca.infodata.dsq.domain.DetectedIssueManagement;
import ca.infodata.dsq.domain.DosageInstruction;
import ca.infodata.dsq.domain.DosageLine;
import ca.infodata.dsq.domain.Duration;
import ca.infodata.dsq.domain.HistoryStatusChange;
import ca.infodata.dsq.domain.ILocation;
import ca.infodata.dsq.domain.IProvider;
import ca.infodata.dsq.domain.Id;
import ca.infodata.dsq.domain.Ingredient;
import ca.infodata.dsq.domain.Location2;
import ca.infodata.dsq.domain.Medication;
import ca.infodata.dsq.domain.MedicationDispense;
import ca.infodata.dsq.domain.NAM;
import ca.infodata.dsq.domain.NAS;
import ca.infodata.dsq.domain.NIU;
import ca.infodata.dsq.domain.NIU_COLLEGE;
import ca.infodata.dsq.domain.NIU_I;
import ca.infodata.dsq.domain.NIU_IPC;
import ca.infodata.dsq.domain.NIU_LDS;
import ca.infodata.dsq.domain.NIU_LDS_MSSS;
import ca.infodata.dsq.domain.NIU_LDS_RAMQ;
import ca.infodata.dsq.domain.NIU_LDS_RAMQ_FACTURATION;
import ca.infodata.dsq.domain.NIU_ODS;
import ca.infodata.dsq.domain.NIU_OTHER_MEDICATION_DM;
import ca.infodata.dsq.domain.NIU_RAMQ;
import ca.infodata.dsq.domain.NIU_SH;
import ca.infodata.dsq.domain.NIU_U;
import ca.infodata.dsq.domain.Organisation;
import ca.infodata.dsq.domain.OtherMedicationDetail;
import ca.infodata.dsq.domain.OtherMedicationSummary;
import ca.infodata.dsq.domain.OtherNIU;
import ca.infodata.dsq.domain.PrescriptionDrugDetails;
import ca.infodata.dsq.domain.PrescriptionDrugSummary;
import ca.infodata.dsq.domain.Quantity;
import ca.infodata.dsq.domain.QuantityObservation;
import ca.infodata.dsq.domain.ReferenceProtocol;
import ca.infodata.dsq.domain.Refusal;
import ca.infodata.dsq.domain.RefusalReason;
import ca.infodata.dsq.domain.SubstanceAdministration;
import ca.infodata.dsq.domain.SubstitutionMade;
import ca.infodata.dsq.domain.SupplyEventSummary;
import ca.infodata.dsq.domain.SupplyRequestItem;
import ca.infodata.dsq.domain.TherapeuticIntent;
import ca.infodata.dsq.domain.ValueWithUnit;
import ca.infodata.dsq.domain.ValueWithUnit2;
import ca.infodata.dsq.service.RequestFault;
import ca.infodata.dsq.service.Transaction;
import ca.infodata.dsq.service.UnexpectedXMLResponseFormatException;
import ca.infodata.dsq.service.UnexpectedXMLResponseFormatWarning;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.dsq.siir.squil.List.QUQIMT120006QCQueryAck;
import ca.infodata.dsq.tools.DocumentBuilderFactoryCache;
import ca.infodata.dsq.tools.Helper;
import ca.infodata.dsq.tools.IgnoreAllErrorHandler;
import ca.infodata.dsq.tools.JoinList;
import ca.infodata.dsq.tools.RequestHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hl7.v3.dm.CD;
import org.hl7.v3.dm.COCTMT090302CAAssignedDevice;
import org.hl7.v3.dm.COCTMT120402CAObservationProblem;
import org.hl7.v3.dm.COCTMT120402CAOtherIndication;
import org.hl7.v3.dm.COCTMT260030CAConsumable;
import org.hl7.v3.dm.COCTMT260030CADetectedIssueEvent;
import org.hl7.v3.dm.COCTMT260030CASubject2;
import org.hl7.v3.dm.COCTMT260030CASubstanceAdministration;
import org.hl7.v3.dm.COCTMT270010CAComponent;
import org.hl7.v3.dm.COCTMT270010CAComponent17;
import org.hl7.v3.dm.COCTMT270010CAComponent18;
import org.hl7.v3.dm.COCTMT270010CAConsumable1;
import org.hl7.v3.dm.COCTMT270010CADosageInstruction;
import org.hl7.v3.dm.COCTMT270010CADosageLine;
import org.hl7.v3.dm.COCTMT270010CASupplementalInstruction;
import org.hl7.v3.dm.COCTMT270010CATrigger;
import org.hl7.v3.dm.CV;
import org.hl7.v3.dm.II;
import org.hl7.v3.dm.INT;
import org.hl7.v3.dm.IVLTS;
import org.hl7.v3.dm.NullFlavor;
import org.hl7.v3.dm.PORXIN060260CAQCV01QUQIMT120006CASubject2;
import org.hl7.v3.dm.PORXMT030040CAAdministrationInstructions;
import org.hl7.v3.dm.PORXMT030040CACombinedMedicationRequest;
import org.hl7.v3.dm.PORXMT030040CADirectTarget;
import org.hl7.v3.dm.PORXMT030040CALocation2;
import org.hl7.v3.dm.PORXMT030040CAPrecondition;
import org.hl7.v3.dm.PORXMT030040CASubject;
import org.hl7.v3.dm.PORXMT030040CASubject2;
import org.hl7.v3.dm.PORXMT030040CASupplyEventFirstSummary;
import org.hl7.v3.dm.PORXMT030040CASupplyEventFutureSummary;
import org.hl7.v3.dm.PORXMT030040CASupplyEventLastSummary;
import org.hl7.v3.dm.PORXMT030040CASupplyEventPastSummary;
import org.hl7.v3.dm.PORXMT030040CASupplyRequest;
import org.hl7.v3.dm.PORXMT030040CAWorkingListEvent;
import org.hl7.v3.dm.PORXMT060190CAAdministrationInstructions;
import org.hl7.v3.dm.PORXMT060190CACombinedMedicationRequest;
import org.hl7.v3.dm.PORXMT060190CADirectTarget;
import org.hl7.v3.dm.PORXMT060190CALocation3;
import org.hl7.v3.dm.PORXMT060190CAOtherMedication;
import org.hl7.v3.dm.PORXMT060190CAPrecondition;
import org.hl7.v3.dm.PORXMT060190CASubject;
import org.hl7.v3.dm.PORXMT060190CASubject2;
import org.hl7.v3.dm.PORXMT060190CASubject7;
import org.hl7.v3.dm.PORXMT060190CASupplyEventFirstSummary;
import org.hl7.v3.dm.PORXMT060190CASupplyEventFutureSummary;
import org.hl7.v3.dm.PORXMT060190CASupplyEventLastSummary;
import org.hl7.v3.dm.PORXMT060190CASupplyEventPastSummary;
import org.hl7.v3.dm.PORXMT060190CASupplyRequest;
import org.hl7.v3.dm.PORXMT060190CAWorkingListEvent;
import org.hl7.v3.dm.PORXMT060210CAAuthor7;
import org.hl7.v3.dm.PORXMT060210CAComponent;
import org.hl7.v3.dm.PORXMT060210CAControlActEvent;
import org.hl7.v3.dm.PORXMT060210CAOtherMedication;
import org.hl7.v3.dm.PORXMT060210CASubject11;
import org.hl7.v3.dm.PORXMT060340CAAuthor1;
import org.hl7.v3.dm.PORXMT060340CACombinedMedicationRequest;
import org.hl7.v3.dm.PORXMT060340CAComponent1;
import org.hl7.v3.dm.PORXMT060340CAComponent11;
import org.hl7.v3.dm.PORXMT060340CAComponent13;
import org.hl7.v3.dm.PORXMT060340CAComponent2;
import org.hl7.v3.dm.PORXMT060340CAComponent3;
import org.hl7.v3.dm.PORXMT060340CAComponent7;
import org.hl7.v3.dm.PORXMT060340CAControlActEvent;
import org.hl7.v3.dm.PORXMT060340CADerivedFrom;
import org.hl7.v3.dm.PORXMT060340CADirectTarget;
import org.hl7.v3.dm.PORXMT060340CAInFulfillmentOf1;
import org.hl7.v3.dm.PORXMT060340CAInitialSupplyRequest;
import org.hl7.v3.dm.PORXMT060340CALocation4;
import org.hl7.v3.dm.PORXMT060340CAMedicationDispense;
import org.hl7.v3.dm.PORXMT060340CAPertinentInformation;
import org.hl7.v3.dm.PORXMT060340CAPrecondition;
import org.hl7.v3.dm.PORXMT060340CAPredecessor;
import org.hl7.v3.dm.PORXMT060340CAPriorCombinedMedicationRequest;
import org.hl7.v3.dm.PORXMT060340CAProduct1;
import org.hl7.v3.dm.PORXMT060340CAResponsibleParty;
import org.hl7.v3.dm.PORXMT060340CASubject2;
import org.hl7.v3.dm.PORXMT060340CASubject8;
import org.hl7.v3.dm.PORXMT060340CASubsequentSupplyRequest;
import org.hl7.v3.dm.PORXMT060340CASubstitutionMade;
import org.hl7.v3.dm.PORXMT060340CASubstitutionPermission;
import org.hl7.v3.dm.PORXMT060340CASupplyEvent;
import org.hl7.v3.dm.PORXMT060340CASupplyEventFirstSummary;
import org.hl7.v3.dm.PORXMT060340CASupplyEventFutureSummary;
import org.hl7.v3.dm.PORXMT060340CASupplyEventLastSummary;
import org.hl7.v3.dm.PORXMT060340CASupplyEventPastSummary;
import org.hl7.v3.dm.PORXMT060340CASupplyRequest;
import org.hl7.v3.dm.PORXMT060340CASupplyRequestItem;
import org.hl7.v3.dm.QUQIMT120006CAQueryAck;
import org.hl7.v3.dm.RTOPQPQ;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class ResponseHelper {
    private static String getAddress(Object ad, String ... fields) {
        if (ad != null) {
            if (ResponseHelper.isInstanceOf(ad, "AD")) {
                try {
                    Collection c;
                    if (Helper.hasMethod(ad, "getContent")) {
                        c = (Collection)Helper.invoke(ad, "getContent");
                    } else if (Helper.hasMethod(ad, "getDelimiterOrCountryOrState")) {
                        c = (Collection)Helper.invoke(ad, "getDelimiterOrCountryOrState");
                    } else {
                        throw new RuntimeException("ad does not have getContent or getDelimiterOrCountryOrState methods");
                    }
                    for (Object o : c) {
                        if (o instanceof JAXBElement) {
                            o = ((JAXBElement)o).getValue();
                        }
                        for (int i = 0; i < fields.length; ++i) {
                            if (!ResponseHelper.isInstanceOf(o, fields[i])) continue;
                            return (String)Helper.invoke(o, "getTextValue");
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw new ClassCastException("invalid class");
            }
        }
        return null;
    }

    public static String getStreet(Object ad) {
        if (ad == null || ResponseHelper.isNullFlavored(ad)) {
            return null;
        }
        if (Helper.hasMethod(ad, "getContent")) {
            return ResponseHelper.getFirst((Collection)Helper.invoke(ad, "getContent"), String.class);
        }
        if (Helper.hasMethod(ad, "getDelimiterOrCountryOrState")) {
            return ResponseHelper.getAddress(ad, "getDelimiterOrCountryOrState", "StreetAddressLine");
        }
        throw new RuntimeException("ad does not have getContent or getDelimiterOrCountryOrState methods");
    }

    public static boolean isNullFlavored(Object o) {
        try {
            if (Helper.hasMethod(o, "getNullFlavor")) {
                Object nullFlavor = Helper.invoke(o, "getNullFlavor");
                if (nullFlavor instanceof Collection) {
                    Collection collection = (Collection)nullFlavor;
                    return !collection.isEmpty();
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getCity(Object ad) {
        return ResponseHelper.getAddress(ad, "AdxpCity", "City");
    }

    public static String getState(Object ad) {
        String s = ResponseHelper.getAddress(ad, "AdxpState", "State");
        return s == null ? "" : s;
    }

    public static String getCountry(Object ad) {
        String s = ResponseHelper.getAddress(ad, "AdxpCountry", "Country");
        return s == null ? "" : s;
    }

    public static String getPostalCode(Object ad) {
        return ResponseHelper.getAddress(ad, "AdxpPostalCode", "PostalCode");
    }

    private static String getName(Object pn, String field, String method) {
        if (pn != null) {
            if (ResponseHelper.isInstanceOf(pn, "PN")) {
                try {
                    Collection c = (Collection)Helper.invoke(pn, method);
                    for (Object o : c) {
                        if (o instanceof JAXBElement) {
                            o = ((JAXBElement)o).getValue();
                        }
                        if (o == null || !ResponseHelper.isInstanceOf(o, field)) continue;
                        return ResponseHelper.getString(o);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw new ClassCastException("invalid class");
            }
        }
        return null;
    }

    public static String getLastName(Object pn) {
        return ResponseHelper.getName(pn, "EnFamily", "getDelimiterOrFamilyOrGiven");
    }

    public static String getFirstName(Object pn) {
        return ResponseHelper.getName(pn, "EnGiven", "getDelimiterOrFamilyOrGiven");
    }

    public static String getLastNameWithGetContent(Object pn) {
        return ResponseHelper.getName(pn, "EnFamily", "getContent");
    }

    public static String getFirstNameWithGetContent(Object pn) {
        return ResponseHelper.getName(pn, "EnGiven", "getContent");
    }

    public static String getString(Object st) {
        Object text;
        Object content;
        if (st == null) {
            return null;
        }
        if (st instanceof String) {
            return (String)st;
        }
        if (Helper.hasMethod(st, "getContent") && (content = Helper.invoke(st, "getContent")) instanceof List) {
            return Helper.getContent((List)content);
        }
        if (ResponseHelper.isInstanceOfCascade(st, "EN")) {
            Collection list = (Collection)Helper.invoke(st, "getContent");
            if (list.isEmpty()) {
                return null;
            }
            return ResponseHelper.getString(list.iterator().next());
        }
        if (Helper.hasMethod(st, "getText") && (text = Helper.invoke(st, "getText")) != null) {
            if (text instanceof String[]) {
                return ResponseHelper.toString((String[])text);
            }
            return (String)text;
        }
        if (Helper.hasMethod(st, "getTextValue") && (text = Helper.invoke(st, "getTextValue")) != null) {
            if (text instanceof String[]) {
                return ResponseHelper.toString((String[])text);
            }
            return (String)text;
        }
        if (Helper.hasMethod(st, "getValue") && (text = Helper.invoke(st, "getValue")) != null) {
            if (text instanceof String[]) {
                return ResponseHelper.toString((String[])text);
            }
            return (String)text;
        }
        return null;
    }

    private static String toString(String[] array) {
        JoinList list = new JoinList(" ");
        for (String s : array) {
            list.add(s);
        }
        return list.toString();
    }

    public static Integer getInteger(INT a) {
        return a == null ? null : (a.getValue() == null ? null : Integer.valueOf(a.getValue().intValue()));
    }

    public static String getHigh(IVLTS ivlts) {
        if (ivlts == null) {
            return null;
        }
        return ResponseHelper.getHigh(ivlts.getRest());
    }

    public static String getLow(IVLTS ivlts) {
        if (ivlts == null) {
            return null;
        }
        return ResponseHelper.getLow(ivlts.getRest());
    }

    public static String getHigh(Collection valueBasedObjects) {
        if (valueBasedObjects != null) {
            for (Object t : valueBasedObjects) {
                if (t == null || !((JAXBElement)t).getName().getLocalPart().equalsIgnoreCase("high")) continue;
                return (String)Helper.invoke(((JAXBElement)t).getValue(), "getValue");
            }
        }
        return null;
    }

    public static String getHighUnit(Collection valueBasedObjects) {
        if (valueBasedObjects != null) {
            for (Object t : valueBasedObjects) {
                if (t == null || !((JAXBElement)t).getName().getLocalPart().equalsIgnoreCase("high")) continue;
                return (String)Helper.invoke(((JAXBElement)t).getValue(), "getUnit");
            }
        }
        return null;
    }

    public static Quantity getLowQuantity(Collection valueBasedObjects) {
        if (valueBasedObjects != null) {
            for (Object t : valueBasedObjects) {
                if (!((JAXBElement)t).getName().getLocalPart().equalsIgnoreCase("low")) continue;
                Object value = Helper.invoke(((JAXBElement)t).getValue(), "getValue");
                String unit = (String)Helper.invoke(((JAXBElement)t).getValue(), "getUnit");
                if (value == null || Helper.isBlank(unit) || (value = Helper.parse(value)) == null) continue;
                return new Quantity((Number)value, unit);
            }
        }
        return null;
    }

    public static Quantity getHighQuantity(Collection valueBasedObjects) {
        if (valueBasedObjects != null) {
            for (Object t : valueBasedObjects) {
                if (!((JAXBElement)t).getName().getLocalPart().equalsIgnoreCase("high")) continue;
                Object value = Helper.invoke(((JAXBElement)t).getValue(), "getValue");
                String unit = (String)Helper.invoke(((JAXBElement)t).getValue(), "getUnit");
                if (value == null || Helper.isBlank(unit) || (value = Helper.parse(value)) == null) continue;
                return new Quantity((Number)value, unit);
            }
        }
        return null;
    }

    public static String getCenter(Collection valueBasedObjects) {
        if (valueBasedObjects != null) {
            for (Object t : valueBasedObjects) {
                if (!((JAXBElement)t).getName().getLocalPart().equalsIgnoreCase("center")) continue;
                return (String)Helper.invoke(((JAXBElement)t).getValue(), "getValue");
            }
        }
        return null;
    }

    public static String getLow(Collection valueBasedObjects) {
        if (valueBasedObjects != null) {
            for (Object t : valueBasedObjects) {
                if (!((JAXBElement)t).getName().getLocalPart().equalsIgnoreCase("low")) continue;
                return (String)Helper.invoke(((JAXBElement)t).getValue(), "getValue");
            }
        }
        return null;
    }

    public static String getLowUnit(Collection valueBasedObjects) {
        if (valueBasedObjects != null) {
            for (Object t : valueBasedObjects) {
                if (!((JAXBElement)t).getName().getLocalPart().equalsIgnoreCase("low")) continue;
                return (String)Helper.invoke(((JAXBElement)t).getValue(), "getUnit");
            }
        }
        return null;
    }

    public static String getHighComp(Collection valueBasedObjects) {
        if (valueBasedObjects != null) {
            for (Object t : valueBasedObjects) {
                if (!ResponseHelper.isInstanceOf(t, "IVLTS")) continue;
                return ResponseHelper.getHigh((Collection)Helper.invoke(t, "getRest"));
            }
        }
        return null;
    }

    public static String getLowComp(Collection valueBasedObjects) {
        if (valueBasedObjects != null) {
            for (Object t : valueBasedObjects) {
                if (!ResponseHelper.isInstanceOf(t, "IVLTS")) continue;
                return ResponseHelper.getLow((Collection)Helper.invoke(t, "getRest"));
            }
        }
        return null;
    }

    public static BigInteger getNumeratorComp(Collection comp) {
        if (comp != null) {
            for (Object t : comp) {
                if (!ResponseHelper.isInstanceOf(t, "PIVLTS")) continue;
                return (BigInteger)Helper.invoke(t, "getFrequency", "getNumerator", "getValue");
            }
        }
        return null;
    }

    public static String getDenomiratorComp(Collection comp) {
        if (comp != null) {
            for (Object t : comp) {
                if (!ResponseHelper.isInstanceOf(t, "PIVLTS")) continue;
                return (String)Helper.invoke(t, "getFrequency", "getDenominator", "getValue");
            }
        }
        return null;
    }

    public static String getDenomiratorCompUnit(Collection comp) {
        if (comp != null) {
            for (Object t : comp) {
                if (!ResponseHelper.isInstanceOf(t, "PIVLTS")) continue;
                return (String)Helper.invoke(t, "getFrequency", "getDenominator", "getUnit");
            }
        }
        return null;
    }

    public static String getNumeratorCompUnit(Collection comp) {
        if (comp != null) {
            for (Object t : comp) {
                if (!ResponseHelper.isInstanceOf(t, "PIVLTS")) continue;
                return (String)Helper.invoke(t, "getFrequency", "getNumerator", "getTextValue");
            }
        }
        return null;
    }

    public static String getWidthElementValue(Collection valueBasedObjects) {
        if (valueBasedObjects != null) {
            for (Object t : valueBasedObjects) {
                if (!((JAXBElement)t).getName().getLocalPart().equalsIgnoreCase("width")) continue;
                return (String)Helper.invoke(((JAXBElement)t).getValue(), "getValue");
            }
        }
        return null;
    }

    public static String getCenterElementValue(Collection valueBasedObjects) {
        if (valueBasedObjects != null) {
            for (Object t : valueBasedObjects) {
                if (!((JAXBElement)t).getName().getLocalPart().equalsIgnoreCase("center")) continue;
                return (String)Helper.invoke(((JAXBElement)t).getValue(), "getValue");
            }
        }
        return null;
    }

    public static String getWidthElementUnit(Collection valueBasedObjects) {
        if (valueBasedObjects != null) {
            for (Object t : valueBasedObjects) {
                if (!((JAXBElement)t).getName().getLocalPart().equalsIgnoreCase("width")) continue;
                return (String)Helper.invoke(((JAXBElement)t).getValue(), "getUnit");
            }
        }
        return null;
    }

    public static <T> T getFirst(Collection col, Class<T> c) {
        if (col != null) {
            for (Object o : col) {
                if (o == null && c == null) {
                    return (T)o;
                }
                if (o == null || c == null || !o.getClass().isAssignableFrom(c)) continue;
                return (T)o;
            }
        }
        return null;
    }

    public static String getFirstTelecom(Object tels) {
        if (tels != null) {
            if (tels instanceof Collection) {
                Iterator iterator = ((Collection)tels).iterator();
                if (iterator.hasNext()) {
                    return ResponseHelper.getTelecom(iterator.next());
                }
            } else {
                return ResponseHelper.getTelecom(tels);
            }
        }
        return null;
    }

    private static String getTelecom(Object tel) {
        return (String)Helper.invoke(tel, "getValue");
    }

    private static boolean isInstanceOfCascade(Object o, String shortClassName) {
        boolean b;
        if (o == null) {
            return false;
        }
        Class<?> c = o.getClass();
        do {
            String name;
            int i;
            if ((i = (name = c.getName()).lastIndexOf(36)) == -1) {
                i = name.lastIndexOf(46);
            }
            b = name.substring(i + 1).equals(shortClassName);
            c = c.getSuperclass();
        } while (!b && c != null);
        return b;
    }

    private static boolean isInstanceOf(Object o, String shortClassName) {
        if (o == null) {
            return false;
        }
        String name = o.getClass().getName();
        int i = name.lastIndexOf(36);
        if (i == -1) {
            i = name.lastIndexOf(46);
        }
        return name.substring(i + 1).equals(shortClassName);
    }

    public static ILocation getLocation(Object location) {
        ILocation ilocation = null;
        if (location != null) {
            Object lds = location;
            if (Helper.hasMethod(location, "getServiceDeliveryLocation")) {
                lds = Helper.invoke(location, "getServiceDeliveryLocation");
            }
            if (lds != null) {
                String code = null;
                Id id = ResponseHelper.getFirstId(Helper.invoke(lds, "getId"));
                String name = Helper.hasMethod(lds, "getName") ? ResponseHelper.getString(Helper.invoke(lds, "getName")) : ResponseHelper.getString(Helper.invoke(lds, "getLocation", "getName"));
                if (Helper.hasMethod(lds, "getCode")) {
                    code = (String)Helper.invoke(lds, "getCode", "getCode");
                }
                Object addr = ResponseHelper.getFirstAddr(lds);
                String street = ResponseHelper.getStreet(addr);
                String city = ResponseHelper.getCity(addr);
                String state = ResponseHelper.getState(addr);
                String zip = ResponseHelper.getPostalCode(addr);
                String country = ResponseHelper.getCountry(addr);
                String telecom = ResponseHelper.getFirstTelecom(Helper.invoke(lds, "getTelecom"));
                if (id != null) {
                    return new Location2(new NIU_LDS(id.extension.trim()), name, code, new Address(street, zip, city, state, country, telecom));
                }
            }
        }
        return ilocation;
    }

    private static Object getFirstAddr(Object lds) {
        Object addr = Helper.invoke(lds, "getAddr");
        if (addr instanceof List) {
            List list = (List)addr;
            if (list.isEmpty()) {
                return null;
            }
            return list.get(0);
        }
        return addr;
    }

    public static IProvider getAuthor(Object author) {
        IProvider provider = null;
        if (author != null) {
            if (Helper.hasMethod(author, "getAssignedEntity") || Helper.hasMethod(author, "getAssignedEntity1") || Helper.hasMethod(author, "getAssignedEntity2") || Helper.hasMethod(author, "getAssignedEntity3")) {
                provider = ResponseHelper.getProviderAssignedEntity(author);
            } else if (Helper.hasMethod(author, "getAssignedPerson")) {
                provider = ResponseHelper.getProviderAssignedPerson(author);
            } else if (Helper.hasMethod(author, "getChangedBy")) {
                provider = ResponseHelper.getProviderAssignedPersonWithChangedByElement(author);
            }
        }
        return provider;
    }

    private static IProvider getProviderAssignedPersonWithChangedByElement(Object author) {
        BasicProvider provider = null;
        if (author != null) {
            String id = null;
            String firstName = null;
            String lastName = null;
            String licenceId = null;
            String licenceOid = null;
            Object entity = Helper.invoke(author, "getChangedBy");
            Object person = Helper.invoke(entity, "getAssignedPerson");
            Object representedPerson = Helper.invoke(entity, "getRepresentedPerson");
            if (person != null) {
                Object ids = Helper.invoke(person, "getId");
                if (ResponseHelper.isInstanceOf(ids, "II")) {
                    id = (String)Helper.invoke(ids, "getExtension");
                } else if (ids instanceof Collection) {
                    for (Object ii : (Collection)ids) {
                        NIU niuII = ResponseHelper.getNIU((String)Helper.invoke(ii, "getRoot"), (String)Helper.invoke(ii, "getExtension"));
                        if (!(niuII instanceof NIU_I)) continue;
                        id = niuII.value();
                    }
                }
            }
            if (representedPerson != null) {
                Object ids;
                Object name = Helper.invoke(representedPerson, "getName");
                if (Helper.hasMethod(name, "getContent")) {
                    firstName = ResponseHelper.getFirstNameWithGetContent(name);
                    lastName = ResponseHelper.getLastNameWithGetContent(name);
                } else if (Helper.hasMethod(name, "getDelimiterOrFamilyOrGiven")) {
                    firstName = ResponseHelper.getFirstName(name);
                    lastName = ResponseHelper.getLastName(name);
                }
                Object asLicensedEntity = Helper.invoke(representedPerson, "getAsLicensedEntity");
                if (asLicensedEntity instanceof JAXBElement) {
                    asLicensedEntity = ((JAXBElement)asLicensedEntity).getValue();
                }
                if (asLicensedEntity != null && ResponseHelper.isInstanceOf(ids = Helper.invoke(asLicensedEntity, "getId"), "II")) {
                    licenceOid = (String)Helper.invoke(ids, "getRoot");
                    licenceId = (String)Helper.invoke(ids, "getExtension");
                }
            }
            if (firstName != null && lastName != null) {
                provider = new BasicProvider(id == null || "NI".equals(id) ? null : new NIU_I(id), licenceId == null | licenceOid == null || "NI".equals(licenceId) ? null : new NIU_COLLEGE(licenceOid, licenceId), firstName, lastName);
            }
        }
        return provider;
    }

    private static IProvider getProviderAssignedPerson(Object author) {
        BasicProvider provider = null;
        if (author != null) {
            Object representedPerson;
            String id = null;
            String firstName = null;
            String lastName = null;
            String licenceId = null;
            String licenceOid = null;
            Object person = Helper.invoke(author, "getAssignedPerson");
            if (person != null) {
                Object ids = Helper.invoke(person, "getId");
                if (ResponseHelper.isInstanceOf(ids, "II")) {
                    id = (String)Helper.invoke(ids, "getExtension");
                } else if (ids instanceof Collection) {
                    for (Object ii : (Collection)ids) {
                        NIU niuII = ResponseHelper.getNIU((String)Helper.invoke(ii, "getRoot"), (String)Helper.invoke(ii, "getExtension"));
                        if (!(niuII instanceof NIU_I)) continue;
                        id = niuII.value();
                    }
                }
            }
            if ((representedPerson = Helper.invoke(person, "getRepresentedPerson")) != null) {
                Object ids;
                Object name = Helper.invoke(representedPerson, "getName");
                if (Helper.hasMethod(name, "getContent")) {
                    firstName = ResponseHelper.getFirstNameWithGetContent(name);
                    lastName = ResponseHelper.getLastNameWithGetContent(name);
                } else if (Helper.hasMethod(name, "getDelimiterOrFamilyOrGiven")) {
                    firstName = ResponseHelper.getFirstName(name);
                    lastName = ResponseHelper.getLastName(name);
                }
                Object asLicensedEntity = Helper.invoke(representedPerson, "getAsLicensedEntity");
                if (asLicensedEntity instanceof JAXBElement) {
                    asLicensedEntity = ((JAXBElement)asLicensedEntity).getValue();
                }
                if (asLicensedEntity != null && ResponseHelper.isInstanceOf(ids = Helper.invoke(asLicensedEntity, "getId"), "II")) {
                    licenceOid = (String)Helper.invoke(ids, "getRoot");
                    licenceId = (String)Helper.invoke(ids, "getExtension");
                }
            }
            if (firstName != null && lastName != null) {
                provider = new BasicProvider(id == null || "NI".equals(id) ? null : new NIU_I(id.trim()), licenceId == null | licenceOid == null || "NI".equals(licenceId) ? null : new NIU_COLLEGE(licenceOid, licenceId), firstName, lastName);
            }
        }
        return provider;
    }

    private static IProvider getProviderAssignedEntity(Object author) {
        BasicProvider provider = null;
        if (author != null) {
            String id = null;
            String firstName = null;
            String lastName = null;
            String licenceId = null;
            String licenceOid = null;
            Location2 location = null;
            Code code = null;
            Object entity = null;
            boolean methodFound = false;
            if (Helper.hasMethod(author, "getAssignedEntity3")) {
                entity = Helper.invoke(author, "getAssignedEntity3");
                methodFound = true;
            }
            if (entity == null && Helper.hasMethod(author, "getAssignedEntity2")) {
                entity = Helper.invoke(author, "getAssignedEntity2", "getValue");
                methodFound = true;
            }
            if (entity == null && Helper.hasMethod(author, "getAssignedEntity1")) {
                entity = Helper.invoke(author, "getAssignedEntity1");
                methodFound = true;
            }
            if (entity == null && Helper.hasMethod(author, "getAssignedEntity")) {
                entity = Helper.invoke(author, "getAssignedEntity");
                methodFound = true;
            }
            if (!methodFound) {
                throw new IllegalArgumentException();
            }
            if (entity != null) {
                Object person;
                Object ids = Helper.invoke(entity, "getId");
                if (ResponseHelper.isInstanceOf(ids, "II")) {
                    id = (String)Helper.invoke(ids, "getExtension");
                } else if (ids instanceof Collection) {
                    for (Object ii : (Collection)ids) {
                        NIU niuII = ResponseHelper.getNIU((String)Helper.invoke(ii, "getRoot"), (String)Helper.invoke(ii, "getExtension"));
                        if (!(niuII instanceof NIU_I)) continue;
                        id = niuII.value();
                    }
                }
                if (Helper.hasMethod(entity, "getCode")) {
                    Object rawCode = Helper.invoke(entity, "getCode");
                    code = ResponseHelper.getCode(rawCode);
                }
                if ((person = Helper.invoke(entity, "getAssignedPerson")) != null) {
                    Object name = Helper.invoke(person, "getName");
                    if (Helper.hasMethod(name, "getContent")) {
                        firstName = ResponseHelper.getFirstNameWithGetContent(name);
                        lastName = ResponseHelper.getLastNameWithGetContent(name);
                    } else if (Helper.hasMethod(name, "getDelimiterOrFamilyOrGiven")) {
                        firstName = ResponseHelper.getFirstName(name);
                        lastName = ResponseHelper.getLastName(name);
                    }
                    Object asHealthCareProvider = Helper.invoke(person, "getAsHealthCareProvider");
                    if (asHealthCareProvider instanceof JAXBElement) {
                        asHealthCareProvider = ((JAXBElement)asHealthCareProvider).getValue();
                    }
                    if (asHealthCareProvider != null && ResponseHelper.isInstanceOf(ids = Helper.invoke(asHealthCareProvider, "getId"), "II")) {
                        licenceOid = (String)Helper.invoke(ids, "getRoot");
                        licenceId = (String)Helper.invoke(ids, "getExtension");
                    }
                }
                if (Helper.hasMethod(entity, "getRepresentedOrganization")) {
                    Object organisation = ResponseHelper.invokeNJax(entity, "getRepresentedOrganization");
                    NIU organisationId = ResponseHelper.getNIU(Helper.invoke(organisation, "getId"));
                    String organisationName = ResponseHelper.getString(Helper.invoke(organisation, "getName"));
                    if (organisationId != null) {
                        location = new Location2(organisationId, organisationName, null, null);
                    }
                }
            }
            if (firstName != null && lastName != null) {
                provider = new BasicProvider(id == null || "NI".equals(id) ? null : new NIU_I(id), licenceId == null | licenceOid == null || "NI".equals(licenceId) ? null : new NIU_COLLEGE(licenceOid, licenceId), firstName, lastName, location, code);
            }
        }
        return provider;
    }

    public static Organisation getOrganisation(Object raw) {
        Organisation org = null;
        if (raw != null) {
            Object entity = Helper.hasMethod(raw, "getAssignedEntity4") ? Helper.invoke(raw, "getAssignedEntity4") : (Helper.hasMethod(raw, "getAssignedEntity") ? Helper.invoke(raw, "getAssignedEntity") : raw);
            if (Helper.hasMethod(entity, "getRepresentedOrganization") && (entity = Helper.invoke(entity, "getRepresentedOrganization")) != null) {
                NIU niu = ResponseHelper.getNIU(Helper.invoke(entity, "getId"));
                String name = ResponseHelper.getString(Helper.invoke(entity, "getName"));
                org = new Organisation(niu, name);
            }
        }
        return org;
    }

    public static Medication getMedication(Object medication) {
        Medication m = null;
        if (ResponseHelper.isNotNull(medication)) {
            if (Helper.hasMethod(medication, "getPlayer")) {
                medication = Helper.invoke(medication, "getPlayer");
            } else if (Helper.hasMethod(medication, "getAdministerableMedicine")) {
                medication = Helper.invoke(medication, "getAdministerableMedicine");
            }
            Code code = null;
            String name = null;
            String desc = null;
            Code formCode = null;
            Quantity packageQuantity = null;
            Code packageContainerCode = null;
            ArrayList<Ingredient> ingredients = null;
            String lotNumberText = null;
            String expirationTime = null;
            code = ResponseHelper.getCode(Helper.invoke(medication, "getCode"));
            name = (String)Helper.invoke(medication, "getName", "getTextValue");
            desc = (String)Helper.invoke(medication, "getDesc", "getTextValue");
            formCode = ResponseHelper.getCode(Helper.invoke(medication, "getFormCode"));
            if (Helper.hasMethod(medication, "getAsContent")) {
                Object containerPackagedMedicine;
                Object content = Helper.invoke(medication, "getAsContent", "getValue");
                packageQuantity = ResponseHelper.getQuantity(Helper.invoke(content, "getQuantity"));
                if (Helper.hasMethod(content, "getContainerPackagedMedicine") && ResponseHelper.isNotNull(containerPackagedMedicine = Helper.invoke(content, "getContainerPackagedMedicine"))) {
                    if (ResponseHelper.isInstanceOf(containerPackagedMedicine, "JAXBElement")) {
                        containerPackagedMedicine = Helper.invoke(containerPackagedMedicine, "getValue");
                    }
                    packageContainerCode = ResponseHelper.getCode(Helper.invoke(containerPackagedMedicine, "getFormCode"));
                }
            }
            if (Helper.hasMethod(medication, "getLotNumberText")) {
                lotNumberText = ResponseHelper.getString(Helper.invoke(medication, "getLotNumberText"));
            }
            if (Helper.hasMethod(medication, "getExpirationTime")) {
                expirationTime = ResponseHelper.getHigh((IVLTS)Helper.invoke(medication, "getExpirationTime"));
            }
            if (Helper.invoke(medication, "getIngredient") != null) {
                ingredients = new ArrayList<Ingredient>();
                List rawIngredients = (List)Helper.invoke(medication, "getIngredient");
                for (Object rawIngredient : rawIngredients) {
                    ingredients.add(ResponseHelper.getIngredient(rawIngredient));
                }
            }
            m = new Medication();
            m.code = code;
            m.name = name;
            m.description = desc;
            m.formCode = formCode;
            m.packageQuantity = packageQuantity;
            m.packageContainerFormCode = packageContainerCode;
            m.ingredients = ingredients;
            m.lotNumberText = lotNumberText;
            m.expirationTime = expirationTime;
        }
        return m;
    }

    public static Ingredient getIngredient(Object rawIngredient) {
        Code icode = null;
        String iname = null;
        String iprotocolIdentifier = null;
        Boolean inegation = null;
        Quantity iquantity = null;
        icode = ResponseHelper.getCode(Helper.invoke(rawIngredient, "getIngredient", "getCode"));
        iname = (String)Helper.invoke(rawIngredient, "getIngredient", "getName", "getTextValue");
        iquantity = ResponseHelper.getQuantity(Helper.invoke(rawIngredient, "getQuantity"));
        inegation = (Boolean)Helper.invoke(rawIngredient, "isNegationInd");
        if (Helper.hasMethod(rawIngredient, "getDefinition")) {
            iprotocolIdentifier = (String)Helper.invoke(rawIngredient, "getDefinition", "getValue", "getSubstanceAdministrationDefinition", "getId", "getExtension");
        }
        return new Ingredient(icode, iname, iprotocolIdentifier, inegation, iquantity);
    }

    public static ArrayList<TherapeuticIntent> getTherapeuticIntents(List<?> reasons, Transaction.TransactionBuilder<?, ?> builder) {
        ArrayList<TherapeuticIntent> intents = null;
        if (reasons != null) {
            intents = new ArrayList<TherapeuticIntent>();
            for (Object r : reasons) {
                TherapeuticIntent ti = new TherapeuticIntent();
                ti.priority = ResponseHelper.getInteger((INT)Helper.invoke(r, "getPriorityNumber"));
                boolean add = ResponseHelper.parseTherapeuticIntentObservationProblem(ti, (JAXBElement<COCTMT120402CAObservationProblem>)((JAXBElement)Helper.invoke(r, "getObservationProblem")));
                add = ResponseHelper.parseTherapeuticIntentOtherIndication(ti, (JAXBElement<COCTMT120402CAOtherIndication>)((JAXBElement)Helper.invoke(r, "getOtherIndication"))) || add;
                if (!add) continue;
                intents.add(ti);
            }
        }
        return intents;
    }

    private static boolean parseTherapeuticIntentObservationProblem(TherapeuticIntent ti, JAXBElement<COCTMT120402CAObservationProblem> raw) {
        if (raw != null && raw.getValue() != null) {
            COCTMT120402CAObservationProblem problem = (COCTMT120402CAObservationProblem)raw.getValue();
            ti.observationProblemType = ResponseHelper.getCode2(problem.getCode());
            ti.observationProblemCode = ResponseHelper.getCode2(problem.getValue());
            return true;
        }
        return false;
    }

    private static boolean parseTherapeuticIntentOtherIndication(TherapeuticIntent ti, JAXBElement<COCTMT120402CAOtherIndication> raw) {
        if (raw != null && raw.getValue() != null) {
            ti.otherIndicationCode = ResponseHelper.getCode(((COCTMT120402CAOtherIndication)raw.getValue()).getCode());
            ti.otherIndicationText = ResponseHelper.getString(((COCTMT120402CAOtherIndication)raw.getValue()).getText());
            return true;
        }
        return false;
    }

    public static ArrayList<Refusal> getRefusalsToFill(Collection<?> rawRefusals) {
        ArrayList<Refusal> refusals = null;
        if (rawRefusals != null) {
            refusals = new ArrayList<Refusal>();
            for (Object r : rawRefusals) {
                if ((r = Helper.invoke(r, "getRefusalToFill")) == null) continue;
                ILocation refusalLocation = null;
                IProvider refusalAuthor = null;
                Long refusalDate = null;
                HashSet<RefusalReason> reasons = new HashSet<RefusalReason>();
                refusalDate = Helper.parseDATETIME_NONSTRICT((String)Helper.invoke(r, "getEffectiveTime", "getValue"));
                refusalAuthor = ResponseHelper.getAuthor(Helper.invoke(r, "getAuthor"));
                refusalLocation = ResponseHelper.getLocation(Helper.invoke(r, "getLocation"));
                Collection rawReasons = (Collection)Helper.invoke(r, "getReason");
                if (rawReasons != null) {
                    for (Object rr : rawReasons) {
                        Code code = ResponseHelper.getCode(Helper.invoke(rr, "getDetectedIssueEvent", "getCode"));
                        String text = (String)Helper.invoke(rr, "getDetectedIssueEvent", "getText", "getTextValue");
                        reasons.add(new RefusalReason(code, text));
                    }
                }
                refusals.add(new Refusal(refusalDate, refusalAuthor, refusalLocation, reasons));
            }
        }
        return refusals;
    }

    public static ArrayList<Annotation> getAnnotations(Collection<?> rawAnnotations) {
        ArrayList<Annotation> annotations = null;
        if (rawAnnotations != null) {
            annotations = new ArrayList<Annotation>();
            for (Object r : rawAnnotations) {
                r = Helper.invoke(r, "getAnnotation");
                String text = (String)Helper.invoke(r, "getText", "getTextValue");
                Code languageCode = null;
                if (Helper.hasMethod(r, "getLanguageCode")) {
                    languageCode = ResponseHelper.getCode(Helper.invoke(r, "getLanguageCode"));
                }
                Long time = Helper.parseDATETIME_NONSTRICT((String)Helper.invoke(r, "getAuthor", "getTime", "getValue"));
                IProvider author = ResponseHelper.getAuthor(Helper.invoke(r, "getAuthor"));
                Organisation organisation = ResponseHelper.getOrganisation(Helper.invoke(r, "getAuthor"));
                annotations.add(new Annotation(text, time, languageCode, author, organisation));
            }
        }
        return annotations;
    }

    public static ArrayList<DetectedIssueEvent> getDetectedIssueEvents(Collection<?> rawDetectedIssueEvents, Transaction.TransactionBuilder<?, ?> builder) {
        ArrayList<DetectedIssueEvent> issues = null;
        if (rawDetectedIssueEvents != null) {
            issues = new ArrayList<DetectedIssueEvent>();
            for (Object r : rawDetectedIssueEvents) {
                Object severityObservation;
                if ((r = Helper.invoke(r, "getDetectedIssueEvent")) == null) continue;
                String text = (String)Helper.invoke(r, "getText", "getTextValue");
                Code code = ResponseHelper.getCode(Helper.invoke(r, "getCode"));
                Code statusCode = ResponseHelper.getCode(Helper.invoke(r, "getStatusCode"));
                Code priorityCode = ResponseHelper.getCode(Helper.invoke(r, "getPriorityCode"));
                Code severityOversvationValue = null;
                ArrayList<DetectedIssueManagement> managements = new ArrayList<DetectedIssueManagement>();
                Object mitigateBy = Helper.invoke(r, "getMitigatedBy");
                for (Object m : (Collection)mitigateBy) {
                    m = Helper.invoke(m, "getDetectedIssueManagement");
                    Code mCode = ResponseHelper.getCode(Helper.invoke(m, "getCode"));
                    String mText = (String)Helper.invoke(m, "getText", "getTextValue");
                    Long mTime = Helper.parseDATETIME_NONSTRICT((String)Helper.invoke(m, "getAuthor", "getTime", "getValue"));
                    Code mStatusCode = ResponseHelper.getCode(Helper.invoke(m, "getStatusCode"));
                    IProvider mAuthor = ResponseHelper.getAuthor(Helper.invoke(m, "getAuthor"));
                    managements.add(new DetectedIssueManagement(mCode, mText, mStatusCode, mAuthor, mTime));
                }
                ArrayList<SubstanceAdministration> relatedSubstanceAdministrations = new ArrayList<SubstanceAdministration>();
                if (r instanceof COCTMT260030CADetectedIssueEvent) {
                    COCTMT260030CADetectedIssueEvent coctmt260030caDetectedIssueEvent = (COCTMT260030CADetectedIssueEvent)r;
                    for (COCTMT260030CASubject2 s : coctmt260030caDetectedIssueEvent.getSubject()) {
                        if (!ResponseHelper.isNotNull(s.getSubstanceAdministration())) continue;
                        COCTMT260030CASubstanceAdministration substanceAdministration = (COCTMT260030CASubstanceAdministration)s.getSubstanceAdministration().getValue();
                        SubstanceAdministration sa = new SubstanceAdministration();
                        sa.niu = ResponseHelper.getNIU(substanceAdministration.getId());
                        sa.status = ResponseHelper.getCode(substanceAdministration.getStatusCode());
                        sa.effectiveTimeStart = ResponseHelper.getLow(substanceAdministration.getEffectiveTime());
                        sa.effectiveTimeEnd = ResponseHelper.getHigh(substanceAdministration.getEffectiveTime());
                        if (ResponseHelper.isNotNull(substanceAdministration.getConsumable())) {
                            sa.medication = ResponseHelper.getMedication(((COCTMT260030CAConsumable)substanceAdministration.getConsumable().getValue()).getMedication());
                        }
                        relatedSubstanceAdministrations.add(sa);
                    }
                }
                if ((severityObservation = Helper.invoke(r, "getSubjectOf", "getSeverityObservation")) != null) {
                    severityOversvationValue = ResponseHelper.getCode(Helper.invoke(severityObservation, "getValue"));
                }
                ResponseHelper.supposedToBeNull(Helper.invoke(r, "getInstantiation"), builder);
                issues.add(new DetectedIssueEvent(code, statusCode, priorityCode, text, managements, severityOversvationValue, relatedSubstanceAdministrations));
            }
        }
        return issues;
    }

    public static Id getFirstId(Object ii) {
        if (ii instanceof Collection) {
            Iterator iterator = ((Collection)ii).iterator();
            if (iterator.hasNext()) {
                return ResponseHelper.getId(iterator.next());
            }
        } else {
            return ResponseHelper.getId(ii);
        }
        return null;
    }

    public static Id getId(Object ii) {
        if (ResponseHelper.isNotNull(ii)) {
            Object nullFlavor = null;
            if (Helper.hasMethod(ii, "getNullFlavor")) {
                nullFlavor = Helper.invoke(ii, "getNullFlavor");
            }
            if (nullFlavor == null || nullFlavor instanceof Collection && ((Collection)nullFlavor).isEmpty() || "OTH".equals(nullFlavor.toString())) {
                String root = (String)Helper.invoke(ii, "getRoot");
                String extension = (String)Helper.invoke(ii, "getExtension");
                if (root != null && extension != null) {
                    return new Id(root, extension);
                }
            }
        }
        return null;
    }

    public static List<Id> getIds(List<?> iis, String use, Integer expectedCount) {
        ArrayList<Id> list = new ArrayList<Id>();
        for (Object ii : iis) {
            Id id = ResponseHelper.getId(ii, use);
            if (id == null) continue;
            list.add(id);
        }
        if (expectedCount != null && list.size() != expectedCount.intValue()) {
            throw new UnexpectedXMLResponseFormatException("was expecting " + expectedCount + " ids with use field = " + use + " but got " + list.size());
        }
        return list;
    }

    public static Id getId(Object ii, String use) {
        if (ResponseHelper.isNotNull(ii)) {
            Object nullFlavor = null;
            if (Helper.hasMethod(ii, "getNullFlavor")) {
                nullFlavor = Helper.invoke(ii, "getNullFlavor");
            }
            if (nullFlavor == null || nullFlavor instanceof Collection && ((Collection)nullFlavor).isEmpty() || "OTH".equals(nullFlavor.toString())) {
                String root = (String)Helper.invoke(ii, "getRoot");
                String extension = (String)Helper.invoke(ii, "getExtension");
                if (root != null) {
                    if (use != null) {
                        if (Helper.hasMethod(ii, "getUse") && use.equals(Helper.invoke(ii, "getUse"))) {
                            return new Id(root, extension);
                        }
                    } else {
                        return new Id(root, extension);
                    }
                }
            }
        }
        return null;
    }

    public static Code getCode(Object rawCode) {
        Code code = null;
        if (ResponseHelper.isNotNull(rawCode)) {
            Object nullFlavor = null;
            if (Helper.hasMethod(rawCode, "getNullFlavor")) {
                nullFlavor = Helper.invoke(rawCode, "getNullFlavor");
            }
            if (nullFlavor == null || nullFlavor instanceof Collection && ((Collection)nullFlavor).isEmpty() || "OTH".equals(nullFlavor.toString())) {
                String codeCode = (String)Helper.invoke(rawCode, "getCode");
                String codeSystem = (String)Helper.invoke(rawCode, "getCodeSystem");
                String codeText = null;
                if (Helper.hasMethod(rawCode, "getOriginalText")) {
                    codeText = ResponseHelper.getString(Helper.invoke(rawCode, "getOriginalText"));
                }
                if (Helper.isBlank(codeText) && Helper.hasMethod(rawCode, "getDisplayName")) {
                    codeText = (String)Helper.invoke(rawCode, "getDisplayName");
                }
                if (Helper.isBlank(codeCode) && !"OTH".equals(nullFlavor.toString()) && Helper.hasMethod(rawCode, "getTranslation")) {
                    Object translation = Helper.invoke(rawCode, "getTranslation");
                    if (translation instanceof Collection && !((Collection)translation).isEmpty()) {
                        Collection col = (Collection)translation;
                        Object cd = col.iterator().next();
                        if (Helper.hasMethod(cd, "getCode")) {
                            codeCode = (String)Helper.invoke(cd, "getCode");
                        }
                    } else {
                        throw new UnexpectedXMLResponseFormatException(rawCode.toString());
                    }
                }
                if (!Helper.isBlank(codeCode)) {
                    code = new Code(codeCode, codeSystem, codeText);
                }
            }
        }
        return code;
    }

    public static Code getCode2(CV rawCode) {
        NullFlavor nullFlavor;
        Code code = null;
        if (ResponseHelper.isNotNull(rawCode) && ((nullFlavor = rawCode.getNullFlavor()) == null || NullFlavor.OTH == nullFlavor)) {
            String codeText;
            String codeCode = rawCode.getCode();
            String codeSystem = rawCode.getCodeSystem();
            String string = codeText = rawCode.getOriginalText() == null ? null : rawCode.getOriginalText().getTextValue();
            if (Helper.isBlank(codeText)) {
                codeText = rawCode.getDisplayName();
            }
            if (Helper.isBlank(codeCode)) {
                List translation = rawCode.getTranslation();
                if (translation != null && translation.size() > 0) {
                    codeCode = ((CD)translation.get(0)).getCode();
                } else {
                    throw new UnexpectedXMLResponseFormatException(rawCode.toString());
                }
            }
            if (!Helper.isBlank(codeCode)) {
                code = new Code(codeCode, codeSystem, codeText);
            }
        }
        return code;
    }

    public static Code getCode2(CD rawCode) {
        NullFlavor nullFlavor;
        Code code = null;
        if (ResponseHelper.isNotNull(rawCode) && ((nullFlavor = rawCode.getNullFlavor()) == null || NullFlavor.OTH == nullFlavor)) {
            String codeText;
            String codeCode = rawCode.getCode();
            String codeSystem = rawCode.getCodeSystem();
            String string = codeText = rawCode.getOriginalText() == null ? null : rawCode.getOriginalText().getTextValue();
            if (Helper.isBlank(codeText)) {
                codeText = rawCode.getDisplayName();
            }
            if (Helper.isBlank(codeCode)) {
                List translation = rawCode.getTranslation();
                if (translation != null && translation.size() > 0) {
                    codeCode = ((CD)translation.get(0)).getCode();
                } else {
                    throw new UnexpectedXMLResponseFormatException(rawCode.toString());
                }
            }
            if (!Helper.isBlank(codeCode)) {
                code = new Code(codeCode, codeSystem, codeText);
            }
        }
        return code;
    }

    public static Quantity getQuantity(Object rawQuantity) {
        Quantity qty = null;
        if (ResponseHelper.isNotNull(rawQuantity)) {
            Object nullFlavor;
            if (rawQuantity instanceof JAXBElement) {
                rawQuantity = ((JAXBElement)rawQuantity).getValue();
            }
            if ((nullFlavor = Helper.invoke(rawQuantity, "getNullFlavor")) == null || nullFlavor instanceof Collection && ((Collection)nullFlavor).isEmpty()) {
                Object value = Helper.invoke(rawQuantity, "getValue");
                String unit = "1";
                if (Helper.hasMethod(rawQuantity, "getUnit")) {
                    unit = (String)Helper.invoke(rawQuantity, "getUnit");
                }
                if (value != null && !Helper.isBlank(unit) && (value = Helper.parse(value)) != null) {
                    qty = new Quantity((Number)value, unit);
                }
            }
        }
        return qty;
    }

    public static Duration getDuration(Object rawDuration) {
        Duration d = null;
        if (ResponseHelper.isNotNull(rawDuration)) {
            if (rawDuration instanceof JAXBElement) {
                rawDuration = ((JAXBElement)rawDuration).getValue();
            }
            if (Helper.hasMethod(rawDuration, "getRest")) {
                rawDuration = Helper.invoke(rawDuration, "getRest");
            }
            Object value = ResponseHelper.getWidthElementValue((Collection)rawDuration);
            String unit = ResponseHelper.getWidthElementUnit((Collection)rawDuration);
            if (value != null && !Helper.isBlank(unit) && (value = Helper.parse(value)) != null) {
                d = new Duration((Number)value, unit);
            }
        }
        return d;
    }

    public static List<RequestFault> getRequestFaults(Object result) {
        ArrayList<RequestFault> faults = new ArrayList<RequestFault>();
        if (result != null) {
            Object rawTypeCode = Helper.invoke(result, "getAcknowledgement", "getTypeCode");
            String typeCode = rawTypeCode instanceof Enum ? String.valueOf(rawTypeCode) : (String)Helper.invoke(rawTypeCode, "getCode");
            if ("AA".equalsIgnoreCase(typeCode)) {
                String statusCode;
                Object controlActEvent = Helper.invoke(result, "getControlActEvent");
                if (Helper.hasMethod(controlActEvent, "getValue")) {
                    controlActEvent = Helper.invoke(controlActEvent, "getValue");
                }
                if ("completed".equalsIgnoreCase(statusCode = (String)Helper.invoke(controlActEvent, "getStatusCode", "getCode")) || "SUCCESS".equalsIgnoreCase(statusCode)) {
                    faults.addAll(ResponseHelper.getDetectedIssues(result));
                } else {
                    faults.addAll(ResponseHelper.getFaultsFromNonAAResponse(result));
                    if (statusCode != null) {
                        faults.add(0, new RequestFault(null, statusCode));
                    }
                }
            } else {
                faults.addAll(ResponseHelper.getFaultsFromNonAAResponse(result));
            }
        }
        ArrayList<RequestFault> faults2 = new ArrayList<RequestFault>(faults.size());
        for (RequestFault fault : faults) {
            faults2.add(ResponseHelper.replace(fault));
        }
        return faults2;
    }

    private static RequestFault replace(RequestFault fault) {
        if (fault.getCode() != null && fault.getCode().contains("UNSVAL") && fault.getMessage().contains("creationTime[@value]")) {
            return new RequestFault("UNSVAL_TIME", "Unsupported time. Your computer clock is likely unsynchronized with dsq clock.", null);
        }
        return fault;
    }

    private static List<RequestFault> getFaultsFromNonAAResponse(Object result) {
        Collection details;
        ArrayList<RequestFault> faults = new ArrayList<RequestFault>();
        if (result != null && (details = (Collection)Helper.invoke(result, "getAcknowledgement", "getAcknowledgementDetail")) != null) {
            StringBuilder b = new StringBuilder(details.size() * 15);
            for (Object detail : details) {
                String[] split;
                Object typeCode1 = Helper.invoke(detail, "getTypeCode");
                if (typeCode1 != null && Helper.hasMethod(typeCode1, "getCode")) {
                    typeCode1 = Helper.invoke(typeCode1, "getCode");
                }
                String typeCode2 = (String)Helper.invoke(detail, "getCode", "getCode");
                String text = ResponseHelper.getString(Helper.invoke(detail, "getText"));
                String code = null;
                if (text != null && !"VALIDAT".equalsIgnoreCase(typeCode2) && (split = text.split("-")).length > 1) {
                    code = split[0].trim();
                }
                b.append(typeCode1);
                b.append(" - ");
                b.append(typeCode2);
                b.append(" - ");
                b.append(text);
                Collection locations = (Collection)Helper.invoke(detail, "getLocation");
                if (locations != null && !locations.isEmpty()) {
                    b.append(" - ");
                    for (Object location : locations) {
                        b.append(ResponseHelper.getString(Helper.invoke(location, new String[0])));
                        b.append(" - ");
                    }
                }
                b.append("\n");
                faults.add(new RequestFault(typeCode2, code, null, b.toString(), null));
            }
        }
        return faults;
    }

    private static List<RequestFault> getDetectedIssues(Object result) {
        ArrayList<RequestFault> faults = new ArrayList<RequestFault>();
        if (result != null) {
            Collection subjects = null;
            Object controlActEvent = Helper.invoke(result, "getControlActEvent");
            if (Helper.hasMethod(controlActEvent, "getValue")) {
                controlActEvent = Helper.invoke(controlActEvent, "getValue");
            }
            if (controlActEvent != null) {
                if (Helper.hasMethod(controlActEvent, "getSubjectOf")) {
                    subjects = (Collection)Helper.invoke(controlActEvent, "getSubjectOf");
                } else if (Helper.hasMethod(controlActEvent, "getSubjectOf1")) {
                    subjects = (Collection)Helper.invoke(controlActEvent, "getSubjectOf1");
                }
                if (subjects != null) {
                    for (Object subject : subjects) {
                        String[] split;
                        Object issue = Helper.invoke(subject, "getDetectedIssueEvent");
                        if (issue == null) continue;
                        String typeCode2 = (String)Helper.invoke(issue, "getCode", "getCode");
                        String text = ResponseHelper.getString(Helper.invoke(issue, "getText"));
                        String code = null;
                        if (text != null && !"VALIDAT".equalsIgnoreCase(typeCode2) && (split = text.split("-")).length > 1) {
                            code = split[0].trim();
                        }
                        String priorityCode = (String)Helper.invoke(issue, "getPriorityCode", "getCode");
                        RequestFault fault = new RequestFault(typeCode2, code, priorityCode, text, null);
                        if (Helper.hasMethod(issue, "getSubject")) {
                            fault.rawSubjects = (List)Helper.invoke(issue, "getSubject");
                        }
                        faults.add(fault);
                    }
                }
            }
        }
        return faults;
    }

    public static boolean containsOnlyFault(String code, List<RequestFault> faults) {
        return faults.size() == 1 && ResponseHelper.containsFault(code, faults);
    }

    public static boolean containsFault(String code, List<RequestFault> faults) {
        for (RequestFault f : faults) {
            if (!f.equalsByCode(code)) continue;
            return true;
        }
        return false;
    }

    public static RequestFault getFault(String code, List<RequestFault> faults) {
        for (RequestFault f : faults) {
            if (!f.equalsByCode(code)) continue;
            return f;
        }
        return null;
    }

    public static boolean isNotNull(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof JAXBElement) {
            return ((JAXBElement)object).getValue() != null;
        }
        return true;
    }

    public static boolean isNotNull(Object object, String ... methods) {
        boolean b = object != null;
        Object o = object;
        for (int i = 0; b && i < methods.length; ++i) {
            b = (o = Helper.invoke(o, methods[i])) != null;
        }
        return b;
    }

    public static boolean isNotNull2(Object object, String methods) {
        return Helper.invoke2(object, methods) != null;
    }

    public static void supposedToBeNullOrEmpty(Object object, Transaction.TransactionBuilder<?, ?> builder) {
        if (object instanceof JAXBElement) {
            object = ((JAXBElement)object).getValue();
        }
        if (object instanceof Collection) {
            ResponseHelper.supposedToBeEmpty(object, builder);
        } else {
            ResponseHelper.supposedToBeNull(object, builder);
        }
    }

    public static void supposedToContainsXElement(Collection object, int x, Transaction.TransactionBuilder<?, ?> builder) {
        if (object.size() != x) {
            builder.getWarnings().add(new UnexpectedXMLResponseFormatWarning("object " + object + " was supposed to contains " + x + "elements. all value may not be parsed"));
        }
    }

    public static void supposedToBeEquals(Object o1, Object o2, Transaction.TransactionBuilder<?, ?> builder) {
        boolean b = o1 == o2;
        b = b || o1 == null || o2 == null;
        boolean bl = b = b || o1.equals(o2);
        if (!b) {
            builder.getWarnings().add(new UnexpectedXMLResponseFormatWarning("object " + o1 + " was supposed to the same as object " + o2 + ". Parsing may be incorrect"));
        }
    }

    public static void supposedToBeNull(Object object, Transaction.TransactionBuilder<?, ?> builder) {
        if (object instanceof JAXBElement) {
            object = ((JAXBElement)object).getValue();
        }
        if (object != null) {
            builder.getWarnings().add(new UnexpectedXMLResponseFormatWarning("object " + object + " was supposed to be null. no parsing value exist for this object"));
        }
    }

    public static void supposedToBeEmpty(Object object, Transaction.TransactionBuilder<?, ?> builder) {
        if (object instanceof JAXBElement) {
            object = ((JAXBElement)object).getValue();
        }
        if (object instanceof Collection && !((Collection)object).isEmpty()) {
            builder.getWarnings().add(new UnexpectedXMLResponseFormatWarning("object " + object + " was supposed to be empty. no parsing value exist for this object"));
        }
    }

    public static void incorrectParsing(Object object, Transaction.TransactionBuilder<?, ?> builder) {
        builder.getWarnings().add(new UnexpectedXMLResponseFormatWarning("object " + object + " was not parsed or incorrectly parsed"));
    }

    public static boolean isResponseOk(List<RequestFault> faults) {
        if (faults == null) {
            return true;
        }
        if (faults.isEmpty()) {
            return true;
        }
        for (RequestFault f : faults) {
            if (f == null || "W".equals(f.getPriorityCode()) || "I".equals(f.getPriorityCode())) continue;
            return false;
        }
        return true;
    }

    public static NIU_OTHER_MEDICATION_DM getNIU_OTHER_MEDICATION_DM(Collection<?> iis) {
        NIU id = null;
        NIU version = null;
        for (Object ii : iis) {
            NIU niu = ResponseHelper.getNIU(ii);
            String oid = niu.oid();
            if (oid.equals("2.16.124.10.101.1.60.3.30.10")) {
                id = niu;
                continue;
            }
            if (!oid.equals("2.16.124.10.101.1.60.3.30.10.1")) continue;
            version = niu;
        }
        if (id != null && version != null) {
            return new NIU_OTHER_MEDICATION_DM(id.value(), version.value());
        }
        return null;
    }

    public static NIU getNIU(Object ii) {
        Class returnThisClassTypeOrNull = null;
        return ResponseHelper.getNIU(ii, returnThisClassTypeOrNull);
    }

    public static <T extends NIU> List<NIU> getNIUs(List<?> iis, Class<T> returnThisClassTypeOrNull) {
        if (iis == null || iis.isEmpty()) {
            return null;
        }
        ArrayList<NIU> nius = new ArrayList<NIU>();
        for (Object ii : iis) {
            T niu = ResponseHelper.getNIU(ii, returnThisClassTypeOrNull);
            if (niu == null) continue;
            nius.add((NIU)niu);
        }
        return nius;
    }

    public static <T extends NIU> T getNIU(Object ii, Class<T> returnThisClassTypeOrNull) {
        if (ii == null) {
            return null;
        }
        if (!"II".equals(ii.getClass().getSimpleName())) {
            throw new ClassCastException(ii.getClass().getName() + " is not of type II");
        }
        String root = (String)Helper.invoke(ii, "getRoot");
        String extension = (String)Helper.invoke(ii, "getExtension");
        return (T)ResponseHelper.getNIU(root, extension, returnThisClassTypeOrNull);
    }

    public static NIU getNIU(String oid, String value) {
        return ResponseHelper.getNIU(oid, value, null);
    }

    public static NIU getNIU(String oid, String value, Class<? extends NIU> returnThisClassTypeOrNull) {
        if (oid == null || value == null) {
            return null;
        }
        if (oid.equals("2.16.124.10.101.1.60.9.125") && (returnThisClassTypeOrNull == null || NIU_SH.class.equals(returnThisClassTypeOrNull))) {
            return new NIU_SH(value);
        }
        if (oid.equals("2.16.124.10.101.1.60.100") && (returnThisClassTypeOrNull == null || NAM.class.equals(returnThisClassTypeOrNull))) {
            return new NAM(value);
        }
        if (oid.equals("2.16.840.1.113883.4.272") && (returnThisClassTypeOrNull == null || NAS.class.equals(returnThisClassTypeOrNull))) {
            return new NAS(value);
        }
        if ((oid.equals("2.16.840.1.113883.3.40.2.3") || oid.equals("2.16.840.1.113883.3.40.6.2") || oid.equals("2.16.840.1.113883.4.277")) && (returnThisClassTypeOrNull == null || NIU_I.class.equals(returnThisClassTypeOrNull))) {
            return new NIU_I(value);
        }
        if (oid.equals("2.16.840.1.113883.4.273") && (returnThisClassTypeOrNull == null || NIU_LDS.class.equals(returnThisClassTypeOrNull))) {
            return new NIU_LDS(value);
        }
        if ((oid.equals("2.16.840.1.113883.4.56") || oid.equals("2.16.124.10.101.1.60.4.1.10.5.5")) && (returnThisClassTypeOrNull == null || NIU_U.class.equals(returnThisClassTypeOrNull))) {
            return new OtherNIU(value, oid);
        }
        if (oid.equals("2.16.124.10.101.1.60.105") && (returnThisClassTypeOrNull == null || NIU_RAMQ.class.equals(returnThisClassTypeOrNull))) {
            return new NIU_RAMQ(value);
        }
        if (oid.equals("2.16.840.1.113883.3.40.2.8") && (returnThisClassTypeOrNull == null || NIU_IPC.class.equals(returnThisClassTypeOrNull))) {
            return new NIU_IPC(value);
        }
        if (oid.equals("2.16.840.1.113883.4.274") && (returnThisClassTypeOrNull == null || NIU_ODS.class.equals(returnThisClassTypeOrNull))) {
            return new NIU_ODS(value);
        }
        if (oid.equals("2.16.124.10.101.1.60.101") && (returnThisClassTypeOrNull == null || NIU_LDS_MSSS.class.equals(returnThisClassTypeOrNull))) {
            return new NIU_LDS_MSSS(value);
        }
        if (oid.equals("2.16.124.10.101.1.60.104") && (returnThisClassTypeOrNull == null || NIU_LDS_RAMQ.class.equals(returnThisClassTypeOrNull))) {
            return new NIU_LDS_RAMQ(value);
        }
        if (oid.equals("2.16.124.10.101.1.60.103") && (returnThisClassTypeOrNull == null || NIU_LDS_RAMQ_FACTURATION.class.equals(returnThisClassTypeOrNull))) {
            return new NIU_LDS_RAMQ_FACTURATION(value);
        }
        for (College college : College.values()) {
            if (!oid.equals(college.codeOID) || returnThisClassTypeOrNull != null && !NIU_COLLEGE.class.equals(returnThisClassTypeOrNull)) continue;
            return new NIU_COLLEGE(college, value);
        }
        if (returnThisClassTypeOrNull == null || OtherNIU.class.equals(returnThisClassTypeOrNull)) {
            return new OtherNIU(value, oid);
        }
        return null;
    }

    @Deprecated
    public static <T> T unmarshalT(InputStream is, Class<T> c) throws Exception {
        if (is == null) {
            throw new NullPointerException("file");
        }
        if (c == null) {
            throw new NullPointerException("class");
        }
        DocumentBuilderFactory dfactory = DocumentBuilderFactoryCache.getInstance(new DocumentBuilderFactoryCache.DocumentBuilderFactoryArg().setNamespaceAware(true).setValidating(true));
        DocumentBuilder documentBuilder = dfactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new IgnoreAllErrorHandler());
        Document doc = documentBuilder.parse(is);
        XmlRootElement annotation = c.getAnnotation(XmlRootElement.class);
        if (annotation == null) {
            throw new Exception("cannot find XmlRootElement annotation for class " + c.getName());
        }
        QName qName = new QName("urn:hl7-org:v3", annotation.name());
        Node node = RequestHelper.findNode(qName, doc.getChildNodes());
        if (node == null) {
            throw new Exception("cannot find node " + qName);
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{c});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        JAXBElement element = unmarshaller.unmarshal(node, c);
        return (T)(element == null ? null : element.getValue());
    }

    public static <T> T unmarshalPartialT(JAXBContext fullDocJaxbContext, InputSource is, Class<T> c) throws Exception {
        if (is == null) {
            throw new NullPointerException("file");
        }
        if (c == null) {
            throw new NullPointerException("class");
        }
        Unmarshaller unmarshaller = fullDocJaxbContext.createUnmarshaller();
        DocumentBuilderFactory dfactory = DocumentBuilderFactoryCache.getInstance(new DocumentBuilderFactoryCache.DocumentBuilderFactoryArg().setNamespaceAware(true).setValidating(true));
        DocumentBuilder documentBuilder = dfactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new IgnoreAllErrorHandler());
        Document doc = documentBuilder.parse(is);
        Node node = doc.getFirstChild();
        JAXBElement element = unmarshaller.unmarshal(node, c);
        return (T)(element == null ? null : element.getValue());
    }

    @Deprecated
    public static <T> T unmarshalT(InputSource is, Class<T> c, String elementTag) throws Exception {
        String localName;
        if (is == null) {
            throw new NullPointerException("file");
        }
        if (c == null) {
            throw new NullPointerException("class");
        }
        DocumentBuilderFactory dfactory = DocumentBuilderFactoryCache.getInstance(new DocumentBuilderFactoryCache.DocumentBuilderFactoryArg().setNamespaceAware(true).setValidating(true));
        DocumentBuilder documentBuilder = dfactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new IgnoreAllErrorHandler());
        Document doc = documentBuilder.parse(is);
        if (elementTag == null) {
            XmlRootElement annotation = c.getAnnotation(XmlRootElement.class);
            if (annotation == null) {
                throw new Exception("cannot find XmlRootElement annotation for class " + c.getName());
            }
            localName = annotation.name();
        } else {
            localName = elementTag;
        }
        QName qName = new QName("urn:hl7-org:v3", localName);
        Node node = RequestHelper.findNode(qName, doc.getChildNodes());
        if (node == null) {
            throw new Exception("cannot find node " + qName);
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{c});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        JAXBElement element = unmarshaller.unmarshal(node, c);
        return (T)(element == null ? null : element.getValue());
    }

    public static String parseAny(Object o) {
        if (o == null) {
            return null;
        }
        String s = null;
        if (o instanceof JAXBElement) {
            o = ((JAXBElement)o).getValue();
        }
        if (ResponseHelper.isInstanceOfCascade(o, "INT")) {
            Object value = Helper.invoke(o, "getValue");
            s = value == null ? null : value.toString();
        } else if (ResponseHelper.isInstanceOfCascade(o, "MO")) {
            Object value = Helper.invoke(o, "getValue");
            s = value == null ? null : value.toString();
            String currency = (String)Helper.invoke(o, "getCurrency");
            if (currency != null) {
                s = s + " " + currency;
            }
        } else if (ResponseHelper.isInstanceOf(o, "IVLPQ")) {
            String width;
            String center;
            String high;
            List values = (List)Helper.invoke(o, "getRest");
            JoinList list = new JoinList(", ");
            String low = ResponseHelper.getLow(values);
            if (low != null) {
                list.add("low:" + low);
            }
            if ((high = ResponseHelper.getHigh(values)) != null) {
                list.add("high:" + high);
            }
            if ((center = ResponseHelper.getCenterElementValue(values)) != null) {
                list.add("center:" + center);
            }
            if ((width = ResponseHelper.getWidthElementValue(values)) != null) {
                list.add("width:" + width);
            }
            s = list.toString();
        } else if (ResponseHelper.isInstanceOfCascade(o, "PQ")) {
            Quantity quantity = ResponseHelper.getQuantity(o);
            s = quantity == null ? null : quantity.toString();
        } else if (ResponseHelper.isInstanceOf(o, "IVLREAL")) {
            String width;
            String center;
            String high;
            List values = (List)Helper.invoke(o, "getRest");
            JoinList list = new JoinList(", ");
            String low = ResponseHelper.getLow(values);
            if (low != null) {
                list.add("low:" + low);
            }
            if ((high = ResponseHelper.getHigh(values)) != null) {
                list.add("high:" + high);
            }
            if ((center = ResponseHelper.getCenterElementValue(values)) != null) {
                list.add("center:" + center);
            }
            if ((width = ResponseHelper.getWidthElementValue(values)) != null) {
                list.add("width:" + width);
            }
            s = list.toString();
        } else if (ResponseHelper.isInstanceOfCascade(o, "REAL")) {
            Object value = Helper.invoke(o, "getValue");
            s = value == null ? null : value.toString();
        } else if (ResponseHelper.isInstanceOfCascade(o, "TS")) {
            Object value = Helper.invoke(o, "getValue");
            s = value == null ? null : value.toString();
        } else if (ResponseHelper.isInstanceOfCascade(o, "CD")) {
            Code code = ResponseHelper.getCode(o);
            s = code == null ? null : code.code + " - " + code.text;
        } else if (Helper.hasMethod(o, "getTextValue")) {
            s = (String)Helper.invoke(o, "getTextValue");
        } else if (Helper.hasMethod(o, "getValue")) {
            Object value = Helper.invoke(o, "getValue");
            s = value == null ? null : value.toString();
        }
        return s;
    }

    public static PrescriptionDrugSummary parsePrescriptionDrugSummary(Transaction.TransactionBuilder<?, ?> builder, PORXMT030040CACombinedMedicationRequest request) {
        PORXMT030040CASupplyEventFutureSummary s;
        PORXMT030040CAWorkingListEvent workingListEvent;
        PORXMT030040CAAdministrationInstructions dosage;
        PORXMT030040CAPrecondition precondition;
        String prescriptionId = null;
        String prescriptionVersion = null;
        Code prescriptionCode = null;
        Code prescriptionStatusCode = null;
        String prescriptionDate = null;
        Medication medication3 = null;
        ArrayList<TherapeuticIntent> reasons = null;
        Code nonauthorityIndicatorCode = null;
        Code dosageCode = null;
        String dosageText = null;
        Quantity supplyRequestQuantity = null;
        Code supplyRequestStatusCode = null;
        ILocation supplyRequestLocation = null;
        Code supplyRequestSubstitutionConditionCode = null;
        ArrayList<Refusal> refusalsToFill = null;
        IProvider prescriber = null;
        Code treatmentTypeCode = null;
        Boolean hasIssues = null;
        Boolean hasAnnotations = null;
        for (II id : request.getId()) {
            if ("2.16.124.10.101.1.60.3.30.6".equals(id.getRoot())) {
                prescriptionId = id.getExtension();
                continue;
            }
            if ("2.16.124.10.101.1.60.3.30.6.1".equals(id.getRoot())) {
                prescriptionVersion = id.getExtension();
                continue;
            }
            if ("2.16.124.10.101.1.60.3.30.4".equals(id.getRoot())) {
                prescriptionId = id.getExtension();
                continue;
            }
            if (!"2.16.124.10.101.1.60.3.30.4.1".equals(id.getRoot())) continue;
            prescriptionVersion = id.getExtension();
        }
        prescriptionStatusCode = ResponseHelper.getCode(request.getStatusCode());
        if (ResponseHelper.isNotNull(request.getAuthor()) && ResponseHelper.isNotNull(request.getAuthor().getTime())) {
            prescriptionDate = request.getAuthor().getTime().getValue();
        }
        prescriptionCode = ResponseHelper.getCode(request.getCode());
        prescriber = ResponseHelper.getAuthor(request.getAuthor());
        reasons = ResponseHelper.getTherapeuticIntents(request.getReason(), builder);
        if (ResponseHelper.isNotNull(request.getPrecondition()) && ResponseHelper.isNotNull((precondition = (PORXMT030040CAPrecondition)request.getPrecondition().getValue()).getVerificationEventCriterion()) && (nonauthorityIndicatorCode = ResponseHelper.getCode(precondition.getVerificationEventCriterion().getCode())) != null && !nonauthorityIndicatorCode.code.equals("VFPAPER")) {
            throw new UnexpectedXMLResponseFormatException("unknow precondition value expected: VFPAPER was:" + nonauthorityIndicatorCode.code);
        }
        if (ResponseHelper.isNotNull(request.getDirectTarget())) {
            medication3 = ResponseHelper.getMedication(((PORXMT030040CADirectTarget)request.getDirectTarget().getValue()).getMedication());
        }
        if (ResponseHelper.isNotNull(request.getComponent1()) && ResponseHelper.isNotNull(dosage = request.getComponent1().getAdministrationInstructions())) {
            dosageCode = ResponseHelper.getCode(dosage.getCode());
            dosageText = dosage.getText().getTextValue();
        }
        if (ResponseHelper.isNotNull(request.getComponent2()) && ResponseHelper.isNotNull(request.getComponent2().getSupplyRequest())) {
            PORXMT030040CASupplyRequest supplyRequest = request.getComponent2().getSupplyRequest();
            supplyRequestStatusCode = ResponseHelper.getCode(supplyRequest.getStatusCode());
            supplyRequestQuantity = ResponseHelper.getQuantity(supplyRequest.getQuantity());
            PORXMT030040CALocation2 location = supplyRequest.getLocation();
            if (ResponseHelper.isNotNull(location)) {
                supplyRequestLocation = ResponseHelper.getLocation(location);
                supplyRequestSubstitutionConditionCode = ResponseHelper.getCode(location.getSubstitutionConditionCode());
            }
        }
        if (ResponseHelper.isNotNull(request.getSubjectOf3())) {
            refusalsToFill = ResponseHelper.getRefusalsToFill(request.getSubjectOf3());
        }
        if (ResponseHelper.isNotNull(request.getComponentOf2()) && ResponseHelper.isNotNull(workingListEvent = request.getComponentOf2().getWorkingListEvent())) {
            treatmentTypeCode = ResponseHelper.getCode(workingListEvent.getCode());
        }
        hasIssues = ResponseHelper.isNotNull(request.getSubjectOf2()) && ((PORXMT030040CASubject2)request.getSubjectOf2().getValue()).getDetectedIssueIndicator() != null;
        hasAnnotations = ResponseHelper.isNotNull(request.getSubjectOf1()) && ((PORXMT030040CASubject)request.getSubjectOf1().getValue()).getAnnotationIndicator() != null;
        SupplyEventSummary supplyEventSummary = new SupplyEventSummary();
        if (ResponseHelper.isNotNull(request.getFulfillment1()) && (s = (PORXMT030040CASupplyEventFutureSummary)Helper.invoke2(request, "getFulfillment1().getValue().getSupplyEventFutureSummary()")) != null) {
            supplyEventSummary.fillsRemaining = s.getRepeatNumber() == null ? null : s.getRepeatNumber().getValue();
            supplyEventSummary.remainingTotalQuantity = ResponseHelper.getQuantity(s.getQuantity());
        }
        if (ResponseHelper.isNotNull(request.getFulfillment2()) && (s = (PORXMT030040CASupplyEventFirstSummary)Helper.invoke2(request, "getFulfillment2().getValue().getSupplyEventFirstSummary()")) != null) {
            supplyEventSummary.firstDispensePickupDate = Helper.parseFULLDATE(ResponseHelper.getHigh(s.getEffectiveTime()));
            supplyEventSummary.firstDispensedQuantity = ResponseHelper.getQuantity(s.getQuantity());
        }
        if (ResponseHelper.isNotNull(request.getFulfillment3()) && (s = (PORXMT030040CASupplyEventLastSummary)Helper.invoke2(request, "getFulfillment3().getValue().getSupplyEventLastSummary()")) != null) {
            supplyEventSummary.lastDispensePickupDate = Helper.parseFULLDATE(ResponseHelper.getHigh(s.getEffectiveTime()));
            supplyEventSummary.lastDispensedQuantity = ResponseHelper.getQuantity(s.getQuantity());
        }
        if (ResponseHelper.isNotNull(request.getFulfillment4()) && (s = (PORXMT030040CASupplyEventPastSummary)Helper.invoke2(request, "getFulfillment4().getValue().getSupplyEventPastSummary()")) != null) {
            supplyEventSummary.numberOfFillMadeAgainstRx = s.getRepeatNumber() == null ? null : s.getRepeatNumber().getValue();
            supplyEventSummary.totalSuppliedAmount = ResponseHelper.getQuantity(s.getQuantity());
        }
        PrescriptionDrugSummary prescription = new PrescriptionDrugSummary(prescriptionId, prescriptionVersion, prescriptionCode, prescriptionStatusCode, Helper.parseDATETIME_NONSTRICT(prescriptionDate), prescriber, medication3, reasons, nonauthorityIndicatorCode == null, dosageText, dosageCode, supplyRequestQuantity, supplyRequestStatusCode, supplyRequestLocation, supplyRequestSubstitutionConditionCode, refusalsToFill, treatmentTypeCode, hasIssues, hasAnnotations);
        prescription.supplyEventSummary = supplyEventSummary;
        return prescription;
    }

    public static PrescriptionDrugSummary parsePrescriptionDrugSummary(Transaction.TransactionBuilder<?, ?> builder, PORXMT060190CACombinedMedicationRequest request) {
        PORXMT060190CASupplyEventFutureSummary s;
        PORXMT060190CAWorkingListEvent workingListEvent;
        PORXMT060190CAAdministrationInstructions dosage;
        PORXMT060190CAPrecondition precondition;
        String prescriptionId = null;
        String prescriptionVersion = null;
        Code prescriptionCode = null;
        Code prescriptionStatusCode = null;
        String prescriptionDate = null;
        Medication medication3 = null;
        ArrayList<TherapeuticIntent> reasons = null;
        Code nonauthorityIndicatorCode = null;
        Code dosageCode = null;
        String dosageText = null;
        Quantity supplyRequestQuantity = null;
        Code supplyRequestStatusCode = null;
        ILocation supplyRequestLocation = null;
        Code supplyRequestSubstitutionConditionCode = null;
        ArrayList<Refusal> refusalsToFill = null;
        IProvider prescriber = null;
        Code treatmentTypeCode = null;
        Boolean hasIssues = null;
        Boolean hasAnnotations = null;
        for (II id : request.getId()) {
            if ("2.16.124.10.101.1.60.3.30.6".equals(id.getRoot())) {
                prescriptionId = id.getExtension();
                continue;
            }
            if ("2.16.124.10.101.1.60.3.30.6.1".equals(id.getRoot())) {
                prescriptionVersion = id.getExtension();
                continue;
            }
            if ("2.16.124.10.101.1.60.3.30.4".equals(id.getRoot())) {
                prescriptionId = id.getExtension();
                continue;
            }
            if (!"2.16.124.10.101.1.60.3.30.4.1".equals(id.getRoot())) continue;
            prescriptionVersion = id.getExtension();
        }
        prescriptionStatusCode = ResponseHelper.getCode(request.getStatusCode());
        if (ResponseHelper.isNotNull(request.getAuthor()) && ResponseHelper.isNotNull(request.getAuthor().getTime())) {
            prescriptionDate = request.getAuthor().getTime().getValue();
        }
        prescriptionCode = ResponseHelper.getCode(request.getCode());
        prescriber = ResponseHelper.getAuthor(request.getAuthor());
        reasons = ResponseHelper.getTherapeuticIntents(request.getReason(), builder);
        if (ResponseHelper.isNotNull(request.getPrecondition()) && ResponseHelper.isNotNull((precondition = (PORXMT060190CAPrecondition)request.getPrecondition().getValue()).getVerificationEventCriterion()) && (nonauthorityIndicatorCode = ResponseHelper.getCode(precondition.getVerificationEventCriterion().getCode())) != null && !nonauthorityIndicatorCode.code.equals("VFPAPER")) {
            throw new UnexpectedXMLResponseFormatException("unknow precondition value expected: VFPAPER was:" + nonauthorityIndicatorCode.code);
        }
        if (ResponseHelper.isNotNull(request.getDirectTarget())) {
            medication3 = ResponseHelper.getMedication(((PORXMT060190CADirectTarget)request.getDirectTarget().getValue()).getMedication());
        }
        if (ResponseHelper.isNotNull(request.getComponent1()) && ResponseHelper.isNotNull(dosage = request.getComponent1().getAdministrationInstructions())) {
            dosageCode = ResponseHelper.getCode(dosage.getCode());
            dosageText = dosage.getText().getTextValue();
        }
        if (ResponseHelper.isNotNull(request.getComponent2()) && ResponseHelper.isNotNull(request.getComponent2().getSupplyRequest())) {
            PORXMT060190CASupplyRequest supplyRequest = request.getComponent2().getSupplyRequest();
            supplyRequestStatusCode = ResponseHelper.getCode(supplyRequest.getStatusCode());
            supplyRequestQuantity = ResponseHelper.getQuantity(supplyRequest.getQuantity());
            PORXMT060190CALocation3 location = supplyRequest.getLocation();
            if (ResponseHelper.isNotNull(location)) {
                supplyRequestLocation = ResponseHelper.getLocation(location);
                supplyRequestSubstitutionConditionCode = ResponseHelper.getCode(location.getSubstitutionConditionCode());
            }
        }
        if (ResponseHelper.isNotNull(request.getSubjectOf3())) {
            refusalsToFill = ResponseHelper.getRefusalsToFill(request.getSubjectOf3());
        }
        if (ResponseHelper.isNotNull(request.getComponentOf2()) && ResponseHelper.isNotNull(workingListEvent = request.getComponentOf2().getWorkingListEvent())) {
            treatmentTypeCode = ResponseHelper.getCode(workingListEvent.getCode());
        }
        hasIssues = ResponseHelper.isNotNull(request.getSubjectOf2()) && ((PORXMT060190CASubject2)request.getSubjectOf2().getValue()).getDetectedIssueIndicator() != null;
        hasAnnotations = ResponseHelper.isNotNull(request.getSubjectOf1()) && ((PORXMT060190CASubject)request.getSubjectOf1().getValue()).getAnnotationIndicator() != null;
        SupplyEventSummary supplyEventSummary = new SupplyEventSummary();
        if (ResponseHelper.isNotNull(request.getFulfillment1()) && (s = (PORXMT060190CASupplyEventFutureSummary)Helper.invoke2(request, "getFulfillment1().getValue().getSupplyEventFutureSummary()")) != null) {
            supplyEventSummary.fillsRemaining = s.getRepeatNumber() == null ? null : s.getRepeatNumber().getValue();
            supplyEventSummary.remainingTotalQuantity = ResponseHelper.getQuantity(s.getQuantity());
        }
        if (ResponseHelper.isNotNull(request.getFulfillment2()) && (s = (PORXMT060190CASupplyEventFirstSummary)Helper.invoke2(request, "getFulfillment2().getValue().getSupplyEventFirstSummary()")) != null) {
            supplyEventSummary.firstDispensePickupDate = Helper.parseFULLDATE(ResponseHelper.getHigh(s.getEffectiveTime()));
            supplyEventSummary.firstDispensedQuantity = ResponseHelper.getQuantity(s.getQuantity());
        }
        if (ResponseHelper.isNotNull(request.getFulfillment3()) && (s = (PORXMT060190CASupplyEventLastSummary)Helper.invoke2(request, "getFulfillment3().getValue().getSupplyEventLastSummary()")) != null) {
            supplyEventSummary.lastDispensePickupDate = Helper.parseFULLDATE(ResponseHelper.getHigh(s.getEffectiveTime()));
            supplyEventSummary.lastDispensedQuantity = ResponseHelper.getQuantity(s.getQuantity());
        }
        if (ResponseHelper.isNotNull(request.getFulfillment4()) && (s = (PORXMT060190CASupplyEventPastSummary)Helper.invoke2(request, "getFulfillment4().getValue().getSupplyEventPastSummary()")) != null) {
            supplyEventSummary.numberOfFillMadeAgainstRx = s.getRepeatNumber() == null ? null : s.getRepeatNumber().getValue();
            supplyEventSummary.totalSuppliedAmount = ResponseHelper.getQuantity(s.getQuantity());
        }
        PrescriptionDrugSummary prescription = new PrescriptionDrugSummary(prescriptionId, prescriptionVersion, prescriptionCode, prescriptionStatusCode, Helper.parseDATETIME_NONSTRICT(prescriptionDate), prescriber, medication3, reasons, nonauthorityIndicatorCode == null, dosageText, dosageCode, supplyRequestQuantity, supplyRequestStatusCode, supplyRequestLocation, supplyRequestSubstitutionConditionCode, refusalsToFill, treatmentTypeCode, hasIssues, hasAnnotations);
        prescription.supplyEventSummary = supplyEventSummary;
        return prescription;
    }

    public static OtherMedicationSummary parseOtherMedicationSummary(Transaction.TransactionBuilder<?, ?> builder, PORXMT060190CAOtherMedication other) {
        OtherMedicationSummary medication = new OtherMedicationSummary();
        medication.niu = ResponseHelper.getNIU_OTHER_MEDICATION_DM(other.getId());
        medication.status = ResponseHelper.getCode(other.getStatusCode());
        if (ResponseHelper.isNotNull(other.getEffectiveTime())) {
            medication.drugActivePeriodStart = Helper.parseDATETIME_NONSTRICT(ResponseHelper.getLow(other.getEffectiveTime()));
            medication.drugActivePeriodEnd = Helper.parseDATETIME_NONSTRICT(ResponseHelper.getHigh(other.getEffectiveTime()));
            medication.drugActivePeriodDuration = ResponseHelper.getDuration(other.getEffectiveTime());
        }
        medication.type = ResponseHelper.getCode(other.getCode());
        medication.author = ResponseHelper.getAuthor(other.getAuthor());
        medication.location = ResponseHelper.getLocation(other.getLocation());
        medication.consumable = ResponseHelper.getMedication(other.getConsumable().getMedication());
        medication.hasIssues = ResponseHelper.isNotNull(other.getSubjectOf1()) && ((PORXMT060190CASubject7)other.getSubjectOf1().getValue()).getDetectedIssueIndicator() != null;
        ResponseHelper.supposedToBeNull(other.getSubjectOf2(), builder);
        return medication;
    }

    public static OtherMedicationDetail parseOtherMedicationDetail(Transaction.TransactionBuilder<?, ?> builder, PORXMT060210CAOtherMedication other) {
        OtherMedicationDetail medication = new OtherMedicationDetail();
        medication.niu = ResponseHelper.getNIU_OTHER_MEDICATION_DM(other.getId());
        medication.status = ResponseHelper.getCode(other.getStatusCode());
        if (ResponseHelper.isNotNull(other.getEffectiveTime())) {
            medication.drugActivePeriodStart = Helper.parseDATETIME_NONSTRICT(ResponseHelper.getLow(other.getEffectiveTime()));
            medication.drugActivePeriodEnd = Helper.parseDATETIME_NONSTRICT(ResponseHelper.getHigh(other.getEffectiveTime()));
            medication.drugActivePeriodDuration = ResponseHelper.getDuration(other.getEffectiveTime());
        }
        medication.type = ResponseHelper.getCode(other.getCode());
        medication.author = ResponseHelper.getAuthor(other.getAuthor());
        medication.location = ResponseHelper.getLocation(other.getLocation());
        medication.consumable = ResponseHelper.getMedication(other.getConsumable().getMedication());
        medication.dosageInstructions = new ArrayList();
        for (PORXMT060210CAComponent c : other.getComponent()) {
            if (c == null) continue;
            medication.dosageInstructions.add(ResponseHelper.getDosageInstruction(builder, c.getDosageInstruction()));
        }
        ResponseHelper.supposedToBeNullOrEmpty(other.getSubjectOf3(), builder);
        medication.detectedIssueEvents = ResponseHelper.getDetectedIssueEvents(other.getSubjectOf5(), builder);
        medication.historyStatusChanges = new ArrayList();
        for (PORXMT060210CASubject11 s : other.getSubjectOf1()) {
            PORXMT060210CAControlActEvent cae = s.getControlActEvent();
            medication.historyStatusChanges.add(ResponseHelper.getHistoryStatusChange(cae));
        }
        ResponseHelper.supposedToBeNullOrEmpty(other.getComponentOf(), builder);
        return medication;
    }

    public static void parseQueryAck(QUQIMT120006CAQueryAck queryAck, QueryContinuationResult qcr) {
        qcr.queryId = queryAck.getQueryId().getRoot();
        qcr.resultTotalQuantity = queryAck.getResultTotalQuantity().getValue().intValue();
        qcr.resultCurrentQuantity = queryAck.getResultCurrentQuantity().getValue().intValue();
        qcr.resultRemainingQuantity = queryAck.getResultRemainingQuantity().getValue().intValue();
    }

    public static void parseQueryAck(QUQIMT120006QCQueryAck queryAck, QueryContinuationResult qcr) {
        qcr.queryId = queryAck.getQueryId().getRoot();
        qcr.resultTotalQuantity = queryAck.getResultTotalQuantity().getValue().intValue();
        qcr.resultCurrentQuantity = queryAck.getResultCurrentQuantity().getValue().intValue();
        qcr.resultRemainingQuantity = queryAck.getResultRemainingQuantity().getValue().intValue();
    }

    public static PrescriptionDrugDetails parsePrescriptionDrugDetail(Transaction.TransactionBuilder<?, PrescriptionDrugDetails> builder, PORXIN060260CAQCV01QUQIMT120006CASubject2 subject) {
        PORXMT060340CASupplyEventLastSummary s;
        Code code;
        PrescriptionDrugDetails detail = null;
        String prescriptionId = null;
        String prescriptionVersion = null;
        Code prescriptionStatusCode = null;
        Code prescriptionCode = null;
        String prescriptionDate = null;
        ILocation prescriptionLocation = null;
        IProvider prescriber = null;
        Medication prescriptionMedication = null;
        ArrayList<ReferenceProtocol> referenceProtocols = new ArrayList<ReferenceProtocol>();
        String previousPrescriptionId = null;
        String previousPrescriptionVersion = null;
        Code previousPrescriptionCode = null;
        ArrayList<TherapeuticIntent> reasons = null;
        Code nonauthorityIndicatorCode = null;
        String derivedFromCode = null;
        ArrayList<QuantityObservation> patientMesures = null;
        ArrayList<DosageInstruction> dosageInstructions = null;
        Boolean notEligibleForTrial = null;
        Code trialSupplyPermissionCode = null;
        String supplyRequestStatusCode = null;
        String supplyRequestEffectiveTimeLow = null;
        String supplyRequestEffectiveTimeHigh = null;
        Duration supplyRequestAllowedPeriodDuration = null;
        ILocation supplyRequestLocation = null;
        String supplyRequestLocationPickupDate = null;
        Code supplyRequestLocationSubstitutionConditionCode = null;
        ArrayList<SupplyRequestItem> supplyRequestItems = null;
        Code substitutionPermissionCode = null;
        Boolean substitutionNotAllowedIndicator = null;
        Code substitutionNotAllowedReasonCode = null;
        ArrayList<Refusal> refusalsToFill = null;
        ArrayList<Annotation> annotations = null;
        ArrayList<DetectedIssueEvent> detectedIssueEvents = null;
        Code treatmentTypeCode = null;
        MedicationDispense medicationDispense = null;
        ArrayList<HistoryStatusChange> historyStatusChanges = null;
        PORXMT060340CACombinedMedicationRequest request = subject.getCombinedMedicationRequest();
        for (II id : request.getId()) {
            if ("2.16.124.10.101.1.60.3.30.6".equals(id.getRoot())) {
                prescriptionId = id.getExtension();
                continue;
            }
            if ("2.16.124.10.101.1.60.3.30.6.1".equals(id.getRoot())) {
                prescriptionVersion = id.getExtension();
                continue;
            }
            if ("2.16.124.10.101.1.60.3.30.4".equals(id.getRoot())) {
                prescriptionId = id.getExtension();
                continue;
            }
            if (!"2.16.124.10.101.1.60.3.30.4.1".equals(id.getRoot())) continue;
            prescriptionVersion = id.getExtension();
        }
        if (ResponseHelper.isNotNull(request.getStatusCode())) {
            prescriptionStatusCode = ResponseHelper.getCode(request.getStatusCode());
        }
        if (ResponseHelper.isNotNull(request.getAuthor(), "getTime")) {
            prescriptionDate = request.getAuthor().getTime().getValue();
        }
        prescriptionCode = ResponseHelper.getCode(request.getCode());
        if (ResponseHelper.isNotNull(request.getDirectTarget(), "getValue")) {
            prescriptionMedication = ResponseHelper.getMedication(((PORXMT060340CADirectTarget)request.getDirectTarget().getValue()).getMedication());
        }
        prescriber = ResponseHelper.getAuthor(request.getAuthor());
        prescriptionLocation = ResponseHelper.getLocation(request.getLocation());
        if (ResponseHelper.isNotNull(request.getDefinition())) {
            for (Object definition : request.getDefinition()) {
                if (definition.getSubstanceAdministrationDefinition() == null) continue;
                Id id = ResponseHelper.getId(definition.getSubstanceAdministrationDefinition().getId());
                code = ResponseHelper.getCode(definition.getSubstanceAdministrationDefinition().getCode());
                if (id == null && code == null) continue;
                referenceProtocols.add(new ReferenceProtocol(id, code));
            }
        }
        if (ResponseHelper.isNotNull(request.getPredecessor(), "getValue", "getPriorCombinedMedicationRequest")) {
            PORXMT060340CAPriorCombinedMedicationRequest previousRequest = ((PORXMT060340CAPredecessor)request.getPredecessor().getValue()).getPriorCombinedMedicationRequest();
            for (Id id : previousRequest.getId()) {
                if ("2.16.124.10.101.1.60.3.30.6".equals(id.getRoot())) {
                    previousPrescriptionId = id.getExtension();
                    continue;
                }
                if ("2.16.124.10.101.1.60.3.30.6.1".equals(id.getRoot())) {
                    previousPrescriptionVersion = id.getExtension();
                    continue;
                }
                if ("2.16.124.10.101.1.60.3.30.4".equals(id.getRoot())) {
                    previousPrescriptionId = id.getExtension();
                    continue;
                }
                if (!"2.16.124.10.101.1.60.3.30.4.1".equals(id.getRoot())) continue;
                previousPrescriptionVersion = id.getExtension();
            }
            previousPrescriptionCode = ResponseHelper.getCode(previousRequest.getCode());
        }
        reasons = ResponseHelper.getTherapeuticIntents(request.getReason(), builder);
        if (ResponseHelper.isNotNull(request.getPrecondition(), "getValue", "getVerificationEventCriterion") && (nonauthorityIndicatorCode = ResponseHelper.getCode(((PORXMT060340CAPrecondition)request.getPrecondition().getValue()).getVerificationEventCriterion().getCode())) != null && !nonauthorityIndicatorCode.code.equals("VFPAPER")) {
            throw new UnexpectedXMLResponseFormatException("unknow precondition value expected: VFPAPER was:" + nonauthorityIndicatorCode.code);
        }
        if (ResponseHelper.isNotNull(request.getDerivedFrom(), "getValue", "getSourceDispense", "getStatusCode")) {
            derivedFromCode = ((PORXMT060340CADerivedFrom)request.getDerivedFrom().getValue()).getSourceDispense().getStatusCode().getCode();
        }
        if (ResponseHelper.isNotNull(request.getPertinentInformation())) {
            patientMesures = new ArrayList<QuantityObservation>();
            for (PORXMT060340CAPertinentInformation pertinentInformation : request.getPertinentInformation()) {
                String effectiveTime = null;
                code = null;
                Quantity quantity = null;
                if (ResponseHelper.isNotNull(pertinentInformation, "getQuantityObservationEvent", "getEffectiveTime")) {
                    effectiveTime = pertinentInformation.getQuantityObservationEvent().getEffectiveTime().getValue();
                }
                if (ResponseHelper.isNotNull(pertinentInformation, "getQuantityObservationEvent")) {
                    code = ResponseHelper.getCode(pertinentInformation.getQuantityObservationEvent().getCode());
                    quantity = ResponseHelper.getQuantity(pertinentInformation.getQuantityObservationEvent().getValue());
                }
                patientMesures.add(new QuantityObservation(Helper.parseDATETIME_NONSTRICT(effectiveTime), code, quantity));
            }
        }
        if (request.getComponent1() != null) {
            dosageInstructions = new ArrayList<DosageInstruction>();
            for (PORXMT060340CAComponent1 component1 : request.getComponent1()) {
                COCTMT270010CADosageInstruction di = component1.getDosageInstruction();
                dosageInstructions.add(ResponseHelper.getDosageInstruction(builder, di));
            }
        }
        if (ResponseHelper.isNotNull(request.getComponent2())) {
            PORXMT060340CAComponent2 component2 = request.getComponent2();
            notEligibleForTrial = component2.isNegationInd();
            if (ResponseHelper.isNotNull(component2.getTrialSupplyPermission())) {
                trialSupplyPermissionCode = ResponseHelper.getCode(component2.getTrialSupplyPermission().getCode());
            }
        }
        if (ResponseHelper.isNotNull(request.getComponent3(), "getSupplyRequest")) {
            PORXMT060340CALocation4 rawLocation;
            PORXMT060340CASupplyRequest supplyRequest = request.getComponent3().getSupplyRequest();
            ResponseHelper.supposedToBeNull(supplyRequest.getDestination(), builder);
            if (ResponseHelper.isNotNull(supplyRequest.getStatusCode())) {
                supplyRequestStatusCode = supplyRequest.getStatusCode().getCode();
            }
            if (ResponseHelper.isNotNull(supplyRequest.getEffectiveTime())) {
                supplyRequestEffectiveTimeLow = ResponseHelper.getLow(supplyRequest.getEffectiveTime().getRest());
                supplyRequestEffectiveTimeHigh = ResponseHelper.getHigh(supplyRequest.getEffectiveTime().getRest());
                supplyRequestAllowedPeriodDuration = ResponseHelper.getDuration(supplyRequest.getEffectiveTime());
            }
            if (ResponseHelper.isNotNull(rawLocation = supplyRequest.getLocation())) {
                supplyRequestLocation = ResponseHelper.getLocation(rawLocation);
                if (ResponseHelper.isNotNull(rawLocation.getTime())) {
                    supplyRequestLocationPickupDate = ResponseHelper.getLow(rawLocation.getTime().getRest());
                }
                supplyRequestLocationSubstitutionConditionCode = ResponseHelper.getCode(rawLocation.getSubstitutionConditionCode());
            }
            supplyRequestItems = new ArrayList<SupplyRequestItem>();
            for (PORXMT060340CAComponent3 component3 : supplyRequest.getComponent()) {
                PORXMT060340CASupplyRequestItem supplyRequestItem = component3.getSupplyRequestItem();
                Quantity totalQuantity = null;
                String totalExpectedUseTime = null;
                Medication medication = null;
                String firstFillExpiryDate = null;
                Quantity firstFillQuantity = null;
                Duration firstFillExpectedUseTime = null;
                Duration dispenseInterval = null;
                BigInteger numberOfFills = null;
                Quantity fillQuantity = null;
                Duration fillExpectedUseTime = null;
                if (ResponseHelper.isNotNull(supplyRequestItem.getQuantity())) {
                    totalQuantity = ResponseHelper.getQuantity(supplyRequestItem.getQuantity());
                }
                if (ResponseHelper.isNotNull(supplyRequestItem.getExpectedUseTime())) {
                    totalExpectedUseTime = ResponseHelper.getWidthElementValue(supplyRequestItem.getExpectedUseTime().getRest());
                }
                if (ResponseHelper.isNotNull(supplyRequestItem.getProduct())) {
                    medication = ResponseHelper.getMedication(((PORXMT060340CAProduct1)supplyRequestItem.getProduct().getValue()).getMedication());
                }
                if (ResponseHelper.isNotNull(supplyRequestItem.getComponent2(), "getValue", "getInitialSupplyRequest")) {
                    PORXMT060340CAInitialSupplyRequest initialSupplyRequest = ((PORXMT060340CAComponent7)supplyRequestItem.getComponent2().getValue()).getInitialSupplyRequest();
                    if (ResponseHelper.isNotNull(initialSupplyRequest.getEffectiveTime())) {
                        firstFillExpiryDate = ResponseHelper.getHigh(initialSupplyRequest.getEffectiveTime().getRest());
                    }
                    if (ResponseHelper.isNotNull(initialSupplyRequest.getQuantity())) {
                        firstFillQuantity = ResponseHelper.getQuantity(initialSupplyRequest.getQuantity());
                    }
                    if (ResponseHelper.isNotNull(initialSupplyRequest.getExpectedUseTime())) {
                        firstFillExpectedUseTime = ResponseHelper.getDuration(initialSupplyRequest.getExpectedUseTime());
                    }
                }
                if (ResponseHelper.isNotNull(supplyRequestItem.getComponent1(), "getSubsequentSupplyRequest")) {
                    PORXMT060340CASubsequentSupplyRequest subsequentSupplyRequest = supplyRequestItem.getComponent1().getSubsequentSupplyRequest();
                    if (ResponseHelper.isNotNull(subsequentSupplyRequest.getEffectiveTime())) {
                        dispenseInterval = ResponseHelper.getDuration(subsequentSupplyRequest.getEffectiveTime());
                    }
                    if (ResponseHelper.isNotNull(subsequentSupplyRequest.getRepeatNumber())) {
                        numberOfFills = subsequentSupplyRequest.getRepeatNumber().getValue();
                    }
                    if (ResponseHelper.isNotNull(subsequentSupplyRequest.getQuantity())) {
                        fillQuantity = ResponseHelper.getQuantity(subsequentSupplyRequest.getQuantity());
                    }
                    if (ResponseHelper.isNotNull(subsequentSupplyRequest.getExpectedUseTime())) {
                        fillExpectedUseTime = ResponseHelper.getDuration(subsequentSupplyRequest.getExpectedUseTime());
                    }
                }
                SupplyRequestItem item = new SupplyRequestItem();
                item.medication = medication;
                item.totalQuantity = totalQuantity;
                item.totalDaysSupply = totalExpectedUseTime == null ? null : new BigInteger(totalExpectedUseTime);
                item.firstFillExpiryDate = Helper.parseDATETIME_NONSTRICT(firstFillExpiryDate);
                item.firstFillQuantity = firstFillQuantity;
                item.firstFillExpectedUseTime = firstFillExpectedUseTime;
                item.dispenseInterval = dispenseInterval;
                item.numberOfFills = numberOfFills;
                item.fillQuantity = fillQuantity;
                item.fillExpectedUseTime = fillExpectedUseTime;
                supplyRequestItems.add(item);
            }
        }
        if (ResponseHelper.isNotNull(request.getSubjectOf5(), "getValue", "getSubstitutionPermission")) {
            PORXMT060340CASubstitutionPermission substitution = ((PORXMT060340CASubject8)request.getSubjectOf5().getValue()).getSubstitutionPermission();
            substitutionPermissionCode = ResponseHelper.getCode(substitution.getCode());
            substitutionNotAllowedIndicator = substitution.isNegationInd();
            substitutionNotAllowedReasonCode = ResponseHelper.getCode(substitution.getReasonCode());
        }
        if (ResponseHelper.isNotNull(request.getSubjectOf6())) {
            refusalsToFill = ResponseHelper.getRefusalsToFill(request.getSubjectOf6());
        }
        if (ResponseHelper.isNotNull(request.getSubjectOf1())) {
            detectedIssueEvents = ResponseHelper.getDetectedIssueEvents(request.getSubjectOf1(), builder);
        }
        if (ResponseHelper.isNotNull(request.getSubjectOf3())) {
            annotations = ResponseHelper.getAnnotations(request.getSubjectOf3());
        }
        if (ResponseHelper.isNotNull(request.getComponentOf2(), "getWorkingListEvent")) {
            treatmentTypeCode = ResponseHelper.getCode(request.getComponentOf2().getWorkingListEvent().getCode());
        }
        if (request.getSubjectOf4() != null && request.getSubjectOf4().size() > 0) {
            historyStatusChanges = new ArrayList<HistoryStatusChange>();
            for (PORXMT060340CASubject2 e : request.getSubjectOf4()) {
                PORXMT060340CAControlActEvent cae = e.getControlActEvent();
                if (cae == null) continue;
                historyStatusChanges.add(ResponseHelper.getHistoryStatusChange(cae));
            }
        }
        SupplyEventSummary supplyEventSummary = new SupplyEventSummary();
        if (ResponseHelper.isNotNull(request.getFulfillment1()) && request.getFulfillment1().size() > 0) {
            medicationDispense = ResponseHelper.parseMedicationDispense(((PORXMT060340CAInFulfillmentOf1)request.getFulfillment1().get(0)).getMedicationDispense(), builder);
        }
        if (ResponseHelper.isNotNull(request.getFulfillment2()) && (s = (PORXMT060340CASupplyEventLastSummary)Helper.invoke2(request, "getFulfillment2().getValue().getSupplyEventLastSummary()")) != null) {
            supplyEventSummary.lastDispensePickupDate = Helper.parseFULLDATE(ResponseHelper.getHigh(s.getEffectiveTime()));
            supplyEventSummary.lastDispensedQuantity = ResponseHelper.getQuantity(s.getQuantity());
        }
        if (ResponseHelper.isNotNull(request.getFulfillment3()) && (s = (PORXMT060340CASupplyEventFirstSummary)Helper.invoke2(request, "getFulfillment3().getValue().getSupplyEventFirstSummary()")) != null) {
            supplyEventSummary.firstDispensePickupDate = Helper.parseFULLDATE(ResponseHelper.getHigh(s.getEffectiveTime()));
            supplyEventSummary.firstDispensedQuantity = ResponseHelper.getQuantity(s.getQuantity());
        }
        if (ResponseHelper.isNotNull(request.getFulfillment4()) && (s = (PORXMT060340CASupplyEventFutureSummary)Helper.invoke2(request, "getFulfillment4().getValue().getSupplyEventFutureSummary()")) != null) {
            supplyEventSummary.fillsRemaining = s.getRepeatNumber() == null ? null : s.getRepeatNumber().getValue();
            supplyEventSummary.remainingTotalQuantity = ResponseHelper.getQuantity(s.getQuantity());
        }
        if (ResponseHelper.isNotNull(request.getFulfillment5()) && (s = (PORXMT060340CASupplyEventPastSummary)Helper.invoke2(request, "getFulfillment5().getValue().getSupplyEventPastSummary()")) != null) {
            supplyEventSummary.numberOfFillMadeAgainstRx = s.getRepeatNumber() == null ? null : s.getRepeatNumber().getValue();
            supplyEventSummary.totalSuppliedAmount = ResponseHelper.getQuantity(s.getQuantity());
        }
        detail = new PrescriptionDrugDetails();
        detail.id = prescriptionId;
        detail.version = prescriptionVersion;
        detail.status = prescriptionStatusCode;
        detail.code = prescriptionCode;
        detail.datetime = Helper.parseDATETIME_NONSTRICT(prescriptionDate);
        detail.location = prescriptionLocation;
        detail.prescriber = prescriber;
        detail.medication = prescriptionMedication;
        detail.referenceProtocols = referenceProtocols;
        detail.previousPrescriptionId = previousPrescriptionId;
        detail.previousPrescriptionVersion = previousPrescriptionVersion;
        detail.previousPrescriptionCode = previousPrescriptionCode;
        detail.reasons = reasons;
        detail.electronicVersionHasAuthority = nonauthorityIndicatorCode == null;
        detail.derivedFromCode = derivedFromCode;
        detail.patientMesures = patientMesures;
        detail.dosageInstructions = dosageInstructions;
        detail.notEligibleForTrial = notEligibleForTrial;
        detail.trialSupplyPermissionCode = trialSupplyPermissionCode;
        detail.supplyRequestStatusCode = supplyRequestStatusCode;
        detail.supplyRequestAllowedPeriodLowDate = Helper.parseDATETIME_NONSTRICT(supplyRequestEffectiveTimeLow);
        detail.supplyRequestAllowedPeriodHighDate = Helper.parseDATETIME_NONSTRICT(supplyRequestEffectiveTimeHigh);
        detail.supplyRequestAllowedPeriodDuration = supplyRequestAllowedPeriodDuration;
        detail.supplyRequestLocation = supplyRequestLocation;
        detail.supplyRequestLocationPickupDate = Helper.parseDATETIME_NONSTRICT(supplyRequestLocationPickupDate);
        detail.supplyRequestLocationSubstitutionConditionCode = supplyRequestLocationSubstitutionConditionCode;
        detail.supplyRequestItems = supplyRequestItems;
        detail.substitutionPermissionCode = substitutionPermissionCode;
        detail.substitutionNotAllowedIndicator = substitutionNotAllowedIndicator;
        detail.substitutionNotAllowedReasonCode = substitutionNotAllowedReasonCode;
        detail.refusalsToFill = refusalsToFill;
        detail.annotations = annotations;
        detail.detectedIssueEvents = detectedIssueEvents;
        detail.treatmentTypeCode = treatmentTypeCode;
        detail.supplyEventSummary = supplyEventSummary;
        detail.medicationDispense = medicationDispense;
        detail.historyStatusChanges = historyStatusChanges;
        return detail;
    }

    private static HistoryStatusChange getHistoryStatusChange(PORXMT060340CAControlActEvent cae) {
        HistoryStatusChange c = new HistoryStatusChange();
        c.changeType = ResponseHelper.getCode2(cae.getCode());
        c.changeEffectivePeriodStart = Helper.parseFULLDATE(ResponseHelper.getLow(cae.getEffectiveTime()));
        c.changeEffectivePeriodEnd = Helper.parseFULLDATE(ResponseHelper.getHigh(cae.getEffectiveTime()));
        c.changeReason = ResponseHelper.getCode2(cae.getReasonCode());
        PORXMT060340CAAuthor1 author = cae.getAuthor();
        if (author != null) {
            c.changeBy = ResponseHelper.getProviderAssignedEntity(author);
            c.changeTimestamp = Helper.parseFULLDATETIME(author.getTime().getValue());
            COCTMT090302CAAssignedDevice device = author.getAssignedDevice();
            if (device != null) {
                c.applicationId = ResponseHelper.getNIU(device.getId());
                c.applicationName = device.getAssignedDevice().getManufacturerModelName().getText();
            }
        }
        return c;
    }

    private static HistoryStatusChange getHistoryStatusChange(PORXMT060210CAControlActEvent cae) {
        HistoryStatusChange c = new HistoryStatusChange();
        c.changeType = ResponseHelper.getCode2(cae.getCode());
        c.changeEffectivePeriodStart = Helper.parseFULLDATE(ResponseHelper.getLow(cae.getEffectiveTime()));
        c.changeEffectivePeriodEnd = Helper.parseFULLDATE(ResponseHelper.getHigh(cae.getEffectiveTime()));
        c.changeReason = ResponseHelper.getCode2(cae.getReasonCode());
        PORXMT060210CAAuthor7 author = cae.getAuthor();
        if (author != null) {
            c.changeBy = ResponseHelper.getProviderAssignedEntity(author);
            c.changeTimestamp = Helper.parseFULLDATETIME(author.getTime().getValue());
            COCTMT090302CAAssignedDevice device = author.getAssignedDevice();
            if (device != null) {
                c.applicationId = ResponseHelper.getNIU(device.getId());
                c.applicationName = device.getAssignedDevice().getManufacturerModelName().getText();
            }
        }
        return c;
    }

    protected static DosageInstruction getDosageInstruction(Transaction.TransactionBuilder<?, ?> builder, COCTMT270010CADosageInstruction di) {
        String dosageFromDate = null;
        String dosageToDate = null;
        Duration dosageWidthDate = null;
        Code dosageCode = null;
        String dosageText = null;
        Code dosageRouteCode = null;
        Code dosageAdministrationUnitCode = null;
        String dosageAdditionnalInstructions = null;
        ArrayList<ValueWithUnit> dosageMaxDoseNumerators = null;
        ArrayList<ValueWithUnit> dosageMaxDoseDenominators = null;
        ArrayList<DosageLine> structuredDosageLines = null;
        ArrayList<Code> approachSiteCodes = null;
        Medication consumable = null;
        dosageCode = ResponseHelper.getCode(di.getCode());
        if (ResponseHelper.isNotNull(di.getText())) {
            dosageText = di.getText().getTextValue();
        }
        if (di.getEffectiveTime() != null) {
            dosageFromDate = ResponseHelper.getLow(di.getEffectiveTime().getRest());
            dosageToDate = ResponseHelper.getHigh(di.getEffectiveTime().getRest());
            dosageWidthDate = ResponseHelper.getDuration(di.getEffectiveTime());
        }
        if (ResponseHelper.isNotNull(di.getApproachSiteCode())) {
            approachSiteCodes = new ArrayList<Code>();
            for (CV rawApproachSiteCode : di.getApproachSiteCode()) {
                Code approachSiteCode = ResponseHelper.getCode2(rawApproachSiteCode);
                approachSiteCodes.add(approachSiteCode);
            }
        }
        dosageRouteCode = ResponseHelper.getCode(di.getRouteCode());
        if (ResponseHelper.isNotNull(di.getMaxDoseQuantity())) {
            dosageMaxDoseNumerators = new ArrayList<ValueWithUnit>();
            dosageMaxDoseDenominators = new ArrayList<ValueWithUnit>();
            for (RTOPQPQ maxDose : di.getMaxDoseQuantity()) {
                Number maxDoseNumeratorValue = Helper.parse(maxDose.getNumerator().getValue());
                String maxDoseNumeratorUnit = maxDose.getNumerator().getUnit();
                Number maxDoseDenominatorValue = Helper.parse(maxDose.getDenominator().getValue());
                String maxDoseDenominatorUnit = maxDose.getDenominator().getUnit();
                if (maxDoseDenominatorValue == null || maxDoseDenominatorValue == null || Helper.isBlank(maxDoseNumeratorUnit) || Helper.isBlank(maxDoseDenominatorUnit)) continue;
                dosageMaxDoseNumerators.add(new ValueWithUnit(maxDoseNumeratorValue, maxDoseNumeratorUnit));
                dosageMaxDoseDenominators.add(new ValueWithUnit(maxDoseDenominatorValue, maxDoseDenominatorUnit));
            }
        }
        dosageAdministrationUnitCode = ResponseHelper.getCode(di.getAdministrationUnitCode());
        if (ResponseHelper.isNotNull(di.getConsumable())) {
            if (ResponseHelper.isNotNull(((COCTMT270010CAConsumable1)di.getConsumable().getValue()).getMedication2())) {
                consumable = ResponseHelper.getMedication(((COCTMT270010CAConsumable1)di.getConsumable().getValue()).getMedication2().getValue());
            }
            ResponseHelper.supposedToBeNull(((COCTMT270010CAConsumable1)di.getConsumable().getValue()).getMedication1(), builder);
            ResponseHelper.supposedToBeNull(((COCTMT270010CAConsumable1)di.getConsumable().getValue()).getMedication3(), builder);
            ResponseHelper.supposedToBeNull(((COCTMT270010CAConsumable1)di.getConsumable().getValue()).getMedication4(), builder);
        }
        if (ResponseHelper.isNotNull(di.getComponent1(), "getValue", "getSupplementalInstruction", "getText")) {
            dosageAdditionnalInstructions = ((COCTMT270010CAComponent)di.getComponent1().getValue()).getSupplementalInstruction().getText().getTextValue();
        }
        if (!di.getComponent2().isEmpty()) {
            structuredDosageLines = new ArrayList<DosageLine>();
            for (COCTMT270010CAComponent17 component : di.getComponent2()) {
                COCTMT270010CADosageLine line = component.getDosageLine();
                BigInteger lineSequenceNumber = null;
                Long lineDateLow = null;
                Long lineDateHigh = null;
                String lineAdhocInstruction = null;
                BigInteger lineNumerator = null;
                ValueWithUnit lineDenominator = null;
                Quantity lineQuantityLow = null;
                Quantity lineQuantityHigh = null;
                Duration lineRateQuantityLow = null;
                Duration lineRateQuantityHigh = null;
                String lineCondition = null;
                String lineAdditionnalInstructions = null;
                if (ResponseHelper.isNotNull(component.getSequenceNumber())) {
                    lineSequenceNumber = component.getSequenceNumber().getValue();
                }
                if (ResponseHelper.isNotNull(line.getText())) {
                    lineAdhocInstruction = line.getText().getTextValue();
                }
                if (ResponseHelper.isNotNull(line.getEffectiveTime())) {
                    lineDateLow = Helper.parseDATETIME_NONSTRICT(ResponseHelper.getLowComp(line.getEffectiveTime().getComp()));
                    lineDateHigh = Helper.parseDATETIME_NONSTRICT(ResponseHelper.getHighComp(line.getEffectiveTime().getComp()));
                    lineNumerator = ResponseHelper.getNumeratorComp(line.getEffectiveTime().getComp());
                    String lineDenominator2 = ResponseHelper.getDenomiratorComp(line.getEffectiveTime().getComp());
                    String lineDenominatorUnit2 = ResponseHelper.getDenomiratorCompUnit(line.getEffectiveTime().getComp());
                    if (lineDenominator2 != null && lineDenominatorUnit2 != null) {
                        lineDenominator = new ValueWithUnit(Helper.parse(lineDenominator2), lineDenominatorUnit2);
                    }
                }
                if (ResponseHelper.isNotNull(line.getDoseQuantity())) {
                    Number lineQuantityHighValueNumber;
                    Number lineQuantityLowValueNumber;
                    String lineQuantityLowValue = ResponseHelper.getLow(line.getDoseQuantity().getRest());
                    String lineQuantityLowUnit = ResponseHelper.getLowUnit(line.getDoseQuantity().getRest());
                    if (lineQuantityLowValue != null && (lineQuantityLowValueNumber = Helper.parse(lineQuantityLowValue)) != null && !Helper.isBlank(lineQuantityLowUnit)) {
                        lineQuantityLow = new Quantity(lineQuantityLowValueNumber, lineQuantityLowUnit);
                    }
                    String lineQuantityHighValue = ResponseHelper.getHigh(line.getDoseQuantity().getRest());
                    String lineQuantityHighUnit = ResponseHelper.getHighUnit(line.getDoseQuantity().getRest());
                    if (lineQuantityHighValue != null && (lineQuantityHighValueNumber = Helper.parse(lineQuantityHighValue)) != null && !Helper.isBlank(lineQuantityHighUnit)) {
                        lineQuantityHigh = new Quantity(lineQuantityHighValueNumber, lineQuantityHighUnit);
                    }
                }
                if (ResponseHelper.isNotNull(line.getRateQuantity())) {
                    Number lineRateQuantityHighValueNumber;
                    Number lineRateQuantityLowValueNumber;
                    String lineRateQuantityLowValue = ResponseHelper.getLow(line.getRateQuantity().getRest());
                    String lineRateQuantityLowUnit = ResponseHelper.getLowUnit(line.getRateQuantity().getRest());
                    if (lineRateQuantityLowValue != null && (lineRateQuantityLowValueNumber = Helper.parse(lineRateQuantityLowValue)) != null && !Helper.isBlank(lineRateQuantityLowUnit)) {
                        lineRateQuantityLow = new Duration(lineRateQuantityLowValueNumber, lineRateQuantityLowUnit);
                    }
                    String lineRateQuantityHighValue = ResponseHelper.getHigh(line.getRateQuantity().getRest());
                    String lineRateQuantityHighUnit = ResponseHelper.getHighUnit(line.getRateQuantity().getRest());
                    if (lineRateQuantityHighValue != null && (lineRateQuantityHighValueNumber = Helper.parse(lineRateQuantityHighValue)) != null && !Helper.isBlank(lineRateQuantityHighUnit)) {
                        lineRateQuantityHigh = new Duration(lineRateQuantityHighValueNumber, lineRateQuantityHighUnit);
                    }
                }
                if (ResponseHelper.isNotNull(line.getTrigger(), "getValue", "getActEventCriterion", "getText")) {
                    lineCondition = ((COCTMT270010CATrigger)line.getTrigger().getValue()).getActEventCriterion().getText().getTextValue();
                }
                if (ResponseHelper.isNotNull(line.getComponent(), "getValue", "getSupplementalInstruction", "getText")) {
                    lineAdditionnalInstructions = ((COCTMT270010CAComponent18)line.getComponent().getValue()).getSupplementalInstruction().getText().getTextValue();
                }
                structuredDosageLines.add(new DosageLine(lineSequenceNumber, lineAdhocInstruction, lineDateLow, lineDateHigh, lineNumerator, lineDenominator, lineQuantityLow, lineQuantityHigh, lineRateQuantityLow, lineRateQuantityHigh, lineCondition, lineAdditionnalInstructions));
            }
        }
        return new DosageInstruction(dosageCode, dosageText, Helper.parseDATETIME_NONSTRICT(dosageFromDate), Helper.parseDATETIME_NONSTRICT(dosageToDate), dosageWidthDate, dosageAdditionnalInstructions, dosageMaxDoseNumerators, dosageMaxDoseDenominators, dosageRouteCode, dosageAdministrationUnitCode, approachSiteCodes, consumable, structuredDosageLines);
    }

    private static MedicationDispense parseMedicationDispense(PORXMT060340CAMedicationDispense medicationDispense, Transaction.TransactionBuilder<?, PrescriptionDrugDetails> builder) {
        MedicationDispense m = new MedicationDispense();
        if (ResponseHelper.isNotNull(medicationDispense.getId())) {
            m.dispenseNumber = medicationDispense.getId().getExtension();
        }
        if (ResponseHelper.isNotNull(medicationDispense.getStatusCode())) {
            m.dispenseStatus = medicationDispense.getStatusCode().getCode();
        }
        m.performer = ResponseHelper.getAuthor(medicationDispense.getPerformer());
        m.location = ResponseHelper.getLocation(medicationDispense.getLocation());
        m.dosageInstructions = new ArrayList();
        for (PORXMT060340CAComponent11 rawDosageInstruction : medicationDispense.getComponent1()) {
            COCTMT270010CASupplementalInstruction si;
            COCTMT270010CADosageInstruction di = rawDosageInstruction.getDosageInstruction();
            Code dosageCode = null;
            String dosageText = null;
            String dosageFromDate = null;
            String dosageToDate = null;
            Duration dosageDuration = null;
            String dosageAdditionnalInstructrions = null;
            ArrayList<ValueWithUnit> dosageMaxDoseNumerators = null;
            ArrayList<ValueWithUnit> dosageMaxDoseDenominators = null;
            Code dosageRouteCode = null;
            Code dosageAdministrationUnitCode = null;
            ArrayList<Code> approachSiteCodes = null;
            Medication consumable = null;
            ArrayList<DosageLine> dosageLines = null;
            dosageCode = ResponseHelper.getCode(di.getCode());
            if (ResponseHelper.isNotNull(di.getText())) {
                dosageText = di.getText().getTextValue();
            }
            if (ResponseHelper.isNotNull(di.getEffectiveTime())) {
                dosageFromDate = ResponseHelper.getLow(di.getEffectiveTime().getRest());
                dosageToDate = ResponseHelper.getHigh(di.getEffectiveTime().getRest());
                dosageDuration = ResponseHelper.getDuration(di.getEffectiveTime().getRest());
            }
            dosageRouteCode = ResponseHelper.getCode(di.getRouteCode());
            dosageAdministrationUnitCode = ResponseHelper.getCode(di.getAdministrationUnitCode());
            if (ResponseHelper.isNotNull(di.getApproachSiteCode())) {
                approachSiteCodes = new ArrayList<Code>();
                for (CV rawApproachSiteCode : di.getApproachSiteCode()) {
                    Code approachSiteCode = ResponseHelper.getCode2(rawApproachSiteCode);
                    if (approachSiteCode == null) continue;
                    approachSiteCodes.add(approachSiteCode);
                }
            }
            if (ResponseHelper.isNotNull(di.getMaxDoseQuantity())) {
                dosageMaxDoseNumerators = new ArrayList<ValueWithUnit>();
                dosageMaxDoseDenominators = new ArrayList<ValueWithUnit>();
                for (RTOPQPQ maxDose : di.getMaxDoseQuantity()) {
                    Number maxDoseNumeratorValue = Helper.parse(maxDose.getNumerator().getValue());
                    String maxDoseNumeratorUnit = maxDose.getNumerator().getUnit();
                    Number maxDoseDenominatorValue = Helper.parse(maxDose.getDenominator().getValue());
                    String maxDoseDenominatorUnit = maxDose.getDenominator().getUnit();
                    if (maxDoseDenominatorValue == null || maxDoseDenominatorValue == null || Helper.isBlank(maxDoseNumeratorUnit) || Helper.isBlank(maxDoseDenominatorUnit)) continue;
                    dosageMaxDoseNumerators.add(new ValueWithUnit(maxDoseNumeratorValue, maxDoseNumeratorUnit));
                    dosageMaxDoseDenominators.add(new ValueWithUnit(maxDoseDenominatorValue, maxDoseDenominatorUnit));
                }
            }
            if (ResponseHelper.isNotNull(di.getConsumable())) {
                if (ResponseHelper.isNotNull(((COCTMT270010CAConsumable1)di.getConsumable().getValue()).getMedication4())) {
                    consumable = ResponseHelper.getMedication(((COCTMT270010CAConsumable1)di.getConsumable().getValue()).getMedication4().getValue());
                }
                ResponseHelper.supposedToBeNull(((COCTMT270010CAConsumable1)di.getConsumable().getValue()).getMedication1(), builder);
                ResponseHelper.supposedToBeNull(((COCTMT270010CAConsumable1)di.getConsumable().getValue()).getMedication2(), builder);
                ResponseHelper.supposedToBeNull(((COCTMT270010CAConsumable1)di.getConsumable().getValue()).getMedication3(), builder);
            }
            if (ResponseHelper.isNotNull(di.getComponent1()) && ResponseHelper.isNotNull(si = ((COCTMT270010CAComponent)di.getComponent1().getValue()).getSupplementalInstruction()) && ResponseHelper.isNotNull(si.getText())) {
                dosageAdditionnalInstructrions = si.getText().getTextValue();
            }
            if (!di.getComponent2().isEmpty()) {
                dosageLines = new ArrayList<DosageLine>();
                for (COCTMT270010CAComponent17 component : di.getComponent2()) {
                    COCTMT270010CADosageLine line = component.getDosageLine();
                    BigInteger lineSequenceNumber = null;
                    Long lineDateLow = null;
                    Long lineDateHigh = null;
                    String lineAdhocInstruction = null;
                    BigInteger lineNumerator = null;
                    ValueWithUnit lineDenominator = null;
                    Quantity lineQuantityLow = null;
                    Quantity lineQuantityHigh = null;
                    Duration lineRateQuantityLow = null;
                    Duration lineRateQuantityHigh = null;
                    String lineCondition = null;
                    String lineAdditionnalInstructions = null;
                    if (ResponseHelper.isNotNull(component.getSequenceNumber())) {
                        lineSequenceNumber = component.getSequenceNumber().getValue();
                    }
                    if (ResponseHelper.isNotNull(line.getText())) {
                        lineAdhocInstruction = line.getText().getTextValue();
                    }
                    if (ResponseHelper.isNotNull(line.getEffectiveTime())) {
                        lineDateLow = Helper.parseDATETIME_NONSTRICT(ResponseHelper.getLowComp(line.getEffectiveTime().getComp()));
                        lineDateHigh = Helper.parseDATETIME_NONSTRICT(ResponseHelper.getHighComp(line.getEffectiveTime().getComp()));
                        lineNumerator = ResponseHelper.getNumeratorComp(line.getEffectiveTime().getComp());
                        String lineDenominator2 = ResponseHelper.getDenomiratorComp(line.getEffectiveTime().getComp());
                        String lineDenominatorUnit2 = ResponseHelper.getDenomiratorCompUnit(line.getEffectiveTime().getComp());
                        if (lineDenominator2 != null && lineDenominatorUnit2 != null) {
                            lineDenominator = new ValueWithUnit(Helper.parse(lineDenominator2), lineDenominatorUnit2);
                        }
                    }
                    if (ResponseHelper.isNotNull(line.getDoseQuantity())) {
                        Number lineQuantityHighValueNumber;
                        Number lineQuantityLowValueNumber;
                        String lineQuantityLowValue = ResponseHelper.getLow(line.getDoseQuantity().getRest());
                        String lineQuantityLowUnit = ResponseHelper.getLowUnit(line.getDoseQuantity().getRest());
                        if (lineQuantityLowValue != null && (lineQuantityLowValueNumber = Helper.parse(lineQuantityLowValue)) != null && !Helper.isBlank(lineQuantityLowUnit)) {
                            lineQuantityLow = new Quantity(lineQuantityLowValueNumber, lineQuantityLowUnit);
                        }
                        String lineQuantityHighValue = ResponseHelper.getHigh(line.getDoseQuantity().getRest());
                        String lineQuantityHighUnit = ResponseHelper.getHighUnit(line.getDoseQuantity().getRest());
                        if (lineQuantityHighValue != null && (lineQuantityHighValueNumber = Helper.parse(lineQuantityHighValue)) != null && !Helper.isBlank(lineQuantityHighUnit)) {
                            lineQuantityHigh = new Quantity(lineQuantityHighValueNumber, lineQuantityHighUnit);
                        }
                    }
                    if (ResponseHelper.isNotNull(line.getRateQuantity())) {
                        String lineRateQuantityLowValue = ResponseHelper.getLow(line.getRateQuantity().getRest());
                        String lineRateQuantityLowUnit = ResponseHelper.getLowUnit(line.getRateQuantity().getRest());
                        if (lineRateQuantityLowValue != null) {
                            lineRateQuantityLow = new Duration(Helper.parse(lineRateQuantityLowValue), lineRateQuantityLowUnit);
                        }
                        String lineRateQuantityHighValue = ResponseHelper.getHigh(line.getRateQuantity().getRest());
                        String lineRateQuantityHighUnit = ResponseHelper.getHighUnit(line.getRateQuantity().getRest());
                        if (lineRateQuantityHighValue != null) {
                            lineRateQuantityHigh = new Duration(Helper.parse(lineRateQuantityHighValue), lineRateQuantityHighUnit);
                        }
                    }
                    if (ResponseHelper.isNotNull(line, "getTrigger", "getValue", "getActEventCriterion", "getText")) {
                        lineCondition = ((COCTMT270010CATrigger)line.getTrigger().getValue()).getActEventCriterion().getText().getTextValue();
                    }
                    if (ResponseHelper.isNotNull(line, "getComponent", "getValue", "getSupplementalInstruction", "getText")) {
                        lineAdditionnalInstructions = ((COCTMT270010CAComponent18)line.getComponent().getValue()).getSupplementalInstruction().getText().getTextValue();
                    }
                    dosageLines.add(new DosageLine(lineSequenceNumber, lineAdhocInstruction, lineDateLow, lineDateHigh, lineNumerator, lineDenominator, lineQuantityLow, lineQuantityHigh, lineRateQuantityLow, lineRateQuantityHigh, lineCondition, lineAdditionnalInstructions));
                }
            }
            m.dosageInstructions.add(new DosageInstruction(dosageCode, dosageText, Helper.parseDATETIME_NONSTRICT(dosageFromDate), Helper.parseDATETIME_NONSTRICT(dosageToDate), dosageDuration, dosageAdditionnalInstructrions, dosageMaxDoseNumerators, dosageMaxDoseDenominators, dosageRouteCode, dosageAdministrationUnitCode, approachSiteCodes, consumable, dosageLines));
        }
        if (ResponseHelper.isNotNull(medicationDispense.getComponent2())) {
            m.substitutionMade = new SubstitutionMade();
            PORXMT060340CASubstitutionMade sm = ((PORXMT060340CAComponent13)medicationDispense.getComponent2().getValue()).getSubstitutionMade();
            m.substitutionMade.substitutionCode = ResponseHelper.getCode(sm.getCode());
            m.substitutionMade.productSelectionReasonCode = ResponseHelper.getCode(sm.getReasonCode());
            if (ResponseHelper.isNotNull(sm.getResponsibleParty())) {
                m.substitutionMade.substitutingPersonIdentifier = ResponseHelper.getNIU(((PORXMT060340CAResponsibleParty)sm.getResponsibleParty().getValue()).getAgent().getId());
            }
        }
        if (ResponseHelper.isNotNull(medicationDispense.getComponent3()) && ResponseHelper.isNotNull(medicationDispense.getComponent3().getSupplyEvent())) {
            PORXMT060340CASupplyEvent supplyEvent = medicationDispense.getComponent3().getSupplyEvent();
            m.dispenseProcessingAndPickupDate = Helper.parseFULLDATE(ResponseHelper.getHigh(supplyEvent.getEffectiveTime()));
            m.dispensedDaysSupply = ResponseHelper.getDuration(supplyEvent.getExpectedUseTime());
            m.dispensedQuantity = ResponseHelper.getQuantity(supplyEvent.getQuantity());
            m.dispenseType = ResponseHelper.getCode(supplyEvent.getCode());
            m.medication = ResponseHelper.getMedication(supplyEvent.getProduct().getMedication());
        }
        return m;
    }

    public static <T> Collection<T> getNullSafe(Collection<T> t) {
        if (t == null) {
            return Collections.emptyList();
        }
        return t;
    }

    public static ValueWithUnit2 getValueWithUnit(Object valueUnitAndType) {
        Object value2;
        String type;
        Object value = Helper.invoke(valueUnitAndType, "getValue");
        String unit = (String)Helper.invoke(valueUnitAndType, "getUnit");
        try {
            type = (String)Helper.invoke(valueUnitAndType, "getType");
        }
        catch (Exception e) {
            try {
                type = (String)Helper.invoke(valueUnitAndType, "getSpecializationType");
            }
            catch (Exception e2) {
                type = null;
            }
        }
        if ("ST".equals(type)) {
            if (value != null) {
                value2 = value;
            } else if (Helper.hasMethod(valueUnitAndType, "getContent")) {
                Collection content = (Collection)Helper.invoke(valueUnitAndType, "getContent");
                value2 = new JoinList(", ", content).toString();
            } else {
                value2 = null;
            }
        } else {
            value2 = Helper.parse(value);
        }
        return new ValueWithUnit2(value2, unit);
    }

    public static Object invokeNJax(Object o, String method) throws RuntimeException {
        if (o != null) {
            try {
                Object r = o.getClass().getMethod(method, new Class[0]).invoke(o, new Object[0]);
                if (r instanceof JAXBElement) {
                    return ((JAXBElement)r).getValue();
                }
                return r;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static File createFile(File file, String content) throws IOException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(file);
            fos.write(content.getBytes());
            fos.flush();
        }
        return file;
    }
}

