/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.tools;

import ca.infodata.dsq.domain.ValueWithUnit;
import ca.infodata.dsq.tools.JoinList;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public final class Helper {
    private Helper() {
        throw new UnsupportedOperationException();
    }

    public static boolean isNonNullAndBlank(String s) {
        return s != null && (s.isEmpty() || s.trim().isEmpty());
    }

    public static boolean isBlank(String s) {
        return s == null || s.isEmpty() || s.trim().isEmpty();
    }

    public static boolean isNotBlank(String s) {
        return !Helper.isBlank(s);
    }

    public static boolean isNonNullAndLowerOrEqualsZero(Number n) {
        return n != null && new BigDecimal(n.toString()).compareTo(BigDecimal.ZERO) <= 0;
    }

    public static boolean isNonNullAndLowerThanZero(Number n) {
        return n != null && new BigDecimal(n.toString()).compareTo(BigDecimal.ZERO) < 0;
    }

    public static boolean isNonNullAndLowerOrEqualsZero(ValueWithUnit n) {
        return n != null && n.value != null && new BigDecimal(n.value.toString()).compareTo(BigDecimal.ZERO) <= 0;
    }

    public static boolean isNonNullAndLowerThanZero(ValueWithUnit n) {
        return n != null && n.value != null && new BigDecimal(n.value.toString()).compareTo(BigDecimal.ZERO) < 0;
    }

    public static Object invoke(Object o, String method) throws RuntimeException {
        if (o != null) {
            try {
                return o.getClass().getMethod(method, new Class[0]).invoke(o, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Object invokeA(Object o, String method, Object arg1) throws RuntimeException {
        if (o != null) {
            try {
                return o.getClass().getMethod(method, Helper.getArg1Class(method, arg1)).invoke(o, arg1);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static Class<?> getArg1Class(String method, Object arg1) {
        if (method.startsWith("add")) {
            return Object.class;
        }
        return arg1.getClass();
    }

    public static Object invokeA2(Object o, String methods, Object arg1) throws RuntimeException {
        if (o != null) {
            try {
                Object o2 = o;
                String[] methods2 = methods.replace(".", "").split("\\(\\)");
                for (int i = 0; i < methods2.length - 1; ++i) {
                    o2 = o.getClass().getMethod(methods2[i], new Class[0]).invoke(o, new Object[0]);
                }
                o2.getClass().getMethod(methods2[methods2.length - 1], Helper.getArg1Class(methods2[methods2.length - 1], arg1)).invoke(o2, arg1);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Object invoke(Object o, String ... methods) throws RuntimeException {
        if (o != null) {
            try {
                Object result = o;
                for (int i = 0; result != null && i < methods.length; ++i) {
                    result = result.getClass().getMethod(methods[i], new Class[0]).invoke(result, new Object[0]);
                }
                return result;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Object invoke2(Object o, String methods) throws RuntimeException {
        String[] methods2 = methods.replace(".", "").split("\\(\\)");
        return Helper.invoke(o, methods2);
    }

    public static boolean hasMethod(Object o, String method) throws RuntimeException {
        if (o != null && method != null) {
            try {
                Method[] methods;
                for (Method m : methods = o.getClass().getMethods()) {
                    if (!m.getName().equals(method)) continue;
                    return true;
                }
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        return false;
    }

    public static boolean hasMethod(Object o, String ... methods) throws RuntimeException {
        if (o != null) {
            for (String m : methods) {
                if (!Helper.hasMethod(o, m)) {
                    return false;
                }
                if ((o = Helper.invoke(o, m)) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void appendPadded(int number, int length, StringBuilder b) {
        if (b == null) {
            throw new NullPointerException("b");
        }
        if (number < 0) {
            throw new IllegalArgumentException("negative number are not supported");
        }
        int pad = Helper.computePadding(number, length);
        for (int i = 0; i < pad; ++i) {
            b.append('0');
        }
        b.append(String.valueOf(number));
    }

    private static int computePadding(int number, int length) {
        int d = number >= 0 && number < 10 ? 1 : (number > 0 ? Helper.fastLog10(number) + 1 : Helper.fastLog10(-number) + 1 + 1);
        return length - d;
    }

    private static int fastLog10(int n) {
        int i = 10;
        int j = 0;
        while (n / i != 0) {
            i *= 10;
            ++j;
        }
        return j;
    }

    public static String truncate(String source, int maxStringLength) {
        if (source == null) {
            return null;
        }
        if (source.length() <= maxStringLength) {
            return source;
        }
        if (maxStringLength < 0) {
            return "";
        }
        return source.substring(0, maxStringLength);
    }

    public static String formatFULLDATETIME(Long timeMillis) {
        return Helper.formatFULLDATETIME(timeMillis, TimeZone.getTimeZone("GMT"), true, true);
    }

    public static String formatFULLDATETIME(Long timeMillis, TimeZone tz) {
        return Helper.formatFULLDATETIME(timeMillis, tz, true, true);
    }

    public static String formatFULLDATETIME(Long timeMillis, TimeZone tz, boolean includeTz, boolean includeMillis) {
        if (timeMillis == null) {
            return null;
        }
        if (tz == null) {
            tz = TimeZone.getTimeZone("GMT");
        }
        StringBuilder pattern = new StringBuilder(24);
        pattern.append("yyyyMMddHHmmss");
        if (includeMillis) {
            pattern.append(".SSSS");
        }
        if (includeTz) {
            pattern.append("Z");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern.toString());
        sdf.setTimeZone(tz);
        String eventTime = sdf.format(timeMillis);
        return eventTime;
    }

    public static String formatFULL_ENDTIME(Long timeMillis, TimeZone tz, boolean includeTz, boolean includeMillis) {
        if (timeMillis == null) {
            return null;
        }
        if (tz == null) {
            tz = TimeZone.getTimeZone("GMT");
        }
        StringBuilder pattern = new StringBuilder(24);
        pattern.append("yyyyMMdd ");
        if (includeMillis) {
            pattern.append(".SSSS");
        }
        if (includeTz) {
            pattern.append("Z");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern.toString());
        sdf.setTimeZone(tz);
        String[] split = sdf.format(timeMillis).split(" ");
        String eventTime = split[0] + "235959" + split[1];
        return eventTime;
    }

    public static String formatFULLDATE(Long timeMillis) {
        if (timeMillis == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        sdf.setTimeZone(TimeZone.getDefault());
        String eventTime = sdf.format(timeMillis);
        return eventTime;
    }

    public static String formatFULLDATE(LocalDate date) {
        if (date == null) {
            return null;
        }
        return LocalDateFormat.format((LocalDate)date, (String)"yyyyMMdd");
    }

    public static long getTimeUtc(int year, int month, int day) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("month must be in [1..12]");
        }
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.clear();
        c.set(1, year);
        c.set(2, month - 1);
        int maximumDay = c.getMaximum(5);
        if (day < 1 || day > maximumDay) {
            throw new IllegalArgumentException("day must be in [" + day + ".." + maximumDay + "]");
        }
        c.set(5, day);
        return c.getTimeInMillis();
    }

    public static long getTimeLocal(int year, int month, int day) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("month must be in [1..12]");
        }
        Calendar c = Calendar.getInstance(TimeZone.getDefault());
        c.clear();
        c.set(1, year);
        c.set(2, month - 1);
        int maximumDay = c.getMaximum(5);
        if (day < 1 || day > maximumDay) {
            throw new IllegalArgumentException("day must be in [" + day + ".." + maximumDay + "]");
        }
        c.set(5, day);
        return c.getTimeInMillis();
    }

    public static Long parseFULLDATE(String source) {
        return Helper.parseDatetime("yyyyMMdd", source, TimeZone.getDefault());
    }

    public static LocalDate parseLocalDateFULLDATE(String source) {
        Long time = Helper.parseDatetime("yyyyMMdd", source, TimeZone.getDefault());
        if (time == null) {
            return null;
        }
        return LocalDate.fromTimeInMillisUTC((Long)time);
    }

    public static Long parseFULLDATETIME(String source) {
        return Helper.parseDatetime("yyyyMMddHHmmss", source, TimeZone.getTimeZone("GMT"));
    }

    public static Long parseFULLDATETIME(String source, TimeZone timeZone) {
        return Helper.parseDatetime("yyyyMMddHHmmss", source, timeZone);
    }

    public static Calendar parseCalendarFULLDATETIME(String source, TimeZone timeZone) {
        Long datetime = Helper.parseDatetime("yyyyMMddHHmmss", source, timeZone);
        if (datetime == null) {
            return null;
        }
        Calendar c = Calendar.getInstance(timeZone);
        c.setTime(new Date(datetime));
        return c;
    }

    public static Long parseDATETIME_NONSTRICT(String source) {
        return Helper.parseDATETIME_NONSTRICT(source, TimeZone.getDefault());
    }

    public static Long parseDATETIME_NONSTRICT(String source, TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timeZone");
        }
        if (source == null) {
            return null;
        }
        if (source.length() >= "yyyyMMddHHmmss".length()) {
            return Helper.parseDatetime("yyyyMMddHHmmss", source, timeZone);
        }
        if (source.length() >= "yyyyMMdd".length()) {
            return Helper.parseDatetime("yyyyMMdd", source, timeZone);
        }
        if (source.length() >= "yyyyMM".length()) {
            return Helper.parseDatetime("yyyyMM", source, timeZone);
        }
        if (source.length() >= "yyyy".length()) {
            return Helper.parseDatetime("yyyy", source, timeZone);
        }
        throw new IllegalArgumentException("unable to parse " + source);
    }

    public static Long parseDatetime(String format, String source, TimeZone timeZone) {
        Date date;
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (timeZone == null) {
            throw new NullPointerException("timeZone");
        }
        if (Helper.isBlank(source)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(timeZone);
        try {
            date = !format.contains("HHmmss") && source.endsWith("000000") ? sdf.parse(source.replace("000000", "")) : sdf.parse(source);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date.getTime();
    }

    public static Number parse(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Number) {
            return (Number)source;
        }
        if (source instanceof String) {
            try {
                DecimalFormat f = new DecimalFormat();
                DecimalFormatSymbols fs = DecimalFormatSymbols.getInstance();
                fs.setDecimalSeparator('.');
                f.setDecimalFormatSymbols(fs);
                String s = (String)source;
                s = s.replace(',', '.');
                return f.parse(s);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("unable to parse " + source);
    }

    public static String wrap(String source, char c) {
        StringBuilder b = new StringBuilder(source);
        for (int i = 0; i < b.length() - 1; ++i) {
            char d = b.charAt(i);
            if (c != d) continue;
            b.insert(i + 1, "\n");
        }
        return b.toString();
    }

    public static String padLeft(String source, int newStringLenght, char paddingChar) {
        if (source == null) {
            throw new IllegalArgumentException("source cant be null");
        }
        int length = source.length();
        if (length >= newStringLenght) {
            return source;
        }
        StringBuilder builder = new StringBuilder(newStringLenght);
        builder.append(source);
        char[] padding = new char[newStringLenght - length];
        Arrays.fill(padding, paddingChar);
        builder.insert(0, padding);
        return builder.toString();
    }

    public static String join(Collection<?> col, String sep) {
        if (sep == null) {
            throw new NullPointerException("sep");
        }
        if (col == null) {
            return "null";
        }
        if (col.isEmpty()) {
            return "[]";
        }
        StringBuilder b = new StringBuilder(col.size() * sep.length());
        Iterator<?> iterator = col.iterator();
        while (iterator.hasNext()) {
            b.append(iterator.next());
            if (!iterator.hasNext()) continue;
            b.append(sep);
        }
        return b.toString();
    }

    public static boolean isNumeric(String s) {
        if (s == null || s.length() == 0 || s.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Helper.isNumeric(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isNumeric(char c) {
        return c >= '0' && c <= '9';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAndClose(InputStream is, Charset charset) throws IOException {
        try {
            InputStreamReader input = new InputStreamReader(is, charset);
            int CHARS_PER_PAGE = 5000;
            char[] buffer = new char[5000];
            StringBuilder output = new StringBuilder(5000);
            int read = input.read(buffer, 0, buffer.length);
            while (read != -1) {
                output.append(buffer, 0, read);
                read = input.read(buffer, 0, buffer.length);
            }
            String string = output.toString();
            return string;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAndClose(Reader reader) throws IOException {
        try {
            int CHARS_PER_PAGE = 5000;
            char[] buffer = new char[5000];
            StringBuilder output = new StringBuilder(5000);
            int read = reader.read(buffer, 0, buffer.length);
            while (read != -1) {
                output.append(buffer, 0, read);
                read = reader.read(buffer, 0, buffer.length);
            }
            String string = output.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        return str.concat(Helper.padding(pads, padChar));
    }

    private static String padding(int repeat, char padChar) throws IndexOutOfBoundsException {
        if (repeat < 0) {
            throw new IndexOutOfBoundsException("Cannot pad a negative amount: " + repeat);
        }
        char[] buf = new char[repeat];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = padChar;
        }
        return new String(buf);
    }

    public static String getContent(List<Serializable> content) {
        if (content == null) {
            return null;
        }
        if (content.isEmpty()) {
            return "";
        }
        JoinList list = new JoinList(" ", content.size());
        for (Serializable c : content) {
            list.add(String.valueOf(c));
        }
        return list.toString();
    }
}

