/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain;

import ca.infodata.dsq.domain.Annotation;
import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.DetectedIssueEvent;
import ca.infodata.dsq.domain.Device;
import ca.infodata.dsq.domain.Duration;
import ca.infodata.dsq.domain.ILocation;
import ca.infodata.dsq.domain.IPrescriptionDetails;
import ca.infodata.dsq.domain.IProvider;
import ca.infodata.dsq.domain.Quantity;
import ca.infodata.dsq.domain.Refusal;
import ca.infodata.dsq.domain.TherapeuticIntent;
import ca.infodata.dsq.tools.Helper;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;

public final class PrescriptionDeviceDetails
implements Serializable,
IPrescriptionDetails {
    private static final long serialVersionUID = 1L;
    public String id = null;
    public String version = null;
    public Code status;
    public Long datetime;
    public ILocation location;
    public IProvider prescriber;
    public String previousPrescriptionId;
    public String previousPrescriptionVersion;
    public ArrayList<TherapeuticIntent> reasons;
    public Boolean electronicVersionHasAuthority;
    public String derivedFromCode;
    public Device device;
    public String usageInstructions;
    public Duration supplyRequestTotalDaysSupply;
    public Quantity supplyRequestTotalQuantity;
    public BigInteger supplyRequestNumberOfFills;
    public Quantity supplyRequestFillQuantity;
    public ILocation supplyRequestLocation;
    public Long supplyRequestLocationPickupDate;
    public ArrayList<Refusal> refusalsToFill;
    public ArrayList<Annotation> annotations;
    public ArrayList<DetectedIssueEvent> detectedIssueEvents;

    public String toString() {
        int i;
        String format = "PrescriptionDeviceDetails [id=%s, version=%s, statusCode=%s, date=%s(%s)\n%s,\n%s\n%s,\nPrevious prescription id=%s, version=%s\nPrescribed because of %s\nElectronic Version Has Authority %s\nDerivedFrom value=%s\nSupply Request\n  totalDaysSupply=%s(d), \n  location=%s, pickupDate=%s(%s)\n  totalQuantity=%s, numberOfFills=%s, fillQuantity=%s\nRefusals To Fill{refusals}\nDetected Issue Events{events}\nAnnotations{annotations}";
        String format2 = "";
        if (this.refusalsToFill != null) {
            for (i = 0; i < this.refusalsToFill.size(); ++i) {
                if (i == 0) {
                    format2 = format2 + "\nRefusal=";
                }
                format2 = format2 + "\n" + this.refusalsToFill.get(i);
            }
        }
        format = format.replace("{refusals}", format2);
        format2 = "";
        if (this.detectedIssueEvents != null) {
            for (i = 0; i < this.detectedIssueEvents.size(); ++i) {
                if (i == 0) {
                    format2 = format2 + "\nEvent=";
                }
                format2 = format2 + "\n" + this.detectedIssueEvents.get(i);
            }
        }
        format = format.replace("{events}", format2);
        format2 = "";
        if (this.annotations != null) {
            for (i = 0; i < this.annotations.size(); ++i) {
                if (i == 0) {
                    format2 = format2 + "\nAnnotation=";
                }
                format2 = format2 + "\n" + this.annotations.get(i);
            }
        }
        format = format.replace("{annotations}", format2);
        return String.format(format, this.id, this.version, this.status, this.datetime, Helper.formatFULLDATETIME(this.datetime), this.prescriber, this.location, this.device, this.previousPrescriptionId, this.previousPrescriptionVersion, this.reasons, this.electronicVersionHasAuthority, this.derivedFromCode, this.supplyRequestTotalDaysSupply, this.supplyRequestLocation, this.supplyRequestLocationPickupDate, Helper.formatFULLDATE(this.supplyRequestLocationPickupDate), this.supplyRequestTotalQuantity, this.supplyRequestNumberOfFills, this.supplyRequestFillQuantity);
    }

    @Override
    public Long getDatetime() {
        return this.datetime;
    }

    @Override
    public Boolean getElectronicVersionHasAuthority() {
        return this.electronicVersionHasAuthority;
    }

    @Override
    public Boolean getHasAnnotations() {
        return this.annotations != null && !this.annotations.isEmpty();
    }

    @Override
    public Boolean getHasIssues() {
        return this.detectedIssueEvents != null && !this.detectedIssueEvents.isEmpty();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IProvider getPrescriber() {
        return this.prescriber;
    }

    @Override
    public ArrayList<TherapeuticIntent> getReasons() {
        return this.reasons;
    }

    @Override
    public ArrayList<Refusal> getRefusalsToFill() {
        return this.refusalsToFill;
    }

    @Override
    public Code getStatus() {
        return this.status;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public ArrayList<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public ArrayList<DetectedIssueEvent> getDetectedIssueEvents() {
        return this.detectedIssueEvents;
    }

    @Override
    public ILocation getLocation() {
        return this.location;
    }

    @Override
    public String getPreviousPrescriptionId() {
        return this.previousPrescriptionId;
    }

    @Override
    public String getPreviousPrescriptionVersion() {
        return this.previousPrescriptionVersion;
    }

    @Override
    public ILocation getSupplyRequestLocation() {
        return this.supplyRequestLocation;
    }

    @Override
    public IPrescriptionDetails getDetail() {
        return this;
    }

    @Override
    public void setDetail(IPrescriptionDetails detail) {
    }
}

