/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain;

import ca.infodata.dsq.domain.Address;
import ca.infodata.dsq.domain.CandidateRelation;
import ca.infodata.dsq.domain.Gender;
import ca.infodata.dsq.domain.ICandidate;
import ca.infodata.dsq.domain.NAM;
import ca.infodata.dsq.domain.NIU_U;
import java.util.ArrayList;
import java.util.List;

public final class Candidate
implements ICandidate {
    private static final long serialVersionUID = 1L;
    public final NIU_U niu;
    public final NAM nam;
    public final String firstName;
    public final String lastName;
    public final Gender gender;
    public final Long birthdate;
    public final Long deceasedate;
    public final Address address;
    public final ArrayList<CandidateRelation> relations;

    public Candidate(NIU_U niu, NAM nam, String firstName, String lastName) {
        this(niu, nam, firstName, lastName, null, null, null, null, null);
    }

    public Candidate(NIU_U niu, NAM nam, String firstName, String lastName, Gender gender, Long birthdate, Address address) {
        this(niu, nam, firstName, lastName, gender, birthdate, address, null, null);
    }

    public Candidate(NIU_U niu, NAM nam, String firstName, String lastName, Gender gender, Long birthdate, Address address, Long deceaseddate, List<CandidateRelation> relationList) {
        if (niu == null) {
            throw new NullPointerException("niu");
        }
        if (firstName == null) {
            throw new NullPointerException("firstName");
        }
        if (lastName == null) {
            throw new NullPointerException("lastName");
        }
        this.niu = niu;
        this.nam = nam;
        this.firstName = firstName;
        this.lastName = lastName;
        this.gender = gender;
        this.birthdate = birthdate;
        this.address = address;
        this.deceasedate = deceaseddate;
        this.relations = relationList == null ? null : new ArrayList<CandidateRelation>(relationList);
    }

    public String toString() {
        return String.format("Candidate [niu=%s, nam=%s, firstName=%s, lastName=%s, gender=%s, birthdate=%s, deceaseddate=%s, address=%s, relation=%s]", new Object[]{this.niu, this.nam, this.firstName, this.lastName, this.gender, this.birthdate, this.deceasedate, this.address, this.relations});
    }

    @Override
    public NIU_U getNiu() {
        return this.niu;
    }

    public NAM getNam() {
        return this.nam;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    public Gender getGender() {
        return this.gender;
    }

    public Long getBirthDate() {
        return this.birthdate;
    }

    public Long getDeceasedDate() {
        return this.deceasedate;
    }

    public Address getAddress() {
        return this.address;
    }

    public ArrayList<CandidateRelation> getRelations() {
        return this.relations;
    }
}

