/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.abst.geo.Triangulate2ViewsMetric;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.PositiveDepthConstraintCheck;
import boofcv.alg.geo.robust.ModelMatcherMultiview;
import boofcv.alg.geo.triangulate.Triangulate2ViewReprojectionMetricError;
import boofcv.alg.sfm.EstimateSceneStructure;
import boofcv.alg.sfm.structure.MetricSceneGraph;
import boofcv.alg.sfm.structure.PairwiseImageGraph;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.geo.Point2D3D;
import georegression.geometry.GeometryMath_F64;
import georegression.geometry.UtilVector3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ddogleg.struct.GrowQueue_F64;
import org.ddogleg.struct.GrowQueue_I32;

public class EstimateSceneCalibrated
implements EstimateSceneStructure<SceneStructureMetric> {
    private volatile boolean stopRequested = false;
    private double TRIANGULATE_MIN_ANGLE = 0.15707963267948966;
    Map<String, Integer> cameraToIndex = new HashMap<String, Integer>();
    ModelMatcherMultiview<Se3_F64, Point2D3D> ransacPnP;
    Triangulate2ViewsMetric triangulate = FactoryMultiView.triangulate2ViewMetric(new ConfigTriangulation(ConfigTriangulation.Type.GEOMETRIC));
    Triangulate2ViewReprojectionMetricError triangulationError = new Triangulate2ViewReprojectionMetricError();
    MetricSceneGraph graph;
    List<MetricSceneGraph.View> viewsAdded = new ArrayList<MetricSceneGraph.View>();
    private Vector3D_F64 arrowA = new Vector3D_F64();
    private Vector3D_F64 arrowB = new Vector3D_F64();
    SceneStructureMetric structure;
    SceneObservations observations;
    PrintStream verbose;
    double maxPixelError = 2.5;
    ConfigRansac configRansac = new ConfigRansac(4000, this.maxPixelError);

    @Override
    public boolean process(PairwiseImageGraph pairwiseGraph) {
        int i;
        this.graph = new MetricSceneGraph(pairwiseGraph);
        for (i = 0; i < this.graph.edges.size(); ++i) {
            this.decomposeEssential(this.graph.edges.get(i));
        }
        this.declareModelFitting();
        for (i = 0; i < this.graph.edges.size(); ++i) {
            MetricSceneGraph.Motion e = this.graph.edges.get(i);
            e.triangulationAngle = this.medianTriangulationAngle(e);
        }
        if (this.verbose != null) {
            this.verbose.println("Selecting root");
        }
        MetricSceneGraph.View origin = this.selectOriginNode();
        MetricSceneGraph.Motion baseMotion = this.selectCoordinateBase(origin);
        this.graph.sanityCheck();
        if (this.verbose != null) {
            this.verbose.println("Stereo triangulation");
        }
        for (int i2 = 0; i2 < this.graph.edges.size() && !this.stopRequested; ++i2) {
            MetricSceneGraph.Motion e = this.graph.edges.get(i2);
            if (!(e.triangulationAngle > 0.3141592653589793) && e != baseMotion) continue;
            this.triangulateStereoEdges(e);
            if (this.verbose == null) continue;
            int a = e.viewSrc.index;
            int b = e.viewDst.index;
            this.verbose.println("   Edge[" + i2 + "] " + a + "->" + b + "  feat3D=" + e.stereoTriangulations.size());
        }
        if (this.stopRequested) {
            return false;
        }
        if (this.verbose != null) {
            this.verbose.println("Defining the coordinate system");
        }
        this.defineCoordinateSystem(origin, baseMotion);
        if (this.stopRequested) {
            return false;
        }
        if (this.verbose != null) {
            this.verbose.println("Estimate all features");
        }
        this.estimateAllFeatures(origin, baseMotion.destination(origin));
        if (this.stopRequested) {
            return false;
        }
        this.convertToOutput(origin);
        return this.viewsAdded.size() >= 2;
    }

    void decomposeEssential(MetricSceneGraph.Motion motion) {
        List<Se3_F64> candidates = MultiViewOps.decomposeEssential(motion.F);
        int bestScore = 0;
        Se3_F64 best = null;
        PositiveDepthConstraintCheck check = new PositiveDepthConstraintCheck();
        for (int i = 0; i < candidates.size(); ++i) {
            Se3_F64 a_to_b = candidates.get(i);
            int count = 0;
            for (int j = 0; j < motion.associated.size(); ++j) {
                Point2D_F64 p1;
                AssociatedIndex a = motion.associated.get(j);
                Point2D_F64 p0 = motion.viewSrc.observationNorm.get(a.src);
                if (!check.checkConstraint(p0, p1 = motion.viewDst.observationNorm.get(a.dst), a_to_b)) continue;
                ++count;
            }
            if (count <= bestScore) continue;
            bestScore = count;
            best = a_to_b;
        }
        if (best == null) {
            throw new RuntimeException("Problem!");
        }
        motion.a_to_b.set(best);
    }

    double medianTriangulationAngle(MetricSceneGraph.Motion edge) {
        GrowQueue_F64 angles = new GrowQueue_F64(edge.associated.size());
        angles.size = edge.associated.size();
        for (int i = 0; i < edge.associated.size(); ++i) {
            double acute;
            AssociatedIndex a = edge.associated.get(i);
            Point2D_F64 normA = edge.viewSrc.observationNorm.get(a.src);
            Point2D_F64 normB = edge.viewDst.observationNorm.get(a.dst);
            angles.data[i] = acute = this.triangulationAngle(normA, normB, edge.a_to_b);
        }
        angles.sort();
        return angles.getFraction(0.5);
    }

    protected void declareModelFitting() {
        this.ransacPnP = FactoryMultiViewRobust.pnpRansac(null, this.configRansac);
    }

    private void convertToOutput(MetricSceneGraph.View origin) {
        int i;
        this.structure = new SceneStructureMetric(false);
        this.observations = new SceneObservations(this.viewsAdded.size());
        int idx = 0;
        for (String key : this.graph.cameras.keySet()) {
            this.cameraToIndex.put(key, idx++);
        }
        this.structure.initialize(this.cameraToIndex.size(), this.viewsAdded.size(), this.graph.features3D.size());
        for (String key : this.graph.cameras.keySet()) {
            int i2 = this.cameraToIndex.get(key);
            this.structure.setCamera(i2, true, this.graph.cameras.get((Object)key).pinhole);
        }
        int[] viewOldToView = new int[this.graph.nodes.size()];
        Arrays.fill(viewOldToView, -1);
        for (i = 0; i < this.viewsAdded.size(); ++i) {
            viewOldToView[this.graph.nodes.indexOf((Object)this.viewsAdded.get((int)i))] = i;
        }
        for (i = 0; i < this.viewsAdded.size(); ++i) {
            MetricSceneGraph.View v = this.viewsAdded.get(i);
            int cameraIndex = this.cameraToIndex.get(v.camera.camera);
            this.structure.setView(i, v == origin, v.viewToWorld.invert((Se3_F64)null));
            this.structure.connectViewToCamera(i, cameraIndex);
        }
        for (int indexPoint = 0; indexPoint < this.graph.features3D.size(); ++indexPoint) {
            MetricSceneGraph.Feature3D f = this.graph.features3D.get(indexPoint);
            this.structure.setPoint(indexPoint, f.worldPt.x, f.worldPt.y, f.worldPt.z);
            if (f.views.size() != f.obsIdx.size) {
                throw new RuntimeException("BUG!");
            }
            for (int j = 0; j < f.views.size(); ++j) {
                MetricSceneGraph.View view = f.views.get(j);
                int viewIndex = viewOldToView[view.index];
                this.structure.connectPointToView(indexPoint, viewIndex);
                Point2D_F64 pixel = this.viewsAdded.get((int)viewIndex).observationPixels.get(f.obsIdx.get(j));
                this.observations.getView(viewIndex).add(indexPoint, (float)pixel.x, (float)pixel.y);
            }
        }
    }

    void addTriangulatedStereoFeatures(MetricSceneGraph.View base, MetricSceneGraph.Motion edge, double scale) {
        MetricSceneGraph.View viewA = edge.viewSrc;
        MetricSceneGraph.View viewB = edge.viewDst;
        boolean baseIsA = base == viewA;
        MetricSceneGraph.View other = baseIsA ? viewB : viewA;
        edge.a_to_b.T.scale(scale);
        Se3_F64 otherToBase = baseIsA ? edge.a_to_b.invert((Se3_F64)null) : edge.a_to_b.copy();
        otherToBase.concat(base.viewToWorld, other.viewToWorld);
        for (int i = 0; i < edge.stereoTriangulations.size(); ++i) {
            MetricSceneGraph.Feature3D edge3D = edge.stereoTriangulations.get(i);
            int indexSrc = edge3D.obsIdx.get(0);
            int indexDst = edge3D.obsIdx.get(1);
            MetricSceneGraph.Feature3D world3D = baseIsA ? viewA.features3D[indexSrc] : viewB.features3D[indexDst];
            edge3D.worldPt.scale(scale);
            if (baseIsA) {
                viewA.viewToWorld.transform(edge3D.worldPt, edge3D.worldPt);
            } else {
                edge.a_to_b.transform(edge3D.worldPt, edge3D.worldPt);
                viewB.viewToWorld.transform(edge3D.worldPt, edge3D.worldPt);
            }
            if (world3D != null) {
                if (!world3D.views.contains(other)) {
                    world3D.views.add(other);
                    world3D.obsIdx.add(baseIsA ? indexDst : indexSrc);
                }
                if (world3D.triangulationAngle >= edge3D.triangulationAngle) continue;
                world3D.worldPt.set(edge3D.worldPt);
                world3D.triangulationAngle = edge3D.triangulationAngle;
                other.features3D[baseIsA ? indexDst : indexSrc] = edge3D;
                continue;
            }
            this.graph.features3D.add(edge3D);
            viewA.features3D[indexSrc] = edge3D;
            viewB.features3D[indexDst] = edge3D;
        }
        edge.stereoTriangulations = new ArrayList<MetricSceneGraph.Feature3D>();
    }

    static double determineScale(MetricSceneGraph.View base, MetricSceneGraph.Motion edge) throws Exception {
        MetricSceneGraph.View viewA = edge.viewSrc;
        MetricSceneGraph.View viewB = edge.viewDst;
        boolean baseIsA = base == viewA;
        Point3D_F64 worldInBase3D = new Point3D_F64();
        Point3D_F64 localInBase3D = new Point3D_F64();
        GrowQueue_F64 scales = new GrowQueue_F64();
        for (int i = 0; i < edge.stereoTriangulations.size(); ++i) {
            MetricSceneGraph.Feature3D world3D;
            MetricSceneGraph.Feature3D edge3D = edge.stereoTriangulations.get(i);
            int indexSrc = edge3D.obsIdx.get(0);
            int indexDst = edge3D.obsIdx.get(1);
            MetricSceneGraph.Feature3D feature3D = world3D = baseIsA ? viewA.features3D[indexSrc] : viewB.features3D[indexDst];
            if (world3D == null) continue;
            SePointOps_F64.transformReverse(base.viewToWorld, world3D.worldPt, worldInBase3D);
            if (!baseIsA) {
                SePointOps_F64.transform(edge.a_to_b, edge3D.worldPt, localInBase3D);
            } else {
                localInBase3D.set(edge3D.worldPt);
            }
            scales.add(worldInBase3D.z / localInBase3D.z);
        }
        if (scales.size < 20) {
            throw new Exception("Not enough matches with known points");
        }
        scales.sort();
        return scales.getFraction(0.5);
    }

    private void estimateAllFeatures(MetricSceneGraph.View seedA, MetricSceneGraph.View seedB) {
        ArrayList<MetricSceneGraph.View> open = new ArrayList<MetricSceneGraph.View>();
        this.addUnvistedToStack(seedA, open);
        this.addUnvistedToStack(seedB, open);
        while (!open.isEmpty()) {
            if (this.stopRequested) {
                return;
            }
            if (this.verbose != null) {
                this.verbose.println("### open.size=" + open.size());
            }
            int bestCount = this.countFeaturesWith3D((MetricSceneGraph.View)open.get(0));
            int bestIndex = 0;
            for (int i = 1; i < open.size(); ++i) {
                int count = this.countFeaturesWith3D((MetricSceneGraph.View)open.get(i));
                if (count <= bestCount) continue;
                bestCount = count;
                bestIndex = i;
            }
            MetricSceneGraph.View v = (MetricSceneGraph.View)open.remove(bestIndex);
            if (this.verbose != null) {
                this.verbose.println("   processing view=" + v.index + " | 3D Features=" + bestCount);
            }
            if (!this.determinePose(v)) {
                throw new RuntimeException("Crap handle this");
            }
            this.addTriangulatedFeaturesForAllEdges(v);
            this.triangulateNoLocation(v);
            this.viewsAdded.add(v);
            this.addUnvistedToStack(v, open);
        }
    }

    void addTriangulatedFeaturesForAllEdges(MetricSceneGraph.View v) {
        for (int i = 0; i < v.connections.size(); ++i) {
            MetricSceneGraph.Motion e = v.connections.get(i);
            if (e.stereoTriangulations.isEmpty()) continue;
            try {
                double scale = EstimateSceneCalibrated.determineScale(v, e);
                this.addTriangulatedStereoFeatures(v, e, scale);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    int countFeaturesWith3D(MetricSceneGraph.View v) {
        int count = 0;
        for (int i = 0; i < v.connections.size(); ++i) {
            MetricSceneGraph.Motion m = v.connections.get(i);
            boolean isSrc = m.viewSrc == v;
            for (int j = 0; j < m.associated.size(); ++j) {
                AssociatedIndex a = m.associated.get(j);
                if (isSrc) {
                    count += m.viewDst.features3D[a.dst] != null ? 1 : 0;
                    continue;
                }
                count += m.viewSrc.features3D[a.src] != null ? 1 : 0;
            }
        }
        return count;
    }

    boolean determinePose(MetricSceneGraph.View target) {
        ArrayList<Point2D3D> list = new ArrayList<Point2D3D>();
        ArrayList<MetricSceneGraph.Feature3D> features = new ArrayList<MetricSceneGraph.Feature3D>();
        GrowQueue_I32 featureIndexes = new GrowQueue_I32();
        for (MetricSceneGraph.Motion c : target.connections) {
            boolean isSrc = c.viewSrc == target;
            MetricSceneGraph.View other = c.destination(target);
            if (other.state != MetricSceneGraph.ViewState.PROCESSED) continue;
            for (int i = 0; i < c.associated.size(); ++i) {
                AssociatedIndex a = c.associated.get(i);
                MetricSceneGraph.Feature3D f = other.features3D[isSrc ? a.dst : a.src];
                if (f == null || f.mark == target.index) continue;
                f.mark = target.index;
                features.add(f);
                featureIndexes.add(isSrc ? a.src : a.dst);
                Point2D_F64 norm = target.observationNorm.get(isSrc ? a.src : a.dst);
                Point2D3D p = new Point2D3D();
                p.location.set(f.worldPt);
                p.observation.set(norm);
                list.add(p);
            }
        }
        this.ransacPnP.setIntrinsic(0, target.camera.pinhole);
        if (list.size() < 20 || !this.ransacPnP.process(list)) {
            if (this.verbose != null) {
                this.verbose.println("   View=" + target.index + " RANSAC failed. list.size=" + list.size());
            }
            return false;
        }
        target.state = MetricSceneGraph.ViewState.PROCESSED;
        int N = this.ransacPnP.getMatchSet().size();
        if (this.verbose != null) {
            this.verbose.println("   View=" + target.index + " PNP RANSAC " + N + "/" + list.size());
        }
        for (int i = 0; i < N; ++i) {
            int which = this.ransacPnP.getInputIndex(i);
            MetricSceneGraph.Feature3D f = (MetricSceneGraph.Feature3D)features.get(which);
            if (f.views.contains(target)) continue;
            f.views.add(target);
            f.obsIdx.add(featureIndexes.get(which));
            target.features3D[featureIndexes.get((int)which)] = f;
            if (f.views.size() == f.obsIdx.size) continue;
            throw new RuntimeException("BUG!");
        }
        Se3_F64 worldToView = (Se3_F64)this.ransacPnP.getModelParameters();
        target.viewToWorld.set(worldToView.invert((Se3_F64)null));
        return true;
    }

    private void triangulateNoLocation(MetricSceneGraph.View target) {
        Se3_F64 otherToTarget = new Se3_F64();
        Se3_F64 worldToTarget = target.viewToWorld.invert((Se3_F64)null);
        for (MetricSceneGraph.Motion c : target.connections) {
            boolean isSrc = c.viewSrc == target;
            MetricSceneGraph.View other = c.destination(target);
            if (other.state != MetricSceneGraph.ViewState.PROCESSED) continue;
            other.viewToWorld.concat(worldToTarget, otherToTarget);
            this.triangulationError.configure(target.camera.pinhole, other.camera.pinhole);
            for (int i = 0; i < c.associated.size(); ++i) {
                double error;
                Point2D_F64 normTarget;
                Point2D_F64 normOther;
                double angle;
                int indexOther;
                AssociatedIndex a = c.associated.get(i);
                int indexTarget = isSrc ? a.src : a.dst;
                int n = indexOther = isSrc ? a.dst : a.src;
                if (target.features3D[indexTarget] != null || other.features3D[indexOther] != null || (angle = this.triangulationAngle(normOther = other.observationNorm.get(indexOther), normTarget = target.observationNorm.get(indexTarget), otherToTarget)) < this.TRIANGULATE_MIN_ANGLE) continue;
                MetricSceneGraph.Feature3D f = new MetricSceneGraph.Feature3D();
                if (!this.triangulate.triangulate(normOther, normTarget, otherToTarget, f.worldPt) || f.worldPt.z <= 0.0 || (error = this.triangulationError.process(normOther, normTarget, otherToTarget, f.worldPt)) > this.maxPixelError * this.maxPixelError) continue;
                other.viewToWorld.transform(f.worldPt, f.worldPt);
                f.views.add(target);
                f.views.add(other);
                f.obsIdx.add(indexTarget);
                f.obsIdx.add(indexOther);
                this.graph.features3D.add(f);
                target.features3D[indexTarget] = f;
                other.features3D[indexOther] = f;
            }
        }
    }

    double triangulationAngle(Point2D_F64 normA, Point2D_F64 normB, Se3_F64 a_to_b) {
        this.arrowA.set(normA.x, normA.y, 1.0);
        this.arrowB.set(normB.x, normB.y, 1.0);
        GeometryMath_F64.mult(a_to_b.R, this.arrowA, this.arrowA);
        return UtilVector3D_F64.acute(this.arrowA, this.arrowB);
    }

    void addUnvistedToStack(MetricSceneGraph.View viewed, List<MetricSceneGraph.View> open) {
        for (int i = 0; i < viewed.connections.size(); ++i) {
            MetricSceneGraph.View other = viewed.connections.get(i).destination(viewed);
            if (other.state != MetricSceneGraph.ViewState.UNPROCESSED) continue;
            other.state = MetricSceneGraph.ViewState.PENDING;
            open.add(other);
            if (this.verbose == null) continue;
            this.verbose.println("  adding to open " + viewed.index + "->" + other.index);
        }
    }

    void defineCoordinateSystem(MetricSceneGraph.View viewA, MetricSceneGraph.Motion motion) {
        MetricSceneGraph.View viewB = motion.destination(viewA);
        viewA.viewToWorld.reset();
        viewB.viewToWorld.set(motion.motionSrcToDst(viewB));
        double scale = viewB.viewToWorld.T.norm();
        viewB.viewToWorld.T.scale(1.0 / scale);
        this.viewsAdded.add(viewA);
        this.viewsAdded.add(viewB);
        viewA.state = MetricSceneGraph.ViewState.PROCESSED;
        viewB.state = MetricSceneGraph.ViewState.PROCESSED;
        boolean originIsDst = viewA == motion.viewDst;
        for (int i = 0; i < motion.stereoTriangulations.size(); ++i) {
            MetricSceneGraph.Feature3D f = motion.stereoTriangulations.get(i);
            if (f.obsIdx.size != 2) {
                throw new RuntimeException("BUG");
            }
            int indexSrc = f.obsIdx.get(0);
            int indexDst = f.obsIdx.get(1);
            motion.viewSrc.features3D[indexSrc] = f;
            motion.viewDst.features3D[indexDst] = f;
            if (originIsDst) {
                SePointOps_F64.transform(motion.a_to_b, f.worldPt, f.worldPt);
            }
            f.worldPt.scale(1.0 / scale);
            this.graph.features3D.add(f);
        }
        motion.stereoTriangulations = new ArrayList<MetricSceneGraph.Feature3D>();
        this.addTriangulatedFeaturesForAllEdges(viewA);
        this.addTriangulatedFeaturesForAllEdges(viewB);
        if (this.verbose != null) {
            this.verbose.println("root  = " + viewA.index);
            this.verbose.println("other = " + viewB.index);
            this.verbose.println("-------------");
        }
    }

    MetricSceneGraph.View selectOriginNode() {
        double bestScore = 0.0;
        MetricSceneGraph.View best = null;
        if (this.verbose != null) {
            this.verbose.println("selectOriginNode");
        }
        for (int i = 0; i < this.graph.nodes.size(); ++i) {
            double score = this.scoreNodeAsOrigin(this.graph.nodes.get(i));
            if (score > bestScore) {
                bestScore = score;
                best = this.graph.nodes.get(i);
            }
            if (this.verbose == null) continue;
            this.verbose.printf("  [%2d] score = %s\n", i, score);
        }
        if (this.verbose != null && best != null) {
            this.verbose.println("     selected = " + best.index);
        }
        return best;
    }

    double scoreNodeAsOrigin(MetricSceneGraph.View node) {
        double score = 0.0;
        List<MetricSceneGraph.Motion> edges = node.connections;
        for (int j = 0; j < edges.size(); ++j) {
            MetricSceneGraph.Motion e = edges.get(j);
            score += e.scoreTriangulation();
        }
        return score;
    }

    MetricSceneGraph.Motion selectCoordinateBase(MetricSceneGraph.View view) {
        double bestScore = 0.0;
        MetricSceneGraph.Motion best = null;
        if (this.verbose != null) {
            this.verbose.println("selectCoordinateBase");
        }
        for (int i = 0; i < view.connections.size(); ++i) {
            MetricSceneGraph.Motion e = view.connections.get(i);
            double s = e.scoreTriangulation();
            if (this.verbose != null) {
                this.verbose.printf("  [%2d] score = %s\n", i, s);
            }
            if (!(s > bestScore)) continue;
            bestScore = s;
            best = e;
        }
        return best;
    }

    void triangulateStereoEdges(MetricSceneGraph.Motion edge) {
        MetricSceneGraph.View viewA = edge.viewSrc;
        MetricSceneGraph.View viewB = edge.viewDst;
        this.triangulationError.configure(viewA.camera.pinhole, viewB.camera.pinhole);
        for (int i = 0; i < edge.associated.size(); ++i) {
            double error;
            Point2D_F64 normB;
            AssociatedIndex f = edge.associated.get(i);
            Point2D_F64 normA = viewA.observationNorm.get(f.src);
            double angle = this.triangulationAngle(normA, normB = viewB.observationNorm.get(f.dst), edge.a_to_b);
            if (angle < this.TRIANGULATE_MIN_ANGLE) continue;
            MetricSceneGraph.Feature3D feature3D = new MetricSceneGraph.Feature3D();
            if (!this.triangulate.triangulate(normA, normB, edge.a_to_b, feature3D.worldPt) || feature3D.worldPt.z <= 0.0 || (error = this.triangulationError.process(normA, normB, edge.a_to_b, feature3D.worldPt)) > this.maxPixelError * this.maxPixelError) continue;
            feature3D.views.add(viewA);
            feature3D.views.add(viewB);
            feature3D.obsIdx.add(f.src);
            feature3D.obsIdx.add(f.dst);
            feature3D.triangulationAngle = angle;
            edge.stereoTriangulations.add(feature3D);
        }
    }

    @Override
    public SceneStructureMetric getSceneStructure() {
        return this.structure;
    }

    @Override
    public SceneObservations getObservations() {
        return this.observations;
    }

    @Override
    public void reset() {
        this.stopRequested = false;
    }

    @Override
    public void requestStop() {
        this.stopRequested = true;
    }

    @Override
    public boolean isStopRequested() {
        return this.stopRequested;
    }

    public void setVerbose(PrintStream verbose, int level) {
        this.verbose = verbose;
    }
}

