/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F32;

public class InterpolatePixelDistortS<T extends ImageGray<T>>
implements InterpolatePixelS<T> {
    protected InterpolatePixelS<T> interpolate;
    protected Point2Transform2_F32 distorter;
    Point2D_F32 p = new Point2D_F32();

    public InterpolatePixelDistortS(InterpolatePixelS<T> interpolate, Point2Transform2_F32 distorter) {
        this.interpolate = interpolate;
        this.distorter = distorter;
    }

    @Override
    public float get(float x, float y) {
        this.distorter.compute(x, y, this.p);
        return this.interpolate.get(this.p.x, this.p.y);
    }

    @Override
    public float get_fast(float x, float y) {
        this.distorter.compute(x, y, this.p);
        return this.interpolate.get_fast(this.p.x, this.p.y);
    }

    @Override
    public InterpolatePixelS<T> copy() {
        throw new RuntimeException("Implement");
    }

    @Override
    public void setBorder(ImageBorder<T> border) {
        this.interpolate.setBorder(border);
    }

    @Override
    public ImageBorder<T> getBorder() {
        return this.interpolate.getBorder();
    }

    @Override
    public void setImage(T image) {
        this.interpolate.setImage(image);
    }

    @Override
    public T getImage() {
        return (T)((ImageGray)this.interpolate.getImage());
    }

    @Override
    public boolean isInFastBounds(float x, float y) {
        return this.interpolate.isInFastBounds(x, y);
    }

    @Override
    public int getFastBorderX() {
        return this.interpolate.getFastBorderX();
    }

    @Override
    public int getFastBorderY() {
        return this.interpolate.getFastBorderY();
    }

    @Override
    public ImageType<T> getImageType() {
        return this.interpolate.getImageType();
    }

    public InterpolatePixelS<T> getInterpolate() {
        return this.interpolate;
    }

    public Point2Transform2_F32 getDistorter() {
        return this.distorter;
    }
}

