/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.trifocal;

import boofcv.struct.geo.TrifocalTensor;
import georegression.struct.point.Point3D_F64;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.decomposition.svd.SafeSvd_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class EnforceTrifocalGeometry {
    private SingularValueDecomposition_F64<DMatrixRMaj> svdU;
    private SingularValueDecomposition_F64<DMatrixRMaj> svdV;
    private DMatrixRMaj U = new DMatrixRMaj(27, 18);
    private DMatrixRMaj Up = new DMatrixRMaj(1, 1);
    private DMatrixRMaj xp = new DMatrixRMaj(1, 1);
    private DMatrixRMaj AU = new DMatrixRMaj(1, 1);
    private DMatrixRMaj vectorT = new DMatrixRMaj(27, 1);
    protected DMatrixRMaj E = new DMatrixRMaj(27, 18);

    public EnforceTrifocalGeometry() {
        this.svdU = DecompositionFactory_DDRM.svd(10, 10, true, false, true);
        this.svdV = DecompositionFactory_DDRM.svd(10, 10, false, true, false);
        this.svdV = new SafeSvd_DDRM(this.svdV);
    }

    public void process(Point3D_F64 e2, Point3D_F64 e3, DMatrixRMaj A) {
        this.constructE(e2, e3);
        this.svdU.decompose(this.E);
        this.svdU.getU(this.U, false);
        SingularOps_DDRM.descendingOrder(this.U, false, this.svdU.getSingularValues(), this.svdU.numberOfSingularValues(), null, false);
        int rank = SingularOps_DDRM.rank(this.svdU, 1.0E-13);
        this.Up.reshape(this.U.numRows, rank);
        CommonOps_DDRM.extract(this.U, 0, this.U.numRows, 0, this.Up.numCols, this.Up, 0, 0);
        this.AU.reshape(A.numRows, this.Up.numCols);
        CommonOps_DDRM.mult(A, this.Up, this.AU);
        this.svdV.decompose(this.AU);
        this.xp.reshape(rank, 1);
        SingularOps_DDRM.nullVector(this.svdV, true, this.xp);
        CommonOps_DDRM.mult(this.Up, this.xp, this.vectorT);
        if (this.vectorT.data[0] > 0.0) {
            CommonOps_DDRM.changeSign(this.vectorT);
        }
    }

    public void computeErrorVector(DMatrixRMaj A, DMatrixRMaj errors) {
        errors.reshape(A.numRows, 1);
        CommonOps_DDRM.mult(A, this.vectorT, errors);
    }

    public void extractSolution(TrifocalTensor tensor) {
        tensor.convertFrom(this.vectorT);
    }

    protected void constructE(Point3D_F64 e2, Point3D_F64 e3) {
        this.E.zero();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    int row = 9 * i + 3 * j + k;
                    int col1 = j * 3 + i;
                    int col2 = k * 3 + i + 9;
                    this.E.data[row * 18 + col1] = e3.getIdx(k);
                    this.E.data[row * 18 + col2] = -e2.getIdx(j);
                }
            }
        }
    }
}

