/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.blur.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.concurrency.IWorkArrays;
import boofcv.struct.image.GrayU8;
import java.util.Arrays;
import javax.annotation.Nullable;

public class ImplMedianHistogramInner_MT {
    public static void process(GrayU8 input, GrayU8 output, int radius, @Nullable IWorkArrays work) {
        if (work == null) {
            work = new IWorkArrays();
        }
        work.reset(256);
        IWorkArrays _work = work;
        int w = 2 * radius + 1;
        if (input.width < w || input.height < w) {
            return;
        }
        int threshold = w * w / 2 + 1;
        BoofConcurrency.loopBlocks(radius, output.height - radius, w, (y0, y1) -> {
            int[] histogram = _work.pop();
            for (int y = y0; y < y1; ++y) {
                int seed = input.startIndex + (y - radius) * input.stride;
                Arrays.fill(histogram, 0);
                for (int i = 0; i < w; ++i) {
                    int idx = seed + i * input.stride;
                    int end = idx + w;
                    while (idx < end) {
                        int n = input.data[idx++] & 0xFF;
                        histogram[n] = histogram[n] + 1;
                    }
                }
                int count = 0;
                int median = 0;
                while ((count += histogram[median]) < threshold) {
                    ++median;
                }
                output.data[output.startIndex + y * output.stride + radius] = (byte)median;
                count += ImplMedianHistogramInner_MT.removeSide(input.data, input.stride, w, histogram, seed, median);
                for (int x = radius + 1; x < input.width - radius; ++x) {
                    seed = input.startIndex + (y - radius) * input.stride + (x - radius);
                    if ((count += ImplMedianHistogramInner_MT.addSide(input.data, input.stride, w, histogram, seed + w - 1, median)) >= threshold) {
                        while (count >= threshold) {
                            count -= histogram[median--];
                        }
                        count += histogram[++median];
                    } else {
                        while (count < threshold) {
                            count += histogram[++median];
                        }
                    }
                    output.data[output.startIndex + y * output.stride + x] = (byte)median;
                    count += ImplMedianHistogramInner_MT.removeSide(input.data, input.stride, w, histogram, seed, median);
                }
            }
        });
    }

    private static int removeSide(byte[] data, int stride, int width, int[] histogram, int seedIdx, int oldMedian) {
        int count = 0;
        int i = 0;
        while (i < width) {
            int value;
            int n = value = data[seedIdx] & 0xFF;
            histogram[n] = histogram[n] - 1;
            if (value <= oldMedian) {
                --count;
            }
            ++i;
            seedIdx += stride;
        }
        return count;
    }

    private static int addSide(byte[] data, int stride, int width, int[] histogram, int seedIdx, int oldValue) {
        int count = 0;
        int i = 0;
        while (i < width) {
            int value;
            int n = value = data[seedIdx] & 0xFF;
            histogram[n] = histogram[n] + 1;
            if (value <= oldValue) {
                ++count;
            }
            ++i;
            seedIdx += stride;
        }
        return count;
    }
}

