/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.circle;

import boofcv.alg.fiducial.calib.circle.EllipseClustersIntoGrid;
import georegression.geometry.UtilLine2D_F64;
import georegression.geometry.UtilVector2D_F64;
import georegression.geometry.algs.TangentLinesTwoEllipses_F64;
import georegression.metric.Intersection2D_F64;
import georegression.misc.GrlConstants;
import georegression.struct.curve.EllipseRotated_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.point.Point2D_F64;
import org.ddogleg.struct.FastQueue;

public class KeyPointsCircleHexagonalGrid {
    FastQueue<Tangents> tangents = new FastQueue<Tangents>(Tangents.class, true);
    FastQueue<Point2D_F64> keypoints = new FastQueue<Point2D_F64>(Point2D_F64.class, true);
    private TangentLinesTwoEllipses_F64 tangentFinder = new TangentLinesTwoEllipses_F64(GrlConstants.TEST_F64, 10);
    private Point2D_F64 A0 = new Point2D_F64();
    private Point2D_F64 A1 = new Point2D_F64();
    private Point2D_F64 A2 = new Point2D_F64();
    private Point2D_F64 A3 = new Point2D_F64();
    private Point2D_F64 B0 = new Point2D_F64();
    private Point2D_F64 B1 = new Point2D_F64();
    private Point2D_F64 B2 = new Point2D_F64();
    private Point2D_F64 B3 = new Point2D_F64();
    private LineGeneral2D_F64 lineA = new LineGeneral2D_F64();
    private LineGeneral2D_F64 lineB = new LineGeneral2D_F64();
    private Point2D_F64 location = new Point2D_F64();

    public boolean process(EllipseClustersIntoGrid.Grid grid) {
        this.init(grid);
        if (!this.horizontal(grid)) {
            return false;
        }
        if (!this.vertical(grid)) {
            return false;
        }
        if (!this.diagonalLR(grid)) {
            return false;
        }
        if (!this.diagonalRL(grid)) {
            return false;
        }
        return this.computeEllipseCenters();
    }

    void init(EllipseClustersIntoGrid.Grid grid) {
        int i;
        int totalEllipses = 0;
        for (i = 0; i < grid.ellipses.size(); ++i) {
            if (grid.ellipses.get(i) == null) continue;
            ++totalEllipses;
        }
        this.tangents.resize(totalEllipses);
        for (i = 0; i < this.tangents.size(); ++i) {
            this.tangents.get(i).reset();
        }
    }

    boolean horizontal(EllipseClustersIntoGrid.Grid grid) {
        for (int i = 0; i < grid.rows; ++i) {
            for (int j = 0; j < grid.columns - 2; ++j) {
                if (i % 2 == 0 && j % 2 == 1 || i % 2 == 1 && j % 2 == 0 || this.addTangents(grid, i, j, i, j + 2)) continue;
                return false;
            }
        }
        return true;
    }

    boolean vertical(EllipseClustersIntoGrid.Grid grid) {
        for (int i = 0; i < grid.rows - 2; ++i) {
            for (int j = 0; j < grid.columns; ++j) {
                if (i % 2 == 0 && j % 2 == 1 || i % 2 == 1 && j % 2 == 0 || this.addTangents(grid, i, j, i + 2, j)) continue;
                return false;
            }
        }
        return true;
    }

    boolean diagonalLR(EllipseClustersIntoGrid.Grid grid) {
        for (int i = 0; i < grid.rows - 1; ++i) {
            for (int j = 0; j < grid.columns - 1; ++j) {
                if (i % 2 == 0 && j % 2 == 1 || i % 2 == 1 && j % 2 == 0 || this.addTangents(grid, i, j, i + 1, j + 1)) continue;
                return false;
            }
        }
        return true;
    }

    boolean diagonalRL(EllipseClustersIntoGrid.Grid grid) {
        for (int i = 0; i < grid.rows - 1; ++i) {
            for (int j = 1; j < grid.columns; ++j) {
                if (i % 2 == 0 && j % 2 == 1 || i % 2 == 1 && j % 2 == 0 || this.addTangents(grid, i, j, i + 1, j - 1)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean addTangents(EllipseClustersIntoGrid.Grid grid, int rowA, int colA, int rowB, int colB) {
        EllipseRotated_F64 a = grid.get(rowA, colA);
        EllipseRotated_F64 b = grid.get(rowB, colB);
        if (a == null || b == null) {
            return false;
        }
        if (!this.tangentFinder.process(a, b, this.A0, this.A1, this.A2, this.A3, this.B0, this.B1, this.B2, this.B3)) {
            return false;
        }
        Tangents ta = this.tangents.get(grid.getIndexOfHexEllipse(rowA, colA));
        Tangents tb = this.tangents.get(grid.getIndexOfHexEllipse(rowB, colB));
        ((Point2D_F64)ta.grow()).set(this.A0);
        ((Point2D_F64)ta.grow()).set(this.A3);
        ((Point2D_F64)tb.grow()).set(this.B0);
        ((Point2D_F64)tb.grow()).set(this.B3);
        return true;
    }

    boolean computeEllipseCenters() {
        this.keypoints.reset();
        for (int tangentIdx = 0; tangentIdx < this.tangents.size(); ++tangentIdx) {
            Tangents t = this.tangents.get(tangentIdx);
            Point2D_F64 center = this.keypoints.grow();
            center.set(0.0, 0.0);
            double totalWeight = 0.0;
            for (int i = 0; i < t.size(); i += 2) {
                UtilLine2D_F64.convert((Point2D_F64)t.get(i), (Point2D_F64)t.get(i + 1), this.lineA);
                for (int j = i + 2; j < t.size(); j += 2) {
                    UtilLine2D_F64.convert((Point2D_F64)t.get(j), (Point2D_F64)t.get(j + 1), this.lineB);
                    double w = UtilVector2D_F64.acute(this.lineA.A, this.lineA.B, this.lineB.A, this.lineB.B);
                    if (w > 1.5707963267948966) {
                        w = Math.PI - w;
                    }
                    if (w <= 0.02) continue;
                    if (null == Intersection2D_F64.intersection(this.lineA, this.lineB, this.location)) {
                        return false;
                    }
                    center.x += this.location.x * w;
                    center.y += this.location.y * w;
                    totalWeight += w;
                }
            }
            if (totalWeight == 0.0) {
                return false;
            }
            center.x /= totalWeight;
            center.y /= totalWeight;
        }
        return true;
    }

    public FastQueue<Point2D_F64> getKeyPoints() {
        return this.keypoints;
    }

    public FastQueue<Tangents> getTangents() {
        return this.tangents;
    }

    public static class Tangents
    extends FastQueue<Point2D_F64> {
        public Tangents() {
            super(8, Point2D_F64.class, true);
        }
    }
}

