/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.block;

import boofcv.alg.InputSanityCheck;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.image.ImageGray;

public abstract class DisparitySparseScoreSadRect<ArrayData, Input extends ImageGray<Input>> {
    protected int disparityMin;
    protected int disparityMax;
    protected int disparityRange;
    protected int localMaxRange;
    protected int radiusX;
    protected int radiusY;
    protected int regionWidth;
    protected int regionHeight;
    protected Input left;
    protected Input right;
    protected ImageBorder<Input> bleft;
    protected ImageBorder<Input> bright;

    public DisparitySparseScoreSadRect(int radiusX, int radiusY) {
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.regionWidth = radiusX * 2 + 1;
        this.regionHeight = radiusY * 2 + 1;
    }

    public void setBorder(ImageBorder<Input> border) {
        this.bleft = border.copy();
        this.bright = border.copy();
    }

    public void configure(int disparityMin, int disparityRange) {
        if (disparityMin < 0) {
            throw new IllegalArgumentException("Min disparity must be greater than or equal to zero. max=" + disparityMin);
        }
        if (disparityRange <= 0) {
            throw new IllegalArgumentException("Disparity range must be more than 0");
        }
        this.disparityMin = disparityMin;
        this.disparityRange = disparityRange;
        this.disparityMax = disparityMin + disparityRange - 1;
    }

    public void setImages(Input left, Input right) {
        InputSanityCheck.checkSameShape(left, right);
        this.left = left;
        this.right = right;
        this.bleft.setImage(left);
        this.bright.setImage(right);
    }

    public abstract boolean process(int var1, int var2);

    public int getLocalMaxRange() {
        return this.localMaxRange;
    }

    public int getDisparityMin() {
        return this.disparityMin;
    }

    public int getDisparityMax() {
        return this.disparityMax;
    }

    public int getRadiusX() {
        return this.radiusX;
    }

    public int getRadiusY() {
        return this.radiusY;
    }

    public abstract ArrayData getScore();

    public abstract Class<Input> getImageType();
}

