/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;

public class ImplHessianBlobIntensity {
    public static void determinant(GrayF32 featureIntensity, GrayF32 hessianXX, GrayF32 hessianYY, GrayF32 hessianXY) {
        int width = hessianXX.width;
        int height = hessianXX.height;
        if (featureIntensity == null) {
            featureIntensity = new GrayF32(width, height);
        }
        for (int y = 0; y < height; ++y) {
            int indexXX = hessianXX.startIndex + y * hessianXX.stride;
            int indexYY = hessianYY.startIndex + y * hessianYY.stride;
            int indexXY = hessianXY.startIndex + y * hessianXY.stride;
            int indexInten = featureIntensity.startIndex + y * featureIntensity.stride;
            for (int x = 0; x < width; ++x) {
                float dxx = hessianXX.data[indexXX++];
                float dyy = hessianYY.data[indexYY++];
                float dxy = hessianXY.data[indexXY++];
                featureIntensity.data[indexInten++] = dxx * dyy - dxy * dxy;
            }
        }
    }

    public static void trace(GrayF32 featureIntensity, GrayF32 hessianXX, GrayF32 hessianYY) {
        int width = hessianXX.width;
        int height = hessianXX.height;
        if (featureIntensity == null) {
            featureIntensity = new GrayF32(width, height);
        }
        for (int y = 0; y < height; ++y) {
            int indexXX = hessianXX.startIndex + y * hessianXX.stride;
            int indexYY = hessianYY.startIndex + y * hessianYY.stride;
            int indexInten = featureIntensity.startIndex + y * featureIntensity.stride;
            for (int x = 0; x < width; ++x) {
                float dxx = hessianXX.data[indexXX++];
                float dyy = hessianYY.data[indexYY++];
                featureIntensity.data[indexInten++] = dxx + dyy;
            }
        }
    }

    public static void determinant(GrayF32 featureIntensity, GrayS16 hessianXX, GrayS16 hessianYY, GrayS16 hessianXY) {
        int width = hessianXX.width;
        int height = hessianXX.height;
        if (featureIntensity == null) {
            featureIntensity = new GrayF32(width, height);
        }
        for (int y = 0; y < height; ++y) {
            int indexXX = hessianXX.startIndex + y * hessianXX.stride;
            int indexYY = hessianYY.startIndex + y * hessianYY.stride;
            int indexXY = hessianXY.startIndex + y * hessianXY.stride;
            int indexInten = featureIntensity.startIndex + y * featureIntensity.stride;
            for (int x = 0; x < width; ++x) {
                short dxx = hessianXX.data[indexXX++];
                short dyy = hessianYY.data[indexYY++];
                short dxy = hessianXY.data[indexXY++];
                featureIntensity.data[indexInten++] = dxx * dyy - dxy * dxy;
            }
        }
    }

    public static void trace(GrayF32 featureIntensity, GrayS16 hessianXX, GrayS16 hessianYY) {
        int width = hessianXX.width;
        int height = hessianXX.height;
        if (featureIntensity == null) {
            featureIntensity = new GrayF32(width, height);
        }
        for (int y = 0; y < height; ++y) {
            int indexXX = hessianXX.startIndex + y * hessianXX.stride;
            int indexYY = hessianYY.startIndex + y * hessianYY.stride;
            int indexInten = featureIntensity.startIndex + y * featureIntensity.stride;
            for (int x = 0; x < width; ++x) {
                short dxx = hessianXX.data[indexXX++];
                short dyy = hessianYY.data[indexYY++];
                featureIntensity.data[indexInten++] = dxx + dyy;
            }
        }
    }
}

