/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.PixelTransformAffine_F32;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.distort.impl.DistortSupport;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.ImageRectangle_F32;
import boofcv.struct.ImageRectangle_F64;
import boofcv.struct.border.BorderType;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;
import georegression.struct.affine.Affine2D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.RectangleLength2D_F32;
import georegression.struct.shapes.RectangleLength2D_F64;
import georegression.struct.shapes.RectangleLength2D_I32;

public class DistortImageOps {
    @Deprecated
    public static <T extends ImageBase<T>> void affine(T input, T output, BorderType borderType, InterpolationType interpType, double a11, double a12, double a21, double a22, double dx, double dy) {
        Affine2D_F32 m = new Affine2D_F32();
        m.a11 = (float)a11;
        m.a12 = (float)a12;
        m.a21 = (float)a21;
        m.a22 = (float)a22;
        m.tx = (float)dx;
        m.ty = (float)dy;
        m = m.invert((Affine2D_F32)null);
        PixelTransformAffine_F32 model = new PixelTransformAffine_F32(m);
        if (input instanceof ImageGray) {
            DistortImageOps.distortSingle((ImageGray)input, (ImageGray)output, model, interpType, borderType);
        } else if (input instanceof Planar) {
            DistortImageOps.distortPL((Planar)input, (Planar)output, model, borderType, interpType);
        }
    }

    public static <Input extends ImageGray<Input>, Output extends ImageGray<Output>> void distortSingle(Input input, Output output, PixelTransform<Point2D_F32> transform, InterpolationType interpType, BorderType borderType) {
        boolean skip;
        boolean bl = skip = borderType == BorderType.SKIP;
        if (skip) {
            borderType = BorderType.EXTENDED;
        }
        Class<?> inputType = input.getClass();
        Class<?> outputType = input.getClass();
        InterpolatePixelS<?> interp = FactoryInterpolation.createPixelS(0.0, 255.0, interpType, borderType, inputType);
        ImageDistort<?, ?> distorter = FactoryDistort.distortSB(false, interp, outputType);
        distorter.setRenderAll(!skip);
        distorter.setModel(transform);
        distorter.apply(input, output);
    }

    public static <Input extends ImageGray<Input>, Output extends ImageGray<Output>> void distortSingle(Input input, Output output, boolean renderAll, PixelTransform<Point2D_F32> transform, InterpolatePixelS<Input> interp) {
        Class<?> inputType = input.getClass();
        ImageDistort<Input, ?> distorter = FactoryDistort.distortSB(false, interp, inputType);
        distorter.setRenderAll(renderAll);
        distorter.setModel(transform);
        distorter.apply(input, output);
    }

    public static <Input extends ImageGray<Input>, Output extends ImageGray<Output>, M extends Planar<Input>, N extends Planar<Output>> void distortPL(M input, N output, PixelTransform<Point2D_F32> transform, BorderType borderType, InterpolationType interpType) {
        Class<Input> inputBandType = input.getBandType();
        Class<Output> outputBandType = output.getBandType();
        InterpolatePixelS<Input> interp = FactoryInterpolation.createPixelS(0.0, 255.0, interpType, borderType, inputBandType);
        ImageDistort<Input, Output> distorter = FactoryDistort.distortSB(false, interp, outputBandType);
        distorter.setModel(transform);
        DistortImageOps.distortPL(input, output, distorter);
    }

    public static <Input extends ImageGray<Input>, Output extends ImageGray<Output>> ImageDistort<Input, Output> createImageDistort(Point2Transform2_F32 transform, InterpolationType interpType, BorderType borderType, Class<Input> inputType, Class<Output> outputType) {
        InterpolatePixelS<Input> interp = FactoryInterpolation.createPixelS(0.0, 255.0, interpType, borderType, inputType);
        ImageDistort<Input, Output> distorter = FactoryDistort.distortSB(true, interp, outputType);
        distorter.setModel(new PointToPixelTransform_F32(transform));
        return distorter;
    }

    @Deprecated
    public static <T extends ImageBase<T>> void scale(T input, T output, BorderType borderType, InterpolationType interpType) {
        PixelTransformAffine_F32 model = DistortSupport.transformScale(output, input, null);
        if (input instanceof ImageGray) {
            DistortImageOps.distortSingle((ImageGray)input, (ImageGray)output, model, interpType, borderType);
        } else if (input instanceof Planar) {
            DistortImageOps.distortPL((Planar)input, (Planar)output, model, borderType, interpType);
        }
    }

    @Deprecated
    public static <T extends ImageBase<T>> void rotate(T input, T output, BorderType borderType, InterpolationType interpType, float angleInputToOutput) {
        float offX = 0.0f;
        float offY = 0.0f;
        PixelTransformAffine_F32 model = DistortSupport.transformRotate(input.width / 2, input.height / 2, (float)(output.width / 2) - offX, (float)(output.height / 2) - offY, angleInputToOutput);
        if (input instanceof ImageGray) {
            DistortImageOps.distortSingle((ImageGray)input, (ImageGray)output, model, interpType, borderType);
        } else if (input instanceof Planar) {
            DistortImageOps.distortPL((Planar)input, (Planar)output, model, borderType, interpType);
        }
    }

    public static <Input extends ImageGray<Input>, Output extends ImageGray<Output>> void distortPL(Planar<Input> input, Planar<Output> output, ImageDistort<Input, Output> distortion) {
        for (int band = 0; band < input.getNumBands(); ++band) {
            distortion.apply(input.getBand(band), output.getBand(band));
        }
    }

    public static RectangleLength2D_I32 boundBox(int srcWidth, int srcHeight, int dstWidth, int dstHeight, Point2D_F32 work, PixelTransform<Point2D_F32> transform) {
        RectangleLength2D_I32 ret = DistortImageOps.boundBox(srcWidth, srcHeight, work, transform);
        int x0 = ret.x0;
        int y0 = ret.y0;
        int x1 = ret.x0 + ret.width;
        int y1 = ret.y0 + ret.height;
        if (x0 < 0) {
            x0 = 0;
        }
        if (x1 > dstWidth) {
            x1 = dstWidth;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (y1 > dstHeight) {
            y1 = dstHeight;
        }
        return new RectangleLength2D_I32(x0, y0, x1 - x0, y1 - y0);
    }

    public static RectangleLength2D_I32 boundBox(int srcWidth, int srcHeight, Point2D_F32 work, PixelTransform<Point2D_F32> transform) {
        int y1;
        int x1;
        transform.compute(0, 0, work);
        int x0 = x1 = (int)work.x;
        int y0 = y1 = (int)work.y;
        for (int i = 1; i < 4; ++i) {
            if (i == 1) {
                transform.compute(srcWidth, 0, work);
            } else if (i == 2) {
                transform.compute(0, srcHeight, work);
            } else if (i == 3) {
                transform.compute(srcWidth - 1, srcHeight, work);
            }
            if (work.x < (float)x0) {
                x0 = (int)work.x;
            } else if (work.x > (float)x1) {
                x1 = (int)work.x;
            }
            if (work.y < (float)y0) {
                y0 = (int)work.y;
                continue;
            }
            if (!(work.y > (float)y1)) continue;
            y1 = (int)work.y;
        }
        return new RectangleLength2D_I32(x0, y0, x1 - x0, y1 - y0);
    }

    public static RectangleLength2D_F32 boundBox_F32(int srcWidth, int srcHeight, PixelTransform<Point2D_F32> transform, Point2D_F32 transformed) {
        ImageRectangle_F32 r = new ImageRectangle_F32();
        r.y0 = Float.MAX_VALUE;
        r.x0 = Float.MAX_VALUE;
        r.y1 = -3.4028235E38f;
        r.x1 = -3.4028235E38f;
        for (int y = 0; y < srcHeight; ++y) {
            transform.compute(0, y, transformed);
            DistortImageOps.updateBoundBox(transformed, r);
            transform.compute(srcWidth, y, transformed);
            DistortImageOps.updateBoundBox(transformed, r);
        }
        for (int x = 0; x < srcWidth; ++x) {
            transform.compute(x, 0, transformed);
            DistortImageOps.updateBoundBox(transformed, r);
            transform.compute(x, srcHeight, transformed);
            DistortImageOps.updateBoundBox(transformed, r);
        }
        return new RectangleLength2D_F32(r.x0, r.y0, r.x1 - r.x0, r.y1 - r.y0);
    }

    private static void updateBoundBox(Point2D_F32 p, ImageRectangle_F32 r) {
        if (p.x < r.x0) {
            r.x0 = p.x;
        } else if (p.x > r.x1) {
            r.x1 = p.x;
        }
        if (p.y < r.y0) {
            r.y0 = p.y;
        } else if (p.y > r.y1) {
            r.y1 = p.y;
        }
    }

    public static RectangleLength2D_F64 boundBox_F64(int srcWidth, int srcHeight, PixelTransform<Point2D_F64> transform, Point2D_F64 transformed) {
        ImageRectangle_F64 r = new ImageRectangle_F64();
        r.y0 = Double.MAX_VALUE;
        r.x0 = Double.MAX_VALUE;
        r.y1 = -1.7976931348623157E308;
        r.x1 = -1.7976931348623157E308;
        for (int y = 0; y < srcHeight; ++y) {
            transform.compute(0, y, transformed);
            DistortImageOps.updateBoundBox(transformed, r);
            transform.compute(srcWidth, y, transformed);
            DistortImageOps.updateBoundBox(transformed, r);
        }
        for (int x = 0; x < srcWidth; ++x) {
            transform.compute(x, 0, transformed);
            DistortImageOps.updateBoundBox(transformed, r);
            transform.compute(x, srcHeight, transformed);
            DistortImageOps.updateBoundBox(transformed, r);
        }
        return new RectangleLength2D_F64(r.x0, r.y0, r.x1 - r.x0, r.y1 - r.y0);
    }

    private static void updateBoundBox(Point2D_F64 transform, ImageRectangle_F64 r) {
        if (transform.x < r.x0) {
            r.x0 = transform.x;
        } else if (transform.x > r.x1) {
            r.x1 = transform.x;
        }
        if (transform.y < r.y0) {
            r.y0 = transform.y;
        } else if (transform.y > r.y1) {
            r.y1 = transform.y;
        }
    }
}

