/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageGray;

public interface AssignPixelValue_SB<T extends ImageGray<T>> {
    public void setImage(T var1);

    public void assign(int var1, float var2);

    public static class S32
    implements AssignPixelValue_SB<GrayS32> {
        GrayS32 image;

        @Override
        public void setImage(GrayS32 image) {
            this.image = image;
        }

        @Override
        public void assign(int indexDst, float value) {
            this.image.data[indexDst] = (int)value;
        }
    }

    public static class I16<T extends GrayI16<T>>
    implements AssignPixelValue_SB<T> {
        T image;

        @Override
        public void setImage(T image) {
            this.image = image;
        }

        @Override
        public void assign(int indexDst, float value) {
            ((GrayI16)this.image).data[indexDst] = (short)value;
        }
    }

    public static class I8<T extends GrayI8<T>>
    implements AssignPixelValue_SB<T> {
        T image;

        @Override
        public void setImage(T image) {
            this.image = image;
        }

        @Override
        public void assign(int indexDst, float value) {
            ((GrayI8)this.image).data[indexDst] = (byte)value;
        }
    }

    public static class F32
    implements AssignPixelValue_SB<GrayF32> {
        GrayF32 image;

        @Override
        public void setImage(GrayF32 image) {
            this.image = image;
        }

        @Override
        public void assign(int indexDst, float value) {
            this.image.data[indexDst] = value;
        }
    }
}

