/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.alg.geo.bundle.cameras.BundleCameraProjective;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.DMatrixRMaj;

public class SceneStructureProjective
extends SceneStructureCommon {
    public final FastQueue<View> views = new FastQueue<View>(View.class, true);

    public SceneStructureProjective(boolean homogenous) {
        super(homogenous);
    }

    public void initialize(int totalViews, int totalPoints) {
        this.initialize(1, totalViews, totalPoints);
        this.setCamera(0, true, new BundleCameraProjective());
        for (int viewIdx = 0; viewIdx < this.views.size; ++viewIdx) {
            this.connectViewToCamera(viewIdx, 0);
        }
    }

    public void initialize(int totalCameras, int totalViews, int totalPoints) {
        int i;
        this.cameras.resize(totalCameras);
        this.views.resize(totalViews);
        this.points.resize(totalPoints);
        for (i = 0; i < this.cameras.size; ++i) {
            ((SceneStructureCommon.Camera[])this.cameras.data)[i].reset();
        }
        for (i = 0; i < this.views.size; ++i) {
            ((View[])this.views.data)[i].reset();
        }
        for (i = 0; i < this.points.size; ++i) {
            ((SceneStructureCommon.Point[])this.points.data)[i].reset();
        }
    }

    public void setView(int which, boolean fixed, DMatrixRMaj worldToView, int width, int height) {
        ((View[])this.views.data)[which].known = fixed;
        ((View[])this.views.data)[which].worldToView.set(worldToView);
        ((View[])this.views.data)[which].width = width;
        ((View[])this.views.data)[which].height = height;
    }

    public void connectViewToCamera(int viewIndex, int cameraIndex) {
        if (this.views.get((int)viewIndex).camera != -1) {
            throw new RuntimeException("View has already been assigned a camera");
        }
        this.views.get((int)viewIndex).camera = cameraIndex;
    }

    public int getUnknownViewCount() {
        int total = 0;
        for (int i = 0; i < this.views.size; ++i) {
            if (((View[])this.views.data)[i].known) continue;
            ++total;
        }
        return total;
    }

    @Override
    public int getParameterCount() {
        return this.getUnknownViewCount() * 12 + this.getUnknownCameraParameterCount() + this.points.size * this.pointSize;
    }

    public FastQueue<View> getViews() {
        return this.views;
    }

    public static class View {
        public boolean known = true;
        public int width;
        public int height;
        public DMatrixRMaj worldToView = new DMatrixRMaj(3, 4);
        public int camera = -1;

        public void reset() {
            this.known = false;
            this.height = 0;
            this.width = 0;
            this.worldToView.zero();
            this.camera = -1;
        }
    }
}

