/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.nn.KdTreePoint3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class PruneStructureFromSceneMetric {
    SceneStructureMetric structure;
    SceneObservations observations;

    public PruneStructureFromSceneMetric(SceneStructureMetric structure, SceneObservations observations) {
        this.structure = structure;
        this.observations = observations;
    }

    public void pruneObservationsByErrorRank(double inlierFraction) {
        Point2D_F64 observation = new Point2D_F64();
        Point2D_F64 predicted = new Point2D_F64();
        Point3D_F64 X2 = new Point3D_F64();
        ArrayList<Errors> errors = new ArrayList<Errors>();
        for (int viewIndex = 0; viewIndex < this.observations.views.size; ++viewIndex) {
            SceneObservations.View v = ((SceneObservations.View[])this.observations.views.data)[viewIndex];
            SceneStructureMetric.View view = ((SceneStructureMetric.View[])this.structure.views.data)[viewIndex];
            int pointIndex = 0;
            while (pointIndex < v.point.size) {
                int pointID = v.point.data[pointIndex];
                SceneStructureCommon.Point f = ((SceneStructureCommon.Point[])this.structure.points.data)[pointID];
                f.get(X2);
                v.get(pointIndex, observation);
                view.worldToView.transform(X2, X2);
                SceneStructureCommon.Camera camera = ((SceneStructureCommon.Camera[])this.structure.cameras.data)[view.camera];
                camera.model.project(X2.x, X2.y, X2.z, predicted);
                Errors e = new Errors();
                e.view = viewIndex;
                e.pointIndexInView = pointIndex++;
                e.error = predicted.distance2(observation);
                errors.add(e);
            }
        }
        errors.sort(Comparator.comparingDouble(a -> a.error));
        for (int i = (int)((double)errors.size() * inlierFraction); i < errors.size(); ++i) {
            Errors e = (Errors)errors.get(i);
            SceneObservations.View v = this.observations.views.get(e.view);
            v.set(e.pointIndexInView, Float.NaN, Float.NaN);
        }
        this.removeMarkedObservations();
    }

    private void removeMarkedObservations() {
        Point2D_F64 observation = new Point2D_F64();
        for (int viewIndex = 0; viewIndex < this.observations.views.size; ++viewIndex) {
            SceneObservations.View v = ((SceneObservations.View[])this.observations.views.data)[viewIndex];
            for (int pointIndex = v.point.size - 1; pointIndex >= 0; --pointIndex) {
                int pointID = v.getPointId(pointIndex);
                SceneStructureCommon.Point f = ((SceneStructureCommon.Point[])this.structure.points.data)[pointID];
                v.get(pointIndex, observation);
                if (!Double.isNaN(observation.x)) continue;
                if (!f.views.contains(viewIndex)) {
                    throw new RuntimeException("BUG!");
                }
                f.removeView(viewIndex);
                v.remove(pointIndex);
            }
        }
    }

    public void pruneObservationsBehindCamera() {
        Point3D_F64 X2 = new Point3D_F64();
        for (int viewIndex = 0; viewIndex < this.observations.views.size; ++viewIndex) {
            SceneObservations.View v = this.observations.views.get(viewIndex);
            SceneStructureMetric.View view = this.structure.views.get(viewIndex);
            for (int pointIndex = 0; pointIndex < v.point.size; ++pointIndex) {
                SceneStructureCommon.Point f = (SceneStructureCommon.Point)this.structure.points.get(v.getPointId(pointIndex));
                f.get(X2);
                if (!f.views.contains(viewIndex)) {
                    throw new RuntimeException("BUG!");
                }
                view.worldToView.transform(X2, X2);
                if (!(X2.z <= 0.0)) continue;
                v.set(pointIndex, Float.NaN, Float.NaN);
            }
        }
        this.removeMarkedObservations();
    }

    public void prunePoints(int count) {
        for (int viewIndex = this.observations.views.size - 1; viewIndex >= 0; --viewIndex) {
            SceneObservations.View v = ((SceneObservations.View[])this.observations.views.data)[viewIndex];
            for (int pointIndex = v.point.size - 1; pointIndex >= 0; --pointIndex) {
                SceneStructureCommon.Point p = ((SceneStructureCommon.Point[])this.structure.points.data)[v.getPointId(pointIndex)];
                if (p.views.size >= count) continue;
                v.remove(pointIndex);
            }
        }
        int[] oldToNew = new int[this.structure.points.size];
        Arrays.fill(oldToNew, -1);
        GrowQueue_I32 prune = new GrowQueue_I32();
        for (int i = 0; i < this.structure.points.size; ++i) {
            if (((SceneStructureCommon.Point[])this.structure.points.data)[i].views.size < count) {
                prune.add(i);
                continue;
            }
            oldToNew[i] = i - prune.size;
        }
        this.pruneUpdatePointID(oldToNew, prune);
    }

    private void pruneUpdatePointID(int[] oldToNew, GrowQueue_I32 prune) {
        if (prune.size == 0) {
            return;
        }
        this.structure.removePoints(prune);
        for (int viewIndex = this.observations.views.size - 1; viewIndex >= 0; --viewIndex) {
            SceneObservations.View v = ((SceneObservations.View[])this.observations.views.data)[viewIndex];
            for (int featureIndex = v.point.size - 1; featureIndex >= 0; --featureIndex) {
                v.point.data[featureIndex] = oldToNew[v.point.data[featureIndex]];
            }
        }
    }

    public void prunePoints(int neighbors, double distance) {
        Point3D_F64 worldX = new Point3D_F64();
        ArrayList<Point3D_F64> cloud = new ArrayList<Point3D_F64>();
        for (int i = 0; i < this.structure.points.size; ++i) {
            SceneStructureCommon.Point structureP = ((SceneStructureCommon.Point[])this.structure.points.data)[i];
            structureP.get(worldX);
            cloud.add(worldX.copy());
        }
        NearestNeighbor<Point3D_F64> nn = FactoryNearestNeighbor.kdtree(new KdTreePoint3D_F64());
        NearestNeighbor.Search<Point3D_F64> search = nn.createSearch();
        nn.setPoints(cloud, false);
        FastQueue resultsNN = new FastQueue(NnData.class, true);
        int[] oldToNew = new int[this.structure.points.size];
        Arrays.fill(oldToNew, -1);
        GrowQueue_I32 prunePointID = new GrowQueue_I32();
        for (int pointId = 0; pointId < this.structure.points.size; ++pointId) {
            SceneStructureCommon.Point structureP = ((SceneStructureCommon.Point[])this.structure.points.data)[pointId];
            structureP.get(worldX);
            search.findNearest((Point3D_F64)cloud.get(pointId), distance * distance, neighbors + 1, resultsNN);
            if (resultsNN.size() > neighbors) {
                oldToNew[pointId] = pointId - prunePointID.size;
                continue;
            }
            prunePointID.add(pointId);
            for (int viewIdx = 0; viewIdx < structureP.views.size; ++viewIdx) {
                SceneObservations.View v = this.observations.getView(structureP.views.data[viewIdx]);
                int pointIdx = v.point.indexOf(pointId);
                if (pointIdx < 0) {
                    throw new RuntimeException("Bad structure. Point not found in view's observation which was in its structure");
                }
                v.remove(pointIdx);
            }
        }
        this.pruneUpdatePointID(oldToNew, prunePointID);
    }

    public void pruneViews(int count) {
        GrowQueue_I32 removeIdx = new GrowQueue_I32();
        for (int viewId = 0; viewId < this.structure.views.size; ++viewId) {
            SceneObservations.View view = ((SceneObservations.View[])this.observations.views.data)[viewId];
            if (view.size() > count) continue;
            removeIdx.add(viewId);
            for (int pointIdx = 0; pointIdx < view.point.size; ++pointIdx) {
                int pointId = view.getPointId(pointIdx);
                int viewIdx = ((SceneStructureCommon.Point[])this.structure.points.data)[pointId].views.indexOf(viewId);
                if (viewIdx < 0) {
                    throw new RuntimeException("Bug in structure. view has point but point doesn't have view");
                }
                ((SceneStructureCommon.Point[])this.structure.points.data)[pointId].views.remove(viewIdx);
            }
        }
        this.structure.views.remove(removeIdx.data, 0, removeIdx.size, null);
        this.observations.views.remove(removeIdx.data, 0, removeIdx.size, null);
    }

    public void pruneUnusedCameras() {
        int i;
        int[] histogram = new int[this.structure.cameras.size];
        for (int i2 = 0; i2 < this.structure.views.size; ++i2) {
            int n = ((SceneStructureMetric.View[])this.structure.views.data)[i2].camera;
            histogram[n] = histogram[n] + 1;
        }
        int[] oldToNew = new int[this.structure.cameras.size];
        GrowQueue_I32 removeIdx = new GrowQueue_I32();
        for (i = 0; i < this.structure.cameras.size; ++i) {
            if (histogram[i] > 0) {
                oldToNew[i] = i - removeIdx.size();
                continue;
            }
            removeIdx.add(i);
        }
        this.structure.cameras.remove(removeIdx.data, 0, removeIdx.size, null);
        for (i = 0; i < this.structure.views.size; ++i) {
            SceneStructureMetric.View v = ((SceneStructureMetric.View[])this.structure.views.data)[i];
            v.camera = oldToNew[v.camera];
        }
    }

    private static class Errors {
        int view;
        int pointIndexInView;
        double error;

        private Errors() {
        }
    }
}

