/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustment;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructure;
import java.io.PrintStream;
import javax.annotation.Nullable;
import org.ddogleg.optimization.UnconstrainedLeastSquaresSchur;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.SchurJacobian;
import org.ejml.data.DMatrix;

public class BundleAdjustmentSchur<Structure extends SceneStructure, M extends DMatrix>
implements BundleAdjustment<Structure> {
    private UnconstrainedLeastSquaresSchur<M> minimizer;
    private FunctionResiduals<Structure> function;
    private Jacobian<Structure, M> jacobian;
    private int maxIterations;
    private double[] parameters = new double[0];
    private volatile boolean stopRequested = false;
    private double ftol;
    private double gtol;
    private PrintStream verbose;
    private Codec<Structure> codec;

    public BundleAdjustmentSchur(UnconstrainedLeastSquaresSchur<M> minimizer, FunctionResiduals<Structure> function, Jacobian<Structure, M> jacobian, Codec<Structure> codec) {
        this.minimizer = minimizer;
        this.function = function;
        this.jacobian = jacobian;
        this.codec = codec;
    }

    @Override
    public void configure(double ftol, double gtol, int maxIterations) {
        this.ftol = ftol;
        this.gtol = gtol;
        this.maxIterations = maxIterations;
    }

    @Override
    public void setParameters(Structure structure, SceneObservations observations) {
        this.function.configure(structure, observations);
        this.jacobian.configure(structure, observations);
        this.minimizer.setFunction(this.function, this.jacobian);
        int N = structure.getParameterCount();
        if (this.parameters.length < N) {
            this.parameters = new double[N];
        }
        this.codec.encode(structure, this.parameters);
        this.minimizer.initialize(this.parameters, this.ftol, this.gtol);
    }

    @Override
    public boolean optimize(Structure output) {
        this.stopRequested = false;
        double before = this.minimizer.getFunctionValue();
        for (int i = 0; i < this.maxIterations && !this.stopRequested && !this.minimizer.iterate(); ++i) {
        }
        this.codec.decode(this.minimizer.getParameters(), output);
        return this.minimizer.getFunctionValue() < before;
    }

    @Override
    public double getFitScore() {
        return this.minimizer.getFunctionValue();
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, int level) {
        this.verbose = out;
        this.minimizer.setVerbose(out, level);
    }

    @Override
    public void requestStop() {
        this.stopRequested = true;
    }

    @Override
    public boolean isStopRequested() {
        return this.stopRequested;
    }

    public static interface Jacobian<Structure extends SceneStructure, M extends DMatrix>
    extends SchurJacobian<M> {
        public void configure(Structure var1, SceneObservations var2);
    }

    public static interface FunctionResiduals<Structure extends SceneStructure>
    extends FunctionNtoM {
        public void configure(Structure var1, SceneObservations var2);
    }

    public static interface Codec<Structure extends SceneStructure> {
        public void decode(double[] var1, Structure var2);

        public void encode(Structure var1, double[] var2);
    }
}

