/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.dense;

import boofcv.abst.feature.dense.DescribeImageDense;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_I32;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class GenericDenseDescribeImageDense<T extends ImageBase<T>, Desc extends TupleDesc>
implements DescribeImageDense<T, Desc> {
    DescribeRegionPoint<T, Desc> alg;
    double radius;
    int featureWidth;
    int periodX;
    int periodY;
    FastQueue<Desc> descriptions;
    FastQueue<Point2D_I32> locations = new FastQueue<Point2D_I32>(Point2D_I32.class, true);

    public GenericDenseDescribeImageDense(DescribeRegionPoint<T, Desc> alg, double descriptorScale, double samplePeriodX, double samplePeriodY) {
        this.alg = alg;
        this.descriptions = new FastQueue<TupleDesc>(alg.getDescriptionType(), alg::createDescription);
        this.configure(descriptorScale, samplePeriodX, samplePeriodY);
    }

    public void configure(double descriptorRegionScale, double periodX, double periodY) {
        this.radius = this.alg.getCanonicalWidth() / 2.0 * descriptorRegionScale;
        this.periodX = (int)(periodX + 0.5);
        this.periodY = (int)(periodY + 0.5);
        this.featureWidth = (int)(this.alg.getCanonicalWidth() * descriptorRegionScale + 0.5);
    }

    @Override
    public void process(T input) {
        if (this.periodX <= 0 || this.periodY <= 0) {
            throw new IllegalArgumentException("Must call configure() first");
        }
        this.alg.setImage(input);
        int x0 = this.featureWidth / 2;
        int x1 = ((ImageBase)input).getWidth() - this.featureWidth / 2;
        int y0 = this.featureWidth / 2;
        int y1 = ((ImageBase)input).getHeight() - this.featureWidth / 2;
        this.descriptions.reset();
        this.locations.reset();
        for (int y = y0; y < y1; y += this.periodY) {
            for (int x = x0; x < x1; x += this.periodX) {
                TupleDesc d = (TupleDesc)this.descriptions.grow();
                if (!this.alg.process(x, y, 0.0, this.radius, d)) {
                    this.descriptions.removeTail();
                    continue;
                }
                this.locations.grow().set(x, y);
            }
        }
    }

    @Override
    public List<Desc> getDescriptions() {
        return this.descriptions.toList();
    }

    @Override
    public List<Point2D_I32> getLocations() {
        return this.locations.toList();
    }

    @Override
    public ImageType<T> getImageType() {
        return this.alg.getImageType();
    }

    @Override
    public Desc createDescription() {
        return this.alg.createDescription();
    }

    @Override
    public Class<Desc> getDescriptionType() {
        return this.alg.getDescriptionType();
    }
}

